/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.maven2.repo;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.axis2.maven2.repo.ArchiveDeployer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCreateRepositoryMojo
extends AbstractMojo {
    private ArtifactFactory factory;
    private ArtifactResolver resolver;
    private Set<Artifact> projectArtifacts;
    private List remoteRepositories;
    private ArtifactRepository localRepository;
    private List<MavenProject> collectedProjects;
    private String servicesDirectory;
    private String modulesDirectory;
    private File axis2xml;
    private String configurationDirectory;
    private boolean useDependencies;
    private boolean useModules;
    private boolean generateFileLists;
    private boolean stripServiceVersion;
    private boolean stripModuleVersion;

    protected abstract String getScope();

    protected abstract File getOutputDirectory();

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set<Object> artifacts = new HashSet<Artifact>();
        if (this.useDependencies) {
            artifacts.addAll(this.projectArtifacts);
        }
        if (this.useModules) {
            for (MavenProject project : this.collectedProjects) {
                artifacts.add(project.getArtifact());
                artifacts.addAll(project.getAttachedArtifacts());
            }
        }
        FilterArtifacts filter = new FilterArtifacts();
        filter.addFilter((ArtifactsFilter)new ScopeFilter(this.getScope(), null));
        filter.addFilter((ArtifactsFilter)new TypeFilter("aar,mar", null));
        try {
            artifacts = filter.filter(artifacts);
        }
        catch (ArtifactFilterException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
        artifacts = this.replaceIncompleteArtifacts(artifacts);
        File outputDirectory = this.getOutputDirectory();
        HashMap<String, ArchiveDeployer> deployers = new HashMap<String, ArchiveDeployer>();
        deployers.put("aar", new ArchiveDeployer(outputDirectory, this.servicesDirectory, "services.list", this.generateFileLists, this.stripServiceVersion));
        deployers.put("mar", new ArchiveDeployer(outputDirectory, this.modulesDirectory, "modules.list", this.generateFileLists, this.stripModuleVersion));
        for (Artifact artifact : artifacts) {
            String type = artifact.getType();
            ArchiveDeployer deployer = (ArchiveDeployer)deployers.get(type);
            if (deployer == null) {
                throw new MojoExecutionException("No deployer found for artifact type " + type);
            }
            deployer.deploy(this.getLog(), artifact);
        }
        if (this.axis2xml != null) {
            this.getLog().info((CharSequence)"Copying axis2.xml");
            File targetDirectory = this.configurationDirectory == null ? outputDirectory : new File(outputDirectory, this.configurationDirectory);
            try {
                FileUtils.copyFile((File)this.axis2xml, (File)new File(targetDirectory, "axis2.xml"));
            }
            catch (IOException iOException) {
                throw new MojoExecutionException("Error copying axis2.xml file: " + iOException.getMessage(), (Exception)iOException);
            }
        }
        for (ArchiveDeployer archiveDeployer : deployers.values()) {
            archiveDeployer.finish(this.getLog());
        }
    }

    private Set<Artifact> replaceIncompleteArtifacts(Set<Artifact> artifacts) throws MojoExecutionException {
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            File file = artifact.getFile();
            if (file != null && file.isDirectory()) {
                artifact = this.factory.createDependencyArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersionRange(), artifact.getType(), artifact.getClassifier(), artifact.getScope());
                try {
                    this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
                }
                catch (AbstractArtifactResolutionException ex) {
                    throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
                }
            }
            result.add(artifact);
        }
        return result;
    }
}

