/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.builder.converter;

import jakarta.jws.WebParam;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.jaxws.description.builder.ParameterDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.WebParamAnnot;
import org.apache.axis2.jaxws.description.builder.converter.ConverterUtils;

public class JavaParamToPDCConverter {
    private Type[] paramTypes;
    private Annotation[][] paramAnnotations;

    public JavaParamToPDCConverter(Type[] paramTypes, Annotation[][] paramAnnotations) {
        this.paramTypes = paramTypes;
        this.paramAnnotations = paramAnnotations;
    }

    public List<ParameterDescriptionComposite> convertParams() {
        ArrayList<ParameterDescriptionComposite> pdcList = new ArrayList<ParameterDescriptionComposite>();
        for (int i = 0; i < this.paramTypes.length; ++i) {
            ParameterDescriptionComposite pdc = new ParameterDescriptionComposite();
            Type paramType = this.paramTypes[i];
            String fullType = ConverterUtils.getType(paramType, "");
            pdc.setParameterType(fullType);
            pdc.setListOrder(i);
            this.attachWebParamAnnotation(pdc, i);
            pdc.setIsListType(ConverterUtils.hasXmlListAnnotation(this.paramAnnotations[i]));
            pdcList.add(pdc);
        }
        return pdcList;
    }

    private void attachWebParamAnnotation(ParameterDescriptionComposite pdc, int order) {
        Annotation[] orderAnnots;
        for (Annotation annot : orderAnnots = this.paramAnnotations[order]) {
            if (!(annot instanceof WebParam)) continue;
            WebParam webParam = (WebParam)annot;
            WebParamAnnot wpAnnot = WebParamAnnot.createWebParamAnnotImpl();
            wpAnnot.setHeader(webParam.header());
            wpAnnot.setMode(webParam.mode());
            wpAnnot.setName(webParam.name());
            wpAnnot.setPartName(webParam.partName());
            wpAnnot.setTargetNamespace(webParam.targetNamespace());
            pdc.setWebParamAnnot(wpAnnot);
        }
    }
}

