/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class POJODeployer
extends AbstractDeployer {
    private static Log log = LogFactory.getLog(POJODeployer.class);
    private ConfigurationContext configCtx;
    private String directory;

    @Override
    public void init(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(DeploymentFileData deploymentFileData) {
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        String serviceHierarchy = Utils.getServiceHierarchy(deploymentFileData.getAbsolutePath(), this.directory);
        if (serviceHierarchy == null) {
            serviceHierarchy = "";
        }
        try {
            String extension = DeploymentFileData.getFileExtension(deploymentFileData.getName());
            if ("class".equals(extension)) {
                File file = deploymentFileData.getFile();
                File parentFile = file.getParentFile();
                ClassLoader classLoader = Utils.getClassLoader(this.configCtx.getAxisConfiguration().getSystemClassLoader(), parentFile, this.configCtx.getAxisConfiguration().isChildFirstClassLoading());
                Thread.currentThread().setContextClassLoader(classLoader);
                String className = Utils.getClassNameFromResourceName(file.getName());
                log.info((Object)Messages.getMessage("deployingpojo", serviceHierarchy + className, deploymentFileData.getFile().getAbsolutePath()));
                AxisService axisService = this.createAxisServiceUsingAnnogen(className, classLoader, deploymentFileData.getFile().toURI().toURL());
                axisService.setName(serviceHierarchy + axisService.getName());
                this.configCtx.getAxisConfiguration().addService(axisService);
            } else if ("jar".equals(extension)) {
                List<String> classList = Utils.getListOfClasses(deploymentFileData);
                ArrayList axisServiceList = new ArrayList();
                for (String className : classList) {
                    ArrayList<URL> extraUrls = new ArrayList<URL>();
                    extraUrls.add(this.configCtx.getAxisConfiguration().getRepository());
                    String webLocation = DeploymentEngine.getWebLocationString();
                    if (webLocation != null) {
                        extraUrls.add(new File(webLocation).toURI().toURL());
                    }
                    ClassLoader classLoader = Utils.createClassLoader(deploymentFileData.getFile().toURI().toURL(), extraUrls.toArray(new URL[extraUrls.size()]), this.configCtx.getAxisConfiguration().getSystemClassLoader(), (File)this.configCtx.getAxisConfiguration().getParameterValue("artifactsDIR"), this.configCtx.getAxisConfiguration().isChildFirstClassLoading());
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                if (axisServiceList.size() > 0) {
                    AxisServiceGroup serviceGroup = new AxisServiceGroup();
                    serviceGroup.setServiceGroupName(serviceHierarchy + deploymentFileData.getName());
                    for (Object anAxisServiceList : axisServiceList) {
                        AxisService axisService = (AxisService)anAxisServiceList;
                        axisService.setName(serviceHierarchy + axisService.getName());
                        serviceGroup.addService(axisService);
                    }
                    this.configCtx.getAxisConfiguration().addServiceGroup(serviceGroup);
                } else {
                    String msg = "Error:\n No annotated classes found in the jar: " + deploymentFileData.getFile().getName() + ". Service deployment failed.";
                    log.error((Object)msg);
                    this.configCtx.getAxisConfiguration().getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), msg);
                }
            }
            super.deploy(deploymentFileData);
        }
        catch (Exception e) {
            log.debug((Object)Messages.getMessage("stroringfaultyservice", e.getMessage()), (Throwable)e);
            this.storeFaultyService(deploymentFileData, e);
        }
        catch (Throwable t) {
            log.debug((Object)Messages.getMessage("stroringfaultyservice", t.getMessage()), t);
            this.storeFaultyService(deploymentFileData, t);
        }
        finally {
            if (threadClassLoader != null) {
                Thread.currentThread().setContextClassLoader(threadClassLoader);
            }
        }
    }

    private void storeFaultyService(DeploymentFileData deploymentFileData, Throwable t) {
        StringWriter errorWriter = new StringWriter();
        PrintWriter ptintWriter = new PrintWriter(errorWriter);
        t.printStackTrace(ptintWriter);
        String error = "Error:\n" + errorWriter.toString();
        this.configCtx.getAxisConfiguration().getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), error);
    }

    private AxisService createAxisServiceUsingAnnogen(String className, ClassLoader classLoader, URL serviceLocation) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxisFault {
        HashMap<String, MessageReceiver> messageReciverMap = new HashMap<String, MessageReceiver>();
        Class inOnlyMessageReceiver = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver");
        MessageReceiver messageReceiver = (MessageReceiver)inOnlyMessageReceiver.newInstance();
        messageReciverMap.put("http://www.w3.org/ns/wsdl/in-only", messageReceiver);
        Class inoutMessageReceiver = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCMessageReceiver");
        MessageReceiver inOutmessageReceiver = (MessageReceiver)inoutMessageReceiver.newInstance();
        messageReciverMap.put("http://www.w3.org/ns/wsdl/in-out", inOutmessageReceiver);
        messageReciverMap.put("http://www.w3.org/ns/wsdl/robust-in-only", inOutmessageReceiver);
        AxisService axisService = AxisService.createService(className, this.configCtx.getAxisConfiguration(), messageReciverMap, null, null, classLoader);
        axisService.setFileName(serviceLocation);
        return axisService;
    }

    public void setMessageReceivers(AxisService service) {
        Iterator<AxisOperation> iterator = service.getOperations();
        while (iterator.hasNext()) {
            AxisOperation operation = iterator.next();
            String MEP = operation.getMessageExchangePattern();
            if (MEP == null) continue;
            try {
                if ("http://www.w3.org/ns/wsdl/in-only".equals(MEP)) {
                    Class inOnlyMessageReceiver = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver");
                    MessageReceiver messageReceiver = (MessageReceiver)inOnlyMessageReceiver.newInstance();
                    operation.setMessageReceiver(messageReceiver);
                    continue;
                }
                Class inoutMessageReceiver = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCMessageReceiver");
                MessageReceiver inOutmessageReceiver = (MessageReceiver)inoutMessageReceiver.newInstance();
                operation.setMessageReceiver(inOutmessageReceiver);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Override
    public void setExtension(String extension) {
    }

    @Override
    public void undeploy(String fileName) throws DeploymentException {
        String serviceHierarchy = Utils.getServiceHierarchy((String)fileName, this.directory);
        if (serviceHierarchy == null) {
            serviceHierarchy = "";
        }
        if (((String)(fileName = Utils.getShortFileName((String)fileName))).endsWith(".class")) {
            Object className = Utils.getClassNameFromResourceName((String)fileName);
            className = serviceHierarchy + (String)className;
            try {
                AxisServiceGroup serviceGroup = this.configCtx.getAxisConfiguration().removeServiceGroup((String)className);
                this.configCtx.removeServiceGroupContext(serviceGroup);
                log.info((Object)Messages.getMessage("serviceremoved", (String)className));
            }
            catch (AxisFault axisFault) {
                log.debug((Object)Messages.getMessage("faultyserviceremoval", axisFault.getMessage()), (Throwable)axisFault);
                this.configCtx.getAxisConfiguration().removeFaultyService((String)fileName);
            }
        } else if (((String)fileName).endsWith(".jar")) {
            fileName = serviceHierarchy + (String)fileName;
            try {
                AxisServiceGroup serviceGroup = this.configCtx.getAxisConfiguration().removeServiceGroup((String)fileName);
                this.configCtx.removeServiceGroupContext(serviceGroup);
                log.info((Object)Messages.getMessage("serviceremoved", (String)fileName));
            }
            catch (AxisFault axisFault) {
                log.debug((Object)Messages.getMessage("faultyserviceremoval", axisFault.getMessage()), (Throwable)axisFault);
                this.configCtx.getAxisConfiguration().removeFaultyService((String)fileName);
            }
        }
        super.undeploy((String)fileName);
    }
}

