/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.builder;

import jakarta.activation.DataHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.attachments.lifecycle.LifecycleManager;
import org.apache.axiom.attachments.lifecycle.impl.LifecycleManagerImpl;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.util.activation.DataHandlerUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.kernel.http.HTTPConstants;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.axis2.util.MultipleEntryHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAllMember;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.constants.Constants;

public class BuilderUtil {
    private static final Log log = LogFactory.getLog(BuilderUtil.class);
    public static final int BOM_SIZE = 4;

    public static SOAPEnvelope buildsoapMessage(MessageContext messageContext, MultipleEntryHashMap requestParameterMap, SOAPFactory soapFactory) throws AxisFault {
        SOAPEnvelope soapEnvelope = soapFactory.getDefaultEnvelope();
        SOAPBody body = soapEnvelope.getBody();
        AxisOperation axisOperation = messageContext.getAxisOperation();
        if (axisOperation != null) {
            AxisMessage axisMessage = axisOperation.getMessage("In");
            XmlSchemaElement xmlSchemaElement = axisMessage.getSchemaElement();
            if (xmlSchemaElement == null) {
                OMElement bodyFirstChild = soapFactory.createOMElement(messageContext.getAxisOperation().getName(), (OMContainer)body);
                BuilderUtil.createSOAPMessageWithoutSchema(soapFactory, bodyFirstChild, requestParameterMap);
            } else {
                String targetNamespace = xmlSchemaElement.getQName().getNamespaceURI();
                QName bodyFirstChildQName = targetNamespace != null && !"".equals(targetNamespace) ? new QName(targetNamespace, xmlSchemaElement.getName()) : new QName(xmlSchemaElement.getName());
                OMElement bodyFirstChild = soapFactory.createOMElement(bodyFirstChildQName, (OMContainer)body);
                XmlSchemaType schemaType = xmlSchemaElement.getSchemaType();
                if (schemaType instanceof XmlSchemaComplexType) {
                    XmlSchemaComplexType complexType = (XmlSchemaComplexType)schemaType;
                    XmlSchemaParticle particle = complexType.getParticle();
                    if (particle instanceof XmlSchemaSequence || particle instanceof XmlSchemaAll) {
                        if (particle instanceof XmlSchemaSequence) {
                            XmlSchemaSequence sequence = (XmlSchemaSequence)particle;
                            for (XmlSchemaSequenceMember sequenceMember : sequence.getItems()) {
                                XmlSchemaElement innerElement = (XmlSchemaElement)sequenceMember;
                                QName qName = innerElement.getQName();
                                if (innerElement.getSchemaTypeName() == null && innerElement.getMinOccurs() == 0L) continue;
                                if (qName == null && innerElement.getSchemaTypeName().equals(Constants.XSD_ANYTYPE)) {
                                    BuilderUtil.createSOAPMessageWithoutSchema(soapFactory, bodyFirstChild, requestParameterMap);
                                    break;
                                }
                                BuilderUtil.checkMinOccurs(innerElement, qName, soapFactory, requestParameterMap, bodyFirstChild);
                            }
                        } else {
                            XmlSchemaAll sequence = (XmlSchemaAll)particle;
                            for (XmlSchemaAllMember sequenceMember : sequence.getItems()) {
                                XmlSchemaElement innerElement = (XmlSchemaElement)sequenceMember;
                                QName qName = innerElement.getQName();
                                if (innerElement.getSchemaTypeName() == null && innerElement.getMinOccurs() == 0L) continue;
                                if (qName == null && innerElement.getSchemaTypeName().equals(Constants.XSD_ANYTYPE)) {
                                    BuilderUtil.createSOAPMessageWithoutSchema(soapFactory, bodyFirstChild, requestParameterMap);
                                    break;
                                }
                                BuilderUtil.checkMinOccurs(innerElement, qName, soapFactory, requestParameterMap, bodyFirstChild);
                            }
                        }
                    }
                } else {
                    throw new AxisFault(xmlSchemaElement.getName() + " message element in schema should follow the (Internationalized Resource Identifier)IRI ) style to process request in REST style");
                }
            }
        }
        return soapEnvelope;
    }

    private static void checkMinOccurs(XmlSchemaElement innerElement, QName qName, SOAPFactory soapFactory, MultipleEntryHashMap requestParameterMap, OMElement bodyFirstChild) throws AxisFault {
        Object value;
        OMNamespace ns;
        long minOccurs = innerElement.getMinOccurs();
        boolean nillable = innerElement.isNillable();
        String name = qName != null ? qName.getLocalPart() : innerElement.getName();
        OMNamespace oMNamespace = ns = qName == null || qName.getNamespaceURI() == null || qName.getNamespaceURI().length() == 0 ? null : soapFactory.createOMNamespace(qName.getNamespaceURI(), null);
        while ((value = requestParameterMap.get(name)) != null) {
            BuilderUtil.addRequestParameter(soapFactory, bodyFirstChild, ns, name, value);
            --minOccurs;
        }
        if (minOccurs > 0L) {
            if (nillable) {
                OMNamespace xsi = soapFactory.createOMNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi");
                OMAttribute omAttribute = soapFactory.createOMAttribute("nil", xsi, "true");
                soapFactory.createOMElement(name, ns, (OMContainer)bodyFirstChild).addAttribute(omAttribute);
            } else {
                throw new AxisFault("Required element " + qName + " defined in the schema can not be found in the request");
            }
        }
    }

    public static void createSOAPMessageWithoutSchema(SOAPFactory soapFactory, OMElement bodyFirstChild, MultipleEntryHashMap requestParameterMap) {
        if (requestParameterMap != null) {
            for (Object o : requestParameterMap.keySet()) {
                Object value;
                String key = (String)o;
                while ((value = requestParameterMap.get(key)) != null) {
                    BuilderUtil.addRequestParameter(soapFactory, bodyFirstChild, null, key, value);
                }
            }
        }
    }

    private static void addRequestParameter(SOAPFactory soapFactory, OMElement bodyFirstChild, OMNamespace ns, String key, Object parameter) {
        if (parameter instanceof DataHandler) {
            DataHandler dataHandler = (DataHandler)parameter;
            OMText dataText = bodyFirstChild.getOMFactory().createOMText(DataHandlerUtils.toBlob((DataHandler)dataHandler), true);
            soapFactory.createOMElement(key, ns, (OMContainer)bodyFirstChild).addChild((OMNode)dataText);
        } else {
            String textValue = parameter.toString();
            soapFactory.createOMElement(key, ns, (OMContainer)bodyFirstChild).setText(textValue);
        }
    }

    public static OMXMLParserWrapper createPOXBuilder(InputStream in, String encoding) {
        return OMXMLBuilderFactory.createOMBuilder((StAXParserConfiguration)StAXParserConfiguration.SOAP, (InputStream)in, (String)encoding);
    }

    public static Reader getReader(InputStream is, String charSetEncoding) throws IOException {
        InputStreamReader inputStreamReader;
        final PushbackInputStream is2 = BuilderUtil.getPushbackInputStream(is);
        final String encoding = BuilderUtil.getCharSetEncoding(is2, charSetEncoding);
        try {
            inputStreamReader = (InputStreamReader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnsupportedEncodingException {
                    return new InputStreamReader((InputStream)is2, encoding);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnsupportedEncodingException)e.getException();
        }
        return new BufferedReader(inputStreamReader);
    }

    public static PushbackInputStream getPushbackInputStream(InputStream is) {
        return new PushbackInputStream(is, 4);
    }

    public static String getCharSetEncoding(PushbackInputStream is2, String defaultEncoding) throws IOException {
        int unread;
        String encoding;
        byte[] bom = new byte[4];
        int n = is2.read(bom, 0, bom.length);
        if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            encoding = "UTF-8";
            if (log.isDebugEnabled()) {
                log.debug((Object)("char set encoding set from BOM =" + encoding));
            }
            unread = n - 3;
        } else if (bom[0] == -2 && bom[1] == -1) {
            encoding = "UTF-16BE";
            if (log.isDebugEnabled()) {
                log.debug((Object)("char set encoding set from BOM =" + encoding));
            }
            unread = n - 2;
        } else if (bom[0] == -1 && bom[1] == -2) {
            encoding = "UTF-16LE";
            if (log.isDebugEnabled()) {
                log.debug((Object)("char set encoding set from BOM =" + encoding));
            }
            unread = n - 2;
        } else if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
            encoding = "UTF-32BE";
            if (log.isDebugEnabled()) {
                log.debug((Object)("char set encoding set from BOM =" + encoding));
            }
            unread = n - 4;
        } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            encoding = "UTF-32LE";
            if (log.isDebugEnabled()) {
                log.debug((Object)("char set encoding set from BOM =" + encoding));
            }
            unread = n - 4;
        } else {
            encoding = defaultEncoding;
            if (log.isDebugEnabled()) {
                log.debug((Object)("char set encoding set from default =" + encoding));
            }
            unread = n;
        }
        if (unread > 0) {
            is2.unread(bom, n - unread, unread);
        }
        return encoding;
    }

    public static String getEnvelopeNamespace(String contentType) {
        String soapNS = "http://schemas.xmlsoap.org/soap/envelope/";
        if (contentType != null) {
            if (contentType.indexOf("application/soap+xml") > -1) {
                soapNS = "http://www.w3.org/2003/05/soap-envelope";
            } else if (contentType.indexOf("text/xml") > -1) {
                soapNS = "http://schemas.xmlsoap.org/soap/envelope/";
            }
        }
        return soapNS;
    }

    public static String getCharSetEncoding(String contentType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Input contentType (" + contentType + ")"));
        }
        if (contentType == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"CharSetEncoding defaulted (UTF-8)");
            }
            return "UTF-8";
        }
        int index = contentType.indexOf(HTTPConstants.CHAR_SET_ENCODING);
        if (index == -1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"CharSetEncoding defaulted (UTF-8)");
            }
            return "UTF-8";
        }
        int indexOfEq = contentType.indexOf("=", index);
        int indexOfSemiColon = contentType.indexOf(";", indexOfEq);
        String value = indexOfSemiColon > 0 ? contentType.substring(indexOfEq + 1, indexOfSemiColon) : contentType.substring(indexOfEq + 1, contentType.length()).trim();
        if (value.indexOf(34) != -1) {
            value = value.replaceAll("\"", "");
        }
        value = value.trim();
        if (log.isDebugEnabled()) {
            log.debug((Object)("CharSetEncoding from content-type (" + value + ")"));
        }
        return value;
    }

    public static Attachments createAttachmentsMap(MessageContext msgContext, InputStream inStream, String contentTypeString) {
        int contentLength;
        String attachmentSizeThreshold;
        String attachmentRepoDir;
        boolean fileCacheForAttachments;
        block7: {
            String contentLengthValue;
            fileCacheForAttachments = BuilderUtil.isAttachmentsCacheEnabled(msgContext);
            attachmentRepoDir = null;
            attachmentSizeThreshold = null;
            if (fileCacheForAttachments) {
                Parameter attachmentSizeThresholdParameter;
                Parameter attachmentRepoDirParameter;
                Object attachmentRepoDirProperty = msgContext.getProperty("attachmentDIR");
                attachmentRepoDir = attachmentRepoDirProperty != null ? (String)attachmentRepoDirProperty : ((attachmentRepoDirParameter = msgContext.getParameter("attachmentDIR")) != null ? (String)attachmentRepoDirParameter.getValue() : null);
                Object attachmentSizeThresholdProperty = msgContext.getProperty("sizeThreshold");
                attachmentSizeThreshold = attachmentSizeThresholdProperty != null && attachmentSizeThresholdProperty instanceof String ? (String)attachmentSizeThresholdProperty : ((attachmentSizeThresholdParameter = msgContext.getParameter("sizeThreshold")) != null ? attachmentSizeThresholdParameter.getValue().toString() : null);
            }
            contentLength = 0;
            Map headers = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
            if (headers != null && (contentLengthValue = (String)headers.get("Content-Length")) != null) {
                try {
                    contentLength = new Integer(contentLengthValue);
                }
                catch (NumberFormatException e) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)("Content-Length is not a valid number.  Will assume it is not set:" + e));
                }
            }
        }
        if (log.isDebugEnabled()) {
            if (contentLength > 0) {
                log.debug((Object)("Creating an Attachments map.  The content-length is" + contentLength));
            } else {
                log.debug((Object)"Creating an Attachments map.");
            }
        }
        return BuilderUtil.createAttachments(msgContext, inStream, contentTypeString, fileCacheForAttachments, attachmentRepoDir, attachmentSizeThreshold, contentLength);
    }

    public static boolean isAttachmentsCacheEnabled(MessageContext msgContext) {
        Parameter parameter_cache_attachment;
        Object cacheAttachmentProperty = msgContext.getProperty("cacheAttachments");
        String cacheAttachmentString = cacheAttachmentProperty != null && cacheAttachmentProperty instanceof String ? (String)cacheAttachmentProperty : ((parameter_cache_attachment = msgContext.getParameter("cacheAttachments")) != null ? (String)parameter_cache_attachment.getValue() : null);
        boolean fileCacheForAttachments = "true".equals(cacheAttachmentString);
        return fileCacheForAttachments;
    }

    public static Attachments createAttachments(MessageContext msgContext, InputStream inStream, String contentTypeString, boolean fileCacheForAttachments, String attachmentRepoDir, String attachmentSizeThreshold, int contentLength) {
        LifecycleManager manager;
        block3: {
            manager = null;
            try {
                AxisConfiguration configuration = msgContext.getRootContext().getAxisConfiguration();
                manager = (LifecycleManager)configuration.getParameterValue("attachmentsLifecycleManager");
                if (manager == null) {
                    manager = new LifecycleManagerImpl();
                    configuration.addParameter("attachmentsLifecycleManager", manager);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"Exception getting Attachments LifecycleManager", (Throwable)e);
            }
        }
        return new Attachments(manager, inStream, contentTypeString, fileCacheForAttachments, attachmentRepoDir, attachmentSizeThreshold, contentLength);
    }

    public static SOAPModelBuilder createSOAPModelBuilder(InputStream in, String encoding) {
        try {
            return OMXMLBuilderFactory.createSOAPModelBuilder((InputStream)in, (String)encoding);
        }
        catch (OMException e) {
            log.info((Object)"OMException in getSOAPBuilder", (Throwable)e);
            try {
                log.info((Object)("Remaining input stream :[" + new String(IOUtils.toByteArray((InputStream)in), encoding) + "]"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    public static Builder getBuilderFromSelector(String type, MessageContext msgContext) throws AxisFault {
        return MessageProcessorSelector.getMessageBuilder(type, msgContext);
    }

    public static void validateSOAPVersion(String soapNamespaceURIFromTransport, SOAPEnvelope envelope) {
        OMNamespace envelopeNamespace;
        String namespaceName;
        if (soapNamespaceURIFromTransport != null && !soapNamespaceURIFromTransport.equals(namespaceName = (envelopeNamespace = envelope.getNamespace()).getNamespaceURI())) {
            throw new SOAPProcessingException("Transport level information does not match with SOAP Message namespace URI", envelopeNamespace.getPrefix() + ":VersionMismatch");
        }
    }

    public static void validateCharSetEncoding(String charsetEncodingFromTransport, String charsetEncodingFromXML, String soapNamespaceURI) throws AxisFault {
        if (charsetEncodingFromXML != null && !"".equals(charsetEncodingFromXML) && charsetEncodingFromTransport != null && !charsetEncodingFromXML.equalsIgnoreCase(charsetEncodingFromTransport) && !BuilderUtil.compatibleEncodings(charsetEncodingFromXML, charsetEncodingFromTransport) && log.isDebugEnabled()) {
            log.debug((Object)("Character Set Encoding from transport information [" + charsetEncodingFromTransport + "] does not match with character set encoding in the received SOAP message [" + charsetEncodingFromXML + "]"));
        }
    }

    private static boolean compatibleEncodings(String enc1, String enc2) {
        enc1 = enc1.toLowerCase();
        enc2 = enc2.toLowerCase();
        if (enc1.endsWith("be") || enc1.endsWith("le")) {
            enc1 = enc1.substring(0, enc1.length() - 2);
        }
        if (enc2.endsWith("be") || enc2.endsWith("le")) {
            enc2 = enc2.substring(0, enc2.length() - 2);
        }
        return enc1.equals(enc2);
    }
}

