/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.tcp;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TCPWorker
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)TCPWorker.class);
    private ConfigurationContext configurationContext;
    private Socket socket;

    public TCPWorker(ConfigurationContext configurationContext, Socket socket) {
        this.configurationContext = configurationContext;
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        AbstractContext msgContext = null;
        AxisEngine engine = new AxisEngine(this.configurationContext);
        AxisConfiguration axisConf = this.configurationContext.getAxisConfiguration();
        TransportOutDescription transportOut = axisConf.getTransportOut("tcp");
        TransportInDescription transportIn = axisConf.getTransportIn("tcp");
        if (transportOut == null || transportIn == null) {
            throw new AxisFault(Messages.getMessage("unknownTransport", "tcp"));
        }
        msgContext = this.configurationContext.createMessageContext();
        ((MessageContext)msgContext).setIncomingTransportName("tcp");
        ((MessageContext)msgContext).setTransportIn(transportIn);
        ((MessageContext)msgContext).setTransportOut(transportOut);
        ((MessageContext)msgContext).setServerSide(true);
        OutputStream out = this.socket.getOutputStream();
        msgContext.setProperty("TRANSPORT_OUT", out);
        InputStreamReader in = new InputStreamReader(this.socket.getInputStream());
        StAXBuilder builder = BuilderUtil.getBuilder(in);
        SOAPEnvelope envelope = (SOAPEnvelope)builder.getDocumentElement();
        ((MessageContext)msgContext).setEnvelope(envelope);
        AxisEngine.receive((MessageContext)msgContext);
        Object var11_14 = null;
        if (this.socket == null) return;
        try {
            this.socket.close();
            return;
        }
        catch (IOException e1) {}
        return;
        {
            catch (Throwable e) {
                log.error((Object)e.getMessage(), e);
                try {
                    AxisEngine engine2 = new AxisEngine(this.configurationContext);
                    if (msgContext != null) {
                        msgContext.setProperty("TRANSPORT_OUT", this.socket.getOutputStream());
                        MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)msgContext, e);
                        AxisEngine.sendFault(faultContext);
                    }
                }
                catch (Exception e1) {
                    log.error((Object)e1.getMessage(), (Throwable)e1);
                }
                Object var11_15 = null;
                if (this.socket == null) return;
                try {
                    this.socket.close();
                    return;
                }
                catch (IOException e1) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            if (this.socket == null) throw throwable;
            try {
                this.socket.close();
                throw throwable;
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

