/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.addressing;

import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressingHelper {
    private static final Log log = LogFactory.getLog((Class)AddressingHelper.class);

    public static boolean isReplyRedirected(MessageContext messageContext) {
        EndpointReference replyTo = messageContext.getReplyTo();
        if (replyTo == null) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)(messageContext.getLogIDString() + " isReplyRedirected: ReplyTo is null. Returning false"));
            }
            return false;
        }
        return !replyTo.hasAnonymousAddress();
    }

    public static boolean isFaultRedirected(MessageContext messageContext) {
        EndpointReference faultTo = messageContext.getFaultTo();
        if (faultTo == null) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)(messageContext.getLogIDString() + " isReplyRedirected: FaultTo is null. Returning isReplyRedirected"));
            }
            return AddressingHelper.isReplyRedirected(messageContext);
        }
        return !faultTo.hasAnonymousAddress();
    }

    public static boolean shouldSendFaultToFaultTo(MessageContext messageContext) {
        Object faultInfoForHeaders = messageContext.getLocalProperty("FaultHeaders");
        boolean doNotSendFaultUsingFaultTo = false;
        if (faultInfoForHeaders != null) {
            String problemHeaderName = (String)((Map)faultInfoForHeaders).get("ProblemHeaderQName");
            doNotSendFaultUsingFaultTo = problemHeaderName != null && "wsa:FaultTo".equals(problemHeaderName);
        }
        return !doNotSendFaultUsingFaultTo;
    }

    public static String getAddressingRequirementParemeterValue(AxisDescription axisDescription) {
        String value = "";
        if (axisDescription != null) {
            value = Utils.getParameterValue(axisDescription.getParameter("addressingRequirementParameter"));
            if (value != null) {
                value = value.trim();
            }
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)("getAddressingRequirementParemeterValue: value: '" + value + "'"));
            }
        }
        if (value == null || "".equals(value)) {
            value = "unspecified";
        }
        return value;
    }

    public static String getInvocationPatternParameterValue(AxisOperation axisOperation) {
        String value = "";
        if (axisOperation != null) {
            value = Utils.getParameterValue(axisOperation.getParameter("wsamInvocationPattern"));
            if (value != null) {
                value = value.trim();
            }
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)("getInvocationPatternParameterValue: value: '" + value + "'"));
            }
        }
        if (value == null || "".equals(value)) {
            value = "both";
        }
        return value;
    }

    public static void setInvocationPatternParameterValue(AxisOperation axisOperation, String value) {
        block11: {
            if (value == null) {
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug((Object)"setInvocationPatternParameterValue: value passed in is null. return");
                }
                return;
            }
            Parameter param = axisOperation.getParameter("wsamInvocationPattern");
            if (param != null) {
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug((Object)"setInvocationPatternParameterValue: Parameter already exists");
                }
                if (!param.isLocked()) {
                    if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                        log.debug((Object)("setInvocationPatternParameterValue: Parameter not locked. Setting value: " + value));
                    }
                    param.setValue(value);
                }
            } else {
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug((Object)"setInvocationPatternParameterValue: Parameter does not exist");
                }
                param = new Parameter();
                param.setName("wsamInvocationPattern");
                param.setValue(value);
                try {
                    if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                        log.debug((Object)("setInvocationPatternParameterValue: Adding parameter with value: " + value));
                    }
                    axisOperation.addParameter(param);
                }
                catch (AxisFault af) {
                    if (!LoggingControl.debugLoggingAllowed || !log.isDebugEnabled()) break block11;
                    log.debug((Object)("setInvocationPatternParameterValue: addParameter failed: " + af.getMessage()));
                }
            }
        }
    }

    public static void setAddressingRequirementParemeterValue(AxisDescription axisDescription, String value) {
        block11: {
            if (value == null) {
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug((Object)"getAddressingRequirementParemeterValue: value passed in is null. return");
                }
                return;
            }
            Parameter param = axisDescription.getParameter("addressingRequirementParameter");
            if (param != null) {
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug((Object)"setAddressingRequirementParemeterValue: Parameter already exists");
                }
                if (!param.isLocked()) {
                    if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                        log.debug((Object)("setAddressingRequirementParemeterValue: Parameter not locked. Setting value: " + value));
                    }
                    param.setValue(value);
                }
            } else {
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug((Object)"setAddressingRequirementParemeterValue: Parameter does not exist");
                }
                param = new Parameter();
                param.setName("addressingRequirementParameter");
                param.setValue(value);
                try {
                    if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                        log.debug((Object)("setAddressingRequirementParemeterValue: Adding parameter with value: " + value));
                    }
                    axisDescription.addParameter(param);
                }
                catch (AxisFault af) {
                    if (!LoggingControl.debugLoggingAllowed || !log.isDebugEnabled()) break block11;
                    log.debug((Object)("setAddressingRequirementParemeterValue: addParameter failed: " + af.getMessage()));
                }
            }
        }
    }
}

