/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.clustering.configuration.ConfigurationManager;
import org.apache.axis2.clustering.configuration.ConfigurationManagerListener;
import org.apache.axis2.clustering.context.ContextManager;
import org.apache.axis2.clustering.context.ContextManagerListener;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;

public class ClusterBuilder
extends DescriptionBuilder {
    public ClusterBuilder(AxisConfiguration axisConfig) {
        this.axisConfig = axisConfig;
    }

    public ClusterBuilder(InputStream serviceInputStream, AxisConfiguration axisConfig) {
        super(serviceInputStream, axisConfig);
    }

    public void buildCluster(OMElement clusterElement) throws DeploymentException {
        OMAttribute classNameAttr = clusterElement.getAttribute(new QName("class"));
        if (classNameAttr == null) {
            throw new DeploymentException(Messages.getMessage("classAttributeNotFound", "cluster"));
        }
        String className = classNameAttr.getAttributeValue();
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException(Messages.getMessage("clusterImplNotFound", className));
            }
            ClusterManager clusterManager = (ClusterManager)clazz.newInstance();
            clusterManager.setConfigurationContext(this.configCtx);
            this.processParameters(clusterElement.getChildrenWithName(new QName("parameter")), clusterManager, null);
            this.loadConfigManager(clusterElement, clusterManager);
            this.loadContextManager(clusterElement, clusterManager);
            this.axisConfig.setClusterManager(clusterManager);
        }
        catch (InstantiationException e) {
            throw new DeploymentException(Messages.getMessage("cannotLoadClusterImpl"));
        }
        catch (IllegalAccessException e) {
            throw new DeploymentException(e);
        }
    }

    private void loadContextManager(OMElement clusterElement, ClusterManager clusterManager) throws DeploymentException, InstantiationException, IllegalAccessException {
        OMElement contextManagerEle = clusterElement.getFirstChildWithName(new QName("contextManager"));
        if (contextManagerEle != null) {
            Class<?> clazz;
            OMAttribute classNameAttr = contextManagerEle.getAttribute(new QName("class"));
            if (classNameAttr == null) {
                throw new DeploymentException(Messages.getMessage("classAttributeNotFound", "contextManager"));
            }
            String className = classNameAttr.getAttributeValue();
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException(Messages.getMessage("clusterImplNotFound", className));
            }
            ContextManager contextManager = (ContextManager)clazz.newInstance();
            clusterManager.setContextManager(contextManager);
            OMElement listenerEle = contextManagerEle.getFirstChildWithName(new QName("listener"));
            if (listenerEle != null) {
                classNameAttr = listenerEle.getAttribute(new QName("class"));
                if (classNameAttr == null) {
                    throw new DeploymentException(Messages.getMessage("classAttributeNotFound", "listener"));
                }
                className = classNameAttr.getAttributeValue();
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentException(Messages.getMessage("clusterImplNotFound", className));
                }
            } else {
                throw new DeploymentException(Messages.getMessage("contextManagerListenerIsNull"));
            }
            ContextManagerListener listener = (ContextManagerListener)clazz.newInstance();
            contextManager.setContextManagerListener(listener);
            this.processParameters(contextManagerEle.getChildrenWithName(new QName("parameter")), contextManager, null);
            OMElement replicationEle = contextManagerEle.getFirstChildWithName(new QName("replication"));
            if (replicationEle != null) {
                OMElement defaultsEle = replicationEle.getFirstChildWithName(new QName("defaults"));
                if (defaultsEle != null) {
                    ArrayList<String> defaults = new ArrayList<String>();
                    Iterator iter = defaultsEle.getChildrenWithName(new QName("exclude"));
                    while (iter.hasNext()) {
                        OMElement excludeEle = (OMElement)iter.next();
                        OMAttribute nameAtt = excludeEle.getAttribute(new QName("name"));
                        defaults.add(nameAtt.getAttributeValue());
                    }
                    contextManager.setReplicationExcludePatterns("defaults", defaults);
                }
                Iterator iter = replicationEle.getChildrenWithName(new QName("context"));
                while (iter.hasNext()) {
                    OMElement contextEle = (OMElement)iter.next();
                    String ctxClassName = contextEle.getAttribute(new QName("class")).getAttributeValue();
                    ArrayList<String> excludes = new ArrayList<String>();
                    Iterator iter2 = contextEle.getChildrenWithName(new QName("exclude"));
                    while (iter2.hasNext()) {
                        OMElement excludeEle = (OMElement)iter2.next();
                        OMAttribute nameAtt = excludeEle.getAttribute(new QName("name"));
                        excludes.add(nameAtt.getAttributeValue());
                    }
                    contextManager.setReplicationExcludePatterns(ctxClassName, excludes);
                }
            }
        }
    }

    private void loadConfigManager(OMElement clusterElement, ClusterManager clusterManager) throws DeploymentException, InstantiationException, IllegalAccessException {
        OMElement configManagerEle = clusterElement.getFirstChildWithName(new QName("configurationManager"));
        if (configManagerEle != null) {
            Class<?> clazz;
            OMAttribute classNameAttr = configManagerEle.getAttribute(new QName("class"));
            if (classNameAttr == null) {
                throw new DeploymentException(Messages.getMessage("classAttributeNotFound", "configurationManager"));
            }
            String className = classNameAttr.getAttributeValue();
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException(Messages.getMessage("clusterImplNotFound", className));
            }
            ConfigurationManager configurationManager = (ConfigurationManager)clazz.newInstance();
            clusterManager.setConfigurationManager(configurationManager);
            OMElement listenerEle = configManagerEle.getFirstChildWithName(new QName("listener"));
            if (listenerEle != null) {
                classNameAttr = listenerEle.getAttribute(new QName("class"));
                if (classNameAttr == null) {
                    throw new DeploymentException(Messages.getMessage("clusterImplNotFound", "listener"));
                }
                className = classNameAttr.getAttributeValue();
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentException(Messages.getMessage("configurationManagerListenerIsNull"));
                }
            } else {
                throw new DeploymentException(Messages.getMessage("configurationManagerListenerIsNull"));
            }
            ConfigurationManagerListener listener = (ConfigurationManagerListener)clazz.newInstance();
            listener.setConfigurationContext(this.configCtx);
            configurationManager.setConfigurationManagerListener(listener);
            configurationManager.setConfigurationContext(this.configCtx);
            this.processParameters(configManagerEle.getChildrenWithName(new QName("parameter")), configurationManager, null);
        }
    }
}

