/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.receivers;

import java.lang.reflect.Method;
import java.net.URL;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.classloader.MultiParentClassLoader;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.context.Replicator;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.DependencyManager;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMessageReceiver
implements MessageReceiver {
    protected static final Log log = LogFactory.getLog((Class)AbstractMessageReceiver.class);
    public static final String SCOPE = "scope";
    protected String serviceTCCL = null;
    public static final String SAVED_TCCL = "_SAVED_TCCL_";
    public static final String SAVED_MC = "_SAVED_MC_";
    public static final String DO_ASYNC = "messageReceiver.invokeOnSeparateThread";

    protected void replicateState(MessageContext messageContext) throws ClusteringFault {
        Replicator.replicate(messageContext);
    }

    protected abstract void invokeBusinessLogic(MessageContext var1) throws AxisFault;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(MessageContext messageCtx) throws AxisFault {
        block7: {
            EndpointReference replyTo;
            if (messageCtx.isPropertyTrue(DO_ASYNC) && (replyTo = messageCtx.getReplyTo()) != null && !replyTo.hasAnonymousAddress()) {
                AsyncMessageReceiverWorker worker = new AsyncMessageReceiverWorker(messageCtx);
                messageCtx.getEnvelope().build();
                messageCtx.getConfigurationContext().getThreadPool().execute(worker);
                return;
            }
            ThreadContextDescriptor tc = this.setThreadContext(messageCtx);
            try {
                this.invokeBusinessLogic(messageCtx);
            }
            catch (AxisFault fault) {
                if (messageCtx.getAxisOperation() instanceof InOnlyAxisOperation && !"http://www.w3.org/ns/wsdl/robust-in-only".equals(messageCtx.getAxisOperation().getMessageExchangePattern())) {
                    log.error((Object)fault);
                    break block7;
                }
                throw fault;
            }
            finally {
                this.restoreThreadContext(tc);
            }
        }
    }

    protected ThreadContextDescriptor setThreadContext(MessageContext msgContext) {
        ClassLoader contextClassLoader;
        ThreadContextDescriptor tc = new ThreadContextDescriptor();
        tc.oldMessageContext = (MessageContext)MessageContext.currentMessageContext.get();
        tc.oldClassLoader = contextClassLoader = Thread.currentThread().getContextClassLoader();
        AxisService service = msgContext.getAxisService();
        String serviceTCCL = (String)service.getParameterValue("ServiceTCCL");
        if (serviceTCCL != null) {
            if ((serviceTCCL = serviceTCCL.trim().toLowerCase()).equals("composite")) {
                Thread.currentThread().setContextClassLoader(new MultiParentClassLoader(new URL[0], new ClassLoader[]{msgContext.getAxisService().getClassLoader(), contextClassLoader}));
            } else if (serviceTCCL.equals("service")) {
                Thread.currentThread().setContextClassLoader(msgContext.getAxisService().getClassLoader());
            }
        }
        MessageContext.setCurrentMessageContext(msgContext);
        return tc;
    }

    protected void restoreThreadContext(ThreadContextDescriptor tc) {
        Thread.currentThread().setContextClassLoader(tc.oldClassLoader);
        MessageContext.currentMessageContext.set(tc.oldMessageContext);
    }

    protected Object makeNewServiceObject(MessageContext msgContext) throws AxisFault {
        try {
            Parameter implInfoParam;
            AxisService service = msgContext.getAxisService();
            ClassLoader classLoader = service.getClassLoader();
            if (service.getParameter("ServiceObjectSupplier") != null) {
                Parameter serviceObjectParam = service.getParameter("ServiceObjectSupplier");
                Class serviceObjectMaker = Loader.loadClass(classLoader, ((String)serviceObjectParam.getValue()).trim());
                Method method = serviceObjectMaker.getMethod("getServiceObject", AxisService.class);
                if (method != null) {
                    return method.invoke(serviceObjectMaker.newInstance(), service);
                }
            }
            if ((implInfoParam = service.getParameter("ServiceClass")) != null) {
                Class implClass = Loader.loadClass(classLoader, ((String)implInfoParam.getValue()).trim());
                return implClass.newInstance();
            }
            throw new AxisFault(Messages.getMessage("paramIsNotSpecified", "SERVICE_OBJECT_SUPPLIER"));
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
    }

    public SOAPFactory getSOAPFactory(MessageContext msgContext) throws AxisFault {
        String nsURI = msgContext.getEnvelope().getNamespace().getNamespaceURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(nsURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(nsURI)) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        throw new AxisFault(Messages.getMessage("invalidSOAPversion"));
    }

    protected Object getTheImplementationObject(MessageContext msgContext) throws AxisFault {
        ServiceContext serviceContext = msgContext.getServiceContext();
        Object serviceimpl = serviceContext.getProperty("serviceObject");
        if (serviceimpl != null) {
            return serviceimpl;
        }
        serviceimpl = this.makeNewServiceObject(msgContext);
        DependencyManager.initServiceObject(serviceimpl, msgContext.getServiceContext());
        serviceContext.setProperty("serviceObject", serviceimpl);
        return serviceimpl;
    }

    public class AsyncMessageReceiverWorker
    implements Runnable {
        private MessageContext messageCtx;

        public AsyncMessageReceiverWorker(MessageContext messageCtx) {
            this.messageCtx = messageCtx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ThreadContextDescriptor tc = AbstractMessageReceiver.this.setThreadContext(this.messageCtx);
                try {
                    AbstractMessageReceiver.this.invokeBusinessLogic(this.messageCtx);
                }
                finally {
                    AbstractMessageReceiver.this.restoreThreadContext(tc);
                }
            }
            catch (AxisFault e) {
                if (this.messageCtx.getAxisOperation() instanceof InOnlyAxisOperation) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
                try {
                    MessageContext faultContext = MessageContextBuilder.createFaultMessageContext(this.messageCtx, e);
                    AxisEngine.sendFault(faultContext);
                }
                catch (AxisFault axisFault) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public class ThreadContextDescriptor {
        public ClassLoader oldClassLoader;
        public MessageContext oldMessageContext;
    }
}

