/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.resolver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.resolver.DefaultURIResolver;
import org.xml.sax.InputSource;

public class AARFileBasedURIResolver
extends DefaultURIResolver {
    protected static final Log log = LogFactory.getLog((Class)AARFileBasedURIResolver.class);
    private File aarFile;
    private URI lastImportLocation;

    public AARFileBasedURIResolver(File aarFile) {
        this.aarFile = aarFile;
    }

    public InputSource resolveEntity(String targetNamespace, String schemaLocation, String baseUri) {
        if (this.isAbsolute(schemaLocation)) {
            return super.resolveEntity(targetNamespace, schemaLocation, baseUri);
        }
        if ((baseUri == null || "".equals(baseUri)) && schemaLocation.startsWith("..")) {
            throw new RuntimeException("Unsupported schema location " + schemaLocation);
        }
        this.lastImportLocation = URI.create(baseUri).resolve(schemaLocation);
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            zin = new ZipInputStream(new FileInputStream(this.aarFile));
            byte[] buf = new byte[1024];
            String searchingStr = this.lastImportLocation.toString();
            while ((entry = zin.getNextEntry()) != null) {
                int read;
                String entryName = entry.getName().toLowerCase();
                if (!entryName.equalsIgnoreCase(searchingStr)) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((read = zin.read(buf)) > 0) {
                    out.write(buf, 0, read);
                }
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                InputSource inputSource = new InputSource(in);
                return inputSource;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (zin != null) {
                    zin.close();
                }
            }
            catch (IOException e) {
                log.debug((Object)e);
            }
        }
        log.info((Object)("AARFileBasedURIResolver: Unable to resolve" + this.lastImportLocation));
        return null;
    }
}

