/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.apache.axis2.util.JavaUtils;

public class URLProcessor {
    public static final String DEFAULT_PACKAGE = "org.apache.axis2";

    public static String makePackageName(String namespace) {
        String hostname = null;
        String path = "";
        try {
            URL u = new URL(namespace);
            hostname = u.getHost();
            path = u.getPath();
        }
        catch (MalformedURLException e) {
            if (namespace.indexOf(":") > -1) {
                hostname = namespace.substring(namespace.indexOf(":") + 1);
                if (hostname.indexOf("/") > -1) {
                    hostname = hostname.substring(0, hostname.indexOf("/"));
                }
            }
            hostname = namespace;
        }
        if (hostname == null || hostname.length() == 0) {
            return null;
        }
        hostname = hostname.replace('-', '_');
        path = path.replace('-', '_');
        if ((path = path.replace(':', '_')).length() > 0 && path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(hostname, ".:");
        String[] words = new String[st.countTokens()];
        for (int i = 0; i < words.length; ++i) {
            words[i] = st.nextToken();
        }
        StringBuffer sb = new StringBuffer(namespace.length());
        for (int i = words.length - 1; i >= 0; --i) {
            URLProcessor.addWordToPackageBuffer(sb, words[i], i == words.length - 1);
        }
        StringTokenizer st2 = new StringTokenizer(path, "/");
        while (st2.hasMoreTokens()) {
            URLProcessor.addWordToPackageBuffer(sb, st2.nextToken(), false);
        }
        return sb.toString().toLowerCase();
    }

    private static void addWordToPackageBuffer(StringBuffer sb, String word, boolean firstWord) {
        if (JavaUtils.isJavaKeyword(word)) {
            word = JavaUtils.makeNonJavaKeyword(word);
        }
        if (!firstWord) {
            sb.append('.');
        }
        if (Character.isDigit(word.charAt(0))) {
            sb.append('_');
        }
        if (word.indexOf(46) != -1) {
            char[] buf = word.toCharArray();
            for (int i = 0; i < word.length(); ++i) {
                if (buf[i] != '.') continue;
                buf[i] = 95;
            }
            word = new String(buf);
        }
        sb.append(word);
    }
}

