/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.RequestResponseTransport;

public class DispatchPhase
extends Phase {
    public DispatchPhase() {
    }

    public DispatchPhase(String phaseName) {
        super(phaseName);
    }

    public void checkPostConditions(MessageContext msgContext) throws AxisFault {
        Object requestResponseTransport;
        EndpointReference toEPR = msgContext.getTo();
        if (msgContext.getAxisService() == null) {
            throw new AxisFault(Messages.getMessage("servicenotfoundforepr", toEPR != null ? toEPR.getAddress() : ""));
        }
        if (msgContext.getAxisOperation() == null) {
            throw new AxisFault(Messages.getMessage("operationnotfoundforepr", toEPR != null ? toEPR.getAddress() : "", msgContext.getWSAAction()));
        }
        this.validateTransport(msgContext);
        if (msgContext.getOperationContext() == null) {
            throw new AxisFault(Messages.getMessage("cannotBeNullOperationContext"));
        }
        if (msgContext.getServiceContext() == null) {
            throw new AxisFault(Messages.getMessage("cannotBeNullServiceContext"));
        }
        if (msgContext.getAxisOperation() == null && msgContext.getOperationContext() != null) {
            msgContext.setAxisOperation(msgContext.getOperationContext().getAxisOperation());
        }
        if (msgContext.getAxisService() == null && msgContext.getServiceContext() != null) {
            msgContext.setAxisService(msgContext.getServiceContext().getAxisService());
        }
        if (msgContext.getAxisOperation().getMessageExchangePattern().equals("http://www.w3.org/2004/08/wsdl/in-only")) {
            requestResponseTransport = msgContext.getProperty("RequestResponseTransportControl");
            if (requestResponseTransport != null) {
                ((RequestResponseTransport)requestResponseTransport).acknowledgeMessage(msgContext);
            }
        } else if (msgContext.getAxisOperation().getMessageExchangePattern().equals("http://www.w3.org/2004/08/wsdl/in-out") && (requestResponseTransport = msgContext.getProperty("RequestResponseTransportControl")) != null && AddressingHelper.isReplyRedirected(msgContext) && AddressingHelper.isFaultRedirected(msgContext)) {
            ((RequestResponseTransport)requestResponseTransport).acknowledgeMessage(msgContext);
        }
        ArrayList operationChain = msgContext.getAxisOperation().getRemainingPhasesInFlow();
        msgContext.setExecutionChain((ArrayList)operationChain.clone());
    }

    private void validateTransport(MessageContext msgctx) throws AxisFault {
        AxisService service = msgctx.getAxisService();
        if (service.isEnableAllTransports()) {
            return;
        }
        List trs = service.getExposedTransports();
        String incommingTrs = msgctx.getIncomingTransportName();
        for (int i = 0; i < trs.size(); ++i) {
            String tr = (String)trs.get(i);
            if (incommingTrs == null || !incommingTrs.equals(tr)) continue;
            return;
        }
        EndpointReference toEPR = msgctx.getTo();
        throw new AxisFault(Messages.getMessage("servicenotfoundforepr", toEPR != null ? toEPR.getAddress() : ""));
    }
}

