/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.async.AsyncResult;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.ClientUtils;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.util.CallbackReceiver;

class OutInAxisOperationClient
extends OperationClient {
    OutInAxisOperationClient(OutInAxisOperation axisOp, ServiceContext sc, Options options) {
        super(axisOp, sc, options);
    }

    public void addMessageContext(MessageContext mc) throws AxisFault {
        mc.setServiceContext(this.sc);
        if (mc.getMessageID() == null) {
            this.setMessageID(mc);
        }
        this.axisOp.registerOperationContext(mc, this.oc);
    }

    public MessageContext getMessageContext(String messageLabel) throws AxisFault {
        return this.oc.getMessageContext(messageLabel);
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public void execute(boolean block) throws AxisFault {
        if (this.completed) {
            throw new AxisFault(Messages.getMessage("mepiscomplted"));
        }
        ConfigurationContext cc = this.sc.getConfigurationContext();
        MessageContext mc = this.oc.getMessageContext("Out");
        if (mc == null) {
            throw new AxisFault(Messages.getMessage("outmsgctxnull"));
        }
        this.prepareMessageContext(cc, mc);
        if (this.options.getTransportIn() == null && mc.getTransportIn() == null) {
            mc.setTransportIn(ClientUtils.inferInTransport(cc.getAxisConfiguration(), this.options, mc));
        } else if (mc.getTransportIn() == null) {
            mc.setTransportIn(this.options.getTransportIn());
        }
        if (this.options.isUseSeparateListener()) {
            CallbackReceiver callbackReceiver = (CallbackReceiver)this.axisOp.getMessageReceiver();
            callbackReceiver.addCallback(mc.getMessageID(), this.callback);
            Boolean useCustomListener = (Boolean)this.options.getProperty("UseCustomListener");
            if (useCustomListener == null || !useCustomListener.booleanValue()) {
                EndpointReference replyToFromTransport = mc.getConfigurationContext().getListenerManager().getEPRforService(this.sc.getAxisService().getName(), this.axisOp.getName().getLocalPart(), mc.getTransportIn().getName().getLocalPart());
                if (mc.getReplyTo() == null) {
                    mc.setReplyTo(replyToFromTransport);
                } else {
                    mc.getReplyTo().setAddress(replyToFromTransport.getAddress());
                }
            }
            mc.setProperty("transportNonBlocking", Boolean.TRUE);
            AxisEngine engine = new AxisEngine(cc);
            mc.getConfigurationContext().registerOperationContext(mc.getMessageID(), this.oc);
            engine.send(mc);
        } else if (block) {
            this.send(mc);
            this.completed = true;
        } else {
            this.sc.getConfigurationContext().getThreadPool().execute(new NonBlockingInvocationWorker(this.callback, mc));
        }
    }

    protected MessageContext send(MessageContext msgctx) throws AxisFault {
        SOAPEnvelope resenvelope;
        AxisEngine engine = new AxisEngine(msgctx.getConfigurationContext());
        MessageContext responseMessageContext = new MessageContext();
        responseMessageContext.setOptions(this.options);
        responseMessageContext.setServerSide(false);
        responseMessageContext.setMessageID(msgctx.getMessageID());
        this.addMessageContext(responseMessageContext);
        responseMessageContext.setServiceContext(msgctx.getServiceContext());
        responseMessageContext.setAxisMessage(this.axisOp.getMessage("In"));
        engine.send(msgctx);
        responseMessageContext.setDoingREST(msgctx.isDoingREST());
        responseMessageContext.setProperty("TRANSPORT_IN", msgctx.getProperty("TRANSPORT_IN"));
        responseMessageContext.setTransportIn(msgctx.getTransportIn());
        responseMessageContext.setTransportOut(msgctx.getTransportOut());
        responseMessageContext.setSoapAction("");
        if (responseMessageContext.getEnvelope() == null) {
            resenvelope = TransportUtils.createSOAPMessage(responseMessageContext, msgctx.getEnvelope().getNamespace().getNamespaceURI());
            if (resenvelope != null) {
                responseMessageContext.setEnvelope(resenvelope);
            } else {
                throw new AxisFault(Messages.getMessage("blockingInvocationExpectsResponse"));
            }
        }
        if ((resenvelope = responseMessageContext.getEnvelope()) != null) {
            if (resenvelope.getBody().hasFault()) {
                SOAPFault soapFault = resenvelope.getBody().getFault();
                engine = new AxisEngine(msgctx.getConfigurationContext());
                engine.receiveFault(responseMessageContext);
                if (this.options.isExceptionToBeThrownOnSOAPFault()) {
                    throw new AxisFault(soapFault.getCode(), soapFault.getReason(), soapFault.getNode(), soapFault.getRole(), soapFault.getDetail());
                }
            } else {
                engine = new AxisEngine(msgctx.getConfigurationContext());
                engine.receive(responseMessageContext);
                if (responseMessageContext.getReplyTo() != null) {
                    this.sc.setTargetEPR(responseMessageContext.getReplyTo());
                }
            }
        }
        return responseMessageContext;
    }

    private class NonBlockingInvocationWorker
    implements Runnable {
        private Callback callback;
        private MessageContext msgctx;

        public NonBlockingInvocationWorker(Callback callback, MessageContext msgctx) {
            this.callback = callback;
            this.msgctx = msgctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                MessageContext response = OutInAxisOperationClient.this.send(this.msgctx);
                if (response != null) {
                    SOAPEnvelope resenvelope = response.getEnvelope();
                    SOAPBody body = resenvelope.getBody();
                    if (body.hasFault()) {
                        Exception ex = body.getFault().getException();
                        if (ex != null) {
                            this.callback.onError(ex);
                        } else {
                            this.callback.onError(new Exception(body.getFault().getReason().getText()));
                        }
                    } else {
                        AsyncResult asyncResult = new AsyncResult(response);
                        this.callback.onComplete(asyncResult);
                    }
                }
            }
            catch (Exception e) {
                this.callback.onError(e);
            }
            finally {
                this.callback.setComplete(true);
            }
        }
    }
}

