/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.repository.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.ModuleBuilder;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.deployment.ServiceGroupBuilder;
import org.apache.axis2.deployment.repository.util.ArchiveFileData;
import org.apache.axis2.deployment.resolver.AARBasedWSDLLocator;
import org.apache.axis2.deployment.resolver.AARFileBasedURIResolver;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.description.WSDL20ToAxisServiceBuilder;
import org.apache.axis2.description.WSDLToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.resolver.URIResolver;

public class ArchiveReader
implements DeploymentConstants {
    private static final Log log = LogFactory.getLog((Class)ArchiveReader.class);

    public ArrayList buildServiceGroup(InputStream zin, ArchiveFileData currentFile, AxisServiceGroup axisServiceGroup, HashMap wsdlServices, ConfigurationContext configCtx) throws XMLStreamException, AxisFault {
        DescriptionBuilder builder = new DescriptionBuilder(zin, configCtx);
        OMElement rootElement = builder.buildOM();
        String elementName = rootElement.getLocalName();
        if ("service".equals(elementName)) {
            AxisService axisService = null;
            String serviceName = DescriptionBuilder.getShortFileName(currentFile.getName());
            if (serviceName != null) {
                axisService = (AxisService)wsdlServices.get(serviceName);
            }
            if (axisService == null) {
                axisService = (AxisService)wsdlServices.get(DescriptionBuilder.getShortFileName(currentFile.getName()));
            }
            if (axisService == null) {
                axisService = new AxisService(serviceName);
            } else {
                axisService.setWsdlFound(true);
            }
            axisService.setParent(axisServiceGroup);
            axisService.setClassLoader(currentFile.getClassLoader());
            ServiceBuilder serviceBuilder = new ServiceBuilder(configCtx, axisService);
            AxisService service = serviceBuilder.populateService(rootElement);
            ArrayList<AxisService> serviceList = new ArrayList<AxisService>();
            serviceList.add(service);
            return serviceList;
        }
        if ("serviceGroup".equals(elementName)) {
            ServiceGroupBuilder groupBuilder = new ServiceGroupBuilder(rootElement, wsdlServices, configCtx);
            return groupBuilder.populateServiceGroup(axisServiceGroup);
        }
        throw new AxisFault("Invalid services.xml found");
    }

    public ArrayList processServiceGroup(String filename, ArchiveFileData currentFile, AxisServiceGroup axisServiceGroup, boolean extractService, HashMap wsdls, ConfigurationContext configCtx) throws AxisFault {
        if (!extractService) {
            ZipInputStream zin = null;
            FileInputStream fin = null;
            try {
                ZipEntry entry;
                fin = new FileInputStream(filename);
                zin = new ZipInputStream(fin);
                while ((entry = zin.getNextEntry()) != null) {
                    if (!entry.getName().equalsIgnoreCase("META-INF/services.xml")) continue;
                    axisServiceGroup.setServiceGroupName(DescriptionBuilder.getShortFileName(currentFile.getName()));
                    ArrayList arrayList = this.buildServiceGroup(zin, currentFile, axisServiceGroup, wsdls, configCtx);
                    return arrayList;
                }
                try {
                    throw new DeploymentException(Messages.getMessage("servicexmlnotfound", filename));
                }
                catch (Exception e) {
                    throw new DeploymentException(e);
                }
            }
            finally {
                if (zin != null) {
                    try {
                        zin.close();
                    }
                    catch (IOException e) {
                        log.info((Object)Messages.getMessage("errorininputstreamclose"));
                    }
                }
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (IOException e) {
                        log.info((Object)Messages.getMessage("errorininputstreamclose"));
                    }
                }
            }
        }
        File file = new File(filename, "META-INF/services.xml");
        if (!file.exists()) {
            file = new File(filename, "META-INF/services.xml".toLowerCase());
        }
        if (file.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                axisServiceGroup.setServiceGroupName(currentFile.getName());
                ArrayList e = this.buildServiceGroup(in, currentFile, axisServiceGroup, wsdls, configCtx);
                return e;
            }
            catch (FileNotFoundException e) {
                throw new DeploymentException(Messages.getMessage("fileNotFound", e.getMessage()));
            }
            catch (XMLStreamException e) {
                throw new DeploymentException(Messages.getMessage("StreamException", e.getMessage()));
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        log.info((Object)Messages.getMessage("errorininputstreamclose"));
                    }
                }
            }
        }
        throw new DeploymentException(Messages.getMessage("servicexmlnotfound"));
    }

    private AxisService processWSDLFile(WSDLToAxisServiceBuilder axisServiceBuilder, File serviceArchiveFile, boolean isArchive, InputStream in, String baseURI) throws DeploymentException {
        try {
            if (serviceArchiveFile != null && isArchive) {
                axisServiceBuilder.setCustomResolver((URIResolver)new AARFileBasedURIResolver(serviceArchiveFile));
                if (axisServiceBuilder instanceof WSDL11ToAxisServiceBuilder) {
                    ((WSDL11ToAxisServiceBuilder)axisServiceBuilder).setCustomWSLD4JResolver(new AARBasedWSDLLocator(baseURI, serviceArchiveFile, in));
                }
            } else if (serviceArchiveFile != null) {
                axisServiceBuilder.setBaseUri(serviceArchiveFile.getParentFile().getAbsolutePath());
            }
            return axisServiceBuilder.populateService();
        }
        catch (AxisFault axisFault) {
            log.info((Object)("Trouble processing wsdl file :" + axisFault.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)axisFault);
            }
            return null;
        }
    }

    public HashMap processWSDLs(ArchiveFileData file) throws DeploymentException {
        File serviceFile = file.getFile();
        HashMap<String, AxisService> servicesMap = new HashMap<String, AxisService>();
        boolean isDirectory = serviceFile.isDirectory();
        if (isDirectory) {
            try {
                File metaInfFolder = new File(serviceFile, "META-INF");
                if (!metaInfFolder.exists() && !(metaInfFolder = new File(serviceFile, "META-INF".toLowerCase())).exists()) {
                    throw new DeploymentException(Messages.getMessage("noMetaInf", serviceFile.getName()));
                }
                this.processFilesInFolder(metaInfFolder, servicesMap);
            }
            catch (FileNotFoundException e) {
                throw new DeploymentException(e);
            }
            catch (IOException e) {
                throw new DeploymentException(e);
            }
            catch (XMLStreamException e) {
                throw new DeploymentException(e);
            }
        }
        try {
            ZipEntry entry;
            FileInputStream fin = new FileInputStream(serviceFile);
            ZipInputStream zin = new ZipInputStream(fin);
            byte[] buf = new byte[1024];
            while ((entry = zin.getNextEntry()) != null) {
                AxisService service;
                int read;
                String entryName = entry.getName().toLowerCase();
                if (!entryName.startsWith("META-INF".toLowerCase()) || !entryName.endsWith(".wsdl")) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                if (entryName.indexOf("/") != entryName.lastIndexOf("/")) continue;
                while ((read = zin.read(buf)) > 0) {
                    out.write(buf, 0, read);
                }
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                OMNamespace documentElementNS = new StAXOMBuilder((InputStream)in).getDocumentElement().getNamespace();
                if (documentElementNS == null) continue;
                WSDLToAxisServiceBuilder wsdlToAxisServiceBuilder = null;
                if ("http://www.w3.org/2006/01/wsdl".equals(documentElementNS.getNamespaceURI())) {
                    wsdlToAxisServiceBuilder = new WSDL20ToAxisServiceBuilder(new ByteArrayInputStream(out.toByteArray()), null, null);
                    wsdlToAxisServiceBuilder.setBaseUri(entryName);
                } else if ("http://schemas.xmlsoap.org/wsdl/".equals(documentElementNS.getNamespaceURI())) {
                    wsdlToAxisServiceBuilder = new WSDL11ToAxisServiceBuilder(new ByteArrayInputStream(out.toByteArray()), null, null);
                } else {
                    new DeploymentException(Messages.getMessage("invalidWSDLFound"));
                }
                if ((service = this.processWSDLFile(wsdlToAxisServiceBuilder, serviceFile, true, new ByteArrayInputStream(out.toByteArray()), entry.getName())) == null) continue;
                servicesMap.put(service.getName(), service);
            }
            try {
                zin.close();
            }
            catch (IOException e) {
                log.info((Object)e);
            }
            try {
                fin.close();
            }
            catch (IOException e) {
                log.info((Object)e);
            }
        }
        catch (FileNotFoundException e) {
            throw new DeploymentException(e);
        }
        catch (IOException e) {
            throw new DeploymentException(e);
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
        return servicesMap;
    }

    public void processFilesInFolder(File folder, HashMap servicesMap) throws FileNotFoundException, XMLStreamException, DeploymentException {
        File[] files = folder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file1 = files[i];
            if (!file1.getName().toLowerCase().endsWith(".wsdl")) continue;
            FileInputStream in = new FileInputStream(file1);
            FileInputStream in2 = null;
            OMNamespace documentElementNS = new StAXOMBuilder((InputStream)in).getDocumentElement().getNamespace();
            if (documentElementNS != null) {
                WSDLToAxisServiceBuilder wsdlToAxisServiceBuilder = null;
                if ("http://www.w3.org/2006/01/wsdl".equals(documentElementNS.getNamespaceURI())) {
                    in2 = new FileInputStream(file1);
                    wsdlToAxisServiceBuilder = new WSDL20ToAxisServiceBuilder(in2, null, null);
                } else if ("http://schemas.xmlsoap.org/wsdl/".equals(documentElementNS.getNamespaceURI())) {
                    in2 = new FileInputStream(file1);
                    wsdlToAxisServiceBuilder = new WSDL11ToAxisServiceBuilder(in2, null, null);
                } else {
                    new DeploymentException(Messages.getMessage("invalidWSDLFound"));
                }
                FileInputStream in3 = new FileInputStream(file1);
                AxisService service = this.processWSDLFile(wsdlToAxisServiceBuilder, file1, false, in2, file1.toURI().toString());
                try {
                    if (in2 != null) {
                        in2.close();
                    }
                    in3.close();
                }
                catch (IOException e) {
                    log.info((Object)e);
                }
                if (service != null) {
                    servicesMap.put(service.getName(), service);
                }
            }
            try {
                ((InputStream)in).close();
                continue;
            }
            catch (IOException e) {
                log.info((Object)e);
            }
        }
    }

    public void readModuleArchive(ArchiveFileData archiveFile, AxisModule module, boolean explodedDir, AxisConfiguration axisConfig) throws DeploymentException {
        block16: {
            boolean moduleXMLFound = false;
            if (!explodedDir) {
                try {
                    ZipEntry entry;
                    FileInputStream fin = new FileInputStream(archiveFile.getAbsolutePath());
                    ZipInputStream zin = new ZipInputStream(fin);
                    while ((entry = zin.getNextEntry()) != null) {
                        if (!entry.getName().equalsIgnoreCase("META-INF/module.xml")) continue;
                        moduleXMLFound = true;
                        ModuleBuilder builder = new ModuleBuilder(zin, module, axisConfig);
                        module.setName(new QName(DescriptionBuilder.getShortFileName(archiveFile.getServiceName())));
                        builder.populateModule();
                        break;
                    }
                    zin.close();
                    fin.close();
                    if (!moduleXMLFound) {
                        throw new DeploymentException(Messages.getMessage("modulexmlnotfound", archiveFile.getAbsolutePath()));
                    }
                    break block16;
                }
                catch (Exception e) {
                    throw new DeploymentException(e);
                }
            }
            File file = new File(archiveFile.getAbsolutePath(), "META-INF/module.xml");
            if (file.exists() || (file = new File(archiveFile.getAbsolutePath(), "META-INF/module.xml".toLowerCase())).exists()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                    ModuleBuilder builder = new ModuleBuilder(in, module, axisConfig);
                    module.setName(new QName(DescriptionBuilder.getShortFileName(archiveFile.getServiceName())));
                    builder.populateModule();
                }
                catch (FileNotFoundException e) {
                    throw new DeploymentException(Messages.getMessage("fileNotFound", e.getMessage()));
                }
                finally {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e) {
                            log.info((Object)Messages.getMessage("errorininputstreamclose"));
                        }
                    }
                }
            }
            throw new DeploymentException(Messages.getMessage("modulexmlnotfound", archiveFile.getAbsolutePath()));
        }
    }
}

