/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;

public class WSDLBasedPolicyProcessor {
    private HashMap ns2modules = new HashMap();

    public WSDLBasedPolicyProcessor(ConfigurationContext configctx) {
        AxisConfiguration axisConfiguration = configctx.getAxisConfiguration();
        Iterator iterator = axisConfiguration.getModules().values().iterator();
        while (iterator.hasNext()) {
            AxisModule axisModule = (AxisModule)iterator.next();
            String[] namespaces = axisModule.getSupportedPolicyNamespaces();
            if (namespaces == null) continue;
            for (int i = 0; i < namespaces.length; ++i) {
                ArrayList<AxisModule> moduleList = null;
                Object obj = this.ns2modules.get(namespaces[i]);
                if (obj == null) {
                    moduleList = new ArrayList<AxisModule>(5);
                    this.ns2modules.put(namespaces[i], moduleList);
                } else {
                    moduleList = (ArrayList<AxisModule>)obj;
                }
                moduleList.add(axisModule);
            }
        }
    }

    public void configureServicePolices(AxisService axisService) throws AxisFault {
        Iterator operations = axisService.getOperations();
        while (operations.hasNext()) {
            AxisOperation axisOp = (AxisOperation)operations.next();
            this.configureOperationPolices(axisOp);
        }
    }

    public void configureOperationPolices(AxisOperation op) throws AxisFault {
        Iterator iterator;
        PolicyInclude policyInclude = op.getPolicyInclude();
        Policy policy = policyInclude.getEffectivePolicy();
        if (policy != null && (iterator = (policy = (Policy)policy.normalize(policyInclude.getPolicyRegistry(), false)).getAlternatives()).hasNext()) {
            ArrayList<String> namespaceList = new ArrayList<String>();
            Iterator assertions = ((List)iterator.next()).iterator();
            while (assertions.hasNext()) {
                Assertion assertion = (Assertion)iterator.next();
                QName name = assertion.getName();
                String namespaceURI = name.getNamespaceURI();
                if (namespaceList.contains(namespaceURI)) continue;
                namespaceList.add(namespaceURI);
            }
            Iterator namespaces = namespaceList.iterator();
            while (iterator.hasNext()) {
                String namespace = (String)namespaces.next();
                List modulesToEngage = (List)this.ns2modules.get(namespace);
                if (modulesToEngage == null) {
                    System.err.println("cannot find any modules to process " + namespace + "type assertions");
                    continue;
                }
                this.engageModulesToAxisDescription(modulesToEngage, op);
            }
        }
    }

    private void engageModulesToAxisDescription(List modulesToEngage, AxisDescription axisDescription) throws AxisFault {
        Iterator iterator = modulesToEngage.iterator();
        while (iterator.hasNext()) {
            AxisModule axisModule = (AxisModule)iterator.next();
            QName moduleName = axisModule.getName();
            if (axisDescription.isEngaged(moduleName)) continue;
            axisDescription.engageModule(axisModule, axisDescription.getAxisConfiguration());
            axisModule.getModule().engageNotify(axisDescription);
        }
    }
}

