/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestURIBasedDispatcher
extends AbstractDispatcher {
    private static final long serialVersionUID = 6212111158265910316L;
    public static final QName NAME = new QName("http://ws.apache.org/axis2/", "RequestURIBasedDispatcher");
    private static final Log log = LogFactory.getLog((Class)RequestURIBasedDispatcher.class);
    String serviceName = null;
    QName operationName = null;

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        String filePart;
        String[] values;
        log.debug((Object)("Checking for Operation using target endpoint uri fragment : " + this.operationName));
        EndpointReference toEPR = messageContext.getTo();
        if (toEPR != null && this.operationName == null && (values = Utils.parseRequestURLForServiceAndOperation(filePart = toEPR.getAddress())).length >= 2 && values[1] != null) {
            this.operationName = new QName(values[1]);
        }
        if (this.operationName != null) {
            AxisOperation axisOperation = service.getOperation(this.operationName);
            this.operationName = null;
            return axisOperation;
        }
        return null;
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        EndpointReference toEPR = messageContext.getTo();
        if (toEPR != null) {
            log.debug((Object)("Checking for Service using target endpoint address : " + toEPR.getAddress()));
            String filePart = toEPR.getAddress();
            String[] values = Utils.parseRequestURLForServiceAndOperation(filePart);
            if (values[1] != null) {
                this.operationName = new QName(values[1]);
            }
            if (values[0] != null) {
                this.serviceName = values[0];
                AxisConfiguration registry = messageContext.getConfigurationContext().getAxisConfiguration();
                return registry.getService(this.serviceName);
            }
        }
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }
}

