/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jibx;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.util.StAXUtils;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshaller;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.StAXWriter;

public class JiBXDataSource
implements OMDataSource {
    private final int marshallerIndex;
    private final String elementName;
    private final String elementNamespaceUri;
    private final Object dataObject;
    private final IBindingFactory bindingFactory;

    public JiBXDataSource(IMarshallable obj, IBindingFactory factory) {
        this.marshallerIndex = -1;
        this.dataObject = obj;
        this.bindingFactory = factory;
        this.elementNamespaceUri = null;
        this.elementName = null;
    }

    public JiBXDataSource(Object obj, int index, String name, String uri, IBindingFactory factory) {
        if (index < 0) {
            throw new IllegalArgumentException("index value must be non-negative");
        }
        this.marshallerIndex = index;
        this.elementName = name;
        this.elementNamespaceUri = uri;
        this.dataObject = obj;
        this.bindingFactory = factory;
    }

    private void marshal(IMarshallingContext ctx) throws JiBXException {
        if (this.marshallerIndex < 0) {
            ((IMarshallable)this.dataObject).marshal(ctx);
        } else {
            IXMLWriter wrtr = ctx.getXmlWriter();
            int nsidx = 0;
            boolean nsfound = true;
            if (!"".equals(this.elementNamespaceUri)) {
                nsfound = false;
                for (nsidx = wrtr.getNamespaceCount() - 1; nsidx > 1; --nsidx) {
                    if (!this.elementNamespaceUri.equals(wrtr.getNamespaceUri(nsidx))) continue;
                    nsfound = true;
                    break;
                }
            }
            try {
                if (nsfound) {
                    wrtr.startTagOpen(nsidx, this.elementName);
                } else {
                    nsidx = wrtr.getNamespaceCount();
                    String[] uris = new String[]{this.elementNamespaceUri};
                    int[] indexes = new int[]{nsidx};
                    String[] prefixes = new String[]{""};
                    wrtr.pushExtensionNamespaces(uris);
                    wrtr.startTagNamespaces(nsidx, this.elementName, indexes, prefixes);
                }
                IMarshaller mrsh = ctx.getMarshaller(this.marshallerIndex, this.bindingFactory.getMappedClasses()[this.marshallerIndex]);
                mrsh.marshal(this.dataObject, ctx);
                wrtr.endTag(nsidx, this.elementName);
                if (!nsfound) {
                    wrtr.popExtensionNamespaces();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        try {
            IMarshallingContext ctx = this.bindingFactory.createMarshallingContext();
            ctx.setOutput(output, format.getCharSetEncoding());
            this.marshal(ctx);
        }
        catch (JiBXException e) {
            throw new XMLStreamException("Error in JiBX marshalling", e);
        }
    }

    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        try {
            IMarshallingContext ctx = this.bindingFactory.createMarshallingContext();
            ctx.setOutput(writer);
            this.marshal(ctx);
        }
        catch (JiBXException e) {
            throw new XMLStreamException("Error in JiBX marshalling", e);
        }
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        try {
            StAXWriter writer = new StAXWriter(this.bindingFactory.getNamespaces(), xmlWriter);
            IMarshallingContext ctx = this.bindingFactory.createMarshallingContext();
            ctx.setXmlWriter((IXMLWriter)writer);
            this.marshal(ctx);
        }
        catch (JiBXException e) {
            throw new XMLStreamException("Error in JiBX marshalling", e);
        }
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.serialize(bos, null);
        return StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(bos.toByteArray()));
    }
}

