/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.emitter;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.util.Utils;
import org.apache.axis2.util.XSLTUtils;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.codegen.emitter.Emitter;
import org.apache.axis2.wsdl.codegen.writer.AntBuildWriter;
import org.apache.axis2.wsdl.codegen.writer.CallbackHandlerWriter;
import org.apache.axis2.wsdl.codegen.writer.ClassWriter;
import org.apache.axis2.wsdl.codegen.writer.ExceptionWriter;
import org.apache.axis2.wsdl.codegen.writer.InterfaceImplementationWriter;
import org.apache.axis2.wsdl.codegen.writer.InterfaceWriter;
import org.apache.axis2.wsdl.codegen.writer.MessageReceiverWriter;
import org.apache.axis2.wsdl.codegen.writer.SchemaWriter;
import org.apache.axis2.wsdl.codegen.writer.ServiceXMLWriter;
import org.apache.axis2.wsdl.codegen.writer.SkeletonInterfaceWriter;
import org.apache.axis2.wsdl.codegen.writer.SkeletonWriter;
import org.apache.axis2.wsdl.codegen.writer.TestClassWriter;
import org.apache.axis2.wsdl.codegen.writer.WSDL11Writer;
import org.apache.axis2.wsdl.codegen.writer.WSDL20Writer;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.axis2.wsdl.util.MessagePartInformationHolder;
import org.apache.axis2.wsdl.util.TypeTesterUtil;
import org.apache.axis2.wsdl.util.XSLTIncludeResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.commons.schema.XmlSchema;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class AxisServiceBasedMultiLanguageEmitter
implements Emitter {
    protected static final String CALL_BACK_HANDLER_SUFFIX = "CallbackHandler";
    protected static final String STUB_SUFFIX = "Stub";
    protected static final String TEST_SUFFIX = "Test";
    protected static final String SKELETON_CLASS_SUFFIX = "Skeleton";
    protected static final String SKELETON_CLASS_SUFFIX_BACK = "Impl";
    protected static final String SKELETON_INTERFACE_SUFFIX = "SkeletonInterface";
    protected static final String SKELETON_INTERFACE_SUFFIX_BACK = "";
    protected static final String MESSAGE_RECEIVER_SUFFIX = "MessageReceiver";
    protected static final String FAULT_SUFFIX = "Exception";
    protected static final String DATABINDING_SUPPORTER_NAME_SUFFIX = "DatabindingSupporter";
    protected static Map mepToClassMap;
    protected static Map mepToSuffixMap;
    protected int uniqueFaultNameCounter = 0;
    protected static HashMap constructorMap;
    protected static final Log log;
    protected URIResolver resolver;
    protected Map infoHolder;
    protected CodeGenConfiguration codeGenConfiguration;
    protected TypeMapper mapper;
    protected AxisService axisService;
    protected Map fullyQualifiedFaultClassNameMap = new HashMap();
    protected Map faultClassNameMap = new HashMap();
    protected Map instantiatableMessageClassNames = new HashMap();
    protected static final String TEST_SRC_DIR_NAME = "test";

    public AxisServiceBasedMultiLanguageEmitter() {
        this.infoHolder = new HashMap();
    }

    public void setCodeGenConfiguration(CodeGenConfiguration configuration) {
        this.codeGenConfiguration = configuration;
        this.axisService = this.codeGenConfiguration.getAxisService();
        this.resolver = new XSLTIncludeResolver(this.codeGenConfiguration);
    }

    public void setMapper(TypeMapper mapper) {
        this.mapper = mapper;
    }

    protected void updateMapperForStub() {
        this.updateMapperClassnames(this.getFullyQualifiedStubName());
    }

    protected String getFullyQualifiedStubName() {
        String packageName = this.codeGenConfiguration.getPackageName();
        String localPart = this.makeJavaClassName(this.axisService.getName());
        return packageName + "." + localPart + STUB_SUFFIX;
    }

    protected void resetFaultNames() {
        this.fullyQualifiedFaultClassNameMap.clear();
        this.faultClassNameMap.clear();
    }

    protected void generateAndPopulateFaultNames() {
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            AxisOperation operation = (AxisOperation)operations.next();
            ArrayList faultMessages = operation.getFaultMessages();
            for (int i = 0; i < faultMessages.size(); ++i) {
                AxisMessage faultMessage = (AxisMessage)faultMessages.get(i);
                if (this.fullyQualifiedFaultClassNameMap.containsKey(faultMessage.getElementQName())) continue;
                String className = this.makeJavaClassName(faultMessage.getName() + FAULT_SUFFIX);
                while (this.fullyQualifiedFaultClassNameMap.containsValue(className)) {
                    className = this.makeJavaClassName(className + this.uniqueFaultNameCounter++);
                }
                this.fullyQualifiedFaultClassNameMap.put(faultMessage.getElementQName(), className);
                this.faultClassNameMap.put(faultMessage.getElementQName(), className);
            }
        }
    }

    public void emitStub() throws CodeGenerationException {
        try {
            if (this.mapper.isObjectMappingPresent()) {
                this.updateMapperForStub();
            } else {
                this.copyToFaultMap();
            }
            this.resetFaultNames();
            this.generateAndPopulateFaultNames();
            this.updateFaultPackageForStub();
            if (!this.codeGenConfiguration.isPackClasses()) {
                this.writeInterface(false);
            }
            this.writeCallBackHandlers();
            this.writeExceptions();
            this.writeInterfaceImplementation();
            this.writeTestClasses();
            if (!this.codeGenConfiguration.isGenerateAll() && !this.codeGenConfiguration.isFlattenFiles()) {
                this.writeAntBuild();
            }
        }
        catch (CodeGenerationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    protected void writeAntBuild() throws Exception {
        Document skeletonModel = this.createDOMDocumentForAntBuild();
        this.debugLogDocument("Document for ant build:", skeletonModel);
        AntBuildWriter antBuildWriter = new AntBuildWriter(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getOutputLanguage());
        antBuildWriter.setDatabindingFramework(this.codeGenConfiguration.getDatabindingType());
        this.writeClass(skeletonModel, antBuildWriter);
    }

    protected Document createDOMDocumentForAntBuild() {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("ant");
        String serviceName = this.makeJavaClassName(this.axisService.getName());
        String packageName = this.codeGenConfiguration.getPackageName();
        String[] dotSeparatedValues = packageName.split("\\.");
        this.addAttribute(doc, "package", dotSeparatedValues[0], rootElement);
        this.addAttribute(doc, "name", serviceName, rootElement);
        this.addAttribute(doc, "servicename", serviceName, rootElement);
        this.addAttribute(doc, "src", this.codeGenConfiguration.getSourceLocation(), rootElement);
        this.addAttribute(doc, "resource", this.codeGenConfiguration.getResourceLocation(), rootElement);
        if (this.codeGenConfiguration.isServerSide()) {
            this.addAttribute(doc, "isserverside", "yes", rootElement);
        }
        doc.appendChild(rootElement);
        return doc;
    }

    protected void writeTestClasses() throws Exception {
        if (this.codeGenConfiguration.isWriteTestCase()) {
            Document classModel = this.createDOMDocumentForTestCase();
            this.debugLogDocument("Document for test case:", classModel);
            TestClassWriter callbackWriter = new TestClassWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), TEST_SRC_DIR_NAME), this.codeGenConfiguration.getOutputLanguage());
            this.writeClass(classModel, callbackWriter);
        }
    }

    protected Document createDOMDocumentForTestCase() {
        String coreClassName = this.makeJavaClassName(this.axisService.getName());
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("class");
        this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), rootElement);
        this.addAttribute(doc, "name", coreClassName + TEST_SUFFIX, rootElement);
        this.addAttribute(doc, "namespace", this.axisService.getTargetNamespace(), rootElement);
        this.addAttribute(doc, "interfaceName", coreClassName, rootElement);
        this.addAttribute(doc, "callbackname", coreClassName + CALL_BACK_HANDLER_SUFFIX, rootElement);
        this.addAttribute(doc, "stubname", coreClassName + STUB_SUFFIX, rootElement);
        this.fillSyncAttributes(doc, rootElement);
        this.loadOperations(doc, rootElement, null);
        rootElement.appendChild(this.createDOMElementforDatabinders(doc, false));
        doc.appendChild(rootElement);
        return doc;
    }

    protected void writeInterfaceImplementation() throws Exception {
        Document interfaceImplModel = this.createDOMDocumentForInterfaceImplementation();
        this.debugLogDocument("Document for interface implementation:", interfaceImplModel);
        InterfaceImplementationWriter writer = new InterfaceImplementationWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
        this.writeClass(interfaceImplModel, writer);
    }

    protected Document createDOMDocumentForInterfaceImplementation() throws Exception {
        String packageName = this.codeGenConfiguration.getPackageName();
        String localPart = this.makeJavaClassName(this.axisService.getName());
        String stubName = localPart + STUB_SUFFIX;
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("class");
        this.addAttribute(doc, "package", packageName, rootElement);
        this.addAttribute(doc, "name", stubName, rootElement);
        this.addAttribute(doc, "servicename", localPart, rootElement);
        this.addAttribute(doc, "namespace", this.axisService.getTargetNamespace(), rootElement);
        this.addAttribute(doc, "interfaceName", localPart, rootElement);
        this.addAttribute(doc, "callbackname", localPart + CALL_BACK_HANDLER_SUFFIX, rootElement);
        if (this.codeGenConfiguration.isPackClasses()) {
            this.addAttribute(doc, "wrapped", "yes", rootElement);
        }
        this.addSoapVersion(doc, rootElement);
        this.addEndpoint(doc, rootElement);
        this.fillSyncAttributes(doc, rootElement);
        if (this.mapper.isObjectMappingPresent()) {
            this.addAttribute(doc, "skip-write", "yes", rootElement);
            this.processModelObjects(this.mapper.getAllMappedObjects(), rootElement, doc);
        }
        this.loadOperations(doc, rootElement, null);
        rootElement.appendChild(this.createDOMElementforDatabinders(doc, false));
        Object moduleCodegenPolicyExtensionElement = this.codeGenConfiguration.getProperty("module-codegen-policy-extensions");
        if (moduleCodegenPolicyExtensionElement != null) {
            rootElement.appendChild(doc.importNode((Element)moduleCodegenPolicyExtensionElement, true));
        }
        rootElement.appendChild(this.getUniqueListofFaults(doc));
        doc.appendChild(rootElement);
        return doc;
    }

    protected Element getUniqueListofFaults(Document doc) {
        Element rootElement = doc.createElement("fault-list");
        Iterator iterator = this.fullyQualifiedFaultClassNameMap.keySet().iterator();
        while (iterator.hasNext()) {
            Element faultElement = doc.createElement("fault");
            QName key = (QName)iterator.next();
            this.addAttribute(doc, "name", (String)this.fullyQualifiedFaultClassNameMap.get(key), faultElement);
            this.addAttribute(doc, "shortName", (String)this.faultClassNameMap.get(key), faultElement);
            String typeMapping = this.mapper.getTypeMappingName(key);
            this.addAttribute(doc, "type", typeMapping == null ? SKELETON_INTERFACE_SUFFIX_BACK : typeMapping, faultElement);
            String attribValue = (String)this.instantiatableMessageClassNames.get(key);
            this.addAttribute(doc, "instantiatableType", attribValue == null ? SKELETON_INTERFACE_SUFFIX_BACK : attribValue, faultElement);
            if (this.mapper.getDefaultMappingName().equals(typeMapping)) {
                this.addAttribute(doc, "default", "yes", faultElement);
            }
            this.addAttribute(doc, "value", this.getParamInitializer(typeMapping), faultElement);
            rootElement.appendChild(faultElement);
        }
        return rootElement;
    }

    private void addFaultMessages(List operationFaultMessages, Set faultMessagesToMep) {
        Iterator iter = operationFaultMessages.iterator();
        while (iter.hasNext()) {
            AxisMessage faultMessage = (AxisMessage)iter.next();
            faultMessagesToMep.add(faultMessage.getElementQName());
        }
    }

    protected Element getUniqueListofFaultsofMep(Document doc, String mep) {
        HashSet faultListForMep = new HashSet();
        Iterator iter = this.axisService.getOperations();
        while (iter.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iter.next();
            if (mep == null) {
                this.addFaultMessages(axisOperation.getFaultMessages(), faultListForMep);
                continue;
            }
            if (!mep.equals(axisOperation.getMessageExchangePattern())) continue;
            this.addFaultMessages(axisOperation.getFaultMessages(), faultListForMep);
        }
        Element rootElement = doc.createElement("fault-list");
        Iterator iterator = faultListForMep.iterator();
        while (iterator.hasNext()) {
            Element faultElement = doc.createElement("fault");
            QName key = (QName)iterator.next();
            this.addAttribute(doc, "name", (String)this.fullyQualifiedFaultClassNameMap.get(key), faultElement);
            this.addAttribute(doc, "shortName", (String)this.faultClassNameMap.get(key), faultElement);
            String typeMapping = this.mapper.getTypeMappingName(key);
            this.addAttribute(doc, "type", typeMapping == null ? SKELETON_INTERFACE_SUFFIX_BACK : typeMapping, faultElement);
            String attribValue = (String)this.instantiatableMessageClassNames.get(key);
            this.addAttribute(doc, "instantiatableType", attribValue == null ? SKELETON_INTERFACE_SUFFIX_BACK : attribValue, faultElement);
            if (this.mapper.getDefaultMappingName().equals(typeMapping)) {
                this.addAttribute(doc, "default", "yes", faultElement);
            }
            this.addAttribute(doc, "value", this.getParamInitializer(typeMapping), faultElement);
            rootElement.appendChild(faultElement);
        }
        return rootElement;
    }

    protected void addEndpoint(Document doc, Element rootElement) throws Exception {
        PolicyInclude policyInclude = this.axisService.getPolicyInclude();
        Policy servicePolicy = policyInclude.getPolicy();
        if (servicePolicy != null) {
            String policyString = PolicyUtil.policyComponentToString((PolicyComponent)servicePolicy);
            policyString = PolicyUtil.getSafeString((String)policyString);
            this.addAttribute(doc, "policy", policyString, rootElement);
        }
        Element endpointElement = doc.createElement("endpoint");
        String endpoint = this.axisService.getEndpoint();
        Text text = doc.createTextNode(endpoint != null ? endpoint : SKELETON_INTERFACE_SUFFIX_BACK);
        endpointElement.appendChild(text);
        rootElement.appendChild(endpointElement);
    }

    protected void addSoapVersion(Document doc, Element rootElement) {
        String soapNsUri = this.axisService.getSoapNsUri();
        if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(soapNsUri)) {
            this.addAttribute(doc, "soap-version", "1.1", rootElement);
        } else if ("http://schemas.xmlsoap.org/wsdl/soap12/".equals(soapNsUri)) {
            this.addAttribute(doc, "soap-version", "1.2", rootElement);
        }
    }

    protected void writeExceptions() throws Exception {
        Iterator iterator = this.fullyQualifiedFaultClassNameMap.keySet().iterator();
        while (iterator.hasNext()) {
            Document doc = this.getEmptyDocument();
            Element faultElement = doc.createElement("fault");
            this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), faultElement);
            QName key = (QName)iterator.next();
            this.addAttribute(doc, "name", (String)this.faultClassNameMap.get(key), faultElement);
            this.addAttribute(doc, "shortName", (String)this.faultClassNameMap.get(key), faultElement);
            String typeMapping = this.mapper.getTypeMappingName(key);
            this.addAttribute(doc, "type", typeMapping == null ? SKELETON_INTERFACE_SUFFIX_BACK : typeMapping, faultElement);
            String attribValue = (String)this.instantiatableMessageClassNames.get(key);
            this.addAttribute(doc, "instantiatableType", attribValue == null ? SKELETON_INTERFACE_SUFFIX_BACK : attribValue, faultElement);
            if (this.mapper.getDefaultMappingName().equals(typeMapping)) {
                this.addAttribute(doc, "default", "yes", faultElement);
            }
            this.addAttribute(doc, "value", this.getParamInitializer(typeMapping), faultElement);
            ExceptionWriter exceptionWriter = new ExceptionWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
            doc.appendChild(faultElement);
            this.writeClass(doc, exceptionWriter);
        }
    }

    protected Document createDOMDocumentForException() {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("callback");
        this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), rootElement);
        this.addAttribute(doc, "name", this.makeJavaClassName(this.axisService.getName()) + CALL_BACK_HANDLER_SUFFIX, rootElement);
        this.loadOperations(doc, rootElement, null);
        doc.appendChild(rootElement);
        return doc;
    }

    protected void writeCallBackHandlers() throws Exception {
        if (this.codeGenConfiguration.isAsyncOn()) {
            Document interfaceModel = this.createDOMDocumentForCallbackHandler();
            this.debugLogDocument("Document for callback handler:", interfaceModel);
            CallbackHandlerWriter callbackWriter = new CallbackHandlerWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
            this.writeClass(interfaceModel, callbackWriter);
        }
    }

    protected Document createDOMDocumentForCallbackHandler() {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("callback");
        this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), rootElement);
        this.addAttribute(doc, "name", this.makeJavaClassName(this.axisService.getName()) + CALL_BACK_HANDLER_SUFFIX, rootElement);
        this.loadOperations(doc, rootElement, null);
        doc.appendChild(rootElement);
        return doc;
    }

    protected void writeInterface(boolean writeDatabinders) throws Exception {
        Document interfaceModel = this.createDOMDocumentForInterface(writeDatabinders);
        this.debugLogDocument("Document for interface:", interfaceModel);
        InterfaceWriter interfaceWriter = new InterfaceWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
        this.writeClass(interfaceModel, interfaceWriter);
    }

    protected Document createDOMDocumentForInterface(boolean writeDatabinders) {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("interface");
        String localPart = null;
        localPart = this.codeGenConfiguration.isBackwordCompatibilityMode() ? this.makeJavaClassName(this.axisService.getPortTypeName()) : this.makeJavaClassName(this.axisService.getName());
        this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), rootElement);
        this.addAttribute(doc, "name", localPart, rootElement);
        this.addAttribute(doc, "callbackname", this.makeJavaClassName(this.axisService.getName()) + CALL_BACK_HANDLER_SUFFIX, rootElement);
        this.fillSyncAttributes(doc, rootElement);
        this.loadOperations(doc, rootElement, null);
        if (writeDatabinders && this.mapper.isObjectMappingPresent()) {
            this.addAttribute(doc, "skip-write", "yes", rootElement);
            this.processModelObjects(this.mapper.getAllMappedObjects(), rootElement, doc);
        }
        doc.appendChild(rootElement);
        return doc;
    }

    protected void updateMapperForMessageReceiver() {
        this.updateMapperClassnames(this.getFullyQualifiedMessageReceiverName());
    }

    protected String getFullyQualifiedMessageReceiverName() {
        String packageName = this.codeGenConfiguration.getPackageName();
        String localPart = this.makeJavaClassName(this.axisService.getName());
        return packageName + "." + localPart + MESSAGE_RECEIVER_SUFFIX;
    }

    protected String getFullyQualifiedSkeletonName() {
        String packageName = this.codeGenConfiguration.getPackageName();
        String localPart = this.makeJavaClassName(this.axisService.getName());
        String skeltonName = this.codeGenConfiguration.isBackwordCompatibilityMode() ? packageName + "." + this.makeJavaClassName(this.axisService.getBindingName()) + SKELETON_CLASS_SUFFIX_BACK : packageName + "." + localPart + SKELETON_CLASS_SUFFIX;
        return skeltonName;
    }

    protected String getFullyQualifiedSkeletonInterfaceName() {
        String packageName = this.codeGenConfiguration.getPackageName();
        String localPart = this.makeJavaClassName(this.axisService.getName());
        String skeltonInterfaceName = this.codeGenConfiguration.isBackwordCompatibilityMode() ? packageName + "." + this.makeJavaClassName(this.axisService.getPortTypeName()) + SKELETON_INTERFACE_SUFFIX_BACK : packageName + "." + localPart + SKELETON_INTERFACE_SUFFIX;
        return skeltonInterfaceName;
    }

    public void emitSkeleton() throws CodeGenerationException {
        try {
            if (this.mapper.isObjectMappingPresent()) {
                this.updateMapperForMessageReceiver();
            } else {
                this.copyToFaultMap();
            }
            this.generateAndPopulateFaultNames();
            if (this.codeGenConfiguration.isServerSideInterface()) {
                this.writeSkeletonInterface();
            }
            if (this.codeGenConfiguration.isServerSideInterface()) {
                if (this.codeGenConfiguration.isGenerateDeployementDescriptor()) {
                    this.writeSkeleton();
                }
            } else {
                this.writeSkeleton();
            }
            this.writeMessageReceiver();
            this.writeExceptions();
            if (this.codeGenConfiguration.isGenerateDeployementDescriptor()) {
                this.writeServiceXml();
            }
            if (!this.codeGenConfiguration.isFlattenFiles()) {
                this.writeAntBuild();
            }
            this.writeWSDLFiles();
        }
        catch (CodeGenerationException cgExp) {
            throw cgExp;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    protected void writeWSDLFiles() {
        this.axisService.setCustomSchemaNamePrefix(SKELETON_INTERFACE_SUFFIX_BACK);
        this.axisService.setCustomSchemaNameSuffix(".xsd");
        this.axisService.setSchemaLocationsAdjusted(false);
        this.axisService.populateSchemaMappings();
        SchemaWriter schemaWriter = new SchemaWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getResourceLocation()));
        Map schemaMappings = this.axisService.getSchemaMappingTable();
        Iterator keys = schemaMappings.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            schemaWriter.writeSchema((XmlSchema)schemaMappings.get(key), (String)key);
        }
        if ("2.0".equals(this.codeGenConfiguration.getWSDLVersion())) {
            WSDL20Writer wsdl20Writer = new WSDL20Writer(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getResourceLocation()));
            wsdl20Writer.writeWSDL(this.axisService);
        } else {
            WSDL11Writer wsdl11Writer = new WSDL11Writer(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getResourceLocation()));
            wsdl11Writer.writeWSDL(this.axisService);
        }
    }

    protected void copyToFaultMap() {
        Map classNameMap = this.mapper.getAllMappedNames();
        Iterator keys = classNameMap.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            this.instantiatableMessageClassNames.put(key, classNameMap.get(key));
        }
    }

    protected void updateFaultPackageForStub() {
        Iterator faultClassNameKeys = this.fullyQualifiedFaultClassNameMap.keySet().iterator();
        while (faultClassNameKeys.hasNext()) {
            Object key = faultClassNameKeys.next();
            String className = (String)this.fullyQualifiedFaultClassNameMap.get(key);
            String fullyQualifiedStubName = this.getFullyQualifiedStubName();
            this.fullyQualifiedFaultClassNameMap.put(key, this.codeGenConfiguration.getPackageName() + "." + className);
        }
    }

    protected void writeMessageReceiver() throws Exception {
        if (this.codeGenConfiguration.isWriteMessageReceiver()) {
            Iterator it = mepToClassMap.keySet().iterator();
            while (it.hasNext()) {
                String mep = (String)it.next();
                Document classModel = this.createDocumentForMessageReceiver(mep, this.codeGenConfiguration.isServerSideInterface());
                this.debugLogDocument("Document for message receiver (mep=" + mep + "):", classModel);
                if (!Boolean.TRUE.equals(this.infoHolder.get(mep))) continue;
                MessageReceiverWriter writer = new MessageReceiverWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
                this.writeClass(classModel, writer);
            }
        }
    }

    protected Document createDocumentForMessageReceiver(String mep, boolean isServerSideInterface) {
        boolean isOpsFound;
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("interface");
        this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), rootElement);
        String localPart = this.makeJavaClassName(this.axisService.getName());
        this.addAttribute(doc, "name", localPart + mepToSuffixMap.get(mep), rootElement);
        if (this.codeGenConfiguration.isBackwordCompatibilityMode()) {
            this.addAttribute(doc, "skeletonname", this.makeJavaClassName(this.axisService.getBindingName()) + SKELETON_CLASS_SUFFIX_BACK, rootElement);
            if (isServerSideInterface) {
                this.addAttribute(doc, "skeletonInterfaceName", this.makeJavaClassName(this.axisService.getPortTypeName()) + SKELETON_INTERFACE_SUFFIX_BACK, rootElement);
            } else {
                this.addAttribute(doc, "skeletonInterfaceName", this.makeJavaClassName(this.axisService.getBindingName()) + SKELETON_CLASS_SUFFIX_BACK, rootElement);
            }
        } else {
            this.addAttribute(doc, "skeletonname", localPart + SKELETON_CLASS_SUFFIX, rootElement);
            if (isServerSideInterface) {
                this.addAttribute(doc, "skeletonInterfaceName", localPart + SKELETON_INTERFACE_SUFFIX, rootElement);
            } else {
                this.addAttribute(doc, "skeletonInterfaceName", localPart + SKELETON_CLASS_SUFFIX, rootElement);
            }
        }
        this.addAttribute(doc, "basereceiver", (String)mepToClassMap.get(mep), rootElement);
        this.fillSyncAttributes(doc, rootElement);
        if (this.mapper.isObjectMappingPresent()) {
            this.addAttribute(doc, "skip-write", "yes", rootElement);
            this.processModelObjects(this.mapper.getAllMappedObjects(), rootElement, doc);
        }
        this.infoHolder.put(mep, (isOpsFound = this.loadOperations(doc, rootElement, mep)) ? Boolean.TRUE : Boolean.FALSE);
        rootElement.appendChild(this.createDOMElementforDatabinders(doc, true));
        rootElement.appendChild(this.getUniqueListofFaultsofMep(doc, mep));
        doc.appendChild(rootElement);
        return doc;
    }

    protected Element createDOMElementforDatabinders(Document doc, boolean isServerside) {
        ArrayList<Element> parameters = new ArrayList<Element>();
        Iterator operationsIterator = this.axisService.getOperations();
        while (operationsIterator.hasNext()) {
            int i;
            Element outputParamElement;
            int i2;
            AxisOperation axisOperation = (AxisOperation)operationsIterator.next();
            String MEP = axisOperation.getMessageExchangePattern();
            if (WSDLUtil.isInputPresentForMEP((String)MEP)) {
                Element[] inputParamElement = this.getInputParamElement(doc, axisOperation);
                for (i2 = 0; i2 < inputParamElement.length; ++i2) {
                    this.addAttribute(doc, "direction", "in", inputParamElement[i2]);
                    parameters.add(inputParamElement[i2]);
                }
            }
            if (WSDLUtil.isOutputPresentForMEP((String)MEP) && (outputParamElement = this.getOutputParamElement(doc, axisOperation)) != null) {
                this.addAttribute(doc, "direction", "out", outputParamElement);
                parameters.add(outputParamElement);
            }
            Element[] faultParamElements = this.getFaultParamElements(doc, axisOperation);
            for (i2 = 0; i2 < faultParamElements.length; ++i2) {
                this.addAttribute(doc, "direction", "out", faultParamElements[i2]);
                parameters.add(faultParamElements[i2]);
            }
            ArrayList headerParameterQNameList = new ArrayList();
            this.addHeaderOperations(headerParameterQNameList, axisOperation, true);
            List parameterElementList = this.getParameterElementList(doc, headerParameterQNameList, "header");
            for (i = 0; i < parameterElementList.size(); ++i) {
                Element newChild = (Element)parameterElementList.get(i);
                parameters.add(newChild);
            }
            headerParameterQNameList.clear();
            parameterElementList.clear();
            this.addHeaderOperations(headerParameterQNameList, axisOperation, false);
            parameterElementList = this.getParameterElementList(doc, headerParameterQNameList, "header");
            for (i = 0; i < parameterElementList.size(); ++i) {
                Element newChild = (Element)parameterElementList.get(i);
                parameters.add(newChild);
            }
        }
        Element rootElement = doc.createElement("databinders");
        this.addAttribute(doc, "dbtype", this.codeGenConfiguration.getDatabindingType(), rootElement);
        String wrapflag = Boolean.toString(this.codeGenConfiguration.isParametersWrapped());
        this.addAttribute(doc, "wrapped", wrapflag, rootElement);
        Element extraElement = this.addElement(doc, "extra", null, rootElement);
        Map propertiesMap = this.codeGenConfiguration.getProperties();
        Iterator it = propertiesMap.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (!(key instanceof String)) continue;
            Object value = propertiesMap.get(key);
            if (value == null) {
                value = SKELETON_INTERFACE_SUFFIX_BACK;
            }
            if (!(value instanceof String)) continue;
            this.addAttribute(doc, (String)key, (String)value, extraElement);
        }
        if (isServerside) {
            this.addAttribute(doc, "isserverside", "yes", rootElement);
        }
        rootElement.appendChild(this.getBase64Elements(doc));
        rootElement.appendChild(this.getOpNames(doc));
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            rootElement.appendChild((Element)iterator.next());
        }
        Parameter details = this.axisService.getParameter("databinding-service-details");
        if (details != null) {
            Object value = details.getValue();
            if (value instanceof Element) {
                rootElement.appendChild(doc.importNode((Element)value, true));
            } else if (value instanceof List) {
                Iterator iter = ((List)value).iterator();
                while (iter.hasNext()) {
                    rootElement.appendChild(doc.importNode((Element)iter.next(), true));
                }
            }
        }
        Iterator operationsIterator2 = this.axisService.getOperations();
        while (operationsIterator2.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)operationsIterator2.next();
            details = axisOperation.getParameter("databinding-operation-details");
            if (details == null) continue;
            rootElement.appendChild(doc.importNode((Element)details.getValue(), true));
        }
        return rootElement;
    }

    protected void addShortType(Element paramElement, String type) {
        if (type != null && type.indexOf(46) != -1) {
            this.addAttribute(paramElement.getOwnerDocument(), "shorttype", type.substring(type.lastIndexOf(46) + 1), paramElement);
        } else {
            this.addAttribute(paramElement.getOwnerDocument(), "shorttype", type == null ? SKELETON_INTERFACE_SUFFIX_BACK : type, paramElement);
        }
    }

    protected Element getOpNames(Document doc) {
        Element root = doc.createElement("opnames");
        Iterator operationsIterator = this.axisService.getOperations();
        while (operationsIterator.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)operationsIterator.next();
            Element elt = doc.createElement("name");
            elt.appendChild(doc.createTextNode(axisOperation.getName().getLocalPart()));
            this.addAttribute(doc, "opnsuri", this.axisService.getTargetNamespace(), elt);
            root.appendChild(elt);
        }
        return root;
    }

    protected Element getBase64Elements(Document doc) {
        Element root = doc.createElement("base64Elements");
        List list = (List)this.codeGenConfiguration.getProperties().get("base64map");
        if (list != null && !list.isEmpty()) {
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                QName qname = (QName)list.get(i);
                Element elt = doc.createElement("name");
                this.addAttribute(doc, "ns-url", qname.getNamespaceURI(), elt);
                this.addAttribute(doc, "localName", qname.getLocalPart(), elt);
                root.appendChild(elt);
            }
        }
        return root;
    }

    protected void processModelObjects(Map objectMappings, Element root, Document doc) {
        Iterator objectIterator = objectMappings.values().iterator();
        while (objectIterator.hasNext()) {
            Object o = objectIterator.next();
            if (!(o instanceof Document)) continue;
            root.appendChild(doc.importNode(((Document)o).getDocumentElement(), true));
        }
    }

    protected void updateMapperClassnames(String fullyQulifiedIncludingClassNamePrefix) {
        Map classNameMap = this.mapper.getAllMappedNames();
        Iterator keys = classNameMap.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            String className = (String)classNameMap.get(key);
            if (!TypeTesterUtil.hasPackage(className) && !TypeTesterUtil.isPrimitive(className)) {
                classNameMap.put(key, fullyQulifiedIncludingClassNamePrefix + "." + className);
                this.instantiatableMessageClassNames.put(key, fullyQulifiedIncludingClassNamePrefix + "$" + className);
                continue;
            }
            classNameMap.put(key, className);
            this.instantiatableMessageClassNames.put(key, className);
        }
    }

    protected void writeServiceXml() throws Exception {
        Document serviceXMLModel = this.createDOMDocumentForServiceXML();
        this.debugLogDocument("Document for service XML:", serviceXMLModel);
        ServiceXMLWriter serviceXmlWriter = new ServiceXMLWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getResourceLocation()), this.codeGenConfiguration.getOutputLanguage());
        this.writeClass(serviceXMLModel, serviceXmlWriter);
    }

    protected Document createDOMDocumentForServiceXML() {
        Document doc = this.getEmptyDocument();
        String className = null;
        String serviceName = this.axisService.getName();
        className = this.codeGenConfiguration.isBackwordCompatibilityMode() ? this.makeJavaClassName(this.axisService.getBindingName()) : this.makeJavaClassName(serviceName);
        doc.appendChild(this.getServiceElement(serviceName, className, doc));
        return doc;
    }

    protected Element getServiceElement(String serviceName, String className, Document doc) {
        Element rootElement = doc.createElement("interface");
        this.addAttribute(doc, "package", SKELETON_INTERFACE_SUFFIX_BACK, rootElement);
        this.addAttribute(doc, "classpackage", this.codeGenConfiguration.getPackageName(), rootElement);
        if (this.codeGenConfiguration.isBackwordCompatibilityMode()) {
            this.addAttribute(doc, "name", className + SKELETON_CLASS_SUFFIX_BACK, rootElement);
        } else {
            this.addAttribute(doc, "name", className + SKELETON_CLASS_SUFFIX, rootElement);
        }
        if (!this.codeGenConfiguration.isWriteTestCase()) {
            this.addAttribute(doc, "testOmit", "true", rootElement);
        }
        this.addAttribute(doc, "servicename", serviceName, rootElement);
        Iterator it = mepToClassMap.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (!Boolean.TRUE.equals(this.infoHolder.get(key))) continue;
            Element elt = this.addElement(doc, "messagereceiver", this.makeJavaClassName(serviceName) + mepToSuffixMap.get(key), rootElement);
            this.addAttribute(doc, "mepURI", key.toString(), elt);
        }
        this.loadOperations(doc, rootElement, null);
        return rootElement;
    }

    protected void writeSkeleton() throws Exception {
        Document skeletonModel = this.createDOMDocumentForSkeleton(this.codeGenConfiguration.isServerSideInterface());
        this.debugLogDocument("Document for skeleton:", skeletonModel);
        SkeletonWriter skeletonWriter = new SkeletonWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
        this.writeClass(skeletonModel, skeletonWriter);
    }

    protected void writeSkeletonInterface() throws Exception {
        Document skeletonModel = this.createDOMDocumentForSkeletonInterface();
        this.debugLogDocument("Document for skeleton Interface:", skeletonModel);
        SkeletonInterfaceWriter skeletonInterfaceWriter = new SkeletonInterfaceWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
        this.writeClass(skeletonModel, skeletonInterfaceWriter);
    }

    protected Document createDOMDocumentForSkeleton(boolean isSkeletonInterface) {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("interface");
        String serviceName = this.makeJavaClassName(this.axisService.getName());
        this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), rootElement);
        if (this.codeGenConfiguration.isBackwordCompatibilityMode()) {
            this.addAttribute(doc, "name", this.makeJavaClassName(this.axisService.getBindingName()) + SKELETON_CLASS_SUFFIX_BACK, rootElement);
        } else {
            this.addAttribute(doc, "name", serviceName + SKELETON_CLASS_SUFFIX, rootElement);
        }
        this.addAttribute(doc, "callbackname", serviceName + CALL_BACK_HANDLER_SUFFIX, rootElement);
        if (isSkeletonInterface) {
            if (this.codeGenConfiguration.isBackwordCompatibilityMode()) {
                this.addAttribute(doc, "skeletonInterfaceName", this.makeJavaClassName(this.axisService.getPortTypeName()) + SKELETON_INTERFACE_SUFFIX_BACK, rootElement);
            } else {
                this.addAttribute(doc, "skeletonInterfaceName", serviceName + SKELETON_INTERFACE_SUFFIX, rootElement);
            }
        }
        this.fillSyncAttributes(doc, rootElement);
        this.loadOperations(doc, rootElement, null);
        rootElement.appendChild(this.getUniqueListofFaults(doc));
        doc.appendChild(rootElement);
        return doc;
    }

    protected Document createDOMDocumentForSkeletonInterface() {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("interface");
        String serviceName = this.makeJavaClassName(this.axisService.getName());
        this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), rootElement);
        if (this.codeGenConfiguration.isBackwordCompatibilityMode()) {
            this.addAttribute(doc, "name", this.makeJavaClassName(this.axisService.getPortTypeName()) + SKELETON_INTERFACE_SUFFIX_BACK, rootElement);
        } else {
            this.addAttribute(doc, "name", serviceName + SKELETON_INTERFACE_SUFFIX, rootElement);
        }
        this.addAttribute(doc, "callbackname", serviceName + CALL_BACK_HANDLER_SUFFIX, rootElement);
        this.fillSyncAttributes(doc, rootElement);
        this.loadOperations(doc, rootElement, null);
        rootElement.appendChild(this.getUniqueListofFaults(doc));
        doc.appendChild(rootElement);
        return doc;
    }

    protected boolean loadOperations(Document doc, Element rootElement, String mep) {
        String portTypeName = this.makeJavaClassName(this.axisService.getName());
        Iterator operations = this.axisService.getOperations();
        boolean opsFound = false;
        while (operations.hasNext()) {
            Element methodElement;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            String messageExchangePattern = axisOperation.getMessageExchangePattern();
            if (this.infoHolder.get(messageExchangePattern) == null) {
                this.infoHolder.put(messageExchangePattern, Boolean.TRUE);
            }
            if (mep == null) {
                opsFound = true;
                methodElement = this.generateMethodElement(doc, portTypeName, axisOperation);
                rootElement.appendChild(methodElement);
                continue;
            }
            if (!mep.equals(axisOperation.getMessageExchangePattern())) continue;
            opsFound = true;
            methodElement = this.generateMethodElement(doc, portTypeName, axisOperation);
            rootElement.appendChild(methodElement);
        }
        return opsFound;
    }

    private Element generateMethodElement(Document doc, String portTypeName, AxisOperation axisOperation) throws DOMException {
        Parameter dbgenimpl;
        ArrayList soapHeaderInputParameterList = new ArrayList();
        ArrayList soapHeaderOutputParameterList = new ArrayList();
        Element methodElement = doc.createElement("method");
        String localPart = axisOperation.getName().getLocalPart();
        this.addAttribute(doc, "name", JavaUtils.xmlNameToJava((String)localPart), methodElement);
        this.addAttribute(doc, "namespace", axisOperation.getName().getNamespaceURI(), methodElement);
        this.addAttribute(doc, "style", axisOperation.getStyle(), methodElement);
        this.addAttribute(doc, "dbsupportname", portTypeName + localPart + DATABINDING_SUPPORTER_NAME_SUFFIX, methodElement);
        this.addAttribute(doc, "mep", Utils.getAxisSpecifMEPConstant((String)axisOperation.getMessageExchangePattern()) + SKELETON_INTERFACE_SUFFIX_BACK, methodElement);
        this.addAttribute(doc, "mepURI", axisOperation.getMessageExchangePattern(), methodElement);
        Parameter dbmethname = axisOperation.getParameter("databinding-generated-receiver");
        if (dbmethname != null) {
            this.addAttribute(doc, "usedbmethod", (String)dbmethname.getValue(), methodElement);
        }
        if ((dbgenimpl = axisOperation.getParameter("databinding-generated-implementation")) != null && Boolean.TRUE.equals(dbgenimpl.getValue())) {
            this.addAttribute(doc, "usdbimpl", "true", methodElement);
        } else {
            this.addAttribute(doc, "usdbimpl", "false", methodElement);
        }
        this.addSOAPAction(doc, methodElement, axisOperation);
        this.addOutputAndFaultActions(doc, methodElement, axisOperation);
        this.addHeaderOperations(soapHeaderInputParameterList, axisOperation, true);
        this.addHeaderOperations(soapHeaderOutputParameterList, axisOperation, false);
        Policy policy = axisOperation.getPolicyInclude().getPolicy();
        if (policy != null) {
            try {
                this.addAttribute(doc, "policy", PolicyUtil.getSafeString((String)PolicyUtil.policyComponentToString((PolicyComponent)policy)), methodElement);
            }
            catch (Exception ex) {
                throw new RuntimeException("can't serialize the policy ..");
            }
        }
        if (WSDLUtil.isInputPresentForMEP((String)axisOperation.getMessageExchangePattern())) {
            methodElement.appendChild(this.getInputElement(doc, axisOperation, soapHeaderInputParameterList));
        }
        if (WSDLUtil.isOutputPresentForMEP((String)axisOperation.getMessageExchangePattern())) {
            methodElement.appendChild(this.getOutputElement(doc, axisOperation, soapHeaderOutputParameterList));
        }
        methodElement.appendChild(this.getFaultElement(doc, axisOperation));
        return methodElement;
    }

    protected Document getEmptyDocument() {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    protected String makeJavaClassName(String word) {
        if (JavaUtils.isJavaKeyword((String)word)) {
            return JavaUtils.makeNonJavaKeyword((String)word);
        }
        return JavaUtils.capitalizeFirstChar((String)JavaUtils.xmlNameToJava((String)word));
    }

    protected void addAttribute(Document document, String AttribName, String attribValue, Element element) {
        XSLTUtils.addAttribute((Document)document, (String)AttribName, (String)attribValue, (Element)element);
    }

    protected void fillSyncAttributes(Document doc, Element rootElement) {
        this.addAttribute(doc, "isAsync", this.codeGenConfiguration.isAsyncOn() ? "1" : "0", rootElement);
        this.addAttribute(doc, "isSync", this.codeGenConfiguration.isSyncOn() ? "1" : "0", rootElement);
    }

    protected void debugLogDocument(String description, Document doc) {
        if (log.isDebugEnabled()) {
            try {
                DOMSource source = new DOMSource(doc);
                StringWriter swrite = new StringWriter();
                swrite.write(description);
                swrite.write("\n");
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(source, new StreamResult(swrite));
                log.debug((Object)swrite.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected File getOutputDirectory(File outputDir, String dir2) {
        if (dir2 != null && !SKELETON_INTERFACE_SUFFIX_BACK.equals(dir2)) {
            outputDir = new File(outputDir, dir2);
        }
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        return outputDir;
    }

    protected void writeClass(Document model, ClassWriter writer) throws IOException, Exception {
        writer.loadTemplate();
        String packageName = model.getDocumentElement().getAttribute("package");
        String className = model.getDocumentElement().getAttribute("name");
        writer.createOutFile(packageName, className);
        writer.parse(model, this.resolver);
    }

    protected void addSOAPAction(Document doc, Element rootElement, AxisOperation axisOperation) {
        this.addAttribute(doc, "soapaction", axisOperation.getInputAction(), rootElement);
    }

    private void addOutputAndFaultActions(Document doc, Element methodElement, AxisOperation operation) {
        String[] faultActionNames;
        String outputAction = operation.getOutputAction();
        if (outputAction != null) {
            Element outputActionElt = doc.createElement("outputActionMapping");
            outputActionElt.setAttribute("Action", outputAction);
            methodElement.appendChild(outputActionElt);
        }
        if ((faultActionNames = operation.getFaultActionNames()) != null) {
            for (int i = 0; i < faultActionNames.length; ++i) {
                Element faultActionElt = doc.createElement("faultActionMapping");
                faultActionElt.setAttribute("faultName", faultActionNames[i]);
                faultActionElt.setAttribute("Action", operation.getFaultAction(faultActionNames[i]));
                methodElement.appendChild(faultActionElt);
            }
        }
    }

    protected void addHeaderOperations(List soapHeaderParameterQNameList, AxisOperation axisOperation, boolean input) {
        AxisMessage outAxisMessage;
        ArrayList headerparamList = new ArrayList();
        String MEP = axisOperation.getMessageExchangePattern();
        if (input) {
            AxisMessage inaxisMessage;
            if (WSDLUtil.isInputPresentForMEP((String)MEP) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                headerparamList = inaxisMessage.getSoapHeaders();
            }
        } else if (WSDLUtil.isOutputPresentForMEP((String)MEP) && (outAxisMessage = axisOperation.getMessage("Out")) != null) {
            headerparamList = outAxisMessage.getSoapHeaders();
        }
        Iterator iterator = headerparamList.iterator();
        while (iterator.hasNext()) {
            SOAPHeaderMessage header = (SOAPHeaderMessage)iterator.next();
            soapHeaderParameterQNameList.add(header.getElement());
        }
    }

    protected Element getInputElement(Document doc, AxisOperation operation, List headerParameterQNameList) {
        PolicyInclude policyInclude;
        Policy policy;
        Element inputElt = doc.createElement("input");
        String MEP = operation.getMessageExchangePattern();
        AxisMessage inputMessage = operation.getMessage("In");
        if (inputMessage != null && (policy = (policyInclude = inputMessage.getPolicyInclude()).getPolicy()) != null) {
            policy = (Policy)policy.normalize(policyInclude.getPolicyRegistry(), false);
            try {
                String policyString = PolicyUtil.policyComponentToString((PolicyComponent)policy);
                policyString = PolicyUtil.getSafeString((String)policyString);
                this.addAttribute(doc, "policy", policyString, inputElt);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (WSDLUtil.isInputPresentForMEP((String)MEP)) {
            Element[] param = this.getInputParamElement(doc, operation);
            for (int i = 0; i < param.length; ++i) {
                inputElt.appendChild(param[i]);
            }
            List parameterElementList = this.getParameterElementList(doc, headerParameterQNameList, "header");
            for (int i = 0; i < parameterElementList.size(); ++i) {
                inputElt.appendChild((Element)parameterElementList.get(i));
            }
        }
        return inputElt;
    }

    protected Element getFaultElement(Document doc, AxisOperation operation) {
        Element faultElt = doc.createElement("fault");
        Element[] param = this.getFaultParamElements(doc, operation);
        for (int i = 0; i < param.length; ++i) {
            faultElt.appendChild(param[i]);
        }
        return faultElt;
    }

    protected Element getOutputElement(Document doc, AxisOperation operation, List headerParameterQNameList) {
        Element outputElt = doc.createElement("output");
        String MEP = operation.getMessageExchangePattern();
        if (WSDLUtil.isOutputPresentForMEP((String)MEP)) {
            Element param;
            PolicyInclude policyInclude;
            Policy policy;
            AxisMessage outMessage = operation.getMessage("Out");
            if (outMessage != null && (policy = (policyInclude = outMessage.getPolicyInclude()).getPolicy()) != null) {
                policy = (Policy)policy.normalize(policyInclude.getPolicyRegistry(), false);
                try {
                    String policyString = PolicyUtil.policyComponentToString((PolicyComponent)policy);
                    policyString = PolicyUtil.getSafeString((String)policyString);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if ((param = this.getOutputParamElement(doc, operation)) != null) {
                outputElt.appendChild(param);
            }
            List outputElementList = this.getParameterElementList(doc, headerParameterQNameList, "header");
            for (int i = 0; i < outputElementList.size(); ++i) {
                outputElt.appendChild((Element)outputElementList.get(i));
            }
        }
        return outputElt;
    }

    protected Element[] getFaultParamElements(Document doc, AxisOperation operation) {
        ArrayList<Element> params = new ArrayList<Element>();
        ArrayList faultMessages = operation.getFaultMessages();
        if (faultMessages != null && !faultMessages.isEmpty()) {
            for (int i = 0; i < faultMessages.size(); ++i) {
                Element paramElement = doc.createElement("param");
                AxisMessage msg = (AxisMessage)faultMessages.get(i);
                if (msg.getElementQName() == null) {
                    throw new RuntimeException("Element QName is null for " + msg.getName() + "!");
                }
                this.addAttribute(doc, "name", (String)this.fullyQualifiedFaultClassNameMap.get(msg.getElementQName()), paramElement);
                this.addAttribute(doc, "shortName", (String)this.faultClassNameMap.get(msg.getElementQName()), paramElement);
                this.addAttribute(doc, "namespace", msg.getElementQName().getNamespaceURI(), paramElement);
                this.addAttribute(doc, "localname", msg.getElementQName().getLocalPart(), paramElement);
                String typeMapping = this.mapper.getTypeMappingName(msg.getElementQName());
                this.addAttribute(doc, "type", typeMapping == null ? SKELETON_INTERFACE_SUFFIX_BACK : typeMapping, paramElement);
                this.addShortType(paramElement, typeMapping);
                String attribValue = (String)this.instantiatableMessageClassNames.get(msg.getElementQName());
                this.addAttribute(doc, "instantiatableType", attribValue == null ? SKELETON_INTERFACE_SUFFIX_BACK : attribValue, paramElement);
                if (this.mapper.getDefaultMappingName().equals(typeMapping)) {
                    this.addAttribute(doc, "default", "yes", paramElement);
                }
                this.addAttribute(doc, "value", this.getParamInitializer(typeMapping), paramElement);
                Iterator iter = msg.getExtensibilityAttributes().iterator();
                while (iter.hasNext()) {
                }
                params.add(paramElement);
            }
            return params.toArray(new Element[params.size()]);
        }
        return new Element[0];
    }

    protected Element[] getInputParamElement(Document doc, AxisOperation operation) {
        AxisMessage inputMessage = operation.getMessage("In");
        ArrayList<Element> paramElementList = new ArrayList<Element>();
        if (inputMessage != null) {
            Element mainParameter = this.generateParamComponent(doc, this.mapper.getParameterName(inputMessage.getElementQName()), this.mapper.getTypeMappingName(inputMessage.getElementQName()), operation.getName(), inputMessage.getElementQName());
            paramElementList.add(mainParameter);
            if (inputMessage.getParameter("UnWrapped") != null) {
                if (inputMessage.getParameter("complexType") != null) {
                    Parameter parameter = inputMessage.getParameter("complexType");
                    this.addAttribute(doc, "complextype", (String)parameter.getValue(), mainParameter);
                }
                Parameter detailsParameter = inputMessage.getParameter("UnWrapped_details");
                MessagePartInformationHolder infoHolder = (MessagePartInformationHolder)detailsParameter.getValue();
                List partsList = infoHolder.getPartsList();
                for (int i = 0; i < partsList.size(); ++i) {
                    QName qName = (QName)partsList.get(i);
                    mainParameter.appendChild(this.generateParamComponent(doc, this.mapper.getParameterName(qName), this.mapper.getTypeMappingName(qName), operation.getName(), qName, qName.getLocalPart(), this.mapper.getTypeMappingStatus(qName) != null, "arrayType".equals(this.mapper.getTypeMappingStatus(qName))));
                }
            }
        }
        return paramElementList.toArray(new Element[paramElementList.size()]);
    }

    protected Element generateParamComponent(Document doc, String paramName, String paramType, QName operationName, QName paramQName) {
        return this.generateParamComponent(doc, paramName, paramType, operationName, paramQName, null, false, false);
    }

    protected Element generateParamComponent(Document doc, String paramName, String paramType, QName paramQName) {
        return this.generateParamComponent(doc, paramName, paramType, null, paramQName, null, false, false);
    }

    protected Element generateParamComponent(Document doc, String paramName, String paramType, QName opName, QName paramQName, String partName, boolean isPrimitive, boolean isArray) {
        Element paramElement = doc.createElement("param");
        this.addAttribute(doc, "name", paramName, paramElement);
        this.addAttribute(doc, "type", paramType == null ? SKELETON_INTERFACE_SUFFIX_BACK : paramType, paramElement);
        this.addShortType(paramElement, paramType);
        if (this.mapper.getDefaultMappingName().equals(paramType)) {
            this.addAttribute(doc, "default", "yes", paramElement);
        }
        this.addAttribute(doc, "value", this.getParamInitializer(paramType), paramElement);
        this.addAttribute(doc, "location", "body", paramElement);
        if (opName != null) {
            this.addAttribute(doc, "opname", opName.getLocalPart(), paramElement);
        }
        if (paramQName != null) {
            Element qNameElement = doc.createElement("qname");
            this.addAttribute(doc, "nsuri", paramQName.getNamespaceURI(), qNameElement);
            this.addAttribute(doc, "localname", paramQName.getLocalPart(), qNameElement);
            paramElement.appendChild(qNameElement);
        }
        if (partName != null) {
            this.addAttribute(doc, "partname", JavaUtils.capitalizeFirstChar((String)partName), paramElement);
        }
        if (isPrimitive) {
            this.addAttribute(doc, "primitive", "yes", paramElement);
        }
        if (isArray) {
            this.addAttribute(doc, "array", "yes", paramElement);
        }
        return paramElement;
    }

    protected Element getOutputParamElement(Document doc, AxisOperation operation) {
        String typeMappingStr;
        String parameterName;
        Element paramElement = doc.createElement("param");
        AxisMessage outputMessage = operation.getMessage("Out");
        if (outputMessage != null) {
            parameterName = this.mapper.getParameterName(outputMessage.getElementQName());
            String typeMapping = this.mapper.getTypeMappingName(outputMessage.getElementQName());
            typeMappingStr = typeMapping == null ? SKELETON_INTERFACE_SUFFIX_BACK : typeMapping;
        } else {
            parameterName = SKELETON_INTERFACE_SUFFIX_BACK;
            typeMappingStr = SKELETON_INTERFACE_SUFFIX_BACK;
        }
        this.addAttribute(doc, "name", parameterName, paramElement);
        this.addAttribute(doc, "type", typeMappingStr, paramElement);
        this.addShortType(paramElement, typeMappingStr);
        if (this.mapper.getDefaultMappingName().equals(typeMappingStr)) {
            this.addAttribute(doc, "default", "yes", paramElement);
        }
        this.addAttribute(doc, "location", "body", paramElement);
        this.addAttribute(doc, "opname", operation.getName().getLocalPart(), paramElement);
        QName paramQName = outputMessage.getElementQName();
        if (paramQName != null) {
            Element qNameElement = doc.createElement("qname");
            this.addAttribute(doc, "nsuri", paramQName.getNamespaceURI(), qNameElement);
            this.addAttribute(doc, "localname", paramQName.getLocalPart(), qNameElement);
            paramElement.appendChild(qNameElement);
        }
        return paramElement;
    }

    protected String getParamInitializer(String paramType) {
        String out = (String)constructorMap.get(paramType);
        if (out == null) {
            out = "null";
        }
        return out;
    }

    protected List getParameterElementList(Document doc, List parameters, String location) {
        ArrayList<Element> parameterElementList = new ArrayList<Element>();
        if (parameters != null && !parameters.isEmpty()) {
            int count = parameters.size();
            for (int i = 0; i < count; ++i) {
                Element param = doc.createElement("param");
                QName name = (QName)parameters.get(i);
                this.addAttribute(doc, "name", this.mapper.getParameterName(name), param);
                String typeMapping = this.mapper.getTypeMappingName(name);
                String typeMappingStr = typeMapping == null ? SKELETON_INTERFACE_SUFFIX_BACK : typeMapping;
                this.addAttribute(doc, "type", typeMappingStr, param);
                this.addAttribute(doc, "location", location, param);
                parameterElementList.add(param);
            }
        }
        return parameterElementList;
    }

    protected Element addElement(Document document, String eltName, String eltValue, Element element) {
        Element elt = XSLTUtils.addChildElement((Document)document, (String)eltName, (Node)element);
        if (eltValue != null) {
            elt.appendChild(document.createTextNode(eltValue));
        }
        return elt;
    }

    static {
        constructorMap = new HashMap(50);
        constructorMap.put("int", "0");
        constructorMap.put("float", "0");
        constructorMap.put("boolean", "true");
        constructorMap.put("double", "0");
        constructorMap.put("byte", "(byte)0");
        constructorMap.put("short", "(short)0");
        constructorMap.put("long", "0");
        constructorMap.put("java.lang.Boolean", "new java.lang.Boolean(false)");
        constructorMap.put("java.lang.Byte", "new java.lang.Byte((byte)0)");
        constructorMap.put("java.lang.Double", "new java.lang.Double(0)");
        constructorMap.put("java.lang.Float", "new java.lang.Float(0)");
        constructorMap.put("java.lang.Integer", "new java.lang.Integer(0)");
        constructorMap.put("java.lang.Long", "new java.lang.Long(0)");
        constructorMap.put("java.lang.Short", "new java.lang.Short((short)0)");
        constructorMap.put("java.math.BigDecimal", "new java.math.BigDecimal(0)");
        constructorMap.put("java.math.BigInteger", "new java.math.BigInteger(\"0\")");
        constructorMap.put("java.lang.Object", "new java.lang.String()");
        constructorMap.put("byte[]", "new byte[0]");
        constructorMap.put("java.util.Calendar", "java.util.Calendar.getInstance()");
        constructorMap.put("javax.xml.namespace.QName", "new javax.xml.namespace.QName(\"http://foo\", \"bar\")");
        mepToClassMap = new HashMap();
        mepToClassMap.put("http://www.w3.org/2004/08/wsdl/in-only", "org.apache.axis2.receivers.AbstractInMessageReceiver");
        mepToClassMap.put("http://www.w3.org/2006/01/wsdl/in-only", "org.apache.axis2.receivers.AbstractInMessageReceiver");
        mepToClassMap.put("http://www.w3.org/2004/08/wsdl/robust-in-only", "org.apache.axis2.receivers.AbstractRobustInMessageReceiver");
        mepToClassMap.put("http://www.w3.org/2006/01/wsdl/robust-in-only", "org.apache.axis2.receivers.AbstractRobustInMessageReceiver");
        mepToClassMap.put("http://www.w3.org/2004/08/wsdl/in-out", "org.apache.axis2.receivers.AbstractInOutSyncMessageReceiver");
        mepToClassMap.put("http://www.w3.org/2006/01/wsdl/in-out", "org.apache.axis2.receivers.AbstractInOutSyncMessageReceiver");
        mepToSuffixMap = new HashMap();
        mepToSuffixMap.put("http://www.w3.org/2004/08/wsdl/in-only", "MessageReceiverInOnly");
        mepToSuffixMap.put("http://www.w3.org/2006/01/wsdl/in-only", "MessageReceiverInOnly");
        mepToSuffixMap.put("http://www.w3.org/2004/08/wsdl/robust-in-only", "MessageReceiverRobustInOnly");
        mepToSuffixMap.put("http://www.w3.org/2006/01/wsdl/robust-in-only", "MessageReceiverRobustInOnly");
        mepToSuffixMap.put("http://www.w3.org/2004/08/wsdl/in-out", "MessageReceiverInOut");
        mepToSuffixMap.put("http://www.w3.org/2006/01/wsdl/in-out", "MessageReceiverInOut");
        log = LogFactory.getLog((Class)AxisServiceBasedMultiLanguageEmitter.class);
    }
}

