/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.rpc.receivers;

import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.DependencyManager;
import org.apache.axis2.receivers.AbstractInOutSyncMessageReceiver;
import org.apache.axis2.rpc.receivers.RPCUtil;

public class RPCMessageReceiver
extends AbstractInOutSyncMessageReceiver {
    private Method method;

    public void invokeBusinessLogic(MessageContext inMessage, MessageContext outMessage) throws AxisFault {
        try {
            Object resObject;
            OMNamespace namespace;
            Object obj = this.getTheImplementationObject(inMessage);
            Class<?> ImplClass = obj.getClass();
            DependencyManager.configureBusinessLogicProvider((Object)obj, (OperationContext)inMessage.getOperationContext());
            AxisOperation op = inMessage.getOperationContext().getAxisOperation();
            AxisService service = inMessage.getAxisService();
            OMElement methodElement = inMessage.getEnvelope().getBody().getFirstElement();
            AxisMessage inaxisMessage = op.getMessage("In");
            String messageNameSpace = null;
            if (inaxisMessage != null) {
                messageNameSpace = inaxisMessage.getElementQName().getNamespaceURI();
            }
            if ((namespace = methodElement.getNamespace()) == null || !messageNameSpace.equals(namespace.getName())) {
                throw new AxisFault("namespace mismatch require " + messageNameSpace + " found " + methodElement.getNamespace().getName());
            }
            String methodName = op.getName().getLocalPart();
            Method[] methods = ImplClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(methodName)) continue;
                this.method = methods[i];
                break;
            }
            Object[] objectArray = RPCUtil.processRequest(methodElement, this.method);
            try {
                resObject = this.method.invoke(obj, objectArray);
            }
            catch (Exception e) {
                throw new AxisFault(e.getMessage());
            }
            SOAPFactory fac = this.getSOAPFactory(inMessage);
            AxisMessage outaxisMessage = op.getMessage("Out");
            if (inaxisMessage != null) {
                messageNameSpace = outaxisMessage.getElementQName().getNamespaceURI();
            }
            OMNamespace ns = fac.createOMNamespace(messageNameSpace, service.getSchematargetNamespacePrefix());
            SOAPEnvelope envelope = fac.getDefaultEnvelope();
            OMElement bodyContent = null;
            if (resObject instanceof Object[]) {
                QName resName = new QName(service.getSchematargetNamespace(), this.method.getName() + "Response", service.getSchematargetNamespacePrefix());
                OMElement bodyChild = RPCUtil.getResponseElement(resName, (Object[])resObject);
                envelope.getBody().addChild((OMNode)bodyChild);
            } else {
                RPCUtil.processResponse(fac, resObject, bodyContent, ns, envelope, this.method);
            }
            outMessage.setEnvelope(envelope);
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
    }
}

