/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.types;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.axis2.databinding.utils.ConverterUtil;

public class Time
implements Serializable {
    private static final long serialVersionUID = -9022201555535589908L;
    private Calendar _value;
    private boolean isFromString;
    private String originalString;

    public Time(Calendar value) {
        this._value = value;
        this._value.clear(1);
        this._value.clear(2);
        this._value.clear(5);
    }

    public Time(String value) throws NumberFormatException {
        this._value = this.makeValue(value);
        this.isFromString = true;
        this.originalString = value;
    }

    public Calendar getAsCalendar() {
        return this._value;
    }

    public void setTime(Calendar date) {
        this._value = date;
        this._value.clear(1);
        this._value.clear(2);
        this._value.clear(5);
    }

    public void setTime(Date date) {
        this._value.setTime(date);
        this._value.clear(1);
        this._value.clear(2);
        this._value.clear(5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Calendar makeValue(String source) throws NumberFormatException {
        if (source == null || source.trim().length() == 0) {
            return null;
        }
        source = source.trim();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        int hour = 0;
        int minite = 0;
        int second = 0;
        int miliSecond = 0;
        int timeZoneOffSet = TimeZone.getDefault().getRawOffset();
        int milliSecondPartLength = 0;
        if (source.length() < 8) throw new RuntimeException("invalid message string");
        if (source.charAt(2) != ':' || source.charAt(5) != ':') {
            throw new RuntimeException("Invalid time format (" + source + ") having : s in wrong places");
        }
        hour = Integer.parseInt(source.substring(0, 2));
        minite = Integer.parseInt(source.substring(3, 5));
        second = Integer.parseInt(source.substring(6, 8));
        if (source.length() > 8) {
            String rest = source.substring(8);
            if (rest.startsWith(".")) {
                if (rest.endsWith("Z")) {
                    timeZoneOffSet = 0;
                    miliSecond = Integer.parseInt(rest.substring(1, rest.lastIndexOf("Z")));
                    milliSecondPartLength = rest.substring(1, rest.lastIndexOf("Z")).trim().length();
                } else if (rest.lastIndexOf("+") > 0 || rest.lastIndexOf("-") > 0) {
                    String timeOffSet = null;
                    if (rest.lastIndexOf("+") > 0) {
                        timeOffSet = rest.substring(rest.lastIndexOf("+") + 1);
                        miliSecond = Integer.parseInt(rest.substring(1, rest.lastIndexOf("+")));
                        milliSecondPartLength = rest.substring(1, rest.lastIndexOf("+")).trim().length();
                        timeZoneOffSet = 1;
                    } else if (rest.lastIndexOf("-") > 0) {
                        timeOffSet = rest.substring(rest.lastIndexOf("-") + 1);
                        miliSecond = Integer.parseInt(rest.substring(1, rest.lastIndexOf("-")));
                        milliSecondPartLength = rest.substring(1, rest.lastIndexOf("-")).trim().length();
                        timeZoneOffSet = -1;
                    }
                    if (timeOffSet.charAt(2) != ':') {
                        throw new RuntimeException("invalid time zone format (" + source + ") without : at correct place");
                    }
                    int hours = Integer.parseInt(timeOffSet.substring(0, 2));
                    int minits = Integer.parseInt(timeOffSet.substring(3, 5));
                    timeZoneOffSet = (hours * 60 + minits) * 60000 * timeZoneOffSet;
                } else {
                    miliSecond = Integer.parseInt(rest.substring(1));
                    milliSecondPartLength = rest.substring(1).trim().length();
                }
            } else if (rest.startsWith("Z")) {
                timeZoneOffSet = 0;
            } else {
                if (!rest.startsWith("+") && !rest.startsWith("-")) throw new NumberFormatException("in valid time zone attribute");
                if (rest.charAt(3) != ':') {
                    throw new RuntimeException("invalid time zone format (" + source + ") without : at correct place");
                }
                int hours = Integer.parseInt(rest.substring(1, 3));
                int minits = Integer.parseInt(rest.substring(4, 6));
                timeZoneOffSet = (hours * 60 + minits) * 60000;
                if (rest.startsWith("-")) {
                    timeZoneOffSet *= -1;
                }
            }
        }
        calendar.set(11, hour);
        calendar.set(12, minite);
        calendar.set(13, second);
        if (milliSecondPartLength != 3) {
            miliSecond *= 1000;
            for (int i = 0; i < milliSecondPartLength; ++i) {
                miliSecond /= 10;
            }
        }
        calendar.set(14, miliSecond);
        calendar.set(15, timeZoneOffSet);
        calendar.set(16, 0);
        return calendar;
    }

    public String toString() {
        if (this._value == null) {
            return "unassigned Time";
        }
        if (this.isFromString) {
            return this.originalString;
        }
        StringBuffer timeString = new StringBuffer();
        ConverterUtil.appendTime(this._value, timeString);
        ConverterUtil.appendTimeZone(this._value, timeString);
        return timeString.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Time)) {
            return false;
        }
        Time other = (Time)obj;
        if (this == obj) {
            return true;
        }
        boolean _equals = this._value == null && other._value == null || this._value != null && this._value.getTime().equals(other._value.getTime());
        return _equals;
    }

    public int hashCode() {
        return this._value == null ? 0 : this._value.hashCode();
    }
}

