/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.factory.OMXMLBuilderFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.databinding.typemapping.SimpleTypeMapper;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.databinding.utils.MultirefHelper;
import org.apache.axis2.databinding.utils.reader.ADBXMLStreamReaderImpl;
import org.apache.axis2.util.StreamWrapper;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JProperty;
import org.codehaus.jam.JamClassIterator;
import org.codehaus.jam.JamService;
import org.codehaus.jam.JamServiceFactory;
import org.codehaus.jam.JamServiceParams;

public class BeanUtil {
    public static XMLStreamReader getPullParser(Object beanObject, QName beanName) {
        try {
            JamServiceFactory factory = JamServiceFactory.getInstance();
            JamServiceParams jam_service_parms = factory.createServiceParams();
            jam_service_parms.addClassLoader(beanObject.getClass().getClassLoader());
            jam_service_parms.includeClass(beanObject.getClass().getName());
            JamService service = factory.createService(jam_service_parms);
            JamClassIterator jClassIter = service.getClasses();
            JClass jClass = null;
            while (jClassIter.hasNext()) {
                jClass = (JClass)jClassIter.next();
            }
            JProperty[] properties = jClass.getDeclaredProperties();
            BeanInfo beanInfo = Introspector.getBeanInfo(beanObject.getClass());
            PropertyDescriptor[] propDescs = beanInfo.getPropertyDescriptors();
            HashMap<String, PropertyDescriptor> propertMap = new HashMap<String, PropertyDescriptor>();
            for (int i = 0; i < propDescs.length; ++i) {
                PropertyDescriptor propDesc = propDescs[i];
                propertMap.put(propDesc.getName(), propDesc);
            }
            ArrayList<Object> object = new ArrayList<Object>();
            for (int i = 0; i < properties.length; ++i) {
                Object value;
                JProperty property = properties[i];
                PropertyDescriptor propDesc = (PropertyDescriptor)propertMap.get(BeanUtil.getCorrectName(property.getSimpleName()));
                if (propDesc == null) continue;
                Class<?> ptype = propDesc.getPropertyType();
                if (propDesc.getName().equals("class")) continue;
                if (SimpleTypeMapper.isSimpleType(ptype)) {
                    value = propDesc.getReadMethod().invoke(beanObject, (Object[])null);
                    object.add(propDesc.getName());
                    object.add(value.toString());
                    continue;
                }
                if (ptype.isArray()) {
                    int j;
                    value = (Object[])propDesc.getReadMethod().invoke(beanObject, (Object[])null);
                    if (SimpleTypeMapper.isSimpleType(ptype.getComponentType())) {
                        for (j = 0; j < ((Object)value).length; ++j) {
                            Object o = value[j];
                            object.add(propDesc.getName());
                            object.add(o.toString());
                        }
                        continue;
                    }
                    for (j = 0; j < ((Object)value).length; ++j) {
                        Object o = value[j];
                        object.add(new QName(propDesc.getName()));
                        object.add(o);
                    }
                    continue;
                }
                if (SimpleTypeMapper.isArrayList(ptype)) {
                    value = propDesc.getReadMethod().invoke(beanObject, (Object[])null);
                    ArrayList objList = (ArrayList)value;
                    if (objList == null || objList.size() <= 0) continue;
                    for (int j = 0; j < objList.size(); ++j) {
                        Object o = objList.get(j);
                        if (SimpleTypeMapper.isSimpleType(o)) {
                            object.add(propDesc.getName());
                            object.add(o);
                            continue;
                        }
                        object.add(new QName(propDesc.getName()));
                        object.add(o);
                    }
                    continue;
                }
                object.add(new QName(propDesc.getName()));
                value = propDesc.getReadMethod().invoke(beanObject, (Object[])null);
                object.add(value);
            }
            return new ADBXMLStreamReaderImpl(beanName, object.toArray(), null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static XMLStreamReader getPullParser(Object beanObject) {
        String className = beanObject.getClass().getName();
        if (className.indexOf(".") > 0) {
            className = className.substring(className.lastIndexOf(46) + 1, className.length());
        }
        return BeanUtil.getPullParser(beanObject, new QName(className));
    }

    public static Object deserialize(Class beanClass, OMElement beanElement) throws AxisFault {
        try {
            if (beanClass.isArray()) {
                ArrayList<Object> valueList = new ArrayList<Object>();
                Class<?> arrayClassType = beanClass.getComponentType();
                Iterator parts = beanElement.getChildElements();
                while (parts.hasNext()) {
                    Object objValue = parts.next();
                    if (!(objValue instanceof OMElement)) continue;
                    OMElement omElement = (OMElement)objValue;
                    valueList.add(BeanUtil.deserialize(arrayClassType, omElement));
                }
                return ConverterUtil.convertToArray(arrayClassType, valueList);
            }
            if (SimpleTypeMapper.isSimpleType(beanClass)) {
                return SimpleTypeMapper.getSimpleTypeObject(beanClass, beanElement);
            }
            HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] propDescs = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propDescs.length; ++i) {
                PropertyDescriptor proprty = propDescs[i];
                properties.put(proprty.getName(), proprty);
            }
            Object beanObj = beanClass.newInstance();
            Iterator elements = beanElement.getChildren();
            while (elements.hasNext()) {
                OMElement parts;
                String partsLocalName;
                PropertyDescriptor prty;
                Object objValue = elements.next();
                if (!(objValue instanceof OMElement) || (prty = (PropertyDescriptor)properties.get(partsLocalName = (parts = (OMElement)objValue).getLocalName())) == null) continue;
                Class<?> parameters = prty.getPropertyType();
                if (prty.equals("class")) continue;
                Object partObj = SimpleTypeMapper.isSimpleType(parameters) ? SimpleTypeMapper.getSimpleTypeObject(parameters, parts) : (SimpleTypeMapper.isArrayList(parameters) ? SimpleTypeMapper.getArrayList((OMElement)parts.getParent(), prty.getName()) : BeanUtil.deserialize(parameters, parts));
                Object[] parms = new Object[]{partObj};
                prty.getWriteMethod().invoke(beanObj, parms);
            }
            return beanObj;
        }
        catch (InstantiationException e) {
            throw new AxisFault("InstantiationException : " + e);
        }
        catch (IllegalAccessException e) {
            throw new AxisFault("IllegalAccessException : " + e);
        }
        catch (InvocationTargetException e) {
            throw new AxisFault("InvocationTargetException : " + e);
        }
        catch (IntrospectionException e) {
            throw new AxisFault("IntrospectionException : " + e);
        }
    }

    public static Object deserialize(Class beanClass, OMElement beanElement, MultirefHelper helper) throws AxisFault {
        Object beanObj;
        try {
            HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] propDescs = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propDescs.length; ++i) {
                PropertyDescriptor proprty = propDescs[i];
                properties.put(proprty.getName(), proprty);
            }
            beanObj = beanClass.newInstance();
            Iterator elements = beanElement.getChildren();
            while (elements.hasNext()) {
                Object partObj;
                OMElement parts;
                String partsLocalName;
                PropertyDescriptor prty;
                Object child = elements.next();
                if (!(child instanceof OMElement) || (prty = (PropertyDescriptor)properties.get((partsLocalName = (parts = (OMElement)child).getLocalName()).toLowerCase())) == null) continue;
                Class<?> parameters = prty.getPropertyType();
                if (prty.equals("class")) continue;
                OMAttribute attr = MultirefHelper.processRefAtt(parts);
                if (attr != null) {
                    String refId = MultirefHelper.getAttvalue(attr);
                    partObj = helper.getObject(refId);
                    if (partObj == null) {
                        partObj = helper.processRef(parameters, refId);
                    }
                } else {
                    partObj = SimpleTypeMapper.getSimpleTypeObject(parameters, parts);
                    if (partObj == null) {
                        partObj = BeanUtil.deserialize(parameters, parts);
                    }
                }
                Object[] parms = new Object[]{partObj};
                prty.getWriteMethod().invoke(beanObj, parms);
            }
        }
        catch (InstantiationException e) {
            throw new AxisFault("InstantiationException : " + e);
        }
        catch (IllegalAccessException e) {
            throw new AxisFault("IllegalAccessException : " + e);
        }
        catch (InvocationTargetException e) {
            throw new AxisFault("InvocationTargetException : " + e);
        }
        catch (IntrospectionException e) {
            throw new AxisFault("IntrospectionException : " + e);
        }
        return beanObj;
    }

    public static Object[] deserialize(OMElement response, Object[] javaTypes) throws AxisFault {
        int length = javaTypes.length;
        int count = 0;
        Object[] retObjs = new Object[length];
        Iterator parts = response.getChildren();
        MultirefHelper helper = new MultirefHelper((OMElement)response.getParent());
        while (parts.hasNext() && count < length) {
            Object objValue = parts.next();
            if (!(objValue instanceof OMElement)) continue;
            OMElement omElement = (OMElement)objValue;
            String currentLocalName = omElement.getLocalName();
            Class classType = (Class)javaTypes[count];
            omElement = BeanUtil.ProcessElement(classType, omElement, helper, parts, currentLocalName, retObjs, count);
            while (omElement != null) {
                omElement = BeanUtil.ProcessElement((Class)javaTypes[++count], omElement, helper, parts, omElement.getLocalName(), retObjs, count);
            }
            ++count;
        }
        helper.clean();
        return retObjs;
    }

    private static OMElement ProcessElement(Class classType, OMElement omElement, MultirefHelper helper, Iterator parts, String currentLocalName, Object[] retObjs, int count) throws AxisFault {
        if (classType.isArray()) {
            boolean done = true;
            ArrayList<Object> valueList = new ArrayList<Object>();
            Class<?> arrayClassType = classType.getComponentType();
            valueList.add(BeanUtil.processObject(omElement, arrayClassType, helper));
            while (parts.hasNext()) {
                Object objValue = parts.next();
                if (!(objValue instanceof OMElement)) continue;
                omElement = (OMElement)objValue;
                if (!currentLocalName.equals(omElement.getLocalName())) {
                    done = false;
                    break;
                }
                valueList.add(BeanUtil.processObject(omElement, arrayClassType, helper));
            }
            retObjs[count] = ConverterUtil.convertToArray(arrayClassType, valueList);
            if (!done) {
                return omElement;
            }
        } else {
            retObjs[count] = BeanUtil.processObject(omElement, classType, helper);
        }
        return null;
    }

    public static Object processObject(OMElement omElement, Class classType, MultirefHelper helper) throws AxisFault {
        boolean hasRef = false;
        OMAttribute omatribute = MultirefHelper.processRefAtt(omElement);
        String ref = null;
        if (omatribute != null) {
            hasRef = true;
            ref = MultirefHelper.getAttvalue(omatribute);
        }
        if (OMElement.class.isAssignableFrom(classType)) {
            if (hasRef) {
                OMElement elemnt = helper.getOMElement(ref);
                if (elemnt == null) {
                    return helper.processOMElementRef(ref);
                }
                return omElement;
            }
            return omElement;
        }
        if (hasRef) {
            if (helper.getObject(ref) != null) {
                return helper.getObject(ref);
            }
            return helper.processRef(classType, ref);
        }
        if (SimpleTypeMapper.isSimpleType(classType)) {
            return SimpleTypeMapper.getSimpleTypeObject(classType, omElement);
        }
        if (SimpleTypeMapper.isArrayList(classType)) {
            return SimpleTypeMapper.getArrayList(omElement);
        }
        return BeanUtil.deserialize(classType, omElement);
    }

    public static OMElement getOMElement(QName opName, Object[] args, String partName) {
        ArrayList<Object> objects = new ArrayList<Object>();
        int argCount = 0;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null) continue;
            if (arg instanceof Object[]) {
                Object[] array = (Object[])arg;
                for (int j = 0; j < array.length; ++j) {
                    Object o = array[j];
                    if (SimpleTypeMapper.isSimpleType(o)) {
                        objects.add("item" + argCount);
                        objects.add(o.toString());
                        continue;
                    }
                    objects.add(new QName("item" + argCount));
                    if (o instanceof OMElement) {
                        OMElement wrappingElement;
                        OMFactory fac = OMAbstractFactory.getOMFactory();
                        if (partName == null) {
                            wrappingElement = fac.createOMElement("item" + argCount, null);
                            wrappingElement.addChild((OMNode)((OMElement)o));
                        } else {
                            wrappingElement = fac.createOMElement(partName, null);
                            wrappingElement.addChild((OMNode)((OMElement)o));
                        }
                        objects.add(wrappingElement);
                        continue;
                    }
                    objects.add(o);
                }
            } else if (SimpleTypeMapper.isSimpleType(arg)) {
                if (partName == null) {
                    objects.add("arg" + argCount);
                } else {
                    objects.add(partName);
                }
                objects.add(arg.toString());
            } else {
                if (partName == null) {
                    objects.add(new QName("arg" + argCount));
                } else {
                    objects.add(new QName(partName));
                }
                if (arg instanceof OMElement) {
                    OMElement wrappingElement;
                    OMFactory fac = OMAbstractFactory.getOMFactory();
                    if (partName == null) {
                        wrappingElement = fac.createOMElement("arg" + argCount, null);
                        wrappingElement.addChild((OMNode)((OMElement)arg));
                    } else {
                        wrappingElement = fac.createOMElement(partName, null);
                        wrappingElement.addChild((OMNode)((OMElement)arg));
                    }
                    objects.add(wrappingElement);
                } else {
                    objects.add(arg);
                }
            }
            ++argCount;
        }
        ADBXMLStreamReaderImpl xr = new ADBXMLStreamReaderImpl(opName, objects.toArray(), null);
        StreamWrapper parser = new StreamWrapper((XMLStreamReader)xr);
        StAXOMBuilder stAXOMBuilder = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)OMAbstractFactory.getSOAP11Factory(), (XMLStreamReader)parser);
        stAXOMBuilder.setDoDebug(true);
        return stAXOMBuilder.getDocumentElement();
    }

    private static String getCorrectName(String wrongName) {
        if (wrongName.length() > 1) {
            return wrongName.substring(0, 1).toLowerCase(Locale.ENGLISH) + wrongName.substring(1, wrongName.length());
        }
        return wrongName.substring(0, 1).toLowerCase(Locale.ENGLISH);
    }
}

