/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.maven2.aar;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.axis2.maven2.aar.AbstractAarMojo;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class DeployAarMojo
extends AbstractAarMojo {
    private static final String LOGIN_FAILED_ERROR_MESSAGE = "Invalid auth credentials!";
    private URL axis2AdminConsoleURL;
    private String axis2AdminUser;
    private String axis2AdminPassword;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Deploying AAR artifact " + this.project.getArtifact().getFile() + " to Axis2 Web Console " + this.axis2AdminConsoleURL));
        try {
            this.deploy(this.project.getArtifact().getFile());
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error deploying aar", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploy(File aarFile) throws MojoExecutionException, IOException {
        if (this.axis2AdminConsoleURL == null) {
            throw new MojoExecutionException("No Axis2 administrative console URL provided.");
        }
        URL axis2AdminConsoleLoginURL = new URL(this.axis2AdminConsoleURL.toString() + "/login");
        HttpPost httpPost = new HttpPost(axis2AdminConsoleLoginURL.toString());
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("userName", this.axis2AdminUser));
        nvps.add(new BasicNameValuePair("password", this.axis2AdminPassword));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
        CloseableHttpClient httpclient = HttpClients.createDefault();
        httpclient.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        try {
            CloseableHttpResponse hcResponse = httpclient.execute((HttpUriRequest)httpPost);
            int status = hcResponse.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new MojoExecutionException("Failed to log in");
            }
            HttpEntity responseEntity = hcResponse.getEntity();
            if (responseEntity == null) {
                throw new MojoExecutionException("url request returned null entity: " + hcResponse.getStatusLine());
            }
            String responseStr = EntityUtils.toString((HttpEntity)responseEntity);
            if (responseStr.indexOf(LOGIN_FAILED_ERROR_MESSAGE) != -1) {
                throw new MojoExecutionException("Failed to log into Axis2 administration web console using credentials");
            }
        }
        finally {
            httpclient.close();
        }
        URL axis2AdminConsoleUploadURL = new URL(this.axis2AdminConsoleURL.toString() + "/upload");
        this.getLog().debug((CharSequence)("Uploading AAR to Axis2 Admin Web Console " + axis2AdminConsoleUploadURL));
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        File file = this.project.getArtifact().getFile();
        FileBody fileBody = new FileBody(file);
        builder.addPart(this.project.getArtifact().getFile().getName(), (ContentBody)fileBody);
        httpPost = null;
        httpPost = new HttpPost(axis2AdminConsoleLoginURL.toString());
        httpclient = null;
        httpclient = HttpClients.createDefault();
        httpclient.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        try {
            CloseableHttpResponse hcResponse = httpclient.execute((HttpUriRequest)httpPost);
            int status = hcResponse.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new MojoExecutionException("Failed to log in");
            }
        }
        finally {
            httpclient.close();
        }
        URL axis2AdminConsoleLogoutURL = new URL(this.axis2AdminConsoleURL.toString() + "/logout");
        this.getLog().debug((CharSequence)("Logging out of Axis2 Admin Web Console " + axis2AdminConsoleLogoutURL));
        HttpGet get = new HttpGet(axis2AdminConsoleLogoutURL.toString());
        httpclient = null;
        httpclient = HttpClients.createDefault();
        httpclient.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        try {
            CloseableHttpResponse hcResponse = httpclient.execute((HttpUriRequest)get);
            int status = hcResponse.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new MojoExecutionException("Failed to log out");
            }
        }
        finally {
            httpclient.close();
        }
    }
}

