/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.tools.maven.wsdl2java;

import java.io.IOException;
import java.io.PrintWriter;
import javax.wsdl.PortType;
import org.apache.axis.tools.maven.wsdl2java.EmitterEx;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaTestCaseWriter;

public class JavaTestCaseWriterEx
extends JavaTestCaseWriter {
    public JavaTestCaseWriterEx(Emitter emitter, ServiceEntry sEntry, SymbolTable symbolTable) {
        super(emitter, sEntry, symbolTable);
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        super.writeFileBody(pw);
        String httpPortSystemProperty = ((EmitterEx)this.emitter).getTestHttpPortSystemProperty();
        if (httpPortSystemProperty != null) {
            int defaultHttpPort = ((EmitterEx)this.emitter).getTestDefaultHttpPort();
            pw.println("    private static String getEndpoint(String portName) throws Exception {");
            pw.print("        String httpPort = System.getProperty(\"" + httpPortSystemProperty + "\"");
            if (defaultHttpPort != -1) {
                pw.print(", \"" + defaultHttpPort + "\"");
            }
            pw.println(");");
            if (defaultHttpPort == -1) {
                pw.println("        if (httpPort == null) {");
                pw.println("            fail(\"Required system property " + httpPortSystemProperty + " not set\");");
                pw.println("        }");
            }
            pw.println("        return \"http://localhost:\" + httpPort + \"/axis/services/\" + portName;");
            pw.println("}");
        }
    }

    protected void writeWSDLTestCode(PrintWriter pw, String portName) {
        String httpPortSystemProperty = ((EmitterEx)this.emitter).getTestHttpPortSystemProperty();
        if (httpPortSystemProperty != null) {
            pw.println("        javax.xml.rpc.ServiceFactory serviceFactory = javax.xml.rpc.ServiceFactory.newInstance();");
            pw.println("        javax.xml.rpc.Service service = serviceFactory.createService(new java.net.URL(getEndpoint(\"" + portName + "\") + \"?WSDL\"), new " + this.sEntry.getName() + "Locator().getServiceName());");
            pw.println("        assertTrue(service != null);");
        } else {
            super.writeWSDLTestCode(pw, portName);
        }
    }

    protected void writeServiceTestCode(PrintWriter pw, String portName, PortType portType, BindingEntry bEntry) {
        String httpPortSystemProperty = ((EmitterEx)this.emitter).getTestHttpPortSystemProperty();
        if (httpPortSystemProperty != null) {
            String bindingType = bEntry.getName() + "Stub";
            pw.println("    private static " + bindingType + " get" + portName + "() throws Exception {");
            pw.println("        " + bindingType + " binding");
            pw.println("                = (" + bindingType + ")");
            pw.print("                          new " + this.sEntry.getName());
            pw.println("Locator().get" + portName + "(new java.net.URL(getEndpoint(\"" + portName + "\")));");
            pw.println("        assertNotNull(\"" + Messages.getMessage((String)"null00", (String)"binding") + "\", binding);");
            pw.println();
            pw.println("        // Time out after a minute");
            pw.println("        binding.setTimeout(60000);");
            pw.println();
            pw.println("        return binding;");
            pw.println("    }");
            pw.println();
        }
        super.writeServiceTestCode(pw, portName, portType, bEntry);
    }

    public void writeBindingAssignment(PrintWriter pw, String bindingType, String portName) {
        String httpPortSystemProperty = ((EmitterEx)this.emitter).getTestHttpPortSystemProperty();
        if (httpPortSystemProperty != null) {
            pw.println("        " + bindingType + " binding = get" + portName + "();");
            pw.println();
        } else {
            super.writeBindingAssignment(pw, bindingType, portName);
        }
    }
}

