/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.tools.maven.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import org.codehaus.plexus.logging.Logger;

public class RemoteDaemon {
    private final Process process;
    private final String description;
    private final int controlPort;
    private BufferedReader controlIn;
    private Writer controlOut;

    public RemoteDaemon(Process process, String description, int controlPort) {
        this.process = process;
        this.description = description;
        this.controlPort = controlPort;
    }

    public Process getProcess() {
        return this.process;
    }

    public String getDescription() {
        return this.description;
    }

    public void startDaemon(Logger logger) throws Exception {
        Socket controlSocket;
        logger.debug("Attempting to establish control connection on port " + this.controlPort);
        while (true) {
            try {
                controlSocket = new Socket(InetAddress.getByName("localhost"), this.controlPort);
            }
            catch (IOException ex) {
                try {
                    int exitValue = this.process.exitValue();
                    throw new IllegalStateException("Process terminated prematurely with exit code " + exitValue);
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    Thread.sleep(100L);
                    continue;
                }
            }
            break;
        }
        logger.debug("Control connection established");
        this.controlIn = new BufferedReader(new InputStreamReader(controlSocket.getInputStream(), "ASCII"));
        this.controlOut = new OutputStreamWriter(controlSocket.getOutputStream(), "ASCII");
        logger.debug("Waiting for daemon to become ready");
        this.expectStatus("READY");
        logger.debug("Daemon is ready");
    }

    public void stopDaemon(Logger logger) throws Exception {
        this.controlOut.write("STOP\r\n");
        this.controlOut.flush();
        this.expectStatus("STOPPED");
    }

    private void expectStatus(String expectedStatus) throws IOException {
        String status = this.controlIn.readLine();
        if (status == null) {
            throw new IllegalStateException("Control connection unexpectedly closed");
        }
        if (!status.equals(expectedStatus)) {
            throw new IllegalStateException("Unexpected status: " + status);
        }
    }
}

