/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.tools.maven.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.axis.tools.maven.server.DaemonManager;
import org.apache.axis.tools.maven.server.RemoteDaemon;
import org.apache.axis.tools.maven.server.StreamPump;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;

public class DefaultDaemonManager
implements DaemonManager,
LogEnabled {
    private final List daemons = new ArrayList();
    private Logger logger;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void startDaemon(String description, String[] cmdline, File workDir, int controlPort) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Starting process with command line: " + Arrays.asList(cmdline));
        }
        Process process = Runtime.getRuntime().exec(cmdline, null, workDir);
        RemoteDaemon daemon = new RemoteDaemon(process, description, controlPort);
        this.daemons.add(daemon);
        new Thread(new StreamPump(process.getInputStream(), System.out)).start();
        new Thread(new StreamPump(process.getErrorStream(), System.err)).start();
        daemon.startDaemon(this.logger);
    }

    public void stopAll() throws Exception {
        Exception savedException = null;
        Iterator it = this.daemons.iterator();
        while (it.hasNext()) {
            boolean success;
            RemoteDaemon daemon = (RemoteDaemon)it.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Stopping " + daemon.getDescription());
            }
            try {
                daemon.stopDaemon(this.logger);
                success = true;
            }
            catch (Exception ex) {
                if (savedException == null) {
                    savedException = ex;
                }
                success = false;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("success = " + success);
            }
            if (success) {
                daemon.getProcess().waitFor();
            } else {
                daemon.getProcess().destroy();
            }
            this.logger.info(daemon.getDescription() + " stopped");
        }
        this.daemons.clear();
        if (savedException != null) {
            throw savedException;
        }
    }
}

