/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.dom.soap12;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.soap.SOAP12Version;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.SOAPVersion;
import org.apache.axiom.soap.impl.dom.SOAPHeaderBlockImpl;
import org.apache.axiom.soap.impl.dom.soap12.SOAP12HeaderImpl;

public class SOAP12HeaderBlockImpl
extends SOAPHeaderBlockImpl {
    public SOAP12HeaderBlockImpl(String localName, OMNamespace ns, SOAPHeader parent, SOAPFactory factory) throws SOAPProcessingException {
        super(localName, ns, parent, factory);
        this.checkParent(parent);
    }

    public SOAP12HeaderBlockImpl(String localName, OMNamespace ns, SOAPFactory factory) {
        super(localName, ns, factory);
    }

    public SOAP12HeaderBlockImpl(String localName, OMNamespace ns, SOAPHeader parent, OMXMLParserWrapper builder, SOAPFactory factory) {
        super(localName, ns, parent, builder, factory);
    }

    protected void checkParent(OMElement parent) throws SOAPProcessingException {
        if (!(parent instanceof SOAP12HeaderImpl)) {
            throw new SOAPProcessingException("Expecting SOAP 1.2 implementation of SOAP Body as the parent. But received some other implementation");
        }
    }

    public void setRole(String roleURI) {
        this.setAttribute("role", roleURI, "http://www.w3.org/2003/05/soap-envelope");
    }

    public String getRole() {
        return this.getAttribute("role", "http://www.w3.org/2003/05/soap-envelope");
    }

    public void setMustUnderstand(boolean mustUnderstand) {
        this.setAttribute("mustUnderstand", mustUnderstand ? "true" : "false", "http://www.w3.org/2003/05/soap-envelope");
    }

    public void setMustUnderstand(String mustUnderstand) throws SOAPProcessingException {
        if (!("true".equals(mustUnderstand) || "false".equals(mustUnderstand) || "0".equals(mustUnderstand) || "1".equals(mustUnderstand))) {
            throw new SOAPProcessingException("mustUndertand should be one of \"true\", \"false\", \"0\" or \"1\" ");
        }
        this.setAttribute("mustUnderstand", mustUnderstand, "http://www.w3.org/2003/05/soap-envelope");
    }

    public boolean getMustUnderstand() throws SOAPProcessingException {
        String mustUnderstand = this.getAttribute("mustUnderstand", "http://www.w3.org/2003/05/soap-envelope");
        if (mustUnderstand != null) {
            if ("true".equals(mustUnderstand) || "1".equals(mustUnderstand)) {
                return true;
            }
            if ("false".equals(mustUnderstand) || "0".equals(mustUnderstand)) {
                return false;
            }
            throw new SOAPProcessingException("Invalid value found in mustUnderstand value of " + this.getLocalName() + " header block");
        }
        return false;
    }

    public void setRelay(boolean relay) {
        this.setAttribute("relay", String.valueOf(relay), "http://www.w3.org/2003/05/soap-envelope");
    }

    public boolean getRelay() {
        return Boolean.valueOf(this.getAttribute("relay", "http://www.w3.org/2003/05/soap-envelope"));
    }

    public SOAPVersion getVersion() {
        return SOAP12Version.getSingleton();
    }
}

