/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.OMXMLStreamReader;
import org.apache.axiom.om.OMXMLStreamReaderConfiguration;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DOMStAXWrapper;
import org.apache.axiom.om.impl.dom.NamespaceURIInterningXMLStreamReaderWrapper;
import org.apache.axiom.om.util.OMXMLStreamReaderValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OMContainerHelper {
    private static final Log log = LogFactory.getLog(OMContainerHelper.class);
    private static final OMXMLStreamReaderConfiguration defaultReaderConfiguration = new OMXMLStreamReaderConfiguration();

    private OMContainerHelper() {
    }

    public static XMLStreamReader getXMLStreamReader(OMContainer container, boolean cache) {
        return OMContainerHelper.getXMLStreamReader(container, cache, defaultReaderConfiguration);
    }

    public static XMLStreamReader getXMLStreamReader(OMContainer container, boolean cache, OMXMLStreamReaderConfiguration configuration) {
        OMXMLStreamReader reader;
        OMXMLParserWrapper builder = container.getBuilder();
        if (builder != null && builder instanceof StAXOMBuilder && !container.isComplete() && ((StAXOMBuilder)builder).isLookahead()) {
            container.buildNext();
        }
        boolean done = container.isComplete();
        if (builder == null && done) {
            reader = new DOMStAXWrapper(null, container, false, configuration.isPreserveNamespaceContext());
        } else {
            if (builder == null && !cache) {
                throw new UnsupportedOperationException("This element was not created in a manner to be switched");
            }
            if (builder != null && builder.isCompleted() && !cache && !done) {
                throw new UnsupportedOperationException("The parser is already consumed!");
            }
            reader = new DOMStAXWrapper(builder, container, cache, configuration.isPreserveNamespaceContext());
        }
        if (configuration.isNamespaceURIInterning()) {
            reader = new NamespaceURIInterningXMLStreamReaderWrapper(reader);
        }
        if (log.isDebugEnabled()) {
            reader = new OMXMLStreamReaderValidator(reader, false);
        }
        return reader;
    }
}

