/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Globber;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.ClassUtil;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class FileSystem
extends Configured
implements Closeable {
    public static final String FS_DEFAULT_NAME_KEY = "fs.defaultFS";
    public static final String DEFAULT_FS = "file:///";
    public static final Log LOG = LogFactory.getLog(FileSystem.class);
    public static final int SHUTDOWN_HOOK_PRIORITY = 10;
    static final Cache CACHE = new Cache();
    private Cache.Key key;
    private static final Map<Class<? extends FileSystem>, Statistics> statisticsTable = new IdentityHashMap<Class<? extends FileSystem>, Statistics>();
    protected Statistics statistics;
    private Set<Path> deleteOnExit = new TreeSet<Path>();
    boolean resolveSymlinks;
    private static final PathFilter DEFAULT_FILTER = new PathFilter(){

        @Override
        public boolean accept(Path file) {
            return true;
        }
    };
    private static volatile boolean FILE_SYSTEMS_LOADED = false;
    private static final Map<String, Class<? extends FileSystem>> SERVICE_FILE_SYSTEMS = new HashMap<String, Class<? extends FileSystem>>();
    private static boolean symlinksEnabled = false;
    private static Configuration conf = null;

    static void addFileSystemForTesting(URI uri, Configuration conf, FileSystem fs) throws IOException {
        CACHE.map.put(new Cache.Key(uri, conf), fs);
    }

    public static FileSystem get(final URI uri, final Configuration conf, String user) throws IOException, InterruptedException {
        String ticketCachePath = conf.get("hadoop.security.kerberos.ticket.cache.path");
        UserGroupInformation ugi = UserGroupInformation.getBestUGI(ticketCachePath, user);
        return ugi.doAs(new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws IOException {
                return FileSystem.get(uri, conf);
            }
        });
    }

    public static FileSystem get(Configuration conf) throws IOException {
        return FileSystem.get(FileSystem.getDefaultUri(conf), conf);
    }

    public static URI getDefaultUri(Configuration conf) {
        return URI.create(FileSystem.fixName(conf.get(FS_DEFAULT_NAME_KEY, DEFAULT_FS)));
    }

    public static void setDefaultUri(Configuration conf, URI uri) {
        conf.set(FS_DEFAULT_NAME_KEY, uri.toString());
    }

    public static void setDefaultUri(Configuration conf, String uri) {
        FileSystem.setDefaultUri(conf, URI.create(FileSystem.fixName(uri)));
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        this.statistics = FileSystem.getStatistics(name.getScheme(), this.getClass());
        this.resolveSymlinks = conf.getBoolean("fs.client.resolve.remote.symlinks", true);
    }

    public String getScheme() {
        throw new UnsupportedOperationException("Not implemented by the " + this.getClass().getSimpleName() + " FileSystem implementation");
    }

    public abstract URI getUri();

    protected URI getCanonicalUri() {
        return this.canonicalizeUri(this.getUri());
    }

    protected URI canonicalizeUri(URI uri) {
        if (uri.getPort() == -1 && this.getDefaultPort() > 0) {
            try {
                uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), this.getDefaultPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new AssertionError((Object)("Valid URI became unparseable: " + uri));
            }
        }
        return uri;
    }

    protected int getDefaultPort() {
        return 0;
    }

    protected static FileSystem getFSofPath(Path absOrFqPath, Configuration conf) throws UnsupportedFileSystemException, IOException {
        absOrFqPath.checkNotSchemeWithRelative();
        absOrFqPath.checkNotRelative();
        return FileSystem.get(absOrFqPath.toUri(), conf);
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
    public String getCanonicalServiceName() {
        return this.getChildFileSystems() == null ? SecurityUtil.buildDTServiceName(this.getUri(), this.getDefaultPort()) : null;
    }

    @Deprecated
    public String getName() {
        return this.getUri().toString();
    }

    @Deprecated
    public static FileSystem getNamed(String name, Configuration conf) throws IOException {
        return FileSystem.get(URI.create(FileSystem.fixName(name)), conf);
    }

    private static String fixName(String name) {
        if (name.equals("local")) {
            LOG.warn("\"local\" is a deprecated filesystem name. Use \"file:///\" instead.");
            name = DEFAULT_FS;
        } else if (name.indexOf(47) == -1) {
            LOG.warn("\"" + name + "\" is a deprecated filesystem name." + " Use \"hdfs://" + name + "/\" instead.");
            name = "hdfs://" + name;
        }
        return name;
    }

    public static LocalFileSystem getLocal(Configuration conf) throws IOException {
        return (LocalFileSystem)FileSystem.get(LocalFileSystem.NAME, conf);
    }

    public static FileSystem get(URI uri, Configuration conf) throws IOException {
        URI defaultUri;
        String scheme = uri.getScheme();
        String authority = uri.getAuthority();
        if (scheme == null && authority == null) {
            return FileSystem.get(conf);
        }
        if (scheme != null && authority == null && scheme.equals((defaultUri = FileSystem.getDefaultUri(conf)).getScheme()) && defaultUri.getAuthority() != null) {
            return FileSystem.get(defaultUri, conf);
        }
        String disableCacheName = String.format("fs.%s.impl.disable.cache", scheme);
        if (conf.getBoolean(disableCacheName, false)) {
            return FileSystem.createFileSystem(uri, conf);
        }
        return CACHE.get(uri, conf);
    }

    public static FileSystem newInstance(final URI uri, final Configuration conf, String user) throws IOException, InterruptedException {
        String ticketCachePath = conf.get("hadoop.security.kerberos.ticket.cache.path");
        UserGroupInformation ugi = UserGroupInformation.getBestUGI(ticketCachePath, user);
        return ugi.doAs(new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws IOException {
                return FileSystem.newInstance(uri, conf);
            }
        });
    }

    public static FileSystem newInstance(URI uri, Configuration conf) throws IOException {
        URI defaultUri;
        String scheme = uri.getScheme();
        String authority = uri.getAuthority();
        if (scheme == null) {
            return FileSystem.newInstance(conf);
        }
        if (authority == null && scheme.equals((defaultUri = FileSystem.getDefaultUri(conf)).getScheme()) && defaultUri.getAuthority() != null) {
            return FileSystem.newInstance(defaultUri, conf);
        }
        return CACHE.getUnique(uri, conf);
    }

    public static FileSystem newInstance(Configuration conf) throws IOException {
        return FileSystem.newInstance(FileSystem.getDefaultUri(conf), conf);
    }

    public static LocalFileSystem newInstanceLocal(Configuration conf) throws IOException {
        return (LocalFileSystem)FileSystem.newInstance(LocalFileSystem.NAME, conf);
    }

    public static void closeAll() throws IOException {
        CACHE.closeAll();
    }

    public static void closeAllForUGI(UserGroupInformation ugi) throws IOException {
        CACHE.closeAll(ugi);
    }

    public Path makeQualified(Path path) {
        this.checkPath(path);
        return path.makeQualified(this.getUri(), this.getWorkingDirectory());
    }

    @InterfaceAudience.Private
    public Token<?> getDelegationToken(String renewer) throws IOException {
        return null;
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
    public Token<?>[] addDelegationTokens(String renewer, Credentials credentials) throws IOException {
        if (credentials == null) {
            credentials = new Credentials();
        }
        ArrayList tokens = new ArrayList();
        this.collectDelegationTokens(renewer, credentials, tokens);
        return tokens.toArray(new Token[tokens.size()]);
    }

    private void collectDelegationTokens(String renewer, Credentials credentials, List<Token<?>> tokens) throws IOException {
        FileSystem[] children;
        Text service;
        Token<TokenIdentifier> token;
        String serviceName = this.getCanonicalServiceName();
        if (serviceName != null && (token = credentials.getToken(service = new Text(serviceName))) == null && (token = this.getDelegationToken(renewer)) != null) {
            tokens.add(token);
            credentials.addToken(service, token);
        }
        if ((children = this.getChildFileSystems()) != null) {
            for (FileSystem fs : children) {
                fs.collectDelegationTokens(renewer, credentials, tokens);
            }
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    @VisibleForTesting
    public FileSystem[] getChildFileSystems() {
        return null;
    }

    public static FSDataOutputStream create(FileSystem fs, Path file, FsPermission permission) throws IOException {
        FSDataOutputStream out = fs.create(file);
        fs.setPermission(file, permission);
        return out;
    }

    public static boolean mkdirs(FileSystem fs, Path dir, FsPermission permission) throws IOException {
        boolean result = fs.mkdirs(dir);
        fs.setPermission(dir, permission);
        return result;
    }

    protected FileSystem() {
        super(null);
    }

    protected void checkPath(Path path) {
        URI uri = path.toUri();
        String thatScheme = uri.getScheme();
        if (thatScheme == null) {
            return;
        }
        URI thisUri = this.getCanonicalUri();
        String thisScheme = thisUri.getScheme();
        if (thisScheme.equalsIgnoreCase(thatScheme)) {
            String thisAuthority = thisUri.getAuthority();
            String thatAuthority = uri.getAuthority();
            if (thatAuthority == null && thisAuthority != null) {
                URI defaultUri = FileSystem.getDefaultUri(this.getConf());
                uri = thisScheme.equalsIgnoreCase(defaultUri.getScheme()) ? defaultUri : null;
            }
            if (uri != null && (thisAuthority == (thatAuthority = (uri = this.canonicalizeUri(uri)).getAuthority()) || thisAuthority != null && thisAuthority.equalsIgnoreCase(thatAuthority))) {
                return;
            }
        }
        throw new IllegalArgumentException("Wrong FS: " + path + ", expected: " + this.getUri());
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null) {
            return null;
        }
        if (start < 0L || len < 0L) {
            throw new IllegalArgumentException("Invalid start or len parameter");
        }
        if (file.getLen() <= start) {
            return new BlockLocation[0];
        }
        String[] name = new String[]{"localhost:50010"};
        String[] host = new String[]{"localhost"};
        return new BlockLocation[]{new BlockLocation(name, host, 0L, file.getLen())};
    }

    public BlockLocation[] getFileBlockLocations(Path p, long start, long len) throws IOException {
        if (p == null) {
            throw new NullPointerException();
        }
        FileStatus file = this.getFileStatus(p);
        return this.getFileBlockLocations(file, start, len);
    }

    @Deprecated
    public FsServerDefaults getServerDefaults() throws IOException {
        Configuration conf = this.getConf();
        return new FsServerDefaults(this.getDefaultBlockSize(), conf.getInt("io.bytes.per.checksum", 512), 65536, this.getDefaultReplication(), conf.getInt("io.file.buffer.size", 4096), false, 0L, DataChecksum.Type.CRC32);
    }

    public FsServerDefaults getServerDefaults(Path p) throws IOException {
        return this.getServerDefaults();
    }

    public Path resolvePath(Path p) throws IOException {
        this.checkPath(p);
        return this.getFileStatus(p).getPath();
    }

    public abstract FSDataInputStream open(Path var1, int var2) throws IOException;

    public FSDataInputStream open(Path f) throws IOException {
        return this.open(f, this.getConf().getInt("io.file.buffer.size", 4096));
    }

    public FSDataOutputStream create(Path f) throws IOException {
        return this.create(f, true);
    }

    public FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
        return this.create(f, overwrite, this.getConf().getInt("io.file.buffer.size", 4096), this.getDefaultReplication(f), this.getDefaultBlockSize(f));
    }

    public FSDataOutputStream create(Path f, Progressable progress) throws IOException {
        return this.create(f, true, this.getConf().getInt("io.file.buffer.size", 4096), this.getDefaultReplication(f), this.getDefaultBlockSize(f), progress);
    }

    public FSDataOutputStream create(Path f, short replication) throws IOException {
        return this.create(f, true, this.getConf().getInt("io.file.buffer.size", 4096), replication, this.getDefaultBlockSize(f));
    }

    public FSDataOutputStream create(Path f, short replication, Progressable progress) throws IOException {
        return this.create(f, true, this.getConf().getInt("io.file.buffer.size", 4096), replication, this.getDefaultBlockSize(f), progress);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize) throws IOException {
        return this.create(f, overwrite, bufferSize, this.getDefaultReplication(f), this.getDefaultBlockSize(f));
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, Progressable progress) throws IOException {
        return this.create(f, overwrite, bufferSize, this.getDefaultReplication(f), this.getDefaultBlockSize(f), progress);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        return this.create(f, overwrite, bufferSize, replication, blockSize, null);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(f, FsPermission.getFileDefault().applyUMask(FsPermission.getUMask(this.getConf())), overwrite, bufferSize, replication, blockSize, progress);
    }

    public abstract FSDataOutputStream create(Path var1, FsPermission var2, boolean var3, int var4, short var5, long var6, Progressable var8) throws IOException;

    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(f, permission, flags, bufferSize, replication, blockSize, progress, null);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        return this.create(f, permission, flags.contains((Object)CreateFlag.OVERWRITE), bufferSize, replication, blockSize, progress);
    }

    @Deprecated
    protected FSDataOutputStream primitiveCreate(Path f, FsPermission absolutePermission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        boolean pathExists = this.exists(f);
        CreateFlag.validate(f, pathExists, flag);
        if (pathExists && flag.contains((Object)CreateFlag.APPEND)) {
            return this.append(f, bufferSize, progress);
        }
        return this.create(f, absolutePermission, flag.contains((Object)CreateFlag.OVERWRITE), bufferSize, replication, blockSize, progress);
    }

    @Deprecated
    protected boolean primitiveMkdir(Path f, FsPermission absolutePermission) throws IOException {
        return this.mkdirs(f, absolutePermission);
    }

    @Deprecated
    protected void primitiveMkdir(Path f, FsPermission absolutePermission, boolean createParent) throws IOException {
        if (!createParent) {
            FileStatus stat = this.getFileStatus(f.getParent());
            if (stat == null) {
                throw new FileNotFoundException("Missing parent:" + f);
            }
            if (!stat.isDirectory()) {
                throw new ParentNotDirectoryException("parent is not a dir");
            }
        }
        if (!this.mkdirs(f, absolutePermission)) {
            throw new IOException("mkdir of " + f + " failed");
        }
    }

    @Deprecated
    public FSDataOutputStream createNonRecursive(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.createNonRecursive(f, FsPermission.getFileDefault(), overwrite, bufferSize, replication, blockSize, progress);
    }

    @Deprecated
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.createNonRecursive(f, permission, overwrite ? EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE), bufferSize, replication, blockSize, progress);
    }

    @Deprecated
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new IOException("createNonRecursive unsupported for this filesystem " + this.getClass());
    }

    public boolean createNewFile(Path f) throws IOException {
        if (this.exists(f)) {
            return false;
        }
        this.create(f, false, this.getConf().getInt("io.file.buffer.size", 4096)).close();
        return true;
    }

    public FSDataOutputStream append(Path f) throws IOException {
        return this.append(f, this.getConf().getInt("io.file.buffer.size", 4096), null);
    }

    public FSDataOutputStream append(Path f, int bufferSize) throws IOException {
        return this.append(f, bufferSize, null);
    }

    public abstract FSDataOutputStream append(Path var1, int var2, Progressable var3) throws IOException;

    public void concat(Path trg, Path[] psrcs) throws IOException {
        throw new UnsupportedOperationException("Not implemented by the " + this.getClass().getSimpleName() + " FileSystem implementation");
    }

    @Deprecated
    public short getReplication(Path src) throws IOException {
        return this.getFileStatus(src).getReplication();
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        return true;
    }

    public abstract boolean rename(Path var1, Path var2) throws IOException;

    @Deprecated
    protected void rename(Path src, Path dst, Options.Rename ... options) throws IOException {
        FileStatus dstStatus;
        FileStatus srcStatus = this.getFileLinkStatus(src);
        if (srcStatus == null) {
            throw new FileNotFoundException("rename source " + src + " not found.");
        }
        boolean overwrite = false;
        if (null != options) {
            for (Options.Rename option : options) {
                if (option != Options.Rename.OVERWRITE) continue;
                overwrite = true;
            }
        }
        try {
            dstStatus = this.getFileLinkStatus(dst);
        }
        catch (IOException e) {
            dstStatus = null;
        }
        if (dstStatus != null) {
            FileStatus[] list;
            if (srcStatus.isDirectory() != dstStatus.isDirectory()) {
                throw new IOException("Source " + src + " Destination " + dst + " both should be either file or directory");
            }
            if (!overwrite) {
                throw new FileAlreadyExistsException("rename destination " + dst + " already exists.");
            }
            if (dstStatus.isDirectory() && (list = this.listStatus(dst)) != null && list.length != 0) {
                throw new IOException("rename cannot overwrite non empty destination directory " + dst);
            }
            this.delete(dst, false);
        } else {
            Path parent = dst.getParent();
            FileStatus parentStatus = this.getFileStatus(parent);
            if (parentStatus == null) {
                throw new FileNotFoundException("rename destination parent " + parent + " not found.");
            }
            if (!parentStatus.isDirectory()) {
                throw new ParentNotDirectoryException("rename destination parent " + parent + " is a file.");
            }
        }
        if (!this.rename(src, dst)) {
            throw new IOException("rename from " + src + " to " + dst + " failed.");
        }
    }

    public boolean truncate(Path f, long newLength) throws IOException {
        throw new UnsupportedOperationException("Not implemented by the " + this.getClass().getSimpleName() + " FileSystem implementation");
    }

    @Deprecated
    public boolean delete(Path f) throws IOException {
        return this.delete(f, true);
    }

    public abstract boolean delete(Path var1, boolean var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteOnExit(Path f) throws IOException {
        if (!this.exists(f)) {
            return false;
        }
        Set<Path> set = this.deleteOnExit;
        synchronized (set) {
            this.deleteOnExit.add(f);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelDeleteOnExit(Path f) {
        Set<Path> set = this.deleteOnExit;
        synchronized (set) {
            return this.deleteOnExit.remove(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDeleteOnExit() {
        Set<Path> set = this.deleteOnExit;
        synchronized (set) {
            Iterator<Path> iter = this.deleteOnExit.iterator();
            while (iter.hasNext()) {
                Path path = iter.next();
                try {
                    if (this.exists(path)) {
                        this.delete(path, true);
                    }
                }
                catch (IOException e) {
                    LOG.info("Ignoring failure to deleteOnExit for path " + path);
                }
                iter.remove();
            }
        }
    }

    public boolean exists(Path f) throws IOException {
        try {
            return this.getFileStatus(f) != null;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public boolean isDirectory(Path f) throws IOException {
        try {
            return this.getFileStatus(f).isDirectory();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public boolean isFile(Path f) throws IOException {
        try {
            return this.getFileStatus(f).isFile();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Deprecated
    public long getLength(Path f) throws IOException {
        return this.getFileStatus(f).getLen();
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        FileStatus status = this.getFileStatus(f);
        if (status.isFile()) {
            long length = status.getLen();
            return new ContentSummary.Builder().length(length).fileCount(1L).directoryCount(0L).spaceConsumed(length).build();
        }
        long[] summary = new long[]{0L, 0L, 1L};
        for (FileStatus s : this.listStatus(f)) {
            long length = s.getLen();
            ContentSummary c = s.isDirectory() ? this.getContentSummary(s.getPath()) : new ContentSummary.Builder().length(length).fileCount(1L).directoryCount(0L).spaceConsumed(length).build();
            summary[0] = summary[0] + c.getLength();
            summary[1] = summary[1] + c.getFileCount();
            summary[2] = summary[2] + c.getDirectoryCount();
        }
        return new ContentSummary.Builder().length(summary[0]).fileCount(summary[1]).directoryCount(summary[2]).spaceConsumed(summary[0]).build();
    }

    public abstract FileStatus[] listStatus(Path var1) throws FileNotFoundException, IOException;

    private void listStatus(ArrayList<FileStatus> results, Path f, PathFilter filter) throws FileNotFoundException, IOException {
        FileStatus[] listing = this.listStatus(f);
        if (listing == null) {
            throw new IOException("Error accessing " + f);
        }
        for (int i = 0; i < listing.length; ++i) {
            if (!filter.accept(listing[i].getPath())) continue;
            results.add(listing[i]);
        }
    }

    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does not support" + " listCorruptFileBlocks");
    }

    public FileStatus[] listStatus(Path f, PathFilter filter) throws FileNotFoundException, IOException {
        ArrayList<FileStatus> results = new ArrayList<FileStatus>();
        this.listStatus(results, f, filter);
        return results.toArray(new FileStatus[results.size()]);
    }

    public FileStatus[] listStatus(Path[] files) throws FileNotFoundException, IOException {
        return this.listStatus(files, DEFAULT_FILTER);
    }

    public FileStatus[] listStatus(Path[] files, PathFilter filter) throws FileNotFoundException, IOException {
        ArrayList<FileStatus> results = new ArrayList<FileStatus>();
        for (int i = 0; i < files.length; ++i) {
            this.listStatus(results, files[i], filter);
        }
        return results.toArray(new FileStatus[results.size()]);
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return new Globber(this, pathPattern, DEFAULT_FILTER).glob();
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        return new Globber(this, pathPattern, filter).glob();
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws FileNotFoundException, IOException {
        return this.listLocatedStatus(f, DEFAULT_FILTER);
    }

    protected RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path f, final PathFilter filter) throws FileNotFoundException, IOException {
        return new RemoteIterator<LocatedFileStatus>(){
            private final FileStatus[] stats;
            private int i;
            {
                this.stats = FileSystem.this.listStatus(f, filter);
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.stats.length;
            }

            @Override
            public LocatedFileStatus next() throws IOException {
                FileStatus result;
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more entry in " + f);
                }
                BlockLocation[] locs = (result = this.stats[this.i++]).isFile() ? FileSystem.this.getFileBlockLocations(result, 0L, result.getLen()) : null;
                return new LocatedFileStatus(result, locs);
            }
        };
    }

    public RemoteIterator<FileStatus> listStatusIterator(final Path p) throws FileNotFoundException, IOException {
        return new RemoteIterator<FileStatus>(){
            private final FileStatus[] stats;
            private int i;
            {
                this.stats = FileSystem.this.listStatus(p);
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.stats.length;
            }

            @Override
            public FileStatus next() throws IOException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more entry in " + p);
                }
                return this.stats[this.i++];
            }
        };
    }

    public RemoteIterator<LocatedFileStatus> listFiles(final Path f, final boolean recursive) throws FileNotFoundException, IOException {
        return new RemoteIterator<LocatedFileStatus>(){
            private Stack<RemoteIterator<LocatedFileStatus>> itors = new Stack();
            private RemoteIterator<LocatedFileStatus> curItor = FileSystem.this.listLocatedStatus(f);
            private LocatedFileStatus curFile;

            @Override
            public boolean hasNext() throws IOException {
                while (this.curFile == null) {
                    if (this.curItor.hasNext()) {
                        this.handleFileStat(this.curItor.next());
                        continue;
                    }
                    if (!this.itors.empty()) {
                        this.curItor = this.itors.pop();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            private void handleFileStat(LocatedFileStatus stat) throws IOException {
                if (stat.isFile()) {
                    this.curFile = stat;
                } else if (recursive) {
                    this.itors.push(this.curItor);
                    this.curItor = FileSystem.this.listLocatedStatus(stat.getPath());
                }
            }

            @Override
            public LocatedFileStatus next() throws IOException {
                if (this.hasNext()) {
                    LocatedFileStatus result = this.curFile;
                    this.curFile = null;
                    return result;
                }
                throw new NoSuchElementException("No more entry in " + f);
            }
        };
    }

    public Path getHomeDirectory() {
        return this.makeQualified(new Path("/user/" + System.getProperty("user.name")));
    }

    public abstract void setWorkingDirectory(Path var1);

    public abstract Path getWorkingDirectory();

    protected Path getInitialWorkingDirectory() {
        return null;
    }

    public boolean mkdirs(Path f) throws IOException {
        return this.mkdirs(f, FsPermission.getDirDefault());
    }

    public abstract boolean mkdirs(Path var1, FsPermission var2) throws IOException;

    public void copyFromLocalFile(Path src, Path dst) throws IOException {
        this.copyFromLocalFile(false, src, dst);
    }

    public void moveFromLocalFile(Path[] srcs, Path dst) throws IOException {
        this.copyFromLocalFile(true, true, srcs, dst);
    }

    public void moveFromLocalFile(Path src, Path dst) throws IOException {
        this.copyFromLocalFile(true, src, dst);
    }

    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.copyFromLocalFile(delSrc, true, src, dst);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        Configuration conf = this.getConf();
        FileUtil.copy((FileSystem)FileSystem.getLocal(conf), srcs, this, dst, delSrc, overwrite, conf);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        Configuration conf = this.getConf();
        FileUtil.copy((FileSystem)FileSystem.getLocal(conf), src, this, dst, delSrc, overwrite, conf);
    }

    public void copyToLocalFile(Path src, Path dst) throws IOException {
        this.copyToLocalFile(false, src, dst);
    }

    public void moveToLocalFile(Path src, Path dst) throws IOException {
        this.copyToLocalFile(true, src, dst);
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.copyToLocalFile(delSrc, src, dst, false);
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst, boolean useRawLocalFileSystem) throws IOException {
        Configuration conf = this.getConf();
        FileSystem local = null;
        local = useRawLocalFileSystem ? FileSystem.getLocal(conf).getRawFileSystem() : FileSystem.getLocal(conf);
        FileUtil.copy(this, src, local, dst, delSrc, conf);
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return tmpLocalFile;
    }

    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        this.moveFromLocalFile(tmpLocalFile, fsOutputFile);
    }

    @Override
    public void close() throws IOException {
        this.processDeleteOnExit();
        CACHE.remove(this.key, this);
    }

    public long getUsed() throws IOException {
        FileStatus[] files;
        long used = 0L;
        for (FileStatus file : files = this.listStatus(new Path("/"))) {
            used += file.getLen();
        }
        return used;
    }

    @Deprecated
    public long getBlockSize(Path f) throws IOException {
        return this.getFileStatus(f).getBlockSize();
    }

    @Deprecated
    public long getDefaultBlockSize() {
        return this.getConf().getLong("fs.local.block.size", 0x2000000L);
    }

    public long getDefaultBlockSize(Path f) {
        return this.getDefaultBlockSize();
    }

    @Deprecated
    public short getDefaultReplication() {
        return 1;
    }

    public short getDefaultReplication(Path path) {
        return this.getDefaultReplication();
    }

    public abstract FileStatus getFileStatus(Path var1) throws IOException;

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "Hive"})
    public void access(Path path, FsAction mode) throws AccessControlException, FileNotFoundException, IOException {
        FileSystem.checkAccessPermissions(this.getFileStatus(path), mode);
    }

    @InterfaceAudience.Private
    static void checkAccessPermissions(FileStatus stat, FsAction mode) throws IOException {
        FsPermission perm = stat.getPermission();
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        String user = ugi.getShortUserName();
        List<String> groups = Arrays.asList(ugi.getGroupNames());
        if (user.equals(stat.getOwner()) ? perm.getUserAction().implies(mode) : (groups.contains(stat.getGroup()) ? perm.getGroupAction().implies(mode) : perm.getOtherAction().implies(mode))) {
            return;
        }
        throw new AccessControlException(String.format("Permission denied: user=%s, path=\"%s\":%s:%s:%s%s", user, stat.getPath(), stat.getOwner(), stat.getGroup(), stat.isDirectory() ? "d" : "-", perm));
    }

    protected Path fixRelativePart(Path p) {
        if (p.isUriPathAbsolute()) {
            return p;
        }
        return new Path(this.getWorkingDirectory(), p);
    }

    public void createSymlink(Path target, Path link, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
        throw new UnsupportedOperationException("Filesystem does not support symlinks!");
    }

    public FileStatus getFileLinkStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.getFileStatus(f);
    }

    public boolean supportsSymlinks() {
        return false;
    }

    public Path getLinkTarget(Path f) throws IOException {
        throw new UnsupportedOperationException("Filesystem does not support symlinks!");
    }

    protected Path resolveLink(Path f) throws IOException {
        throw new UnsupportedOperationException("Filesystem does not support symlinks!");
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        return this.getFileChecksum(f, Long.MAX_VALUE);
    }

    public FileChecksum getFileChecksum(Path f, long length) throws IOException {
        return null;
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
    }

    public void setWriteChecksum(boolean writeChecksum) {
    }

    public FsStatus getStatus() throws IOException {
        return this.getStatus(null);
    }

    public FsStatus getStatus(Path p) throws IOException {
        return new FsStatus(Long.MAX_VALUE, 0L, Long.MAX_VALUE);
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
    }

    public final Path createSnapshot(Path path) throws IOException {
        return this.createSnapshot(path, null);
    }

    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support createSnapshot");
    }

    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support renameSnapshot");
    }

    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support deleteSnapshot");
    }

    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support modifyAclEntries");
    }

    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeAclEntries");
    }

    public void removeDefaultAcl(Path path) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeDefaultAcl");
    }

    public void removeAcl(Path path) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeAcl");
    }

    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support setAcl");
    }

    public AclStatus getAclStatus(Path path) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support getAclStatus");
    }

    public void setXAttr(Path path, String name, byte[] value) throws IOException {
        this.setXAttr(path, name, value, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
    }

    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support setXAttr");
    }

    public byte[] getXAttr(Path path, String name) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support getXAttr");
    }

    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support getXAttrs");
    }

    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support getXAttrs");
    }

    public List<String> listXAttrs(Path path) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support listXAttrs");
    }

    public void removeXAttr(Path path, String name) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeXAttr");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFileSystems() {
        Class<FileSystem> clazz = FileSystem.class;
        synchronized (FileSystem.class) {
            if (!FILE_SYSTEMS_LOADED) {
                ServiceLoader<FileSystem> serviceLoader = ServiceLoader.load(FileSystem.class);
                Iterator<FileSystem> it = serviceLoader.iterator();
                while (it.hasNext()) {
                    FileSystem fs = null;
                    try {
                        fs = it.next();
                        try {
                            SERVICE_FILE_SYSTEMS.put(fs.getScheme(), fs.getClass());
                        }
                        catch (Exception e) {
                            LOG.warn("Cannot load: " + fs + " from " + ClassUtil.findContainingJar(fs.getClass()), e);
                        }
                    }
                    catch (ServiceConfigurationError ee) {
                        LOG.warn("Cannot load filesystem", ee);
                    }
                }
                FILE_SYSTEMS_LOADED = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Class<? extends FileSystem> getFileSystemClass(String scheme, Configuration conf) throws IOException {
        if (!FILE_SYSTEMS_LOADED) {
            FileSystem.loadFileSystems();
        }
        Class<FileSystem> clazz = null;
        if (conf != null) {
            clazz = conf.getClass("fs." + scheme + ".impl", null);
        }
        if (clazz == null) {
            clazz = SERVICE_FILE_SYSTEMS.get(scheme);
        }
        if (clazz == null) {
            throw new IOException("No FileSystem for scheme: " + scheme);
        }
        return clazz;
    }

    private static FileSystem createFileSystem(URI uri, Configuration conf) throws IOException {
        Class<? extends FileSystem> clazz = FileSystem.getFileSystemClass(uri.getScheme(), conf);
        FileSystem fs = ReflectionUtils.newInstance(clazz, conf);
        fs.initialize(uri, conf);
        return fs;
    }

    @Deprecated
    public static synchronized Map<String, Statistics> getStatistics() {
        HashMap<String, Statistics> result = new HashMap<String, Statistics>();
        for (Statistics stat : statisticsTable.values()) {
            result.put(stat.getScheme(), stat);
        }
        return result;
    }

    public static synchronized List<Statistics> getAllStatistics() {
        return new ArrayList<Statistics>(statisticsTable.values());
    }

    public static synchronized Statistics getStatistics(String scheme, Class<? extends FileSystem> cls) {
        Statistics result = statisticsTable.get(cls);
        if (result == null) {
            result = new Statistics(scheme);
            statisticsTable.put(cls, result);
        }
        return result;
    }

    public static synchronized void clearStatistics() {
        for (Statistics stat : statisticsTable.values()) {
            stat.reset();
        }
    }

    public static synchronized void printStatistics() throws IOException {
        for (Map.Entry<Class<? extends FileSystem>, Statistics> pair : statisticsTable.entrySet()) {
            System.out.println("  FileSystem " + pair.getKey().getName() + ": " + pair.getValue());
        }
    }

    @VisibleForTesting
    public static boolean areSymlinksEnabled() {
        return symlinksEnabled;
    }

    @VisibleForTesting
    public static void enableSymlinks() {
        symlinksEnabled = true;
    }

    public static final class Statistics {
        private final String scheme;
        private final StatisticsData rootData;
        private final ThreadLocal<StatisticsData> threadData;
        private final Set<StatisticsDataReference> allData;
        private static final ReferenceQueue<Thread> STATS_DATA_REF_QUEUE = new ReferenceQueue();
        private static final Thread STATS_DATA_CLEANER = new Thread(new StatisticsDataReferenceCleaner());

        public Statistics(String scheme) {
            this.scheme = scheme;
            this.rootData = new StatisticsData();
            this.threadData = new ThreadLocal();
            this.allData = new HashSet<StatisticsDataReference>();
        }

        public Statistics(Statistics other) {
            this.scheme = other.scheme;
            this.rootData = new StatisticsData();
            other.visitAll(new StatisticsAggregator<Void>(){

                @Override
                public void accept(StatisticsData data) {
                    Statistics.this.rootData.add(data);
                }

                @Override
                public Void aggregate() {
                    return null;
                }
            });
            this.threadData = new ThreadLocal();
            this.allData = new HashSet<StatisticsDataReference>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StatisticsData getThreadStatistics() {
            StatisticsData data = this.threadData.get();
            if (data == null) {
                data = new StatisticsData();
                this.threadData.set(data);
                StatisticsDataReference ref = new StatisticsDataReference(data, Thread.currentThread());
                Statistics statistics = this;
                synchronized (statistics) {
                    this.allData.add(ref);
                }
            }
            return data;
        }

        public void incrementBytesRead(long newBytes) {
            this.getThreadStatistics().bytesRead += newBytes;
        }

        public void incrementBytesWritten(long newBytes) {
            this.getThreadStatistics().bytesWritten += newBytes;
        }

        public void incrementReadOps(int count) {
            this.getThreadStatistics().readOps += count;
        }

        public void incrementLargeReadOps(int count) {
            this.getThreadStatistics().largeReadOps += count;
        }

        public void incrementWriteOps(int count) {
            this.getThreadStatistics().writeOps += count;
        }

        private synchronized <T> T visitAll(StatisticsAggregator<T> visitor) {
            visitor.accept(this.rootData);
            for (StatisticsDataReference ref : this.allData) {
                StatisticsData data = ref.getData();
                visitor.accept(data);
            }
            return visitor.aggregate();
        }

        public long getBytesRead() {
            return this.visitAll(new StatisticsAggregator<Long>(){
                private long bytesRead = 0L;

                @Override
                public void accept(StatisticsData data) {
                    this.bytesRead += data.bytesRead;
                }

                @Override
                public Long aggregate() {
                    return this.bytesRead;
                }
            });
        }

        public long getBytesWritten() {
            return this.visitAll(new StatisticsAggregator<Long>(){
                private long bytesWritten = 0L;

                @Override
                public void accept(StatisticsData data) {
                    this.bytesWritten += data.bytesWritten;
                }

                @Override
                public Long aggregate() {
                    return this.bytesWritten;
                }
            });
        }

        public int getReadOps() {
            return this.visitAll(new StatisticsAggregator<Integer>(){
                private int readOps = 0;

                @Override
                public void accept(StatisticsData data) {
                    this.readOps += data.readOps;
                    this.readOps += data.largeReadOps;
                }

                @Override
                public Integer aggregate() {
                    return this.readOps;
                }
            });
        }

        public int getLargeReadOps() {
            return this.visitAll(new StatisticsAggregator<Integer>(){
                private int largeReadOps = 0;

                @Override
                public void accept(StatisticsData data) {
                    this.largeReadOps += data.largeReadOps;
                }

                @Override
                public Integer aggregate() {
                    return this.largeReadOps;
                }
            });
        }

        public int getWriteOps() {
            return this.visitAll(new StatisticsAggregator<Integer>(){
                private int writeOps = 0;

                @Override
                public void accept(StatisticsData data) {
                    this.writeOps += data.writeOps;
                }

                @Override
                public Integer aggregate() {
                    return this.writeOps;
                }
            });
        }

        public String toString() {
            return this.visitAll(new StatisticsAggregator<String>(){
                private StatisticsData total = new StatisticsData();

                @Override
                public void accept(StatisticsData data) {
                    this.total.add(data);
                }

                @Override
                public String aggregate() {
                    return this.total.toString();
                }
            });
        }

        public void reset() {
            this.visitAll(new StatisticsAggregator<Void>(){
                private StatisticsData total = new StatisticsData();

                @Override
                public void accept(StatisticsData data) {
                    this.total.add(data);
                }

                @Override
                public Void aggregate() {
                    this.total.negate();
                    Statistics.this.rootData.add(this.total);
                    return null;
                }
            });
        }

        public String getScheme() {
            return this.scheme;
        }

        @VisibleForTesting
        synchronized int getAllThreadLocalDataSize() {
            return this.allData.size();
        }

        static {
            STATS_DATA_CLEANER.setName(StatisticsDataReferenceCleaner.class.getName());
            STATS_DATA_CLEANER.setDaemon(true);
            STATS_DATA_CLEANER.start();
        }

        private static class StatisticsDataReferenceCleaner
        implements Runnable {
            private StatisticsDataReferenceCleaner() {
            }

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            StatisticsDataReference ref = (StatisticsDataReference)STATS_DATA_REF_QUEUE.remove();
                            ref.cleanUp();
                        }
                    }
                    catch (Throwable th) {
                        LOG.warn("exception in the cleaner thread but it will continue to run", th);
                        continue;
                    }
                    break;
                }
            }
        }

        private class StatisticsDataReference
        extends WeakReference<Thread> {
            private final StatisticsData data;

            public StatisticsDataReference(StatisticsData data, Thread thread) {
                super(thread, STATS_DATA_REF_QUEUE);
                this.data = data;
            }

            public StatisticsData getData() {
                return this.data;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void cleanUp() {
                Statistics statistics = Statistics.this;
                synchronized (statistics) {
                    Statistics.this.rootData.add(this.data);
                    Statistics.this.allData.remove(this);
                }
            }
        }

        private static interface StatisticsAggregator<T> {
            public void accept(StatisticsData var1);

            public T aggregate();
        }

        public static class StatisticsData {
            volatile long bytesRead;
            volatile long bytesWritten;
            volatile int readOps;
            volatile int largeReadOps;
            volatile int writeOps;

            void add(StatisticsData other) {
                this.bytesRead += other.bytesRead;
                this.bytesWritten += other.bytesWritten;
                this.readOps += other.readOps;
                this.largeReadOps += other.largeReadOps;
                this.writeOps += other.writeOps;
            }

            void negate() {
                this.bytesRead = -this.bytesRead;
                this.bytesWritten = -this.bytesWritten;
                this.readOps = -this.readOps;
                this.largeReadOps = -this.largeReadOps;
                this.writeOps = -this.writeOps;
            }

            public String toString() {
                return this.bytesRead + " bytes read, " + this.bytesWritten + " bytes written, " + this.readOps + " read ops, " + this.largeReadOps + " large read ops, " + this.writeOps + " write ops";
            }

            public long getBytesRead() {
                return this.bytesRead;
            }

            public long getBytesWritten() {
                return this.bytesWritten;
            }

            public int getReadOps() {
                return this.readOps;
            }

            public int getLargeReadOps() {
                return this.largeReadOps;
            }

            public int getWriteOps() {
                return this.writeOps;
            }
        }
    }

    static class Cache {
        private final ClientFinalizer clientFinalizer = new ClientFinalizer();
        private final Map<Key, FileSystem> map = new HashMap<Key, FileSystem>();
        private final Set<Key> toAutoClose = new HashSet<Key>();
        private static AtomicLong unique = new AtomicLong(1L);

        Cache() {
        }

        FileSystem get(URI uri, Configuration conf) throws IOException {
            Key key = new Key(uri, conf);
            return this.getInternal(uri, conf, key);
        }

        FileSystem getUnique(URI uri, Configuration conf) throws IOException {
            Key key = new Key(uri, conf, unique.getAndIncrement());
            return this.getInternal(uri, conf, key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FileSystem getInternal(URI uri, Configuration conf, Key key) throws IOException {
            FileSystem fs;
            Cache cache = this;
            synchronized (cache) {
                fs = this.map.get(key);
            }
            if (fs != null) {
                return fs;
            }
            fs = FileSystem.createFileSystem(uri, conf);
            cache = this;
            synchronized (cache) {
                FileSystem oldfs = this.map.get(key);
                if (oldfs != null) {
                    fs.close();
                    return oldfs;
                }
                if (this.map.isEmpty() && !ShutdownHookManager.get().isShutdownInProgress()) {
                    ShutdownHookManager.get().addShutdownHook(this.clientFinalizer, 10);
                }
                fs.key = key;
                this.map.put(key, fs);
                if (conf.getBoolean("fs.automatic.close", true)) {
                    this.toAutoClose.add(key);
                }
                return fs;
            }
        }

        synchronized void remove(Key key, FileSystem fs) {
            if (this.map.containsKey(key) && fs == this.map.get(key)) {
                this.map.remove(key);
                this.toAutoClose.remove(key);
            }
        }

        synchronized void closeAll() throws IOException {
            this.closeAll(false);
        }

        synchronized void closeAll(boolean onlyAutomatic) throws IOException {
            ArrayList<IOException> exceptions = new ArrayList<IOException>();
            ArrayList<Key> keys = new ArrayList<Key>();
            keys.addAll(this.map.keySet());
            for (Key key : keys) {
                FileSystem fs = this.map.get(key);
                if (onlyAutomatic && !this.toAutoClose.contains(key)) continue;
                this.remove(key, fs);
                if (fs == null) continue;
                try {
                    fs.close();
                }
                catch (IOException ioe) {
                    exceptions.add(ioe);
                }
            }
            if (!exceptions.isEmpty()) {
                throw MultipleIOException.createIOException(exceptions);
            }
        }

        synchronized void closeAll(UserGroupInformation ugi) throws IOException {
            ArrayList<FileSystem> targetFSList = new ArrayList<FileSystem>();
            for (Map.Entry<Key, FileSystem> entry : this.map.entrySet()) {
                Key key = entry.getKey();
                FileSystem fs = entry.getValue();
                if (!ugi.equals(key.ugi) || fs == null) continue;
                targetFSList.add(fs);
            }
            ArrayList<IOException> exceptions = new ArrayList<IOException>();
            for (FileSystem fs : targetFSList) {
                try {
                    fs.close();
                }
                catch (IOException ioe) {
                    exceptions.add(ioe);
                }
            }
            if (!exceptions.isEmpty()) {
                throw MultipleIOException.createIOException(exceptions);
            }
        }

        static class Key {
            final String scheme;
            final String authority;
            final UserGroupInformation ugi;
            final long unique;

            Key(URI uri, Configuration conf) throws IOException {
                this(uri, conf, 0L);
            }

            Key(URI uri, Configuration conf, long unique) throws IOException {
                this.scheme = uri.getScheme() == null ? "" : StringUtils.toLowerCase(uri.getScheme());
                this.authority = uri.getAuthority() == null ? "" : StringUtils.toLowerCase(uri.getAuthority());
                this.unique = unique;
                this.ugi = UserGroupInformation.getCurrentUser();
            }

            public int hashCode() {
                return (this.scheme + this.authority).hashCode() + this.ugi.hashCode() + (int)this.unique;
            }

            static boolean isEqual(Object a, Object b) {
                return a == b || a != null && a.equals(b);
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj != null && obj instanceof Key) {
                    Key that = (Key)obj;
                    return Key.isEqual(this.scheme, that.scheme) && Key.isEqual(this.authority, that.authority) && Key.isEqual(this.ugi, that.ugi) && this.unique == that.unique;
                }
                return false;
            }

            public String toString() {
                return "(" + this.ugi.toString() + ")@" + this.scheme + "://" + this.authority;
            }
        }

        private class ClientFinalizer
        implements Runnable {
            private ClientFinalizer() {
            }

            @Override
            public synchronized void run() {
                try {
                    Cache.this.closeAll(true);
                }
                catch (IOException e) {
                    LOG.info("FileSystem.Cache.closeAll() threw an exception:\n" + e);
                }
            }
        }
    }
}

