/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.hadoop.io;

import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;

public class AvroKeyValue<K, V> {
    public static final String KEY_VALUE_PAIR_RECORD_NAME = "KeyValuePair";
    public static final String KEY_VALUE_PAIR_RECORD_NAMESPACE = "org.apache.avro.mapreduce";
    public static final String KEY_FIELD = "key";
    public static final String VALUE_FIELD = "value";
    private final GenericRecord mKeyValueRecord;

    public AvroKeyValue(GenericRecord keyValueRecord) {
        this.mKeyValueRecord = keyValueRecord;
    }

    public GenericRecord get() {
        return this.mKeyValueRecord;
    }

    public K getKey() {
        return (K)this.mKeyValueRecord.get(KEY_FIELD);
    }

    public V getValue() {
        return (V)this.mKeyValueRecord.get(VALUE_FIELD);
    }

    public void setKey(K key) {
        this.mKeyValueRecord.put(KEY_FIELD, key);
    }

    public void setValue(V value) {
        this.mKeyValueRecord.put(VALUE_FIELD, value);
    }

    public static Schema getSchema(Schema keySchema, Schema valueSchema) {
        Schema schema = Schema.createRecord(KEY_VALUE_PAIR_RECORD_NAME, "A key/value pair", KEY_VALUE_PAIR_RECORD_NAMESPACE, false);
        schema.setFields(Arrays.asList(new Schema.Field(KEY_FIELD, keySchema, "The key", (Object)null), new Schema.Field(VALUE_FIELD, valueSchema, "The value", (Object)null)));
        return schema;
    }

    public static class Iterator<K, V>
    implements java.util.Iterator<AvroKeyValue<K, V>> {
        private final java.util.Iterator<? extends GenericRecord> mGenericIterator;

        public Iterator(java.util.Iterator<? extends GenericRecord> genericIterator) {
            this.mGenericIterator = genericIterator;
        }

        @Override
        public boolean hasNext() {
            return this.mGenericIterator.hasNext();
        }

        @Override
        public AvroKeyValue<K, V> next() {
            GenericRecord genericRecord = this.mGenericIterator.next();
            if (null == genericRecord) {
                return null;
            }
            return new AvroKeyValue(genericRecord);
        }

        @Override
        public void remove() {
            this.mGenericIterator.remove();
        }
    }
}

