/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.specific;

import java.io.File;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.compiler.specific.ProtocolTask;
import org.apache.avro.compiler.specific.SpecificCompiler;

public class SchemaTask
extends ProtocolTask {
    @Override
    protected void doCompile(File src, File dest) throws IOException {
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(src);
        SpecificCompiler compiler = new SpecificCompiler(schema, this.getDateTimeLogicalTypeImplementation());
        compiler.setStringType(this.getStringType());
        compiler.compileToDestination(src, dest);
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.err.println("Usage: SchemaTask <schema.avsc>... <output-folder>");
            System.exit(1);
        }
        File dst = new File(args[args.length - 1]);
        for (int i = 0; i < args.length - 1; ++i) {
            new SchemaTask().doCompile(new File(args[i]), dst);
        }
    }
}

