/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.trevni.BZip2Codec;
import org.apache.trevni.Codec;
import org.apache.trevni.MetaData;
import org.junit.Assert;
import org.junit.Test;

public class TestBZip2Codec {
    @Test
    public void testBZip2CompressionAndDecompression() throws IOException {
        MetaData meta = new MetaData();
        meta.setCodec("bzip2");
        Codec codec = Codec.get(meta);
        Assert.assertTrue((boolean)(codec instanceof BZip2Codec));
        int inputByteSize = 196650;
        byte[] inputByteArray = new byte[196650];
        for (int i = 0; i < 196650; ++i) {
            inputByteArray[i] = (byte)(65 + i % 10);
        }
        ByteBuffer inputByteBuffer = ByteBuffer.wrap(inputByteArray);
        ByteBuffer compressedBuffer = codec.compress(inputByteBuffer);
        Assert.assertTrue((compressedBuffer.array().length > 0 ? 1 : 0) != 0);
        Assert.assertTrue((compressedBuffer.array().length < inputByteArray.length ? 1 : 0) != 0);
        ByteBuffer decompressedBuffer = codec.decompress(compressedBuffer);
        Assert.assertTrue((decompressedBuffer.array().length == inputByteArray.length ? 1 : 0) != 0);
        byte[] outputByteArray = decompressedBuffer.array();
        System.arraycopy(outputByteArray, 0, inputByteArray, 0, 196650);
    }
}

