/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NativeCodeLoader {
    private static final Log LOG;
    private static boolean nativeCodeLoaded;

    public static boolean isNativeCodeLoaded() {
        return nativeCodeLoaded;
    }

    public static native boolean buildSupportsSnappy();

    public static native boolean buildSupportsOpenssl();

    public static native String getLibraryName();

    public boolean getLoadNativeLibraries(Configuration conf) {
        return conf.getBoolean("io.native.lib.available", true);
    }

    public void setLoadNativeLibraries(Configuration conf, boolean loadNativeLibraries) {
        conf.setBoolean("io.native.lib.available", loadNativeLibraries);
    }

    static {
        block4: {
            LOG = LogFactory.getLog(NativeCodeLoader.class);
            nativeCodeLoaded = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying to load the custom-built native-hadoop library...");
            }
            try {
                System.loadLibrary("hadoop");
                LOG.debug("Loaded the native-hadoop library");
                nativeCodeLoaded = true;
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("Failed to load native-hadoop with error: " + t);
                LOG.debug("java.library.path=" + System.getProperty("java.library.path"));
            }
        }
        if (!nativeCodeLoaded) {
            LOG.warn("Unable to load native-hadoop library for your platform... using builtin-java classes where applicable");
        }
    }
}

