/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DeprecatedUTF8;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguousUnderConstruction;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotFSImageFormat;
import org.apache.hadoop.hdfs.util.XMLUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.ShortWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FSImageSerialization {
    private static final ThreadLocal<TLData> TL_DATA = new ThreadLocal<TLData>(){

        @Override
        protected TLData initialValue() {
            return new TLData();
        }
    };

    private FSImageSerialization() {
    }

    private static void writePermissionStatus(INodeAttributes inode, DataOutput out) throws IOException {
        FsPermission p = FSImageSerialization.TL_DATA.get().FILE_PERM;
        p.fromShort(inode.getFsPermissionShort());
        PermissionStatus.write(out, inode.getUserName(), inode.getGroupName(), p);
    }

    private static void writeBlocks(Block[] blocks, DataOutput out) throws IOException {
        if (blocks == null) {
            out.writeInt(0);
        } else {
            out.writeInt(blocks.length);
            for (Block blk : blocks) {
                blk.write(out);
            }
        }
    }

    static INodeFile readINodeUnderConstruction(DataInput in, FSNamesystem fsNamesys, int imgVersion) throws IOException {
        byte[] name = FSImageSerialization.readBytes(in);
        long inodeId = NameNodeLayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, imgVersion) ? in.readLong() : fsNamesys.dir.allocateNewInodeId();
        short blockReplication = in.readShort();
        long modificationTime = in.readLong();
        long preferredBlockSize = in.readLong();
        int numBlocks = in.readInt();
        BlockInfoContiguous[] blocks = new BlockInfoContiguous[numBlocks];
        Block blk = new Block();
        for (int i = 0; i < numBlocks - 1; ++i) {
            blk.readFields(in);
            blocks[i] = new BlockInfoContiguous(blk, blockReplication);
        }
        if (numBlocks > 0) {
            blk.readFields(in);
            blocks[i] = new BlockInfoContiguousUnderConstruction(blk, blockReplication, HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, null);
        }
        PermissionStatus perm = PermissionStatus.read(in);
        String clientName = FSImageSerialization.readString(in);
        String clientMachine = FSImageSerialization.readString(in);
        int numLocs = in.readInt();
        assert (numLocs == 0) : "Unexpected block locations";
        INodeFile file = new INodeFile(inodeId, name, perm, modificationTime, modificationTime, blocks, blockReplication, preferredBlockSize, 0);
        file.toUnderConstruction(clientName, clientMachine);
        return file;
    }

    static void writeINodeUnderConstruction(DataOutputStream out, INodeFile cons, String path) throws IOException {
        FSImageSerialization.writeString(path, out);
        out.writeLong(cons.getId());
        out.writeShort(cons.getFileReplication());
        out.writeLong(cons.getModificationTime());
        out.writeLong(cons.getPreferredBlockSize());
        FSImageSerialization.writeBlocks(cons.getBlocks(), out);
        cons.getPermissionStatus().write(out);
        FileUnderConstructionFeature uc = cons.getFileUnderConstructionFeature();
        FSImageSerialization.writeString(uc.getClientName(), out);
        FSImageSerialization.writeString(uc.getClientMachine(), out);
        out.writeInt(0);
    }

    public static void writeINodeFile(INodeFile file, DataOutput out, boolean writeUnderConstruction) throws IOException {
        FSImageSerialization.writeLocalName(file, out);
        out.writeLong(file.getId());
        out.writeShort(file.getFileReplication());
        out.writeLong(file.getModificationTime());
        out.writeLong(file.getAccessTime());
        out.writeLong(file.getPreferredBlockSize());
        FSImageSerialization.writeBlocks(file.getBlocks(), out);
        SnapshotFSImageFormat.saveFileDiffList(file, out);
        if (writeUnderConstruction) {
            if (file.isUnderConstruction()) {
                out.writeBoolean(true);
                FileUnderConstructionFeature uc = file.getFileUnderConstructionFeature();
                FSImageSerialization.writeString(uc.getClientName(), out);
                FSImageSerialization.writeString(uc.getClientMachine(), out);
            } else {
                out.writeBoolean(false);
            }
        }
        FSImageSerialization.writePermissionStatus(file, out);
    }

    public static void writeINodeFileAttributes(INodeFileAttributes file, DataOutput out) throws IOException {
        FSImageSerialization.writeLocalName(file, out);
        FSImageSerialization.writePermissionStatus(file, out);
        out.writeLong(file.getModificationTime());
        out.writeLong(file.getAccessTime());
        out.writeShort(file.getFileReplication());
        out.writeLong(file.getPreferredBlockSize());
    }

    private static void writeQuota(QuotaCounts quota, DataOutput out) throws IOException {
        out.writeLong(quota.getNameSpace());
        out.writeLong(quota.getStorageSpace());
    }

    public static void writeINodeDirectory(INodeDirectory node, DataOutput out) throws IOException {
        FSImageSerialization.writeLocalName(node, out);
        out.writeLong(node.getId());
        out.writeShort(0);
        out.writeLong(node.getModificationTime());
        out.writeLong(0L);
        out.writeLong(0L);
        out.writeInt(-1);
        FSImageSerialization.writeQuota(node.getQuotaCounts(), out);
        if (node.isSnapshottable()) {
            out.writeBoolean(true);
        } else {
            out.writeBoolean(false);
            out.writeBoolean(node.isWithSnapshot());
        }
        FSImageSerialization.writePermissionStatus(node, out);
    }

    public static void writeINodeDirectoryAttributes(INodeDirectoryAttributes a, DataOutput out) throws IOException {
        FSImageSerialization.writeLocalName(a, out);
        FSImageSerialization.writePermissionStatus(a, out);
        out.writeLong(a.getModificationTime());
        FSImageSerialization.writeQuota(a.getQuotaCounts(), out);
    }

    private static void writeINodeSymlink(INodeSymlink node, DataOutput out) throws IOException {
        FSImageSerialization.writeLocalName(node, out);
        out.writeLong(node.getId());
        out.writeShort(0);
        out.writeLong(0L);
        out.writeLong(0L);
        out.writeLong(0L);
        out.writeInt(-2);
        Text.writeString(out, node.getSymlinkString());
        FSImageSerialization.writePermissionStatus(node, out);
    }

    private static void writeINodeReference(INodeReference ref, DataOutput out, boolean writeUnderConstruction, SnapshotFSImageFormat.ReferenceMap referenceMap) throws IOException {
        FSImageSerialization.writeLocalName(ref, out);
        out.writeLong(ref.getId());
        out.writeShort(0);
        out.writeLong(0L);
        out.writeLong(0L);
        out.writeLong(0L);
        out.writeInt(-3);
        boolean isWithName = ref instanceof INodeReference.WithName;
        out.writeBoolean(isWithName);
        if (!isWithName) {
            Preconditions.checkState(ref instanceof INodeReference.DstReference);
            out.writeInt(((INodeReference.DstReference)ref).getDstSnapshotId());
        } else {
            out.writeInt(((INodeReference.WithName)ref).getLastSnapshotId());
        }
        INodeReference.WithCount withCount = (INodeReference.WithCount)ref.getReferredINode();
        referenceMap.writeINodeReferenceWithCount(withCount, out, writeUnderConstruction);
    }

    public static void saveINode2Image(INode node, DataOutput out, boolean writeUnderConstruction, SnapshotFSImageFormat.ReferenceMap referenceMap) throws IOException {
        if (node.isReference()) {
            FSImageSerialization.writeINodeReference(node.asReference(), out, writeUnderConstruction, referenceMap);
        } else if (node.isDirectory()) {
            FSImageSerialization.writeINodeDirectory(node.asDirectory(), out);
        } else if (node.isSymlink()) {
            FSImageSerialization.writeINodeSymlink(node.asSymlink(), out);
        } else if (node.isFile()) {
            FSImageSerialization.writeINodeFile(node.asFile(), out, writeUnderConstruction);
        }
    }

    public static String readString(DataInput in) throws IOException {
        DeprecatedUTF8 ustr = FSImageSerialization.TL_DATA.get().U_STR;
        ustr.readFields(in);
        return ustr.toStringChecked();
    }

    static String readString_EmptyAsNull(DataInput in) throws IOException {
        String s = FSImageSerialization.readString(in);
        return s.isEmpty() ? null : s;
    }

    public static void writeString(String str, DataOutput out) throws IOException {
        DeprecatedUTF8 ustr = FSImageSerialization.TL_DATA.get().U_STR;
        ustr.set(str);
        ustr.write(out);
    }

    static long readLong(DataInput in) throws IOException {
        LongWritable uLong = FSImageSerialization.TL_DATA.get().U_LONG;
        uLong.readFields(in);
        return uLong.get();
    }

    static void writeLong(long value, DataOutputStream out) throws IOException {
        LongWritable uLong = FSImageSerialization.TL_DATA.get().U_LONG;
        uLong.set(value);
        uLong.write(out);
    }

    static boolean readBoolean(DataInput in) throws IOException {
        BooleanWritable uBoolean = FSImageSerialization.TL_DATA.get().U_BOOLEAN;
        uBoolean.readFields(in);
        return uBoolean.get();
    }

    static void writeBoolean(boolean value, DataOutputStream out) throws IOException {
        BooleanWritable uBoolean = FSImageSerialization.TL_DATA.get().U_BOOLEAN;
        uBoolean.set(value);
        uBoolean.write(out);
    }

    static void writeByte(byte value, DataOutputStream out) throws IOException {
        out.write(value);
    }

    static int readInt(DataInput in) throws IOException {
        IntWritable uInt = FSImageSerialization.TL_DATA.get().U_INT;
        uInt.readFields(in);
        return uInt.get();
    }

    static void writeInt(int value, DataOutputStream out) throws IOException {
        IntWritable uInt = FSImageSerialization.TL_DATA.get().U_INT;
        uInt.set(value);
        uInt.write(out);
    }

    static short readShort(DataInput in) throws IOException {
        ShortWritable uShort = FSImageSerialization.TL_DATA.get().U_SHORT;
        uShort.readFields(in);
        return uShort.get();
    }

    static void writeShort(short value, DataOutputStream out) throws IOException {
        ShortWritable uShort = FSImageSerialization.TL_DATA.get().U_SHORT;
        uShort.set(value);
        uShort.write(out);
    }

    public static byte[] readBytes(DataInput in) throws IOException {
        DeprecatedUTF8 ustr = FSImageSerialization.TL_DATA.get().U_STR;
        ustr.readFields(in);
        int len = ustr.getLength();
        byte[] bytes = new byte[len];
        System.arraycopy(ustr.getBytes(), 0, bytes, 0, len);
        return bytes;
    }

    public static byte readByte(DataInput in) throws IOException {
        return in.readByte();
    }

    public static byte[][] readPathComponents(DataInput in) throws IOException {
        DeprecatedUTF8 ustr = FSImageSerialization.TL_DATA.get().U_STR;
        ustr.readFields(in);
        return DFSUtil.bytes2byteArray(ustr.getBytes(), ustr.getLength(), (byte)47);
    }

    public static byte[] readLocalName(DataInput in) throws IOException {
        byte[] createdNodeName = new byte[in.readShort()];
        in.readFully(createdNodeName);
        return createdNodeName;
    }

    private static void writeLocalName(INodeAttributes inode, DataOutput out) throws IOException {
        byte[] name = inode.getLocalNameBytes();
        FSImageSerialization.writeBytes(name, out);
    }

    public static void writeBytes(byte[] data, DataOutput out) throws IOException {
        out.writeShort(data.length);
        out.write(data);
    }

    public static void writeCompactBlockArray(Block[] blocks, DataOutputStream out) throws IOException {
        WritableUtils.writeVInt(out, blocks.length);
        Block prev = null;
        for (Block b : blocks) {
            long szDelta = b.getNumBytes() - (prev != null ? prev.getNumBytes() : 0L);
            long gsDelta = b.getGenerationStamp() - (prev != null ? prev.getGenerationStamp() : 0L);
            out.writeLong(b.getBlockId());
            WritableUtils.writeVLong(out, szDelta);
            WritableUtils.writeVLong(out, gsDelta);
            prev = b;
        }
    }

    public static Block[] readCompactBlockArray(DataInput in, int logVersion) throws IOException {
        int num = WritableUtils.readVInt(in);
        if (num < 0) {
            throw new IOException("Invalid block array length: " + num);
        }
        Block prev = null;
        Block[] ret = new Block[num];
        for (int i = 0; i < num; ++i) {
            long id = in.readLong();
            long sz = WritableUtils.readVLong(in) + (prev != null ? prev.getNumBytes() : 0L);
            long gs = WritableUtils.readVLong(in) + (prev != null ? prev.getGenerationStamp() : 0L);
            ret[i] = new Block(id, sz, gs);
            prev = ret[i];
        }
        return ret;
    }

    public static void writeCacheDirectiveInfo(DataOutputStream out, CacheDirectiveInfo directive) throws IOException {
        FSImageSerialization.writeLong(directive.getId(), out);
        int flags = (directive.getPath() != null ? 1 : 0) | (directive.getReplication() != null ? 2 : 0) | (directive.getPool() != null ? 4 : 0) | (directive.getExpiration() != null ? 8 : 0);
        out.writeInt(flags);
        if (directive.getPath() != null) {
            FSImageSerialization.writeString(directive.getPath().toUri().getPath(), out);
        }
        if (directive.getReplication() != null) {
            FSImageSerialization.writeShort(directive.getReplication(), out);
        }
        if (directive.getPool() != null) {
            FSImageSerialization.writeString(directive.getPool(), out);
        }
        if (directive.getExpiration() != null) {
            FSImageSerialization.writeLong(directive.getExpiration().getMillis(), out);
        }
    }

    public static CacheDirectiveInfo readCacheDirectiveInfo(DataInput in) throws IOException {
        CacheDirectiveInfo.Builder builder = new CacheDirectiveInfo.Builder();
        builder.setId(FSImageSerialization.readLong(in));
        int flags = in.readInt();
        if ((flags & 1) != 0) {
            builder.setPath(new Path(FSImageSerialization.readString(in)));
        }
        if ((flags & 2) != 0) {
            builder.setReplication(FSImageSerialization.readShort(in));
        }
        if ((flags & 4) != 0) {
            builder.setPool(FSImageSerialization.readString(in));
        }
        if ((flags & 8) != 0) {
            builder.setExpiration(CacheDirectiveInfo.Expiration.newAbsolute(FSImageSerialization.readLong(in)));
        }
        if ((flags & 0xFFFFFFF0) != 0) {
            throw new IOException("unknown flags set in ModifyCacheDirectiveInfoOp: " + flags);
        }
        return builder.build();
    }

    public static CacheDirectiveInfo readCacheDirectiveInfo(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        String expiryTime;
        String pool;
        String replicationString;
        CacheDirectiveInfo.Builder builder = new CacheDirectiveInfo.Builder();
        builder.setId(Long.parseLong(st.getValue("ID")));
        String path = st.getValueOrNull("PATH");
        if (path != null) {
            builder.setPath(new Path(path));
        }
        if ((replicationString = st.getValueOrNull("REPLICATION")) != null) {
            builder.setReplication(Short.parseShort(replicationString));
        }
        if ((pool = st.getValueOrNull("POOL")) != null) {
            builder.setPool(pool);
        }
        if ((expiryTime = st.getValueOrNull("EXPIRATION")) != null) {
            builder.setExpiration(CacheDirectiveInfo.Expiration.newAbsolute(Long.parseLong(expiryTime)));
        }
        return builder.build();
    }

    public static void writeCacheDirectiveInfo(ContentHandler contentHandler, CacheDirectiveInfo directive) throws SAXException {
        XMLUtils.addSaxString(contentHandler, "ID", Long.toString(directive.getId()));
        if (directive.getPath() != null) {
            XMLUtils.addSaxString(contentHandler, "PATH", directive.getPath().toUri().getPath());
        }
        if (directive.getReplication() != null) {
            XMLUtils.addSaxString(contentHandler, "REPLICATION", Short.toString(directive.getReplication()));
        }
        if (directive.getPool() != null) {
            XMLUtils.addSaxString(contentHandler, "POOL", directive.getPool());
        }
        if (directive.getExpiration() != null) {
            XMLUtils.addSaxString(contentHandler, "EXPIRATION", "" + directive.getExpiration().getMillis());
        }
    }

    public static void writeCachePoolInfo(DataOutputStream out, CachePoolInfo info) throws IOException {
        FSImageSerialization.writeString(info.getPoolName(), out);
        String ownerName = info.getOwnerName();
        String groupName = info.getGroupName();
        Long limit = info.getLimit();
        FsPermission mode = info.getMode();
        Long maxRelativeExpiry = info.getMaxRelativeExpiryMs();
        boolean hasOwner = ownerName != null;
        boolean hasGroup = groupName != null;
        boolean hasMode = mode != null;
        boolean hasLimit = limit != null;
        boolean hasMaxRelativeExpiry = maxRelativeExpiry != null;
        int flags = (hasOwner ? 1 : 0) | (hasGroup ? 2 : 0) | (hasMode ? 4 : 0) | (hasLimit ? 8 : 0) | (hasMaxRelativeExpiry ? 16 : 0);
        FSImageSerialization.writeInt(flags, out);
        if (hasOwner) {
            FSImageSerialization.writeString(ownerName, out);
        }
        if (hasGroup) {
            FSImageSerialization.writeString(groupName, out);
        }
        if (hasMode) {
            mode.write(out);
        }
        if (hasLimit) {
            FSImageSerialization.writeLong(limit, out);
        }
        if (hasMaxRelativeExpiry) {
            FSImageSerialization.writeLong(maxRelativeExpiry, out);
        }
    }

    public static CachePoolInfo readCachePoolInfo(DataInput in) throws IOException {
        String poolName = FSImageSerialization.readString(in);
        CachePoolInfo info = new CachePoolInfo(poolName);
        int flags = FSImageSerialization.readInt(in);
        if ((flags & 1) != 0) {
            info.setOwnerName(FSImageSerialization.readString(in));
        }
        if ((flags & 2) != 0) {
            info.setGroupName(FSImageSerialization.readString(in));
        }
        if ((flags & 4) != 0) {
            info.setMode(FsPermission.read(in));
        }
        if ((flags & 8) != 0) {
            info.setLimit(FSImageSerialization.readLong(in));
        }
        if ((flags & 0x10) != 0) {
            info.setMaxRelativeExpiryMs(FSImageSerialization.readLong(in));
        }
        if ((flags & 0xFFFFFFE0) != 0) {
            throw new IOException("Unknown flag in CachePoolInfo: " + flags);
        }
        return info;
    }

    public static void writeCachePoolInfo(ContentHandler contentHandler, CachePoolInfo info) throws SAXException {
        XMLUtils.addSaxString(contentHandler, "POOLNAME", info.getPoolName());
        String ownerName = info.getOwnerName();
        String groupName = info.getGroupName();
        Long limit = info.getLimit();
        FsPermission mode = info.getMode();
        Long maxRelativeExpiry = info.getMaxRelativeExpiryMs();
        if (ownerName != null) {
            XMLUtils.addSaxString(contentHandler, "OWNERNAME", ownerName);
        }
        if (groupName != null) {
            XMLUtils.addSaxString(contentHandler, "GROUPNAME", groupName);
        }
        if (mode != null) {
            FSEditLogOp.fsPermissionToXml(contentHandler, mode);
        }
        if (limit != null) {
            XMLUtils.addSaxString(contentHandler, "LIMIT", Long.toString(limit));
        }
        if (maxRelativeExpiry != null) {
            XMLUtils.addSaxString(contentHandler, "MAXRELATIVEEXPIRY", Long.toString(maxRelativeExpiry));
        }
    }

    public static CachePoolInfo readCachePoolInfo(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        String poolName = st.getValue("POOLNAME");
        CachePoolInfo info = new CachePoolInfo(poolName);
        if (st.hasChildren("OWNERNAME")) {
            info.setOwnerName(st.getValue("OWNERNAME"));
        }
        if (st.hasChildren("GROUPNAME")) {
            info.setGroupName(st.getValue("GROUPNAME"));
        }
        if (st.hasChildren("MODE")) {
            info.setMode(FSEditLogOp.fsPermissionFromXml(st));
        }
        if (st.hasChildren("LIMIT")) {
            info.setLimit(Long.parseLong(st.getValue("LIMIT")));
        }
        if (st.hasChildren("MAXRELATIVEEXPIRY")) {
            info.setMaxRelativeExpiryMs(Long.parseLong(st.getValue("MAXRELATIVEEXPIRY")));
        }
        return info;
    }

    private static final class TLData {
        final DeprecatedUTF8 U_STR = new DeprecatedUTF8();
        final ShortWritable U_SHORT = new ShortWritable();
        final IntWritable U_INT = new IntWritable();
        final LongWritable U_LONG = new LongWritable();
        final FsPermission FILE_PERM = new FsPermission(0);
        final BooleanWritable U_BOOLEAN = new BooleanWritable();

        private TLData() {
        }
    }
}

