/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.hadoop.file.HadoopCodecFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public abstract class AvroOutputFormatBase<K, V>
extends FileOutputFormat<K, V> {
    protected static CodecFactory getCompressionCodec(TaskAttemptContext context) {
        if (FileOutputFormat.getCompressOutput(context)) {
            int deflateLevel = context.getConfiguration().getInt("avro.mapred.deflate.level", -1);
            int xzLevel = context.getConfiguration().getInt("avro.mapred.xz.level", 6);
            String outputCodec = context.getConfiguration().get("avro.output.codec");
            if (outputCodec == null) {
                String compressionCodec = context.getConfiguration().get("mapred.output.compression.codec");
                String avroCodecName = HadoopCodecFactory.getAvroCodecName(compressionCodec);
                if (avroCodecName != null) {
                    context.getConfiguration().set("avro.output.codec", avroCodecName);
                    return HadoopCodecFactory.fromHadoopString(compressionCodec);
                }
                return CodecFactory.deflateCodec(deflateLevel);
            }
            if ("deflate".equals(outputCodec)) {
                return CodecFactory.deflateCodec(deflateLevel);
            }
            if ("xz".equals(outputCodec)) {
                return CodecFactory.xzCodec(xzLevel);
            }
            return CodecFactory.fromString(outputCodec);
        }
        return CodecFactory.nullCodec();
    }

    protected OutputStream getAvroFileOutputStream(TaskAttemptContext context) throws IOException {
        Path path = new Path(((FileOutputCommitter)this.getOutputCommitter(context)).getWorkPath(), AvroOutputFormatBase.getUniqueFile(context, context.getConfiguration().get("avro.mo.config.namedOutput", "part"), ".avro"));
        return path.getFileSystem(context.getConfiguration()).create(path);
    }

    protected static int getSyncInterval(TaskAttemptContext context) {
        return context.getConfiguration().getInt("avro.mapred.sync.interval", 64000);
    }
}

