/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni.avro;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.reflect.ReflectData;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.trevni.ColumnFileMetaData;
import org.apache.trevni.avro.AvroColumnWriter;

public class AvroTrevniOutputFormat<T>
extends FileOutputFormat<AvroWrapper<T>, NullWritable> {
    public static final String EXT = ".trv";
    public static final String META_PREFIX = "trevni.meta.";

    public static void setMeta(JobConf job, String key, String value) {
        job.set(META_PREFIX + key, value);
    }

    @Override
    public RecordWriter<AvroWrapper<T>, NullWritable> getRecordWriter(FileSystem ignore, JobConf job, String name, Progressable prog) throws IOException {
        boolean isMapOnly = job.getNumReduceTasks() == 0;
        final Schema schema = isMapOnly ? AvroJob.getMapOutputSchema(job) : AvroJob.getOutputSchema(job);
        final ColumnFileMetaData meta = AvroTrevniOutputFormat.filterMetadata(job);
        final Path dir = FileOutputFormat.getTaskOutputPath(job, name);
        final FileSystem fs = dir.getFileSystem(job);
        if (!fs.mkdirs(dir)) {
            throw new IOException("Failed to create directory: " + dir);
        }
        final long blockSize = fs.getDefaultBlockSize(dir);
        return new RecordWriter<AvroWrapper<T>, NullWritable>(){
            private int part = 0;
            private AvroColumnWriter<T> writer;
            {
                this.writer = new AvroColumnWriter(schema2, columnFileMetaData, ReflectData.get());
            }

            private void flush() throws IOException {
                Throwable throwable = null;
                Object var2_3 = null;
                try (FSDataOutputStream out = fs.create(new Path(dir, "part-" + this.part++ + AvroTrevniOutputFormat.EXT));){
                    this.writer.writeTo(out);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.writer = new AvroColumnWriter(schema, meta, ReflectData.get());
            }

            @Override
            public void write(AvroWrapper<T> wrapper, NullWritable ignore) throws IOException {
                this.writer.write(wrapper.datum());
                if (this.writer.sizeEstimate() >= blockSize) {
                    this.flush();
                }
            }

            @Override
            public void close(Reporter reporter) throws IOException {
                this.flush();
            }
        };
    }

    static ColumnFileMetaData filterMetadata(JobConf job) {
        ColumnFileMetaData meta = new ColumnFileMetaData();
        for (Map.Entry<String, String> e : job) {
            if (!e.getKey().startsWith(META_PREFIX)) continue;
            meta.put(e.getKey().substring(META_PREFIX.length()), e.getValue().getBytes(StandardCharsets.UTF_8));
        }
        return meta;
    }
}

