/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Inject;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.ConfEntryInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.ConfInfo;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class ConfBlock
extends HtmlBlock {
    final AppContext appContext;

    @Inject
    ConfBlock(AppContext appctx) {
        this.appContext = appctx;
    }

    @Override
    protected void render(HtmlBlock.Block html) {
        String jid = this.$("job.id");
        if (jid.isEmpty()) {
            ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{"Sorry, can't do anything without a JobID."})))._();
            return;
        }
        JobId jobID = MRApps.toJobID(jid);
        Job job = this.appContext.getJob(jobID);
        if (job == null) {
            ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{"Sorry, ", jid, " not found."})))._();
            return;
        }
        Path confPath = job.getConfFile();
        try {
            ConfInfo info = new ConfInfo(job);
            ((HamletImpl.EImp)((Object)((Hamlet.DIV)html.div()).h3(confPath.toString())))._();
            HamletSpec.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)((HamletImpl.EImp)((Object)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.THEAD)((Hamlet.TABLE)html.table("#conf")).thead()).tr()).th(".ui-state-default", "key")).th(".ui-state-default", "value")).th(".ui-state-default", "source chain")))._())._()).tbody();
            for (ConfEntryInfo entry : info.getProperties()) {
                StringBuffer buffer = new StringBuffer();
                String[] sources = entry.getSource();
                boolean first = true;
                for (int i = sources.length - 2; i >= 0; --i) {
                    if (!first) {
                        buffer.append(" \u2b05 ");
                    }
                    first = false;
                    buffer.append(sources[i]);
                }
                ((HamletImpl.EImp)((Object)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TBODY)tbody).tr()).td(entry.getName())).td(entry.getValue())).td(buffer.toString())))._();
            }
            ((Hamlet.TABLE)((Hamlet.TFOOT)((Hamlet.TR)((Hamlet.TH)((HamletImpl.EImp)((Object)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((HamletImpl.EImp)((Object)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((HamletImpl.EImp)((Object)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.TH)((Hamlet.TR)((Hamlet.TFOOT)((Hamlet.TABLE)((HamletImpl.EImp)((Object)tbody))._()).tfoot()).tr()).th()).input("search_init")).$type(HamletSpec.InputType.text)).$name("key")).$value("key")))._())._()).th()).input("search_init")).$type(HamletSpec.InputType.text)).$name("value")).$value("value")))._())._()).th()).input("search_init")).$type(HamletSpec.InputType.text)).$name("source chain")).$value("source chain")))._())._())._())._())._();
        }
        catch (IOException e) {
            LOG.error("Error while reading " + confPath, e);
            ((Hamlet.P)html.p())._(new Object[]{"Sorry got an error while reading conf file. ", confPath});
        }
    }
}

