/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import org.apache.trevni.ArrayColumnOutputBuffer;
import org.apache.trevni.ColumnFileMetaData;
import org.apache.trevni.ColumnMetaData;
import org.apache.trevni.ColumnOutputBuffer;
import org.apache.trevni.OutputBuffer;
import org.apache.trevni.TrevniRuntimeException;

public class ColumnFileWriter {
    static final byte[] MAGIC_0;
    static final byte[] MAGIC_1;
    static final byte[] MAGIC;
    private ColumnFileMetaData metaData;
    private ColumnOutputBuffer[] columns;
    private long rowCount;
    private int columnCount;
    private long size;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 84;
        byArray[1] = 114;
        byArray[2] = 118;
        MAGIC_0 = byArray;
        MAGIC_1 = new byte[]{84, 114, 118, 1};
        MAGIC = new byte[]{84, 114, 118, 2};
    }

    public ColumnFileWriter(ColumnFileMetaData fileMeta, ColumnMetaData ... columnMeta) throws IOException {
        this.checkColumns(columnMeta);
        this.metaData = fileMeta;
        this.columnCount = columnMeta.length;
        this.columns = new ColumnOutputBuffer[this.columnCount];
        int i = 0;
        while (i < this.columnCount) {
            ColumnMetaData c = columnMeta[i];
            c.setDefaults(this.metaData);
            this.columns[i] = c.isArray() ? new ArrayColumnOutputBuffer(this, c) : new ColumnOutputBuffer(this, c);
            this.size += 65536L;
            ++i;
        }
    }

    private void checkColumns(ColumnMetaData[] columnMeta) {
        HashSet<String> seen = new HashSet<String>();
        ColumnMetaData[] columnMetaDataArray = columnMeta;
        int n = columnMeta.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnMetaData c = columnMetaDataArray[n2];
            String name = c.getName();
            if (seen.contains(name)) {
                throw new TrevniRuntimeException("Duplicate column name: " + name);
            }
            ColumnMetaData parent = c.getParent();
            if (parent != null && !seen.contains(parent.getName())) {
                throw new TrevniRuntimeException("Parent must precede child: " + name);
            }
            seen.add(name);
            ++n2;
        }
    }

    void incrementSize(int n) {
        this.size += (long)n;
    }

    public long sizeEstimate() {
        return this.size;
    }

    public ColumnFileMetaData getMetaData() {
        return this.metaData;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void writeRow(Object ... row) throws IOException {
        this.startRow();
        int column = 0;
        while (column < this.columnCount) {
            this.writeValue(row[column], column);
            ++column;
        }
        this.endRow();
    }

    public void startRow() throws IOException {
        int column = 0;
        while (column < this.columnCount) {
            this.columns[column].startRow();
            ++column;
        }
    }

    public void writeLength(int length, int column) throws IOException {
        this.columns[column].writeLength(length);
    }

    public void writeValue(Object value, int column) throws IOException {
        this.columns[column].writeValue(value);
    }

    public void endRow() throws IOException {
        int column = 0;
        while (column < this.columnCount) {
            this.columns[column].endRow();
            ++column;
        }
        ++this.rowCount;
    }

    public void writeTo(File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream out = new FileOutputStream(file);){
            this.writeTo(out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        this.writeHeader(out);
        int column = 0;
        while (column < this.columnCount) {
            this.columns[column].writeTo(out);
            ++column;
        }
    }

    private void writeHeader(OutputStream out) throws IOException {
        OutputBuffer header = new OutputBuffer();
        header.write(MAGIC);
        header.writeFixed64(this.rowCount);
        header.writeFixed32(this.columnCount);
        this.metaData.write(header);
        ColumnOutputBuffer[] columnOutputBufferArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnOutputBuffer column = columnOutputBufferArray[n2];
            column.getMeta().write(header);
            ++n2;
        }
        long[] lArray = this.computeStarts(header.size());
        int n3 = lArray.length;
        n = 0;
        while (n < n3) {
            long start = lArray[n];
            header.writeFixed64(start);
            ++n;
        }
        header.writeTo(out);
    }

    private long[] computeStarts(long start) throws IOException {
        long[] result = new long[this.columnCount];
        start += (long)(this.columnCount * 8);
        int column = 0;
        while (column < this.columnCount) {
            result[column] = start;
            start += this.columns[column].size();
            ++column;
        }
        return result;
    }
}

