/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import com.google.inject.Inject;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.ContainerNotFoundException;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class AppBlock
extends HtmlBlock {
    private static final Log LOG = LogFactory.getLog(AppBlock.class);
    protected ApplicationBaseProtocol appBaseProt;
    protected Configuration conf;
    protected ApplicationId appID = null;

    @Inject
    protected AppBlock(ApplicationBaseProtocol appBaseProt, View.ViewContext ctx, Configuration conf) {
        super(ctx);
        this.appBaseProt = appBaseProt;
        this.conf = conf;
    }

    @Override
    protected void render(HtmlBlock.Block html) {
        Collection<ApplicationAttemptReport> attempts;
        ApplicationReport appReport;
        String webUiType = this.$("web.ui.type");
        String aid = this.$("app.id");
        if (aid.isEmpty()) {
            this.puts("Bad request: requires Application ID");
            return;
        }
        try {
            this.appID = Apps.toAppID(aid);
        }
        catch (Exception e) {
            this.puts("Invalid Application ID: " + aid);
            return;
        }
        UserGroupInformation callerUGI = this.getCallerUGI();
        try {
            final GetApplicationReportRequest request = GetApplicationReportRequest.newInstance(this.appID);
            appReport = callerUGI == null ? this.appBaseProt.getApplicationReport(request).getApplicationReport() : callerUGI.doAs(new PrivilegedExceptionAction<ApplicationReport>(){

                @Override
                public ApplicationReport run() throws Exception {
                    return AppBlock.this.appBaseProt.getApplicationReport(request).getApplicationReport();
                }
            });
        }
        catch (Exception e) {
            String message = "Failed to read the application " + this.appID + ".";
            LOG.error(message, e);
            ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{message})))._();
            return;
        }
        if (appReport == null) {
            this.puts("Application not found: " + aid);
            return;
        }
        AppInfo app = new AppInfo(appReport);
        this.setTitle(StringHelper.join("Application ", aid));
        if (webUiType != null && webUiType.equals("ResourceManager") && this.conf.getBoolean("yarn.resourcemanager.webapp.ui-actions.enabled", true)) {
            ((Hamlet.DIV)((HamletImpl.EImp)((Object)((Hamlet.BUTTON)((Hamlet.BUTTON)((Hamlet.DIV)html.div()).button()).$onclick("confirmAction()")).b("Kill Application")))._())._();
            StringBuilder script = new StringBuilder();
            script.append("function confirmAction() {").append(" b = confirm(\"Are you sure?\");").append(" if (b == true) {").append(" $.ajax({").append(" type: 'PUT',").append(" url: '/ws/v1/cluster/apps/").append(aid).append("/state',").append(" contentType: 'application/json',").append(" data: '{\"state\":\"KILLED\"}',").append(" dataType: 'json'").append(" }).done(function(data){").append(" setTimeout(function(){").append(" location.href = '/cluster/app/").append(aid).append("';").append(" }, 1000);").append(" }).fail(function(data){").append(" console.log(data);").append(" });").append(" }").append("}");
            ((HamletImpl.EImp)((Object)((Hamlet.SCRIPT)((Hamlet.SCRIPT)html.script()).$type("text/javascript"))._(new Object[]{script.toString()})))._();
        }
        String schedulerPath = WebAppUtils.getResolvedRMWebAppURLWithScheme(this.conf) + "/cluster/scheduler?openQueues=" + app.getQueue();
        this.info("Application Overview")._("User:", schedulerPath, app.getUser())._("Name:", app.getName())._("Application Type:", app.getType())._("Application Tags:", app.getApplicationTags() == null ? "" : app.getApplicationTags())._("YarnApplicationState:", app.getAppState() == null ? "N/A" : this.clarifyAppState(app.getAppState()))._("Queue:", schedulerPath, app.getQueue())._("FinalStatus Reported by AM:", this.clairfyAppFinalStatus(app.getFinalAppStatus()))._("Started:", Times.format(app.getStartedTime()))._("Elapsed:", StringUtils.formatTime(Times.elapsed(app.getStartedTime(), app.getFinishedTime())))._("Tracking URL:", app.getTrackingUrl() == null || app.getTrackingUrl().equals("N/A") ? null : this.root_url(app.getTrackingUrl()), app.getTrackingUrl() == null || app.getTrackingUrl().equals("N/A") ? "Unassigned" : (app.getAppState() == YarnApplicationState.FINISHED || app.getAppState() == YarnApplicationState.FAILED || app.getAppState() == YarnApplicationState.KILLED ? "History" : "ApplicationMaster"))._("Diagnostics:", app.getDiagnosticsInfo() == null ? "" : app.getDiagnosticsInfo());
        try {
            final GetApplicationAttemptsRequest request = GetApplicationAttemptsRequest.newInstance(this.appID);
            attempts = callerUGI == null ? this.appBaseProt.getApplicationAttempts(request).getApplicationAttemptList() : callerUGI.doAs(new PrivilegedExceptionAction<Collection<ApplicationAttemptReport>>(){

                @Override
                public Collection<ApplicationAttemptReport> run() throws Exception {
                    return AppBlock.this.appBaseProt.getApplicationAttempts(request).getApplicationAttemptList();
                }
            });
        }
        catch (Exception e) {
            String message = "Failed to read the attempts of the application " + this.appID + ".";
            LOG.error(message, e);
            ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{message})))._();
            return;
        }
        this.createApplicationMetricsTable(html);
        html._(InfoBlock.class);
        this.generateApplicationTable(html, callerUGI, attempts);
    }

    protected void generateApplicationTable(HtmlBlock.Block html, UserGroupInformation callerUGI, Collection<ApplicationAttemptReport> attempts) {
        HamletSpec.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)((HamletImpl.EImp)((Object)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.THEAD)((Hamlet.TABLE)html.table("#attempts")).thead()).tr()).th(".id", "Attempt ID")).th(".started", "Started")).th(".node", "Node")).th(".logs", "Logs")))._())._()).tbody();
        StringBuilder attemptsTableData = new StringBuilder("[\n");
        for (ApplicationAttemptReport appAttemptReport : attempts) {
            ContainerReport containerReport;
            AppAttemptInfo appAttempt = new AppAttemptInfo(appAttemptReport);
            try {
                final GetContainerReportRequest request = GetContainerReportRequest.newInstance(appAttemptReport.getAMContainerId());
                containerReport = callerUGI == null ? this.appBaseProt.getContainerReport(request).getContainerReport() : callerUGI.doAs(new PrivilegedExceptionAction<ContainerReport>(){

                    @Override
                    public ContainerReport run() throws Exception {
                        ContainerReport report = null;
                        if (request.getContainerId() != null) {
                            try {
                                report = AppBlock.this.appBaseProt.getContainerReport(request).getContainerReport();
                            }
                            catch (ContainerNotFoundException ex) {
                                LOG.warn(ex.getMessage());
                            }
                        }
                        return report;
                    }
                });
            }
            catch (Exception e) {
                String message = "Failed to read the AM container of the application attempt " + appAttemptReport.getApplicationAttemptId() + ".";
                LOG.error(message, e);
                ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{message})))._();
                return;
            }
            long startTime = 0L;
            String logsLink = null;
            String nodeLink = null;
            if (containerReport != null) {
                ContainerInfo container = new ContainerInfo(containerReport);
                startTime = container.getStartedTime();
                logsLink = containerReport.getLogUrl();
                nodeLink = containerReport.getNodeHttpAddress();
            }
            attemptsTableData.append("[\"<a href='").append(this.url("appattempt", appAttempt.getAppAttemptId())).append("'>").append(appAttempt.getAppAttemptId()).append("</a>\",\"").append(startTime).append("\",\"<a ").append(nodeLink == null ? "#" : "href='" + nodeLink).append("'>").append(nodeLink == null ? "N/A" : StringEscapeUtils.escapeJavaScript(StringEscapeUtils.escapeHtml(nodeLink))).append("</a>\",\"<a ").append(logsLink == null ? "#" : "href='" + logsLink).append("'>").append(logsLink == null ? "N/A" : "Logs").append("</a>\"],\n");
        }
        if (attemptsTableData.charAt(attemptsTableData.length() - 2) == ',') {
            attemptsTableData.delete(attemptsTableData.length() - 2, attemptsTableData.length() - 1);
        }
        attemptsTableData.append("]");
        ((HamletImpl.EImp)((Object)((Hamlet.SCRIPT)((Hamlet.SCRIPT)html.script()).$type("text/javascript"))._(new Object[]{"var attemptsTableData=" + attemptsTableData})))._();
        ((Hamlet.TABLE)((HamletImpl.EImp)((Object)tbody))._())._();
    }

    private String clarifyAppState(YarnApplicationState state) {
        String ret = state.toString();
        switch (state) {
            case NEW: {
                return ret + ": waiting for application to be initialized";
            }
            case NEW_SAVING: {
                return ret + ": waiting for application to be persisted in state-store.";
            }
            case SUBMITTED: {
                return ret + ": waiting for application to be accepted by scheduler.";
            }
            case ACCEPTED: {
                return ret + ": waiting for AM container to be allocated, launched and" + " register with RM.";
            }
            case RUNNING: {
                return ret + ": AM has registered with RM and started running.";
            }
        }
        return ret;
    }

    private String clairfyAppFinalStatus(FinalApplicationStatus status) {
        if (status == FinalApplicationStatus.UNDEFINED) {
            return "Application has not completed yet.";
        }
        return status.toString();
    }

    protected void createApplicationMetricsTable(HtmlBlock.Block html) {
    }
}

