/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FileOutputCommitter
extends OutputCommitter {
    private static final Log LOG = LogFactory.getLog(FileOutputCommitter.class);
    public static final String PENDING_DIR_NAME = "_temporary";
    @Deprecated
    protected static final String TEMP_DIR_NAME = "_temporary";
    public static final String SUCCEEDED_FILE_NAME = "_SUCCESS";
    public static final String SUCCESSFUL_JOB_OUTPUT_DIR_MARKER = "mapreduce.fileoutputcommitter.marksuccessfuljobs";
    public static final String FILEOUTPUTCOMMITTER_ALGORITHM_VERSION = "mapreduce.fileoutputcommitter.algorithm.version";
    public static final int FILEOUTPUTCOMMITTER_ALGORITHM_VERSION_DEFAULT = 1;
    public static final String FILEOUTPUTCOMMITTER_FAILURE_ATTEMPTS = "mapreduce.fileoutputcommitter.failures.attempts";
    public static final int FILEOUTPUTCOMMITTER_FAILURE_ATTEMPTS_DEFAULT = 1;
    private Path outputPath = null;
    private Path workPath = null;
    private final int algorithmVersion;

    public FileOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        this(outputPath, (JobContext)context);
        if (outputPath != null) {
            this.workPath = FileOutputCommitter.getTaskAttemptPath(context, outputPath);
        }
    }

    @InterfaceAudience.Private
    public FileOutputCommitter(Path outputPath, JobContext context) throws IOException {
        Configuration conf = context.getConfiguration();
        this.algorithmVersion = conf.getInt(FILEOUTPUTCOMMITTER_ALGORITHM_VERSION, 1);
        LOG.info("File Output Committer Algorithm version is " + this.algorithmVersion);
        if (this.algorithmVersion != 1 && this.algorithmVersion != 2) {
            throw new IOException("Only 1 or 2 algorithm version is supported");
        }
        if (outputPath != null) {
            FileSystem fs = outputPath.getFileSystem(context.getConfiguration());
            this.outputPath = fs.makeQualified(outputPath);
        }
    }

    private Path getOutputPath() {
        return this.outputPath;
    }

    private boolean hasOutputPath() {
        return this.outputPath != null;
    }

    private Path getPendingJobAttemptsPath() {
        return FileOutputCommitter.getPendingJobAttemptsPath(this.getOutputPath());
    }

    private static Path getPendingJobAttemptsPath(Path out) {
        return new Path(out, "_temporary");
    }

    private static int getAppAttemptId(JobContext context) {
        return context.getConfiguration().getInt("mapreduce.job.application.attempt.id", 0);
    }

    public Path getJobAttemptPath(JobContext context) {
        return FileOutputCommitter.getJobAttemptPath(context, this.getOutputPath());
    }

    public static Path getJobAttemptPath(JobContext context, Path out) {
        return FileOutputCommitter.getJobAttemptPath(FileOutputCommitter.getAppAttemptId(context), out);
    }

    protected Path getJobAttemptPath(int appAttemptId) {
        return FileOutputCommitter.getJobAttemptPath(appAttemptId, this.getOutputPath());
    }

    private static Path getJobAttemptPath(int appAttemptId, Path out) {
        return new Path(FileOutputCommitter.getPendingJobAttemptsPath(out), String.valueOf(appAttemptId));
    }

    private Path getPendingTaskAttemptsPath(JobContext context) {
        return FileOutputCommitter.getPendingTaskAttemptsPath(context, this.getOutputPath());
    }

    private static Path getPendingTaskAttemptsPath(JobContext context, Path out) {
        return new Path(FileOutputCommitter.getJobAttemptPath(context, out), "_temporary");
    }

    public Path getTaskAttemptPath(TaskAttemptContext context) {
        return new Path(this.getPendingTaskAttemptsPath(context), String.valueOf(context.getTaskAttemptID()));
    }

    public static Path getTaskAttemptPath(TaskAttemptContext context, Path out) {
        return new Path(FileOutputCommitter.getPendingTaskAttemptsPath(context, out), String.valueOf(context.getTaskAttemptID()));
    }

    public Path getCommittedTaskPath(TaskAttemptContext context) {
        return this.getCommittedTaskPath(FileOutputCommitter.getAppAttemptId(context), context);
    }

    public static Path getCommittedTaskPath(TaskAttemptContext context, Path out) {
        return FileOutputCommitter.getCommittedTaskPath(FileOutputCommitter.getAppAttemptId(context), context, out);
    }

    protected Path getCommittedTaskPath(int appAttemptId, TaskAttemptContext context) {
        return new Path(this.getJobAttemptPath(appAttemptId), String.valueOf(context.getTaskAttemptID().getTaskID()));
    }

    private static Path getCommittedTaskPath(int appAttemptId, TaskAttemptContext context, Path out) {
        return new Path(FileOutputCommitter.getJobAttemptPath(appAttemptId, out), String.valueOf(context.getTaskAttemptID().getTaskID()));
    }

    private FileStatus[] getAllCommittedTaskPaths(JobContext context) throws IOException {
        Path jobAttemptPath = this.getJobAttemptPath(context);
        FileSystem fs = jobAttemptPath.getFileSystem(context.getConfiguration());
        return fs.listStatus(jobAttemptPath, (PathFilter)new CommittedTaskFilter());
    }

    public Path getWorkPath() throws IOException {
        return this.workPath;
    }

    @Override
    public void setupJob(JobContext context) throws IOException {
        if (this.hasOutputPath()) {
            Path jobAttemptPath = this.getJobAttemptPath(context);
            FileSystem fs = jobAttemptPath.getFileSystem(context.getConfiguration());
            if (!fs.mkdirs(jobAttemptPath)) {
                LOG.error("Mkdirs failed to create " + jobAttemptPath);
            }
        } else {
            LOG.warn("Output Path is null in setupJob()");
        }
    }

    @Override
    public void commitJob(JobContext context) throws IOException {
        int maxAttemptsOnFailure = this.isCommitJobRepeatable(context) ? context.getConfiguration().getInt(FILEOUTPUTCOMMITTER_FAILURE_ATTEMPTS, 1) : 1;
        int attempt = 0;
        boolean jobCommitNotFinished = true;
        while (jobCommitNotFinished) {
            try {
                this.commitJobInternal(context);
                jobCommitNotFinished = false;
            }
            catch (Exception e) {
                if (++attempt >= maxAttemptsOnFailure) {
                    throw e;
                }
                LOG.warn("Exception get thrown in job commit, retry (" + attempt + ") time.", e);
            }
        }
    }

    @VisibleForTesting
    protected void commitJobInternal(JobContext context) throws IOException {
        if (this.hasOutputPath()) {
            Path finalOutput = this.getOutputPath();
            FileSystem fs = finalOutput.getFileSystem(context.getConfiguration());
            if (this.algorithmVersion == 1) {
                for (FileStatus stat : this.getAllCommittedTaskPaths(context)) {
                    this.mergePaths(fs, stat, finalOutput);
                }
            }
            this.cleanupJob(context);
            if (context.getConfiguration().getBoolean(SUCCESSFUL_JOB_OUTPUT_DIR_MARKER, true)) {
                Path markerPath = new Path(this.outputPath, SUCCEEDED_FILE_NAME);
                if (this.isCommitJobRepeatable(context)) {
                    fs.create(markerPath, true).close();
                } else {
                    fs.create(markerPath).close();
                }
            }
        } else {
            LOG.warn("Output Path is null in commitJob()");
        }
    }

    private void mergePaths(FileSystem fs, FileStatus from, Path to) throws IOException {
        FileStatus toStat;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Merging data from " + from + " to " + to);
        }
        try {
            toStat = fs.getFileStatus(to);
        }
        catch (FileNotFoundException fnfe) {
            toStat = null;
        }
        if (from.isFile()) {
            if (toStat != null && !fs.delete(to, true)) {
                throw new IOException("Failed to delete " + to);
            }
            if (!fs.rename(from.getPath(), to)) {
                throw new IOException("Failed to rename " + from + " to " + to);
            }
        } else if (from.isDirectory()) {
            if (toStat != null) {
                if (!toStat.isDirectory()) {
                    if (!fs.delete(to, true)) {
                        throw new IOException("Failed to delete " + to);
                    }
                    this.renameOrMerge(fs, from, to);
                } else {
                    for (FileStatus subFrom : fs.listStatus(from.getPath())) {
                        Path subTo = new Path(to, subFrom.getPath().getName());
                        this.mergePaths(fs, subFrom, subTo);
                    }
                }
            } else {
                this.renameOrMerge(fs, from, to);
            }
        }
    }

    private void renameOrMerge(FileSystem fs, FileStatus from, Path to) throws IOException {
        if (this.algorithmVersion == 1) {
            if (!fs.rename(from.getPath(), to)) {
                throw new IOException("Failed to rename " + from + " to " + to);
            }
        } else {
            fs.mkdirs(to);
            for (FileStatus subFrom : fs.listStatus(from.getPath())) {
                Path subTo = new Path(to, subFrom.getPath().getName());
                this.mergePaths(fs, subFrom, subTo);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    public void cleanupJob(JobContext context) throws IOException {
        if (this.hasOutputPath()) {
            Path pendingJobAttemptsPath = this.getPendingJobAttemptsPath();
            FileSystem fs = pendingJobAttemptsPath.getFileSystem(context.getConfiguration());
            try {
                fs.delete(pendingJobAttemptsPath, true);
                return;
            }
            catch (FileNotFoundException e) {
                if (this.isCommitJobRepeatable(context)) return;
                throw e;
            }
        } else {
            LOG.warn("Output Path is null in cleanupJob()");
        }
    }

    @Override
    public void abortJob(JobContext context, JobStatus.State state) throws IOException {
        this.cleanupJob(context);
    }

    @Override
    public void setupTask(TaskAttemptContext context) throws IOException {
    }

    @Override
    public void commitTask(TaskAttemptContext context) throws IOException {
        this.commitTask(context, null);
    }

    @InterfaceAudience.Private
    public void commitTask(TaskAttemptContext context, Path taskAttemptPath) throws IOException {
        TaskAttemptID attemptId = context.getTaskAttemptID();
        if (this.hasOutputPath()) {
            FileStatus taskAttemptDirStatus;
            context.progress();
            if (taskAttemptPath == null) {
                taskAttemptPath = this.getTaskAttemptPath(context);
            }
            FileSystem fs = taskAttemptPath.getFileSystem(context.getConfiguration());
            try {
                taskAttemptDirStatus = fs.getFileStatus(taskAttemptPath);
            }
            catch (FileNotFoundException e) {
                taskAttemptDirStatus = null;
            }
            if (taskAttemptDirStatus != null) {
                if (this.algorithmVersion == 1) {
                    Path committedTaskPath = this.getCommittedTaskPath(context);
                    if (fs.exists(committedTaskPath) && !fs.delete(committedTaskPath, true)) {
                        throw new IOException("Could not delete " + committedTaskPath);
                    }
                    if (!fs.rename(taskAttemptPath, committedTaskPath)) {
                        throw new IOException("Could not rename " + taskAttemptPath + " to " + committedTaskPath);
                    }
                    LOG.info("Saved output of task '" + attemptId + "' to " + committedTaskPath);
                } else {
                    this.mergePaths(fs, taskAttemptDirStatus, this.outputPath);
                    LOG.info("Saved output of task '" + attemptId + "' to " + this.outputPath);
                }
            } else {
                LOG.warn("No Output found for " + attemptId);
            }
        } else {
            LOG.warn("Output Path is null in commitTask()");
        }
    }

    @Override
    public void abortTask(TaskAttemptContext context) throws IOException {
        this.abortTask(context, null);
    }

    @InterfaceAudience.Private
    public void abortTask(TaskAttemptContext context, Path taskAttemptPath) throws IOException {
        if (this.hasOutputPath()) {
            FileSystem fs;
            context.progress();
            if (taskAttemptPath == null) {
                taskAttemptPath = this.getTaskAttemptPath(context);
            }
            if (!(fs = taskAttemptPath.getFileSystem(context.getConfiguration())).delete(taskAttemptPath, true)) {
                LOG.warn("Could not delete " + taskAttemptPath);
            }
        } else {
            LOG.warn("Output Path is null in abortTask()");
        }
    }

    @Override
    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        return this.needsTaskCommit(context, null);
    }

    @InterfaceAudience.Private
    public boolean needsTaskCommit(TaskAttemptContext context, Path taskAttemptPath) throws IOException {
        if (this.hasOutputPath()) {
            if (taskAttemptPath == null) {
                taskAttemptPath = this.getTaskAttemptPath(context);
            }
            FileSystem fs = taskAttemptPath.getFileSystem(context.getConfiguration());
            return fs.exists(taskAttemptPath);
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean isRecoverySupported() {
        return true;
    }

    @Override
    public boolean isCommitJobRepeatable(JobContext context) throws IOException {
        return this.algorithmVersion == 2;
    }

    @Override
    public void recoverTask(TaskAttemptContext context) throws IOException {
        if (this.hasOutputPath()) {
            context.progress();
            TaskAttemptID attemptId = context.getTaskAttemptID();
            int previousAttempt = FileOutputCommitter.getAppAttemptId(context) - 1;
            if (previousAttempt < 0) {
                throw new IOException("Cannot recover task output for first attempt...");
            }
            Path previousCommittedTaskPath = this.getCommittedTaskPath(previousAttempt, context);
            FileSystem fs = previousCommittedTaskPath.getFileSystem(context.getConfiguration());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying to recover task from " + previousCommittedTaskPath);
            }
            if (this.algorithmVersion == 1) {
                if (fs.exists(previousCommittedTaskPath)) {
                    Path committedTaskPath = this.getCommittedTaskPath(context);
                    if (fs.exists(committedTaskPath) && !fs.delete(committedTaskPath, true)) {
                        throw new IOException("Could not delete " + committedTaskPath);
                    }
                    Path committedParent = committedTaskPath.getParent();
                    fs.mkdirs(committedParent);
                    if (!fs.rename(previousCommittedTaskPath, committedTaskPath)) {
                        throw new IOException("Could not rename " + previousCommittedTaskPath + " to " + committedTaskPath);
                    }
                } else {
                    LOG.warn(attemptId + " had no output to recover.");
                }
            } else {
                if (fs.exists(previousCommittedTaskPath)) {
                    LOG.info("Recovering task for upgrading scenario, moving files from " + previousCommittedTaskPath + " to " + this.outputPath);
                    FileStatus from = fs.getFileStatus(previousCommittedTaskPath);
                    this.mergePaths(fs, from, this.outputPath);
                }
                LOG.info("Done recovering task " + attemptId);
            }
        } else {
            LOG.warn("Output Path is null in recoverTask()");
        }
    }

    private static class CommittedTaskFilter
    implements PathFilter {
        private CommittedTaskFilter() {
        }

        @Override
        public boolean accept(Path path) {
            return !"_temporary".equals(path.getName());
        }
    }
}

