/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroInputFormat;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.AvroMapper;
import org.apache.avro.mapred.AvroMultipleInputs;
import org.apache.avro.mapred.TaggedInputSplit;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;

class DelegatingInputFormat<K, V>
implements InputFormat<K, V> {
    DelegatingInputFormat() {
    }

    @Override
    public InputSplit[] getSplits(JobConf conf, int numSplits) throws IOException {
        JobConf confCopy = new JobConf(conf);
        ArrayList<TaggedInputSplit> splits = new ArrayList<TaggedInputSplit>();
        Map<Path, Class<? extends AvroMapper>> mapperMap = AvroMultipleInputs.getMapperTypeMap(conf);
        Map<Path, Schema> schemaMap = AvroMultipleInputs.getInputSchemaMap(conf);
        HashMap schemaPaths = new HashMap();
        for (Map.Entry<Path, Schema> entry : schemaMap.entrySet()) {
            if (!schemaPaths.containsKey(entry.getValue())) {
                schemaPaths.put(entry.getValue(), new ArrayList());
                System.out.println(entry.getValue());
                System.out.println(entry.getKey());
            }
            ((List)schemaPaths.get(entry.getValue())).add(entry.getKey());
        }
        for (Map.Entry<Path, Schema> entry : schemaPaths.entrySet()) {
            Class<? extends Mapper> mapperClass;
            Schema schema = (Schema)((Object)entry.getKey());
            System.out.println(schema);
            InputFormat format = ReflectionUtils.newInstance(AvroInputFormat.class, conf);
            List paths = (List)((Object)entry.getValue());
            HashMap mapperPaths = new HashMap();
            for (Path path : paths) {
                mapperClass = mapperMap.get(path);
                if (!mapperPaths.containsKey(mapperClass)) {
                    mapperPaths.put(mapperClass, new ArrayList());
                }
                ((List)mapperPaths.get(mapperClass)).add(path);
            }
            for (Map.Entry entry2 : mapperPaths.entrySet()) {
                InputSplit[] pathSplits;
                paths = (List)entry2.getValue();
                mapperClass = (Class<? extends Mapper>)entry2.getKey();
                if (mapperClass == null) {
                    mapperClass = conf.getMapperClass();
                }
                FileInputFormat.setInputPaths(confCopy, paths.toArray(new Path[0]));
                for (InputSplit pathSplit : pathSplits = format.getSplits(confCopy, numSplits)) {
                    splits.add(new TaggedInputSplit(pathSplit, conf, format.getClass(), mapperClass, schema));
                }
            }
        }
        return splits.toArray(new InputSplit[0]);
    }

    @Override
    public RecordReader<K, V> getRecordReader(InputSplit split, JobConf conf, Reporter reporter) throws IOException {
        TaggedInputSplit taggedInputSplit = (TaggedInputSplit)split;
        Schema schema = taggedInputSplit.getSchema();
        AvroJob.setInputSchema(conf, schema);
        InputFormat inputFormat = ReflectionUtils.newInstance(taggedInputSplit.getInputFormatClass(), conf);
        return inputFormat.getRecordReader(taggedInputSplit.getInputSplit(), conf, reporter);
    }
}

