/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */
package org.apache.avro.ipc.trace;

@SuppressWarnings("all")
/** * A Span is our basic unit of tracing. It tracks the critical points
 * of a single RPC call and records other call meta-data. It also
 * allows arbitrary string annotations. Both the client and server create
 * Span objects, each of which is populated with half of the relevant event
 * data. They share a span ID, which allows us to merge them into one complete
 * span later on. */
public interface AvroTrace {
  public static final org.apache.avro.Protocol PROTOCOL = org.apache.avro.Protocol.parse("{\"protocol\":\"AvroTrace\",\"namespace\":\"org.apache.avro.ipc.trace\",\"doc\":\"* A Span is our basic unit of tracing. It tracks the critical points\\n * of a single RPC call and records other call meta-data. It also\\n * allows arbitrary string annotations. Both the client and server create\\n * Span objects, each of which is populated with half of the relevant event\\n * data. They share a span ID, which allows us to merge them into one complete\\n * span later on.\",\"types\":[{\"type\":\"enum\",\"name\":\"SpanEvent\",\"symbols\":[\"SERVER_RECV\",\"SERVER_SEND\",\"CLIENT_RECV\",\"CLIENT_SEND\"]},{\"type\":\"fixed\",\"name\":\"ID\",\"size\":8},{\"type\":\"record\",\"name\":\"TimestampedEvent\",\"fields\":[{\"name\":\"timeStamp\",\"type\":\"long\"},{\"name\":\"event\",\"type\":[\"SpanEvent\",{\"type\":\"string\",\"avro.java.string\":\"String\"}]}]},{\"type\":\"record\",\"name\":\"Span\",\"doc\":\"* An individual span is the basic unit of testing.\\n   * The record is used by both \\\\\\\"client\\\\\\\" and \\\\\\\"server\\\\\\\".\",\"fields\":[{\"name\":\"traceID\",\"type\":\"ID\"},{\"name\":\"spanID\",\"type\":\"ID\"},{\"name\":\"parentSpanID\",\"type\":[\"ID\",\"null\"]},{\"name\":\"messageName\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"requestPayloadSize\",\"type\":\"long\"},{\"name\":\"responsePayloadSize\",\"type\":\"long\"},{\"name\":\"requestorHostname\",\"type\":[{\"type\":\"string\",\"avro.java.string\":\"String\"},\"null\"]},{\"name\":\"responderHostname\",\"type\":[{\"type\":\"string\",\"avro.java.string\":\"String\"},\"null\"]},{\"name\":\"events\",\"type\":{\"type\":\"array\",\"items\":\"TimestampedEvent\"}},{\"name\":\"complete\",\"type\":\"boolean\"}]}],\"messages\":{\"getAllSpans\":{\"doc\":\"* Get all spans stored on this host.\",\"request\":[],\"response\":{\"type\":\"array\",\"items\":\"Span\"}},\"getSpansInRange\":{\"doc\":\"* Get spans occuring between start and end. Each is a unix timestamp\\n   * in nanosecond units (for consistency with TimestampedEvent).\",\"request\":[{\"name\":\"start\",\"type\":\"long\"},{\"name\":\"end\",\"type\":\"long\"}],\"response\":{\"type\":\"array\",\"items\":\"Span\"}}}}");
  /** * Get all spans stored on this host. */
  java.util.List<org.apache.avro.ipc.trace.Span> getAllSpans() throws org.apache.avro.AvroRemoteException;
  /** * Get spans occuring between start and end. Each is a unix timestamp
   * in nanosecond units (for consistency with TimestampedEvent). */
  java.util.List<org.apache.avro.ipc.trace.Span> getSpansInRange(long start, long end) throws org.apache.avro.AvroRemoteException;

  @SuppressWarnings("all")
  /** * A Span is our basic unit of tracing. It tracks the critical points
 * of a single RPC call and records other call meta-data. It also
 * allows arbitrary string annotations. Both the client and server create
 * Span objects, each of which is populated with half of the relevant event
 * data. They share a span ID, which allows us to merge them into one complete
 * span later on. */
  public interface Callback extends AvroTrace {
    public static final org.apache.avro.Protocol PROTOCOL = org.apache.avro.ipc.trace.AvroTrace.PROTOCOL;
    /** * Get all spans stored on this host. */
    void getAllSpans(org.apache.avro.ipc.Callback<java.util.List<org.apache.avro.ipc.trace.Span>> callback) throws java.io.IOException;
    /** * Get spans occuring between start and end. Each is a unix timestamp
   * in nanosecond units (for consistency with TimestampedEvent). */
    void getSpansInRange(long start, long end, org.apache.avro.ipc.Callback<java.util.List<org.apache.avro.ipc.trace.Span>> callback) throws java.io.IOException;
  }
}