/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.AtlasException;
import org.apache.atlas.RequestContextV1;
import org.apache.atlas.metrics.Metrics;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.typesystem.ITypedReferenceableInstance;
import org.apache.atlas.typesystem.persistence.Id;
import org.apache.atlas.typesystem.types.ClassType;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RequestContext {
    private static final Logger LOG = LoggerFactory.getLogger(RequestContext.class);
    private static final ThreadLocal<RequestContext> CURRENT_CONTEXT = new ThreadLocal();
    private Set<String> createdEntityIds = new LinkedHashSet<String>();
    private Set<String> updatedEntityIds = new LinkedHashSet<String>();
    private Set<String> deletedEntityIds = new LinkedHashSet<String>();
    private List<ITypedReferenceableInstance> deletedEntities = new ArrayList<ITypedReferenceableInstance>();
    private Map<String, ITypedReferenceableInstance> entityCacheV1 = new HashMap<String, ITypedReferenceableInstance>();
    private Map<String, AtlasEntity.AtlasEntityWithExtInfo> entityCacheV2 = new HashMap<String, AtlasEntity.AtlasEntityWithExtInfo>();
    private String user;
    private long requestTime;
    private TypeSystem typeSystem = TypeSystem.getInstance();
    private Metrics metrics = new Metrics();

    private RequestContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static RequestContext get() {
        if (CURRENT_CONTEXT.get() == null) {
            Class<RequestContext> clazz = RequestContext.class;
            // MONITORENTER : org.apache.atlas.RequestContext.class
            if (CURRENT_CONTEXT.get() == null) {
                RequestContext.createContext();
            }
            // MONITOREXIT : clazz
        }
        RequestContextV1.get();
        return CURRENT_CONTEXT.get();
    }

    public static RequestContext createContext() {
        RequestContext context = new RequestContext();
        context.requestTime = System.currentTimeMillis();
        CURRENT_CONTEXT.set(context);
        return context;
    }

    public void cache(ITypedReferenceableInstance instance) {
        this.entityCacheV1.put(instance.getId()._getId(), instance);
    }

    public void cache(AtlasEntity.AtlasEntityWithExtInfo entity) {
        if (entity != null && entity.getEntity() != null && entity.getEntity().getGuid() != null) {
            this.entityCacheV2.put(entity.getEntity().getGuid(), entity);
        }
    }

    public ITypedReferenceableInstance getInstanceV1(String guid) {
        return this.entityCacheV1.get(guid);
    }

    public AtlasEntity.AtlasEntityWithExtInfo getInstanceV2(String guid) {
        return this.entityCacheV2.get(guid);
    }

    public static void clear() {
        RequestContext instance = CURRENT_CONTEXT.get();
        if (instance != null) {
            if (instance.entityCacheV1 != null) {
                instance.entityCacheV1.clear();
            }
            if (instance.entityCacheV2 != null) {
                instance.entityCacheV2.clear();
            }
        }
        CURRENT_CONTEXT.remove();
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
        RequestContextV1.get().setUser(user);
    }

    public void recordEntityCreate(Collection<String> createdEntityIds) {
        this.createdEntityIds.addAll(createdEntityIds);
    }

    public void recordEntityUpdate(Collection<String> updatedEntityIds) {
        this.updatedEntityIds.addAll(updatedEntityIds);
    }

    public void recordEntityUpdate(String entityId) {
        this.updatedEntityIds.add(entityId);
    }

    public void recordEntityDelete(String entityId, String typeName) throws AtlasException {
        ClassType type = (ClassType)this.typeSystem.getDataType(ClassType.class, typeName);
        ITypedReferenceableInstance entity = type.createInstance(new Id(entityId, 0, typeName), new String[0]);
        if (this.deletedEntityIds.add(entityId)) {
            this.deletedEntities.add(entity);
        }
    }

    public List<String> getCreatedEntityIds() {
        return new ArrayList<String>(this.createdEntityIds);
    }

    public List<String> getUpdatedEntityIds() {
        return new ArrayList<String>(this.updatedEntityIds);
    }

    public List<String> getDeletedEntityIds() {
        return new ArrayList<String>(this.deletedEntityIds);
    }

    public List<ITypedReferenceableInstance> getDeletedEntities() {
        return this.deletedEntities;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public boolean isDeletedEntity(String entityGuid) {
        return this.deletedEntityIds.contains(entityGuid);
    }

    public static Metrics getMetrics() {
        return RequestContext.get().metrics;
    }
}

