/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.dataflow.LSMIndexUtil;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionManager;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.common.transactions.ITxnIdFactory;
import org.apache.asterix.common.transactions.TransactionOptions;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.CachingTxnIdFactory;
import org.apache.asterix.metadata.api.ExtensionMetadataDataset;
import org.apache.asterix.metadata.api.ExtensionMetadataDatasetId;
import org.apache.asterix.metadata.api.IExtensionMetadataEntity;
import org.apache.asterix.metadata.api.IExtensionMetadataSearchKey;
import org.apache.asterix.metadata.api.IMetadataEntityTupleTranslator;
import org.apache.asterix.metadata.api.IMetadataExtension;
import org.apache.asterix.metadata.api.IMetadataIndex;
import org.apache.asterix.metadata.api.IMetadataNode;
import org.apache.asterix.metadata.api.IValueExtractor;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.entities.Library;
import org.apache.asterix.metadata.entities.Node;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.metadata.entitytupletranslators.CompactionPolicyTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.DatasetTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.DatasourceAdapterTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.DatatypeTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.DataverseTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.ExternalFileTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.FeedConnectionTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.FeedPolicyTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.FeedTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.FunctionTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.IndexTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.LibraryTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.MetadataTupleTranslatorProvider;
import org.apache.asterix.metadata.entitytupletranslators.NodeGroupTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.NodeTupleTranslator;
import org.apache.asterix.metadata.valueextractors.MetadataEntityValueExtractor;
import org.apache.asterix.metadata.valueextractors.TupleCopyValueExtractor;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractComplexType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.transaction.management.opcallbacks.AbstractIndexModificationOperationCallback;
import org.apache.asterix.transaction.management.opcallbacks.SecondaryIndexModificationOperationCallback;
import org.apache.asterix.transaction.management.opcallbacks.UpsertOperationCallback;
import org.apache.asterix.transaction.management.service.transaction.DatasetIdFactory;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.impls.IndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public class MetadataNode
implements IMetadataNode {
    private static final long serialVersionUID = 1L;
    private IDatasetLifecycleManager datasetLifecycleManager;
    private ITransactionSubsystem transactionSubsystem;
    private int metadataStoragePartition;
    private transient CachingTxnIdFactory txnIdFactory;
    private transient MetadataTupleTranslatorProvider tupleTranslatorProvider;
    private Map<ExtensionMetadataDatasetId, ExtensionMetadataDataset<?>> extensionDatasets;
    public static final MetadataNode INSTANCE = new MetadataNode();

    private MetadataNode() {
    }

    public void initialize(INcApplicationContext runtimeContext, MetadataTupleTranslatorProvider tupleTranslatorProvider, List<IMetadataExtension> metadataExtensions, int partitionId) {
        this.tupleTranslatorProvider = tupleTranslatorProvider;
        this.transactionSubsystem = runtimeContext.getTransactionSubsystem();
        this.datasetLifecycleManager = runtimeContext.getDatasetLifecycleManager();
        this.metadataStoragePartition = partitionId;
        if (metadataExtensions != null) {
            this.extensionDatasets = new HashMap();
            for (IMetadataExtension metadataExtension : metadataExtensions) {
                for (ExtensionMetadataDataset extensionIndex : metadataExtension.getExtensionIndexes()) {
                    this.extensionDatasets.put(extensionIndex.getId(), extensionIndex);
                }
            }
        }
        this.txnIdFactory = new CachingTxnIdFactory(runtimeContext);
    }

    public int getMetadataStoragePartition() {
        return this.metadataStoragePartition;
    }

    @Override
    public void beginTransaction(TxnId transactionId) throws ACIDException, RemoteException {
        TransactionOptions options = new TransactionOptions(ITransactionManager.AtomicityLevel.ATOMIC);
        this.transactionSubsystem.getTransactionManager().beginTransaction(transactionId, options);
    }

    @Override
    public void commitTransaction(TxnId txnId) throws RemoteException, ACIDException {
        this.transactionSubsystem.getTransactionManager().commitTransaction(txnId);
    }

    @Override
    public void abortTransaction(TxnId txnId) throws RemoteException, ACIDException {
        this.transactionSubsystem.getTransactionManager().abortTransaction(txnId);
    }

    private <T> void addEntity(TxnId txnId, T entity, IMetadataEntityTupleTranslator<T> tupleTranslator, IMetadataIndex index) throws AlgebricksException {
        try {
            ITupleReference tuple = tupleTranslator.getTupleFromMetadataEntity(entity);
            this.insertTupleIntoIndex(txnId, index, tuple);
        }
        catch (ACIDException | HyracksDataException e) {
            throw new AlgebricksException(e);
        }
    }

    private <T> void upsertEntity(TxnId txnId, T entity, IMetadataEntityTupleTranslator<T> tupleTranslator, IMetadataIndex index) throws AlgebricksException {
        try {
            ITupleReference tuple = tupleTranslator.getTupleFromMetadataEntity(entity);
            this.upsertTupleIntoIndex(txnId, index, tuple);
        }
        catch (ACIDException | HyracksDataException e) {
            throw new AlgebricksException(e);
        }
    }

    private <T> void deleteEntity(TxnId txnId, T entity, IMetadataEntityTupleTranslator<T> tupleTranslator, IMetadataIndex index) throws AlgebricksException {
        try {
            ITupleReference tuple = tupleTranslator.getTupleFromMetadataEntity(entity);
            this.deleteTupleFromIndex(txnId, index, tuple);
        }
        catch (ACIDException | HyracksDataException e) {
            throw new AlgebricksException(e);
        }
    }

    private <T> List<T> getEntities(TxnId txnId, ITupleReference searchKey, IMetadataEntityTupleTranslator<T> tupleTranslator, IMetadataIndex index) throws AlgebricksException, RemoteException {
        try {
            MetadataEntityValueExtractor<T> valueExtractor = new MetadataEntityValueExtractor<T>(tupleTranslator);
            ArrayList results = new ArrayList();
            this.searchIndex(txnId, index, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public <T extends IExtensionMetadataEntity> void addEntity(TxnId txnId, T entity) throws AlgebricksException, RemoteException {
        ExtensionMetadataDataset<?> index = this.extensionDatasets.get(entity.getDatasetId());
        if (index == null) {
            throw new AlgebricksException("Metadata Extension Index: " + entity.getDatasetId() + " was not found");
        }
        IMetadataEntityTupleTranslator<?> tupleTranslator = index.getTupleTranslator();
        this.addEntity(txnId, entity, tupleTranslator, index);
    }

    @Override
    public <T extends IExtensionMetadataEntity> void upsertEntity(TxnId txnId, T entity) throws AlgebricksException, RemoteException {
        ExtensionMetadataDataset<?> index = this.extensionDatasets.get(entity.getDatasetId());
        if (index == null) {
            throw new AlgebricksException("Metadata Extension Index: " + entity.getDatasetId() + " was not found");
        }
        IMetadataEntityTupleTranslator<?> tupleTranslator = index.getTupleTranslator();
        this.upsertEntity(txnId, entity, tupleTranslator, index);
    }

    @Override
    public <T extends IExtensionMetadataEntity> void deleteEntity(TxnId txnId, T entity) throws AlgebricksException, RemoteException {
        ExtensionMetadataDataset<?> index = this.extensionDatasets.get(entity.getDatasetId());
        if (index == null) {
            throw new AlgebricksException("Metadata Extension Index: " + entity.getDatasetId() + " was not found");
        }
        IMetadataEntityTupleTranslator<?> tupleTranslator = index.getTupleTranslator();
        this.deleteEntity(txnId, entity, tupleTranslator, index);
    }

    @Override
    public <T extends IExtensionMetadataEntity> List<T> getEntities(TxnId txnId, IExtensionMetadataSearchKey searchKey) throws AlgebricksException, RemoteException {
        ExtensionMetadataDataset<?> index = this.extensionDatasets.get(searchKey.getDatasetId());
        if (index == null) {
            throw new AlgebricksException("Metadata Extension Index: " + searchKey.getDatasetId() + " was not found");
        }
        IMetadataEntityTupleTranslator<?> tupleTranslator = index.getTupleTranslator();
        return this.getEntities(txnId, searchKey.getSearchKey(), tupleTranslator, index);
    }

    @Override
    public void addDataverse(TxnId txnId, Dataverse dataverse) throws AlgebricksException, RemoteException {
        try {
            DataverseTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataverseTupleTranslator(true);
            ITupleReference tuple = tupleReaderWriter.getTupleFromMetadataEntity(dataverse);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.DATAVERSE_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 33) {
                throw new AlgebricksException("A dataverse with this name " + dataverse.getDataverseName() + " already exists.", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addDataset(TxnId txnId, Dataset dataset) throws AlgebricksException, RemoteException {
        try {
            DatasetTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDatasetTupleTranslator(true);
            ITupleReference datasetTuple = tupleReaderWriter.getTupleFromMetadataEntity(dataset);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.DATASET_DATASET, datasetTuple);
            if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                InternalDatasetDetails id = (InternalDatasetDetails)dataset.getDatasetDetails();
                Index primaryIndex = new Index(dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName(), DatasetConfig.IndexType.BTREE, id.getPrimaryKey(), id.getKeySourceIndicator(), id.getPrimaryKeyType(), false, false, true, dataset.getPendingOp());
                this.addIndex(txnId, primaryIndex);
            }
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 33) {
                throw new AlgebricksException("A dataset with this name " + dataset.getDatasetName() + " already exists in dataverse '" + dataset.getDataverseName() + "'.", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addIndex(TxnId txnId, Index index) throws AlgebricksException, RemoteException {
        try {
            IndexTupleTranslator tupleWriter = this.tupleTranslatorProvider.getIndexTupleTranslator(txnId, this, true);
            ITupleReference tuple = tupleWriter.getTupleFromMetadataEntity(index);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.INDEX_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 33) {
                throw new AlgebricksException("An index with name '" + index.getIndexName() + "' already exists.", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addNode(TxnId txnId, Node node) throws AlgebricksException, RemoteException {
        try {
            NodeTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getNodeTupleTranslator(true);
            ITupleReference tuple = tupleReaderWriter.getTupleFromMetadataEntity(node);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.NODE_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 33) {
                throw new AlgebricksException("A node with name '" + node.getNodeName() + "' already exists.", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void modifyNodeGroup(TxnId txnId, NodeGroup nodeGroup, AbstractIndexModificationOperationCallback.Operation modificationOp) throws AlgebricksException, RemoteException {
        try {
            NodeGroupTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getNodeGroupTupleTranslator(true);
            ITupleReference tuple = tupleReaderWriter.getTupleFromMetadataEntity(nodeGroup);
            this.modifyMetadataIndex(modificationOp, txnId, MetadataPrimaryIndexes.NODEGROUP_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 33) {
                throw new AlgebricksException("A nodegroup with name '" + nodeGroup.getNodeGroupName() + "' already exists.", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addDatatype(TxnId txnId, Datatype datatype) throws AlgebricksException, RemoteException {
        try {
            DatatypeTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataTypeTupleTranslator(txnId, this, true);
            ITupleReference tuple = tupleReaderWriter.getTupleFromMetadataEntity(datatype);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.DATATYPE_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 33) {
                throw new AlgebricksException("A datatype with name '" + datatype.getDatatypeName() + "' already exists.", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addFunction(TxnId txnId, Function function) throws AlgebricksException, RemoteException {
        try {
            FunctionTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFunctionTupleTranslator(true);
            ITupleReference functionTuple = tupleReaderWriter.getTupleFromMetadataEntity(function);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.FUNCTION_DATASET, functionTuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 33) {
                throw new AlgebricksException("A function with this name " + function.getName() + " and arity " + function.getArity() + " already exists in dataverse '" + function.getDataverseName() + "'.", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private void insertTupleIntoIndex(TxnId txnId, IMetadataIndex metadataIndex, ITupleReference tuple) throws ACIDException, HyracksDataException {
        this.modifyMetadataIndex(AbstractIndexModificationOperationCallback.Operation.INSERT, txnId, metadataIndex, tuple);
    }

    private void upsertTupleIntoIndex(TxnId txnId, IMetadataIndex metadataIndex, ITupleReference tuple) throws ACIDException, HyracksDataException {
        this.modifyMetadataIndex(AbstractIndexModificationOperationCallback.Operation.UPSERT, txnId, metadataIndex, tuple);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void modifyMetadataIndex(AbstractIndexModificationOperationCallback.Operation op, TxnId txnId, IMetadataIndex metadataIndex, ITupleReference tuple) throws ACIDException, HyracksDataException {
        String resourceName = metadataIndex.getFile().getRelativePath();
        ILSMIndex lsmIndex = (ILSMIndex)this.datasetLifecycleManager.get(resourceName);
        this.datasetLifecycleManager.open(resourceName);
        try {
            ITransactionContext txnCtx = this.transactionSubsystem.getTransactionManager().getTransactionContext(txnId);
            IModificationOperationCallback modCallback = this.createIndexModificationCallback(op, txnCtx, metadataIndex);
            IndexAccessParameters iap = new IndexAccessParameters(modCallback, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            ILSMIndexAccessor indexAccessor = lsmIndex.createAccessor((IIndexAccessParameters)iap);
            txnCtx.setWriteTxn(true);
            txnCtx.register(metadataIndex.getResourceId(), StoragePathUtil.getPartitionNumFromRelativePath((String)resourceName), lsmIndex, modCallback, metadataIndex.isPrimaryIndex());
            LSMIndexUtil.checkAndSetFirstLSN((AbstractLSMIndex)((AbstractLSMIndex)lsmIndex), (ILogManager)this.transactionSubsystem.getLogManager());
            switch (op) {
                case INSERT: {
                    indexAccessor.forceInsert(tuple);
                    return;
                }
                case DELETE: {
                    indexAccessor.forceDelete(tuple);
                    return;
                }
                case UPSERT: {
                    indexAccessor.forceUpsert(tuple);
                    return;
                }
                default: {
                    throw new IllegalStateException("Unknown operation type: " + op);
                }
            }
        }
        finally {
            this.datasetLifecycleManager.close(resourceName);
        }
    }

    private IModificationOperationCallback createIndexModificationCallback(AbstractIndexModificationOperationCallback.Operation indexOp, ITransactionContext txnCtx, IMetadataIndex metadataIndex) {
        switch (indexOp) {
            case INSERT: 
            case DELETE: {
                return new SecondaryIndexModificationOperationCallback(metadataIndex.getDatasetId(), metadataIndex.getPrimaryKeyIndexes(), txnCtx, this.transactionSubsystem.getLockManager(), this.transactionSubsystem, metadataIndex.getResourceId(), this.metadataStoragePartition, 0, indexOp);
            }
            case UPSERT: {
                return new UpsertOperationCallback(metadataIndex.getDatasetId(), metadataIndex.getPrimaryKeyIndexes(), txnCtx, this.transactionSubsystem.getLockManager(), this.transactionSubsystem, metadataIndex.getResourceId(), this.metadataStoragePartition, 0, indexOp);
            }
        }
        throw new IllegalStateException("Unknown operation type: " + indexOp);
    }

    @Override
    public void dropDataverse(TxnId txnId, String dataverseName) throws AlgebricksException, RemoteException {
        try {
            this.confirmDataverseCanBeDeleted(txnId, dataverseName);
            List<Function> dataverseFunctions = this.getDataverseFunctions(txnId, dataverseName);
            for (Function function : dataverseFunctions) {
                this.dropFunction(txnId, new FunctionSignature(dataverseName, function.getName(), function.getArity()), true);
            }
            List<Dataset> dataverseDatasets = this.getDataverseDatasets(txnId, dataverseName);
            for (int i = 0; i < dataverseDatasets.size(); ++i) {
                Dataset ds = dataverseDatasets.get(i);
                this.dropDataset(txnId, dataverseName, ds.getDatasetName(), true);
            }
            List<Datatype> dataverseDatatypes = this.getDataverseDatatypes(txnId, dataverseName);
            for (int i = 0; i < dataverseDatatypes.size(); ++i) {
                this.forceDropDatatype(txnId, dataverseName, dataverseDatatypes.get(i).getDatatypeName());
            }
            List<DatasourceAdapter> dataverseAdapters = this.getDataverseAdapters(txnId, dataverseName);
            for (DatasourceAdapter adapter : dataverseAdapters) {
                this.dropAdapter(txnId, dataverseName, adapter.getAdapterIdentifier().getName());
            }
            List<Feed> dataverseFeeds = this.getDataverseFeeds(txnId, dataverseName);
            for (int i = 0; i < dataverseFeeds.size(); ++i) {
                Feed feed = dataverseFeeds.get(i);
                List<FeedConnection> feedConnections = this.getFeedConnections(txnId, dataverseName, feed.getFeedName());
                for (FeedConnection feedConnection : feedConnections) {
                    this.dropFeedConnection(txnId, dataverseName, feed.getFeedName(), feedConnection.getDatasetName());
                }
                this.dropFeed(txnId, dataverseName, feed.getFeedName());
            }
            List<FeedPolicyEntity> feedPolicies = this.getDataversePolicies(txnId, dataverseName);
            if (feedPolicies != null && feedPolicies.size() > 0) {
                for (FeedPolicyEntity feedPolicy : feedPolicies) {
                    this.dropFeedPolicy(txnId, dataverseName, feedPolicy.getPolicyName());
                }
            }
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName);
            ITupleReference tuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.DATAVERSE_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.DATAVERSE_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 37) {
                throw new AlgebricksException("Cannot drop dataverse '" + dataverseName + "' because it doesn't exist.", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropDataset(TxnId txnId, String dataverseName, String datasetName) throws AlgebricksException, RemoteException {
        this.dropDataset(txnId, dataverseName, datasetName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropDataset(TxnId txnId, String dataverseName, String datasetName, boolean force) throws AlgebricksException, RemoteException {
        Dataset dataset;
        if (!force) {
            this.confirmDatasetCanBeDeleted(txnId, dataverseName, datasetName);
        }
        if ((dataset = this.getDataset(txnId, dataverseName, datasetName)) == null) {
            throw new AlgebricksException("Cannot drop dataset '" + datasetName + "' because it doesn't exist.");
        }
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datasetName);
            ITupleReference datasetTuple = null;
            try {
                List<ExternalFile> datasetFiles;
                datasetTuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.DATASET_DATASET, searchKey);
                List<Index> datasetIndexes = this.getDatasetIndexes(txnId, dataverseName, datasetName);
                if (datasetIndexes != null) {
                    for (Index index : datasetIndexes) {
                        this.dropIndex(txnId, dataverseName, datasetName, index.getIndexName());
                    }
                }
                if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL && (datasetFiles = this.getExternalFiles(txnId, dataset)) != null && datasetFiles.size() > 0) {
                    for (ExternalFile file : datasetFiles) {
                        this.dropExternalFile(txnId, dataverseName, file.getDatasetName(), file.getFileNumber());
                    }
                }
            }
            catch (HyracksDataException hde) {
                if (!hde.getComponent().equals("HYR") || hde.getErrorCode() != 37) {
                    throw new AlgebricksException((Throwable)hde);
                }
            }
            finally {
                this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.DATASET_DATASET, datasetTuple);
            }
        }
        catch (ACIDException | HyracksDataException e) {
            throw new AlgebricksException(e);
        }
    }

    @Override
    public void dropIndex(TxnId txnId, String dataverseName, String datasetName, String indexName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datasetName, indexName);
            ITupleReference tuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.INDEX_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.INDEX_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 37) {
                throw new AlgebricksException("Cannot drop index '" + datasetName + "." + indexName + "' because it doesn't exist.", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public boolean dropNodegroup(TxnId txnId, String nodeGroupName, boolean failSilently) throws AlgebricksException, RemoteException {
        List<String> datasetNames = this.getDatasetNamesPartitionedOnThisNodeGroup(txnId, nodeGroupName);
        if (!datasetNames.isEmpty()) {
            if (failSilently) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Nodegroup '" + nodeGroupName + "' cannot be dropped; it was used for partitioning these datasets:");
            for (int i = 0; i < datasetNames.size(); ++i) {
                sb.append("\n" + (i + 1) + "- " + datasetNames.get(i) + ".");
            }
            throw new AlgebricksException(sb.toString());
        }
        try {
            ITupleReference searchKey = MetadataNode.createTuple(nodeGroupName);
            ITupleReference tuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.NODEGROUP_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.NODEGROUP_DATASET, tuple);
            return true;
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 37) {
                throw new AlgebricksException("Cannot drop nodegroup '" + nodeGroupName + "' because it doesn't exist", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropDatatype(TxnId txnId, String dataverseName, String datatypeName) throws AlgebricksException, RemoteException {
        this.confirmDatatypeIsUnused(txnId, dataverseName, datatypeName);
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datatypeName);
            ITupleReference tuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.DATATYPE_DATASET, searchKey);
            List<String> nestedTypes = this.getNestedComplexDatatypeNamesForThisDatatype(txnId, dataverseName, datatypeName);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.DATATYPE_DATASET, tuple);
            for (String nestedType : nestedTypes) {
                Datatype dt = this.getDatatype(txnId, dataverseName, nestedType);
                if (dt == null || !dt.getIsAnonymous()) continue;
                this.dropDatatype(txnId, dataverseName, dt.getDatatypeName());
            }
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 37) {
                throw new AlgebricksException("Cannot drop type '" + datatypeName + "' because it doesn't exist", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private void forceDropDatatype(TxnId txnId, String dataverseName, String datatypeName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datatypeName);
            ITupleReference tuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.DATATYPE_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.DATATYPE_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 37) {
                throw new AlgebricksException("Cannot drop type '" + datatypeName + "' because it doesn't exist", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private void deleteTupleFromIndex(TxnId txnId, IMetadataIndex metadataIndex, ITupleReference tuple) throws ACIDException, HyracksDataException {
        this.modifyMetadataIndex(AbstractIndexModificationOperationCallback.Operation.DELETE, txnId, metadataIndex, tuple);
    }

    @Override
    public List<Dataverse> getDataverses(TxnId txnId) throws AlgebricksException, RemoteException {
        try {
            DataverseTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataverseTupleTranslator(false);
            MetadataEntityValueExtractor<Dataverse> valueExtractor = new MetadataEntityValueExtractor<Dataverse>(tupleReaderWriter);
            ArrayList<Dataverse> results = new ArrayList<Dataverse>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATAVERSE_DATASET, null, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public Dataverse getDataverse(TxnId txnId, String dataverseName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName);
            DataverseTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataverseTupleTranslator(false);
            MetadataEntityValueExtractor<Dataverse> valueExtractor = new MetadataEntityValueExtractor<Dataverse>(tupleReaderWriter);
            ArrayList results = new ArrayList();
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATAVERSE_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Dataverse)results.get(0);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public List<Dataset> getDataverseDatasets(TxnId txnId, String dataverseName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName);
            DatasetTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDatasetTupleTranslator(false);
            MetadataEntityValueExtractor<Dataset> valueExtractor = new MetadataEntityValueExtractor<Dataset>(tupleReaderWriter);
            ArrayList<Dataset> results = new ArrayList<Dataset>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATASET_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public List<Feed> getDataverseFeeds(TxnId txnId, String dataverseName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName);
            FeedTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedTupleTranslator(false);
            MetadataEntityValueExtractor<Feed> valueExtractor = new MetadataEntityValueExtractor<Feed>(tupleReaderWriter);
            ArrayList<Feed> results = new ArrayList<Feed>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.FEED_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public List<Library> getDataverseLibraries(TxnId txnId, String dataverseName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName);
            LibraryTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getLibraryTupleTranslator(false);
            MetadataEntityValueExtractor<Library> valueExtractor = new MetadataEntityValueExtractor<Library>(tupleReaderWriter);
            ArrayList<Library> results = new ArrayList<Library>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.LIBRARY_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private List<Datatype> getDataverseDatatypes(TxnId txnId, String dataverseName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName);
            DatatypeTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataTypeTupleTranslator(txnId, this, false);
            MetadataEntityValueExtractor<Datatype> valueExtractor = new MetadataEntityValueExtractor<Datatype>(tupleReaderWriter);
            ArrayList<Datatype> results = new ArrayList<Datatype>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATATYPE_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public Dataset getDataset(TxnId txnId, String dataverseName, String datasetName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datasetName);
            DatasetTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDatasetTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<Dataset> valueExtractor = new MetadataEntityValueExtractor<Dataset>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATASET_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Dataset)results.get(0);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    public List<Dataset> getAllDatasets(TxnId txnId) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = null;
            DatasetTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDatasetTupleTranslator(false);
            MetadataEntityValueExtractor<Dataset> valueExtractor = new MetadataEntityValueExtractor<Dataset>(tupleReaderWriter);
            ArrayList<Dataset> results = new ArrayList<Dataset>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATASET_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    public List<Function> getAllFunctions(TxnId txnId) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = null;
            FunctionTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFunctionTupleTranslator(false);
            MetadataEntityValueExtractor<Function> valueExtractor = new MetadataEntityValueExtractor<Function>(tupleReaderWriter);
            ArrayList<Function> results = new ArrayList<Function>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.FUNCTION_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    public List<Datatype> getAllDatatypes(TxnId txnId) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = null;
            DatatypeTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataTypeTupleTranslator(txnId, this, false);
            MetadataEntityValueExtractor<Datatype> valueExtractor = new MetadataEntityValueExtractor<Datatype>(tupleReaderWriter);
            ArrayList<Datatype> results = new ArrayList<Datatype>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATATYPE_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private void confirmDataverseCanBeDeleted(TxnId txnId, String dataverseName) throws AlgebricksException, RemoteException {
        List<Dataset> datasets = this.getAllDatasets(txnId);
        for (Dataset set : datasets) {
            if (set.getDataverseName().equals(dataverseName) || !set.getItemTypeDataverseName().equals(dataverseName)) continue;
            throw new AlgebricksException("Cannot drop dataverse. Type " + dataverseName + "." + set.getItemTypeName() + " used by dataset " + set.getDataverseName() + "." + set.getDatasetName());
        }
        List<Function> functions = this.getAllFunctions(txnId);
        for (Function function : functions) {
            if (function.getDataverseName().equals(dataverseName)) continue;
            for (List<String> datasetDependency : function.getDependencies().get(0)) {
                if (!datasetDependency.get(0).equals(dataverseName)) continue;
                throw new AlgebricksException("Cannot drop dataverse. Function " + function.getDataverseName() + "." + function.getName() + "@" + function.getArity() + " depends on dataset " + datasetDependency.get(0) + "." + datasetDependency.get(1));
            }
            for (List<String> functionDependency : function.getDependencies().get(1)) {
                if (!functionDependency.get(0).equals(dataverseName)) continue;
                throw new AlgebricksException("Cannot drop dataverse. Function " + function.getDataverseName() + "." + function.getName() + "@" + function.getArity() + " depends on function " + functionDependency.get(0) + "." + functionDependency.get(1) + "@" + functionDependency.get(2));
            }
        }
    }

    private void confirmFunctionCanBeDeleted(TxnId txnId, FunctionSignature signature) throws AlgebricksException, RemoteException {
        List<Function> functions = this.getAllFunctions(txnId);
        for (Function function : functions) {
            for (List<String> functionalDependency : function.getDependencies().get(1)) {
                if (!functionalDependency.get(0).equals(signature.getNamespace()) || !functionalDependency.get(1).equals(signature.getName()) || !functionalDependency.get(2).equals(Integer.toString(signature.getArity()))) continue;
                throw new AlgebricksException("Cannot drop function " + signature + " being used by function " + function.getDataverseName() + "." + function.getName() + "@" + function.getArity());
            }
        }
    }

    private void confirmDatasetCanBeDeleted(TxnId txnId, String dataverseName, String datasetName) throws AlgebricksException, RemoteException {
        List<Function> functions = this.getAllFunctions(txnId);
        for (Function function : functions) {
            for (List<String> datasetDependency : function.getDependencies().get(0)) {
                if (!datasetDependency.get(0).equals(dataverseName) || !datasetDependency.get(1).equals(datasetName)) continue;
                throw new AlgebricksException("Cannot drop dataset " + dataverseName + "." + datasetName + " being used by function " + function.getDataverseName() + "." + function.getName() + "@" + function.getArity());
            }
        }
    }

    private void confirmDatatypeIsUnused(TxnId txnId, String dataverseName, String datatypeName) throws AlgebricksException, RemoteException {
        this.confirmDatatypeIsUnusedByDatatypes(txnId, dataverseName, datatypeName);
        this.confirmDatatypeIsUnusedByDatasets(txnId, dataverseName, datatypeName);
    }

    private void confirmDatatypeIsUnusedByDatasets(TxnId txnId, String dataverseName, String datatypeName) throws AlgebricksException, RemoteException {
        List<Dataset> datasets = this.getAllDatasets(txnId);
        for (Dataset set : datasets) {
            if (!set.getItemTypeName().equals(datatypeName) || !set.getItemTypeDataverseName().equals(dataverseName)) continue;
            throw new AlgebricksException("Cannot drop type " + dataverseName + "." + datatypeName + " being used by dataset " + set.getDataverseName() + "." + set.getDatasetName());
        }
    }

    private void confirmDatatypeIsUnusedByDatatypes(TxnId txnId, String dataverseName, String datatypeName) throws AlgebricksException, RemoteException {
        Datatype dataTypeToBeDropped = this.getDatatype(txnId, dataverseName, datatypeName);
        assert (dataTypeToBeDropped != null);
        IAType typeToBeDropped = dataTypeToBeDropped.getDatatype();
        List<Datatype> datatypes = this.getAllDatatypes(txnId);
        for (Datatype dataType : datatypes) {
            AbstractComplexType recType;
            if (!dataType.getDataverseName().equals(dataverseName) || dataType.getDatatype().getTypeName().equals(datatypeName) || !(recType = (AbstractComplexType)dataType.getDatatype()).containsType(typeToBeDropped)) continue;
            throw new AlgebricksException("Cannot drop type " + dataverseName + "." + datatypeName + " being used by type " + dataverseName + "." + recType.getTypeName());
        }
    }

    private List<String> getNestedComplexDatatypeNamesForThisDatatype(TxnId txnId, String dataverseName, String datatypeName) throws AlgebricksException, RemoteException {
        ARecordType recType;
        Datatype parentType = this.getDatatype(txnId, dataverseName, datatypeName);
        List subTypes = null;
        if (parentType.getDatatype().getTypeTag() == ATypeTag.OBJECT) {
            recType = (ARecordType)parentType.getDatatype();
            subTypes = Arrays.asList(recType.getFieldTypes());
        } else if (parentType.getDatatype().getTypeTag() == ATypeTag.UNION) {
            recType = (AUnionType)parentType.getDatatype();
            subTypes = recType.getUnionList();
        }
        ArrayList<String> nestedTypes = new ArrayList<String>();
        if (subTypes != null) {
            for (IAType subType : subTypes) {
                if (subType instanceof BuiltinType) continue;
                nestedTypes.add(subType.getTypeName());
            }
        }
        return nestedTypes;
    }

    public List<String> getDatasetNamesPartitionedOnThisNodeGroup(TxnId txnId, String nodegroup) throws AlgebricksException, RemoteException {
        ArrayList<String> nodeGroupDatasets = new ArrayList<String>();
        List<Dataset> datasets = this.getAllDatasets(txnId);
        for (Dataset set : datasets) {
            if (!set.getNodeGroupName().equals(nodegroup)) continue;
            nodeGroupDatasets.add(set.getDatasetName());
        }
        return nodeGroupDatasets;
    }

    @Override
    public Index getIndex(TxnId txnId, String dataverseName, String datasetName, String indexName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datasetName, indexName);
            IndexTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getIndexTupleTranslator(txnId, this, false);
            MetadataEntityValueExtractor<Index> valueExtractor = new MetadataEntityValueExtractor<Index>(tupleReaderWriter);
            ArrayList results = new ArrayList();
            this.searchIndex(txnId, MetadataPrimaryIndexes.INDEX_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Index)results.get(0);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public List<Index> getDatasetIndexes(TxnId txnId, String dataverseName, String datasetName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datasetName);
            IndexTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getIndexTupleTranslator(txnId, this, false);
            MetadataEntityValueExtractor<Index> valueExtractor = new MetadataEntityValueExtractor<Index>(tupleReaderWriter);
            ArrayList<Index> results = new ArrayList<Index>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.INDEX_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public Datatype getDatatype(TxnId txnId, String dataverseName, String datatypeName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datatypeName);
            DatatypeTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataTypeTupleTranslator(txnId, this, false);
            MetadataEntityValueExtractor<Datatype> valueExtractor = new MetadataEntityValueExtractor<Datatype>(tupleReaderWriter);
            ArrayList results = new ArrayList();
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATATYPE_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Datatype)results.get(0);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public NodeGroup getNodeGroup(TxnId txnId, String nodeGroupName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(nodeGroupName);
            NodeGroupTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getNodeGroupTupleTranslator(false);
            MetadataEntityValueExtractor<NodeGroup> valueExtractor = new MetadataEntityValueExtractor<NodeGroup>(tupleReaderWriter);
            ArrayList results = new ArrayList();
            this.searchIndex(txnId, MetadataPrimaryIndexes.NODEGROUP_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (NodeGroup)results.get(0);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public Function getFunction(TxnId txnId, FunctionSignature functionSignature) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(functionSignature.getNamespace(), functionSignature.getName(), "" + functionSignature.getArity());
            FunctionTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFunctionTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<Function> valueExtractor = new MetadataEntityValueExtractor<Function>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.FUNCTION_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Function)results.get(0);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public List<Function> getFunctions(TxnId txnId, String dataverseName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName);
            FunctionTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFunctionTupleTranslator(false);
            ArrayList<Function> results = new ArrayList<Function>();
            MetadataEntityValueExtractor<Function> valueExtractor = new MetadataEntityValueExtractor<Function>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.FUNCTION_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropFunction(TxnId txnId, FunctionSignature functionSignature) throws AlgebricksException, RemoteException {
        this.dropFunction(txnId, functionSignature, false);
    }

    private void dropFunction(TxnId txnId, FunctionSignature functionSignature, boolean force) throws AlgebricksException, RemoteException {
        Function function;
        if (!force) {
            this.confirmFunctionCanBeDeleted(txnId, functionSignature);
        }
        if ((function = this.getFunction(txnId, functionSignature)) == null) {
            throw new AlgebricksException("Cannot drop function '" + functionSignature.toString() + "' because it doesn't exist.");
        }
        try {
            ITupleReference searchKey = MetadataNode.createTuple(functionSignature.getNamespace(), functionSignature.getName(), "" + functionSignature.getArity());
            ITupleReference functionTuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.FUNCTION_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.FUNCTION_DATASET, functionTuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 37) {
                throw new AlgebricksException("There is no function with the name " + functionSignature.getName() + " and arity " + functionSignature.getArity(), (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private ITupleReference getTupleToBeDeleted(TxnId txnId, IMetadataIndex metadataIndex, ITupleReference searchKey) throws AlgebricksException, HyracksDataException, RemoteException {
        TupleCopyValueExtractor valueExtractor = new TupleCopyValueExtractor(metadataIndex.getTypeTraits());
        ArrayList results = new ArrayList();
        this.searchIndex(txnId, metadataIndex, searchKey, valueExtractor, results);
        if (results.isEmpty()) {
            throw HyracksDataException.create((int)37, (Serializable[])new Serializable[0]);
        }
        return (ITupleReference)results.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printMetadata() {
        StringBuilder sb = new StringBuilder();
        try {
            RangePredicate rangePred = null;
            IMetadataIndex index = MetadataPrimaryIndexes.DATAVERSE_DATASET;
            String resourceName = index.getFile().toString();
            IIndex indexInstance = (IIndex)this.datasetLifecycleManager.get(resourceName);
            this.datasetLifecycleManager.open(resourceName);
            IIndexAccessor indexAccessor = indexInstance.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
            IIndexCursor rangeCursor = indexAccessor.createSearchCursor(false);
            try {
                rangePred = new RangePredicate(null, null, true, true, null, null);
                indexAccessor.search(rangeCursor, (ISearchPredicate)rangePred);
                try {
                    while (rangeCursor.hasNext()) {
                        rangeCursor.next();
                        sb.append(TupleUtils.printTuple((ITupleReference)rangeCursor.getTuple(), (ISerializerDeserializer[])new ISerializerDeserializer[]{SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING)}));
                    }
                }
                finally {
                    rangeCursor.close();
                }
                this.datasetLifecycleManager.close(resourceName);
                index = MetadataPrimaryIndexes.DATASET_DATASET;
                indexInstance = (IIndex)this.datasetLifecycleManager.get(resourceName);
                this.datasetLifecycleManager.open(resourceName);
                indexAccessor = indexInstance.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
                rangeCursor = indexAccessor.createSearchCursor(false);
                rangePred = null;
                rangePred = new RangePredicate(null, null, true, true, null, null);
                indexAccessor.search(rangeCursor, (ISearchPredicate)rangePred);
                try {
                    while (rangeCursor.hasNext()) {
                        rangeCursor.next();
                        sb.append(TupleUtils.printTuple((ITupleReference)rangeCursor.getTuple(), (ISerializerDeserializer[])new ISerializerDeserializer[]{SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING), SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING)}));
                    }
                }
                finally {
                    rangeCursor.close();
                }
                this.datasetLifecycleManager.close(resourceName);
                index = MetadataPrimaryIndexes.INDEX_DATASET;
                indexInstance = (IIndex)this.datasetLifecycleManager.get(resourceName);
                this.datasetLifecycleManager.open(resourceName);
                indexAccessor = indexInstance.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
                rangeCursor = indexAccessor.createSearchCursor(false);
                rangePred = null;
                rangePred = new RangePredicate(null, null, true, true, null, null);
                indexAccessor.search(rangeCursor, (ISearchPredicate)rangePred);
                try {
                    while (rangeCursor.hasNext()) {
                        rangeCursor.next();
                        sb.append(TupleUtils.printTuple((ITupleReference)rangeCursor.getTuple(), (ISerializerDeserializer[])new ISerializerDeserializer[]{SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING), SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING), SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING)}));
                    }
                }
                finally {
                    rangeCursor.close();
                }
            }
            finally {
                rangeCursor.destroy();
            }
            this.datasetLifecycleManager.close(resourceName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <ResultType> void searchIndex(TxnId txnId, IMetadataIndex index, ITupleReference searchKey, IValueExtractor<ResultType> valueExtractor, List<ResultType> results) throws AlgebricksException, HyracksDataException, RemoteException {
        IBinaryComparatorFactory[] comparatorFactories = index.getKeyBinaryComparatorFactory();
        if (index.getFile() == null) {
            throw new AlgebricksException("No file for Index " + index.getDataverseName() + "." + index.getIndexName());
        }
        String resourceName = index.getFile().getRelativePath();
        IIndex indexInstance = (IIndex)this.datasetLifecycleManager.get(resourceName);
        this.datasetLifecycleManager.open(resourceName);
        IIndexAccessor indexAccessor = indexInstance.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        try {
            IBinaryComparator[] searchCmps = null;
            MultiComparator searchCmp = null;
            if (searchKey != null) {
                searchCmps = new IBinaryComparator[searchKey.getFieldCount()];
                for (int i = 0; i < searchKey.getFieldCount(); ++i) {
                    searchCmps[i] = comparatorFactories[i].createBinaryComparator();
                }
                searchCmp = new MultiComparator(searchCmps);
            }
            RangePredicate rangePred = new RangePredicate(searchKey, searchKey, true, true, searchCmp, searchCmp);
            this.search(indexAccessor, rangePred, results, valueExtractor, txnId);
        }
        finally {
            indexAccessor.destroy();
        }
        this.datasetLifecycleManager.close(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <ResultType> void search(IIndexAccessor indexAccessor, RangePredicate rangePred, List<ResultType> results, IValueExtractor<ResultType> valueExtractor, TxnId txnId) throws HyracksDataException, RemoteException, AlgebricksException {
        IIndexCursor rangeCursor = indexAccessor.createSearchCursor(false);
        try {
            indexAccessor.search(rangeCursor, (ISearchPredicate)rangePred);
            try {
                while (rangeCursor.hasNext()) {
                    rangeCursor.next();
                    ResultType result = valueExtractor.getValue(txnId, rangeCursor.getTuple());
                    if (result == null) continue;
                    results.add(result);
                }
            }
            finally {
                rangeCursor.close();
            }
        }
        finally {
            rangeCursor.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeDatasetIdFactory(TxnId txnId) throws AlgebricksException, RemoteException {
        int mostRecentDatasetId;
        try {
            String resourceName = MetadataPrimaryIndexes.DATASET_DATASET.getFile().getRelativePath();
            IIndex indexInstance = (IIndex)this.datasetLifecycleManager.get(resourceName);
            this.datasetLifecycleManager.open(resourceName);
            try {
                mostRecentDatasetId = this.getMostRecentDatasetIdFromStoredDatasetIndex(indexInstance, txnId);
            }
            finally {
                this.datasetLifecycleManager.close(resourceName);
            }
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
        DatasetIdFactory.initialize((int)mostRecentDatasetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMostRecentDatasetIdFromStoredDatasetIndex(IIndex indexInstance, TxnId txnId) throws HyracksDataException, RemoteException, AlgebricksException {
        DatasetTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDatasetTupleTranslator(false);
        MetadataEntityValueExtractor<Dataset> valueExtractor = new MetadataEntityValueExtractor<Dataset>(tupleReaderWriter);
        RangePredicate rangePred = new RangePredicate(null, null, true, true, null, null);
        int mostRecentDatasetId = 100;
        IIndexAccessor indexAccessor = indexInstance.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        try {
            IIndexCursor rangeCursor = indexAccessor.createSearchCursor(false);
            try {
                indexAccessor.search(rangeCursor, (ISearchPredicate)rangePred);
                try {
                    while (rangeCursor.hasNext()) {
                        rangeCursor.next();
                        ITupleReference ref = rangeCursor.getTuple();
                        Dataset ds = (Dataset)valueExtractor.getValue(txnId, ref);
                        int datasetId = ds.getDatasetId();
                        if (mostRecentDatasetId >= datasetId) continue;
                        mostRecentDatasetId = datasetId;
                    }
                }
                finally {
                    rangeCursor.close();
                }
            }
            finally {
                rangeCursor.destroy();
            }
        }
        finally {
            indexAccessor.destroy();
        }
        return mostRecentDatasetId;
    }

    public static ITupleReference createTuple(String ... fields) {
        ISerializerDeserializer stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
        AMutableString aString = new AMutableString("");
        ArrayTupleBuilder tupleBuilder = new ArrayTupleBuilder(fields.length);
        for (String s : fields) {
            aString.setValue(s);
            try {
                stringSerde.serialize((Object)aString, tupleBuilder.getDataOutput());
            }
            catch (HyracksDataException e) {
                throw new IllegalStateException("Failed to create search tuple!!!! This should never happen", e);
            }
            tupleBuilder.addFieldEndOffset();
        }
        ArrayTupleReference tuple = new ArrayTupleReference();
        tuple.reset(tupleBuilder.getFieldEndOffsets(), tupleBuilder.getByteArray());
        return tuple;
    }

    @Override
    public List<Function> getDataverseFunctions(TxnId txnId, String dataverseName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName);
            FunctionTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFunctionTupleTranslator(false);
            MetadataEntityValueExtractor<Function> valueExtractor = new MetadataEntityValueExtractor<Function>(tupleReaderWriter);
            ArrayList<Function> results = new ArrayList<Function>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.FUNCTION_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addAdapter(TxnId txnId, DatasourceAdapter adapter) throws AlgebricksException, RemoteException {
        try {
            DatasourceAdapterTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getAdapterTupleTranslator(true);
            ITupleReference adapterTuple = tupleReaderWriter.getTupleFromMetadataEntity(adapter);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, adapterTuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 33) {
                throw new AlgebricksException("A adapter with this name " + adapter.getAdapterIdentifier().getName() + " already exists in dataverse '" + adapter.getAdapterIdentifier().getNamespace() + "'.", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropAdapter(TxnId txnId, String dataverseName, String adapterName) throws AlgebricksException, RemoteException {
        DatasourceAdapter adapter = this.getAdapter(txnId, dataverseName, adapterName);
        if (adapter == null) {
            throw new AlgebricksException("Cannot drop adapter '" + adapter + "' because it doesn't exist.");
        }
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, adapterName);
            ITupleReference datasetTuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, datasetTuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 37) {
                throw new AlgebricksException("Cannot drop adapter '" + adapterName + " since it doesn't exist", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public DatasourceAdapter getAdapter(TxnId txnId, String dataverseName, String adapterName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, adapterName);
            DatasourceAdapterTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getAdapterTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<DatasourceAdapter> valueExtractor = new MetadataEntityValueExtractor<DatasourceAdapter>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (DatasourceAdapter)results.get(0);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addCompactionPolicy(TxnId txnId, CompactionPolicy compactionPolicy) throws AlgebricksException, RemoteException {
        try {
            CompactionPolicyTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getCompactionPolicyTupleTranslator(true);
            ITupleReference compactionPolicyTuple = tupleReaderWriter.getTupleFromMetadataEntity(compactionPolicy);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.COMPACTION_POLICY_DATASET, compactionPolicyTuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 33) {
                throw new AlgebricksException("A compcation policy with this name " + compactionPolicy.getPolicyName() + " already exists in dataverse '" + compactionPolicy.getPolicyName() + "'.", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public CompactionPolicy getCompactionPolicy(TxnId txnId, String dataverse, String policyName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverse, policyName);
            CompactionPolicyTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getCompactionPolicyTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<CompactionPolicy> valueExtractor = new MetadataEntityValueExtractor<CompactionPolicy>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.COMPACTION_POLICY_DATASET, searchKey, valueExtractor, results);
            if (!results.isEmpty()) {
                return (CompactionPolicy)results.get(0);
            }
            return null;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public List<DatasourceAdapter> getDataverseAdapters(TxnId txnId, String dataverseName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName);
            DatasourceAdapterTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getAdapterTupleTranslator(false);
            MetadataEntityValueExtractor<DatasourceAdapter> valueExtractor = new MetadataEntityValueExtractor<DatasourceAdapter>(tupleReaderWriter);
            ArrayList<DatasourceAdapter> results = new ArrayList<DatasourceAdapter>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addLibrary(TxnId txnId, Library library) throws AlgebricksException, RemoteException {
        try {
            LibraryTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getLibraryTupleTranslator(true);
            ITupleReference libraryTuple = tupleReaderWriter.getTupleFromMetadataEntity(library);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.LIBRARY_DATASET, libraryTuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 33) {
                throw new AlgebricksException("A library with this name " + library.getDataverseName() + " already exists in dataverse '" + library.getDataverseName() + "'.", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropLibrary(TxnId txnId, String dataverseName, String libraryName) throws AlgebricksException, RemoteException {
        Library library = this.getLibrary(txnId, dataverseName, libraryName);
        if (library == null) {
            throw new AlgebricksException("Cannot drop library '" + library + "' because it doesn't exist.");
        }
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, libraryName);
            ITupleReference datasetTuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.LIBRARY_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.LIBRARY_DATASET, datasetTuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 37) {
                throw new AlgebricksException("Cannot drop library '" + libraryName, (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public Library getLibrary(TxnId txnId, String dataverseName, String libraryName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, libraryName);
            LibraryTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getLibraryTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<Library> valueExtractor = new MetadataEntityValueExtractor<Library>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.LIBRARY_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Library)results.get(0);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public int getMostRecentDatasetId() throws AlgebricksException, RemoteException {
        return DatasetIdFactory.getMostRecentDatasetId();
    }

    @Override
    public void addFeedPolicy(TxnId txnId, FeedPolicyEntity feedPolicy) throws AlgebricksException, RemoteException {
        try {
            FeedPolicyTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedPolicyTupleTranslator(true);
            ITupleReference feedPolicyTuple = tupleReaderWriter.getTupleFromMetadataEntity(feedPolicy);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.FEED_POLICY_DATASET, feedPolicyTuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 33) {
                throw new AlgebricksException("A feed policy with this name " + feedPolicy.getPolicyName() + " already exists in dataverse '" + feedPolicy.getPolicyName() + "'.", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public FeedPolicyEntity getFeedPolicy(TxnId txnId, String dataverse, String policyName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverse, policyName);
            FeedPolicyTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedPolicyTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<FeedPolicyEntity> valueExtractor = new MetadataEntityValueExtractor<FeedPolicyEntity>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.FEED_POLICY_DATASET, searchKey, valueExtractor, results);
            if (!results.isEmpty()) {
                return (FeedPolicyEntity)results.get(0);
            }
            return null;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addFeedConnection(TxnId txnId, FeedConnection feedConnection) throws AlgebricksException {
        try {
            FeedConnectionTupleTranslator tupleReaderWriter = new FeedConnectionTupleTranslator(true);
            ITupleReference feedConnTuple = tupleReaderWriter.getTupleFromMetadataEntity(feedConnection);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.FEED_CONNECTION_DATASET, feedConnTuple);
        }
        catch (ACIDException | HyracksDataException e) {
            throw new AlgebricksException(e);
        }
    }

    @Override
    public List<FeedConnection> getFeedConnections(TxnId txnId, String dataverseName, String feedName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, feedName);
            FeedConnectionTupleTranslator tupleReaderWriter = new FeedConnectionTupleTranslator(false);
            ArrayList<FeedConnection> results = new ArrayList<FeedConnection>();
            MetadataEntityValueExtractor<FeedConnection> valueExtractor = new MetadataEntityValueExtractor<FeedConnection>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.FEED_CONNECTION_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public FeedConnection getFeedConnection(TxnId txnId, String dataverseName, String feedName, String datasetName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, feedName, datasetName);
            FeedConnectionTupleTranslator tupleReaderWriter = new FeedConnectionTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<FeedConnection> valueExtractor = new MetadataEntityValueExtractor<FeedConnection>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.FEED_CONNECTION_DATASET, searchKey, valueExtractor, results);
            if (!results.isEmpty()) {
                return (FeedConnection)results.get(0);
            }
            return null;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropFeedConnection(TxnId txnId, String dataverseName, String feedName, String datasetName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, feedName, datasetName);
            ITupleReference tuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.FEED_CONNECTION_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.FEED_CONNECTION_DATASET, tuple);
        }
        catch (ACIDException | HyracksDataException e) {
            throw new AlgebricksException(e);
        }
    }

    @Override
    public void addFeed(TxnId txnId, Feed feed) throws AlgebricksException, RemoteException {
        try {
            FeedTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedTupleTranslator(true);
            ITupleReference feedTuple = tupleReaderWriter.getTupleFromMetadataEntity(feed);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.FEED_DATASET, feedTuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 33) {
                throw new AlgebricksException("A feed with this name " + feed.getFeedName() + " already exists in dataverse '" + feed.getDataverseName() + "'.", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public Feed getFeed(TxnId txnId, String dataverse, String feedName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverse, feedName);
            FeedTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<Feed> valueExtractor = new MetadataEntityValueExtractor<Feed>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.FEED_DATASET, searchKey, valueExtractor, results);
            if (!results.isEmpty()) {
                return (Feed)results.get(0);
            }
            return null;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public List<Feed> getFeeds(TxnId txnId, String dataverse) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverse);
            FeedTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedTupleTranslator(false);
            ArrayList<Feed> results = new ArrayList<Feed>();
            MetadataEntityValueExtractor<Feed> valueExtractor = new MetadataEntityValueExtractor<Feed>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.FEED_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropFeed(TxnId txnId, String dataverse, String feedName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverse, feedName);
            ITupleReference tuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.FEED_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.FEED_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 37) {
                throw new AlgebricksException("Cannot drop feed '" + feedName + "' because it doesn't exist", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropFeedPolicy(TxnId txnId, String dataverseName, String policyName) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, policyName);
            ITupleReference tuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.FEED_POLICY_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.FEED_POLICY_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 37) {
                throw new AlgebricksException("Unknown feed policy " + policyName, (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public List<FeedPolicyEntity> getDataversePolicies(TxnId txnId, String dataverse) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverse);
            FeedPolicyTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedPolicyTupleTranslator(false);
            MetadataEntityValueExtractor<FeedPolicyEntity> valueExtractor = new MetadataEntityValueExtractor<FeedPolicyEntity>(tupleReaderWriter);
            ArrayList<FeedPolicyEntity> results = new ArrayList<FeedPolicyEntity>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.FEED_POLICY_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addExternalFile(TxnId txnId, ExternalFile externalFile) throws AlgebricksException, RemoteException {
        try {
            ExternalFileTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getExternalFileTupleTranslator(true);
            ITupleReference externalFileTuple = tupleReaderWriter.getTupleFromMetadataEntity(externalFile);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, externalFileTuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 33) {
                throw new AlgebricksException("An externalFile with this number " + externalFile.getFileNumber() + " already exists in dataset '" + externalFile.getDatasetName() + "' in dataverse '" + externalFile.getDataverseName() + "'.", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public List<ExternalFile> getExternalFiles(TxnId txnId, Dataset dataset) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataset.getDataverseName(), dataset.getDatasetName());
            ExternalFileTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getExternalFileTupleTranslator(false);
            MetadataEntityValueExtractor<ExternalFile> valueExtractor = new MetadataEntityValueExtractor<ExternalFile>(tupleReaderWriter);
            ArrayList<ExternalFile> results = new ArrayList<ExternalFile>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropExternalFile(TxnId txnId, String dataverseName, String datasetName, int fileNumber) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = this.createExternalFileSearchTuple(dataverseName, datasetName, fileNumber);
            ITupleReference datasetTuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, datasetTuple);
        }
        catch (HyracksDataException e) {
            if (e.getComponent().equals("HYR") && e.getErrorCode() == 37) {
                throw new AlgebricksException("Couldn't drop externalFile.", (Throwable)e);
            }
            throw new AlgebricksException((Throwable)e);
        }
        catch (ACIDException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropExternalFiles(TxnId txnId, Dataset dataset) throws AlgebricksException, RemoteException {
        List<ExternalFile> files = this.getExternalFiles(txnId, dataset);
        for (int i = 0; i < files.size(); ++i) {
            this.dropExternalFile(txnId, files.get(i).getDataverseName(), files.get(i).getDatasetName(), files.get(i).getFileNumber());
        }
    }

    public ITupleReference createExternalFileSearchTuple(String dataverseName, String datasetName, int fileNumber) throws HyracksDataException {
        ISerializerDeserializer stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
        ISerializerDeserializer intSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
        AMutableString aString = new AMutableString("");
        ArrayTupleBuilder tupleBuilder = new ArrayTupleBuilder(3);
        aString.setValue(dataverseName);
        stringSerde.serialize((Object)aString, tupleBuilder.getDataOutput());
        tupleBuilder.addFieldEndOffset();
        aString.setValue(datasetName);
        stringSerde.serialize((Object)aString, tupleBuilder.getDataOutput());
        tupleBuilder.addFieldEndOffset();
        intSerde.serialize((Object)new AInt32(fileNumber), tupleBuilder.getDataOutput());
        tupleBuilder.addFieldEndOffset();
        ArrayTupleReference tuple = new ArrayTupleReference();
        tuple.reset(tupleBuilder.getFieldEndOffsets(), tupleBuilder.getByteArray());
        return tuple;
    }

    @Override
    public ExternalFile getExternalFile(TxnId txnId, String dataverseName, String datasetName, Integer fileNumber) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = this.createExternalFileSearchTuple(dataverseName, datasetName, fileNumber);
            ExternalFileTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getExternalFileTupleTranslator(false);
            MetadataEntityValueExtractor<ExternalFile> valueExtractor = new MetadataEntityValueExtractor<ExternalFile>(tupleReaderWriter);
            ArrayList results = new ArrayList();
            this.searchIndex(txnId, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (ExternalFile)results.get(0);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void updateDataset(TxnId txnId, Dataset dataset) throws AlgebricksException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataset.getDataverseName(), dataset.getDatasetName());
            ITupleReference datasetTuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.DATASET_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.DATASET_DATASET, datasetTuple);
            DatasetTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDatasetTupleTranslator(true);
            datasetTuple = tupleReaderWriter.getTupleFromMetadataEntity(dataset);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.DATASET_DATASET, datasetTuple);
        }
        catch (ACIDException | HyracksDataException e) {
            throw new AlgebricksException(e);
        }
    }

    public ITxnIdFactory getTxnIdFactory() {
        return this.txnIdFactory;
    }
}

