/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.context.AsterixVirtualBufferCacheProvider;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.external.indexing.IndexingConstants;
import org.apache.asterix.metadata.api.IResourceFactoryProvider;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.data.IBinaryComparatorFactoryProvider;
import org.apache.hyracks.algebricks.data.ITypeTraitProvider;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationSchedulerProvider;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTrackerFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCacheProvider;
import org.apache.hyracks.storage.am.lsm.rtree.dataflow.ExternalRTreeLocalResourceFactory;
import org.apache.hyracks.storage.am.lsm.rtree.dataflow.LSMRTreeWithAntiMatterLocalResourceFactory;
import org.apache.hyracks.storage.am.rtree.frames.RTreePolicyType;
import org.apache.hyracks.storage.common.IResourceFactory;
import org.apache.hyracks.storage.common.IStorageManager;

public class RTreeResourceFactoryProvider
implements IResourceFactoryProvider {
    private static final RTreePolicyType rTreePolicyType = RTreePolicyType.RTREE;
    public static final RTreeResourceFactoryProvider INSTANCE = new RTreeResourceFactoryProvider();

    private RTreeResourceFactoryProvider() {
    }

    @Override
    public IResourceFactory getResourceFactory(MetadataProvider mdProvider, Dataset dataset, Index index, ARecordType recordType, ARecordType metaType, ILSMMergePolicyFactory mergePolicyFactory, Map<String, String> mergePolicyProperties, ITypeTraits[] filterTypeTraits, IBinaryComparatorFactory[] filterCmpFactories) throws AlgebricksException {
        IBinaryComparatorFactory[] btreeCompFactories;
        int[] nArray;
        int i;
        if (index.getKeyFieldNames().size() != 1) {
            throw new CompilationException(1013, new Serializable[]{Integer.valueOf(index.getKeyFieldNames().size()), index.getIndexType(), Integer.valueOf(1)});
        }
        IAType spatialType = (IAType)Index.getNonNullableOpenFieldType((IAType)index.getKeyFieldTypes().get((int)0), index.getKeyFieldNames().get((int)0), (ARecordType)recordType).first;
        if (spatialType == null) {
            throw new CompilationException(1014, new Serializable[]{StringUtils.join((Iterable)index.getKeyFieldNames().get(0), (char)'.')});
        }
        List<List<String>> primaryKeyFields = dataset.getPrimaryKeys();
        int numPrimaryKeys = primaryKeyFields.size();
        ITypeTraits[] primaryTypeTraits = null;
        IBinaryComparatorFactory[] primaryComparatorFactories = null;
        IStorageComponentProvider storageComponentProvider = mdProvider.getStorageComponentProvider();
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            primaryTypeTraits = new ITypeTraits[numPrimaryKeys + 1 + (dataset.hasMetaPart() ? 1 : 0)];
            primaryComparatorFactories = new IBinaryComparatorFactory[numPrimaryKeys];
            List<Integer> indicators = null;
            if (dataset.hasMetaPart()) {
                indicators = ((InternalDatasetDetails)dataset.getDatasetDetails()).getKeySourceIndicator();
            }
            for (int i2 = 0; i2 < numPrimaryKeys; ++i2) {
                IAType keyType = indicators == null || indicators.get(i2) == 0 ? recordType.getSubFieldType(primaryKeyFields.get(i2)) : metaType.getSubFieldType(primaryKeyFields.get(i2));
                primaryComparatorFactories[i2] = storageComponentProvider.getComparatorFactoryProvider().getBinaryComparatorFactory((Object)keyType, true);
                primaryTypeTraits[i2] = storageComponentProvider.getTypeTraitProvider().getTypeTrait((Object)keyType);
            }
            primaryTypeTraits[numPrimaryKeys] = storageComponentProvider.getTypeTraitProvider().getTypeTrait((Object)recordType);
            if (dataset.hasMetaPart()) {
                primaryTypeTraits[numPrimaryKeys + 1] = storageComponentProvider.getTypeTraitProvider().getTypeTrait((Object)recordType);
            }
        }
        boolean isPointMBR = spatialType.getTypeTag() == ATypeTag.POINT || spatialType.getTypeTag() == ATypeTag.POINT3D;
        int numDimensions = NonTaggedFormatUtil.getNumDimensions((ATypeTag)spatialType.getTypeTag());
        int numNestedSecondaryKeyFields = numDimensions * 2;
        IBinaryComparatorFactory[] secondaryComparatorFactories = new IBinaryComparatorFactory[numNestedSecondaryKeyFields];
        IPrimitiveValueProviderFactory[] valueProviderFactories = new IPrimitiveValueProviderFactory[numNestedSecondaryKeyFields];
        ITypeTraits[] secondaryTypeTraits = new ITypeTraits[numNestedSecondaryKeyFields + numPrimaryKeys];
        IAType nestedKeyType = NonTaggedFormatUtil.getNestedSpatialType((ATypeTag)spatialType.getTypeTag());
        ATypeTag keyType = nestedKeyType.getTypeTag();
        for (i = 0; i < numNestedSecondaryKeyFields; ++i) {
            secondaryComparatorFactories[i] = storageComponentProvider.getComparatorFactoryProvider().getBinaryComparatorFactory((Object)nestedKeyType, true);
            secondaryTypeTraits[i] = storageComponentProvider.getTypeTraitProvider().getTypeTrait((Object)nestedKeyType);
            valueProviderFactories[i] = storageComponentProvider.getPrimitiveValueProviderFactory();
        }
        for (i = 0; i < numPrimaryKeys; ++i) {
            secondaryTypeTraits[numNestedSecondaryKeyFields + i] = dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL ? primaryTypeTraits[i] : IndexingConstants.getTypeTraits((int)i);
        }
        int[] rtreeFields = null;
        if (filterTypeTraits != null && filterTypeTraits.length > 0) {
            rtreeFields = new int[numNestedSecondaryKeyFields + numPrimaryKeys];
            for (int i3 = 0; i3 < rtreeFields.length; ++i3) {
                rtreeFields[i3] = i3;
            }
        }
        IStorageManager storageManager = storageComponentProvider.getStorageManager();
        ILSMOperationTrackerFactory opTrackerFactory = dataset.getIndexOperationTrackerFactory(index);
        ILSMIOOperationCallbackFactory ioOpCallbackFactory = dataset.getIoOperationCallbackFactory(index);
        IMetadataPageManagerFactory metadataPageManagerFactory = storageComponentProvider.getMetadataPageManagerFactory();
        ILSMIOOperationSchedulerProvider ioSchedulerProvider = storageComponentProvider.getIoOperationSchedulerProvider();
        ILinearizeComparatorFactory linearizeCmpFactory = MetadataProvider.proposeLinearizer(keyType, secondaryComparatorFactories.length);
        ITypeTraits[] typeTraits = RTreeResourceFactoryProvider.getTypeTraits(mdProvider, dataset, index, recordType, metaType);
        IBinaryComparatorFactory[] rtreeCmpFactories = RTreeResourceFactoryProvider.getCmpFactories(mdProvider, index, recordType, metaType);
        if (filterTypeTraits != null && filterTypeTraits.length > 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = numNestedSecondaryKeyFields + numPrimaryKeys;
        } else {
            nArray = null;
        }
        int[] secondaryFilterFields = nArray;
        IBinaryComparatorFactory[] iBinaryComparatorFactoryArray = btreeCompFactories = dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL ? IndexingConstants.getBuddyBtreeComparatorFactories() : RTreeResourceFactoryProvider.getComparatorFactoriesForDeletedKeyBTree(secondaryTypeTraits, primaryComparatorFactories, secondaryComparatorFactories);
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            AsterixVirtualBufferCacheProvider vbcProvider = new AsterixVirtualBufferCacheProvider(dataset.getDatasetId());
            return new LSMRTreeWithAntiMatterLocalResourceFactory(storageManager, typeTraits, rtreeCmpFactories, filterTypeTraits, filterCmpFactories, secondaryFilterFields, opTrackerFactory, ioOpCallbackFactory, metadataPageManagerFactory, (IVirtualBufferCacheProvider)vbcProvider, ioSchedulerProvider, mergePolicyFactory, mergePolicyProperties, true, valueProviderFactories, rTreePolicyType, linearizeCmpFactory, rtreeFields, isPointMBR, btreeCompFactories);
        }
        return new ExternalRTreeLocalResourceFactory(storageManager, typeTraits, rtreeCmpFactories, filterTypeTraits, filterCmpFactories, secondaryFilterFields, opTrackerFactory, ioOpCallbackFactory, metadataPageManagerFactory, ioSchedulerProvider, mergePolicyFactory, mergePolicyProperties, true, btreeCompFactories, valueProviderFactories, rTreePolicyType, linearizeCmpFactory, rtreeFields, new int[]{numNestedSecondaryKeyFields}, isPointMBR, mdProvider.getStorageProperties().getBloomFilterFalsePositiveRate());
    }

    private static IBinaryComparatorFactory[] getComparatorFactoriesForDeletedKeyBTree(ITypeTraits[] secondaryTypeTraits, IBinaryComparatorFactory[] primaryComparatorFactories, IBinaryComparatorFactory[] secondaryComparatorFactories) {
        int i;
        IBinaryComparatorFactory[] btreeCompFactories = new IBinaryComparatorFactory[secondaryTypeTraits.length];
        for (i = 0; i < secondaryComparatorFactories.length; ++i) {
            btreeCompFactories[i] = secondaryComparatorFactories[i];
        }
        int j = 0;
        while (i < secondaryTypeTraits.length) {
            btreeCompFactories[i] = primaryComparatorFactories[j];
            ++i;
            ++j;
        }
        return btreeCompFactories;
    }

    private static ITypeTraits[] getTypeTraits(MetadataProvider metadataProvider, Dataset dataset, Index index, ARecordType recordType, ARecordType metaType) throws AlgebricksException {
        int i;
        ITypeTraitProvider ttProvider = metadataProvider.getStorageComponentProvider().getTypeTraitProvider();
        List<List<String>> secondaryKeyFields = index.getKeyFieldNames();
        int numSecondaryKeys = secondaryKeyFields.size();
        int numPrimaryKeys = dataset.getPrimaryKeys().size();
        ITypeTraits[] primaryTypeTraits = dataset.getPrimaryTypeTraits(metadataProvider, recordType, metaType);
        if (numSecondaryKeys != 1) {
            throw new AsterixException("Cannot use " + numSecondaryKeys + " fields as a key for the R-tree index. There can be only one field as a key for the R-tree index.");
        }
        List<Integer> keySourceIndicators = index.getKeyFieldSourceIndicators();
        ARecordType sourceType = keySourceIndicators == null || keySourceIndicators.get(0) == 0 ? recordType : metaType;
        Pair<IAType, Boolean> spatialTypePair = Index.getNonNullableOpenFieldType(index.getKeyFieldTypes().get(0), secondaryKeyFields.get(0), sourceType);
        IAType spatialType = (IAType)spatialTypePair.first;
        if (spatialType == null) {
            throw new AsterixException("Could not find field " + secondaryKeyFields.get(0) + " in the schema.");
        }
        int numDimensions = NonTaggedFormatUtil.getNumDimensions((ATypeTag)spatialType.getTypeTag());
        int numNestedSecondaryKeyFields = numDimensions * 2;
        ITypeTraits[] secondaryTypeTraits = new ITypeTraits[numNestedSecondaryKeyFields + numPrimaryKeys];
        IAType nestedKeyType = NonTaggedFormatUtil.getNestedSpatialType((ATypeTag)spatialType.getTypeTag());
        for (i = 0; i < numNestedSecondaryKeyFields; ++i) {
            secondaryTypeTraits[i] = ttProvider.getTypeTrait((Object)nestedKeyType);
        }
        for (i = 0; i < numPrimaryKeys; ++i) {
            secondaryTypeTraits[numNestedSecondaryKeyFields + i] = primaryTypeTraits[i];
        }
        return secondaryTypeTraits;
    }

    private static IBinaryComparatorFactory[] getCmpFactories(MetadataProvider metadataProvider, Index index, ARecordType recordType, ARecordType metaType) throws AlgebricksException {
        IBinaryComparatorFactoryProvider cmpFactoryProvider = metadataProvider.getStorageComponentProvider().getComparatorFactoryProvider();
        List<List<String>> secondaryKeyFields = index.getKeyFieldNames();
        int numSecondaryKeys = secondaryKeyFields.size();
        if (numSecondaryKeys != 1) {
            throw new AsterixException("Cannot use " + numSecondaryKeys + " fields as a key for the R-tree index. There can be only one field as a key for the R-tree index.");
        }
        List<Integer> keySourceIndicators = index.getKeyFieldSourceIndicators();
        ARecordType sourceType = keySourceIndicators == null || keySourceIndicators.get(0) == 0 ? recordType : metaType;
        Pair<IAType, Boolean> spatialTypePair = Index.getNonNullableOpenFieldType(index.getKeyFieldTypes().get(0), secondaryKeyFields.get(0), sourceType);
        IAType spatialType = (IAType)spatialTypePair.first;
        if (spatialType == null) {
            throw new AsterixException("Could not find field " + secondaryKeyFields.get(0) + " in the schema.");
        }
        IAType nestedKeyType = NonTaggedFormatUtil.getNestedSpatialType((ATypeTag)spatialType.getTypeTag());
        int numDimensions = NonTaggedFormatUtil.getNumDimensions((ATypeTag)spatialType.getTypeTag());
        int numNestedSecondaryKeyFields = numDimensions * 2;
        IBinaryComparatorFactory[] secondaryComparatorFactories = new IBinaryComparatorFactory[numNestedSecondaryKeyFields];
        for (int i = 0; i < numNestedSecondaryKeyFields; ++i) {
            secondaryComparatorFactories[i] = cmpFactoryProvider.getBinaryComparatorFactory((Object)nestedKeyType, true);
        }
        return secondaryComparatorFactories;
    }
}

