/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class FunctionTupleTranslator
extends AbstractTupleTranslator<Function> {
    private static final long serialVersionUID = 1147594449575992161L;
    public static final int FUNCTION_DATAVERSENAME_TUPLE_FIELD_INDEX = 0;
    public static final int FUNCTION_FUNCTIONNAME_TUPLE_FIELD_INDEX = 1;
    public static final int FUNCTION_FUNCTIONARITY_TUPLE_FIELD_INDEX = 2;
    public static final int FUNCTION_PAYLOAD_TUPLE_FIELD_INDEX = 3;
    private transient OrderedListBuilder dependenciesListBuilder = new OrderedListBuilder();
    private transient OrderedListBuilder dependencyListBuilder = new OrderedListBuilder();
    private transient OrderedListBuilder dependencyNameListBuilder = new OrderedListBuilder();
    private transient AOrderedListType stringList = new AOrderedListType((IAType)BuiltinType.ASTRING, null);
    private transient AOrderedListType ListofLists = new AOrderedListType((IAType)new AOrderedListType((IAType)BuiltinType.ASTRING, null), null);
    private ISerializerDeserializer<ARecord> recordSerDes = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)MetadataRecordTypes.FUNCTION_RECORDTYPE);

    protected FunctionTupleTranslator(boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.FUNCTION_DATASET.getFieldCount());
    }

    @Override
    public Function getMetadataEntityFromTuple(ITupleReference frameTuple) throws HyracksDataException {
        byte[] serRecord = frameTuple.getFieldData(3);
        int recordStartOffset = frameTuple.getFieldStart(3);
        int recordLength = frameTuple.getFieldLength(3);
        ByteArrayInputStream stream = new ByteArrayInputStream(serRecord, recordStartOffset, recordLength);
        DataInputStream in = new DataInputStream(stream);
        ARecord functionRecord = (ARecord)this.recordSerDes.deserialize((DataInput)in);
        return this.createFunctionFromARecord(functionRecord);
    }

    private Function createFunctionFromARecord(ARecord functionRecord) {
        String dataverseName = ((AString)functionRecord.getValueByPos(0)).getStringValue();
        String functionName = ((AString)functionRecord.getValueByPos(1)).getStringValue();
        String arity = ((AString)functionRecord.getValueByPos(2)).getStringValue();
        IACursor cursor = ((AOrderedList)functionRecord.getValueByPos(3)).getCursor();
        ArrayList<String> params = new ArrayList<String>();
        while (cursor.next()) {
            params.add(((AString)cursor.get()).getStringValue());
        }
        String returnType = ((AString)functionRecord.getValueByPos(4)).getStringValue();
        String definition = ((AString)functionRecord.getValueByPos(5)).getStringValue();
        String language = ((AString)functionRecord.getValueByPos(6)).getStringValue();
        String functionKind = ((AString)functionRecord.getValueByPos(7)).getStringValue();
        IACursor dependenciesCursor = ((AOrderedList)functionRecord.getValueByPos(8)).getCursor();
        ArrayList<List<List<String>>> dependencies = new ArrayList<List<List<String>>>();
        int i = 0;
        while (dependenciesCursor.next()) {
            dependencies.add(new ArrayList());
            AOrderedList dependencyList = (AOrderedList)dependenciesCursor.get();
            IACursor qualifiedDependencyCursor = dependencyList.getCursor();
            int j = 0;
            while (qualifiedDependencyCursor.next()) {
                AOrderedList qualifiedList = (AOrderedList)qualifiedDependencyCursor.get();
                IACursor qualifiedNameCursor = qualifiedList.getCursor();
                ((List)dependencies.get(i)).add(new ArrayList());
                while (qualifiedNameCursor.next()) {
                    ((List)((List)dependencies.get(i)).get(j)).add(((AString)qualifiedNameCursor.get()).getStringValue());
                }
                ++j;
            }
            ++i;
        }
        FunctionSignature signature = new FunctionSignature(dataverseName, functionName, Integer.parseInt(arity));
        return new Function(signature, params, returnType, definition, language, functionKind, dependencies);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Function function) throws HyracksDataException, AlgebricksException {
        this.tupleBuilder.reset();
        this.aString.setValue(function.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(function.getName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(function.getArity() + "");
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.FUNCTION_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(function.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.getName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.getArity() + "");
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        listBuilder.reset((AbstractCollectionType)((AOrderedListType)MetadataRecordTypes.FUNCTION_RECORDTYPE.getFieldTypes()[3]));
        for (String param : function.getArguments()) {
            itemValue.reset();
            this.aString.setValue(param);
            this.stringSerde.serialize((Object)this.aString, itemValue.getDataOutput());
            listBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        listBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(3, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.getReturnType());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(4, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.getFunctionBody());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(5, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.getLanguage());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(6, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.getKind());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(7, (IValueReference)this.fieldValue);
        this.dependenciesListBuilder.reset((AbstractCollectionType)((AOrderedListType)MetadataRecordTypes.FUNCTION_RECORDTYPE.getFieldTypes()[8]));
        List<List<List<String>>> dependenciesList = function.getDependencies();
        for (List<List<String>> dependencies : dependenciesList) {
            this.dependencyListBuilder.reset((AbstractCollectionType)this.ListofLists);
            for (List<String> dependency : dependencies) {
                this.dependencyNameListBuilder.reset((AbstractCollectionType)this.stringList);
                for (String subName : dependency) {
                    itemValue.reset();
                    this.aString.setValue(subName);
                    this.stringSerde.serialize((Object)this.aString, itemValue.getDataOutput());
                    this.dependencyNameListBuilder.addItem((IValueReference)itemValue);
                }
                itemValue.reset();
                this.dependencyNameListBuilder.write(itemValue.getDataOutput(), true);
                this.dependencyListBuilder.addItem((IValueReference)itemValue);
            }
            itemValue.reset();
            this.dependencyListBuilder.write(itemValue.getDataOutput(), true);
            this.dependenciesListBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        this.dependenciesListBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(8, (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

