/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.util.List;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.external.indexing.IndexingConstants;
import org.apache.asterix.external.operators.ExternalScanOperatorDescriptor;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.formats.nontagged.TypeTraitProvider;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.metadata.utils.SecondaryTreeIndexOperationsHelper;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.runtime.utils.RuntimeUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.jobgen.impl.ConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.base.SinkRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.connectors.IConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.IConnectorDescriptorRegistry;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.connectors.OneToOneConnectorDescriptor;
import org.apache.hyracks.dataflow.std.sort.ExternalSortOperatorDescriptor;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.TreeIndexBulkLoadOperatorDescriptor;

public class SecondaryRTreeOperationsHelper
extends SecondaryTreeIndexOperationsHelper {
    protected IPrimitiveValueProviderFactory[] valueProviderFactories;
    protected int numNestedSecondaryKeyFields;
    protected ATypeTag keyType;
    protected int[] primaryKeyFields;
    protected int[] rtreeFields;
    protected boolean isPointMBR;
    protected RecordDescriptor secondaryRecDescForPointMBR = null;

    protected SecondaryRTreeOperationsHelper(Dataset dataset, Index index, PhysicalOptimizationConfig physOptConf, MetadataProvider metadataProvider) throws AlgebricksException {
        super(dataset, index, physOptConf, metadataProvider);
    }

    @Override
    protected int getNumSecondaryKeys() {
        return this.numNestedSecondaryKeyFields;
    }

    @Override
    protected void setSecondaryRecDescAndComparators() throws AlgebricksException {
        int i;
        List<List<String>> secondaryKeyFields = this.index.getKeyFieldNames();
        int numSecondaryKeys = secondaryKeyFields.size();
        boolean isOverridingKeyFieldTypes = this.index.isOverridingKeyFieldTypes();
        if (numSecondaryKeys != 1) {
            throw new AsterixException("Cannot use " + numSecondaryKeys + " fields as a key for the R-tree index. There can be only one field as a key for the R-tree index.");
        }
        Pair<IAType, Boolean> spatialTypePair = Index.getNonNullableOpenFieldType(this.index.getKeyFieldTypes().get(0), secondaryKeyFields.get(0), this.itemType);
        IAType spatialType = (IAType)spatialTypePair.first;
        this.anySecondaryKeyIsNullable = (Boolean)spatialTypePair.second;
        if (spatialType == null) {
            throw new AsterixException("Could not find field " + secondaryKeyFields.get(0) + " in the schema.");
        }
        this.isPointMBR = spatialType.getTypeTag() == ATypeTag.POINT || spatialType.getTypeTag() == ATypeTag.POINT3D;
        int numDimensions = NonTaggedFormatUtil.getNumDimensions((ATypeTag)spatialType.getTypeTag());
        this.numNestedSecondaryKeyFields = numDimensions * 2;
        int recordColumn = this.dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL ? this.numPrimaryKeys : 0;
        this.secondaryFieldAccessEvalFactories = this.metadataProvider.getDataFormat().createMBRFactory(this.metadataProvider.getFunctionManager(), isOverridingKeyFieldTypes ? this.enforcedItemType : this.itemType, secondaryKeyFields.get(0), recordColumn, numDimensions, this.filterFieldName, this.isPointMBR);
        this.secondaryComparatorFactories = new IBinaryComparatorFactory[this.numNestedSecondaryKeyFields];
        this.valueProviderFactories = new IPrimitiveValueProviderFactory[this.numNestedSecondaryKeyFields];
        ISerializerDeserializer[] secondaryRecFields = new ISerializerDeserializer[this.numPrimaryKeys + this.numNestedSecondaryKeyFields + this.numFilterFields];
        ISerializerDeserializer[] enforcedRecFields = new ISerializerDeserializer[1 + this.numPrimaryKeys + this.numFilterFields];
        this.secondaryTypeTraits = new ITypeTraits[this.numNestedSecondaryKeyFields + this.numPrimaryKeys];
        ITypeTraits[] enforcedTypeTraits = new ITypeTraits[1 + this.numPrimaryKeys];
        IAType nestedKeyType = NonTaggedFormatUtil.getNestedSpatialType((ATypeTag)spatialType.getTypeTag());
        this.keyType = nestedKeyType.getTypeTag();
        for (i = 0; i < this.numNestedSecondaryKeyFields; ++i) {
            ISerializerDeserializer keySerde;
            secondaryRecFields[i] = keySerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)nestedKeyType);
            this.secondaryComparatorFactories[i] = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)nestedKeyType, true);
            this.secondaryTypeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)nestedKeyType);
            this.valueProviderFactories[i] = this.metadataProvider.getStorageComponentProvider().getPrimitiveValueProviderFactory();
        }
        if (this.dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            for (i = 0; i < this.numPrimaryKeys; ++i) {
                secondaryRecFields[this.numNestedSecondaryKeyFields + i] = this.primaryRecDesc.getFields()[i];
                this.secondaryTypeTraits[this.numNestedSecondaryKeyFields + i] = this.primaryRecDesc.getTypeTraits()[i];
                enforcedRecFields[i] = this.primaryRecDesc.getFields()[i];
                enforcedTypeTraits[i] = this.primaryRecDesc.getTypeTraits()[i];
            }
        } else {
            for (i = 0; i < this.numPrimaryKeys; ++i) {
                secondaryRecFields[this.numNestedSecondaryKeyFields + i] = IndexingConstants.getSerializerDeserializer((int)i);
                this.secondaryTypeTraits[this.numNestedSecondaryKeyFields + i] = IndexingConstants.getTypeTraits((int)i);
                enforcedRecFields[i] = IndexingConstants.getSerializerDeserializer((int)i);
                enforcedTypeTraits[i] = IndexingConstants.getTypeTraits((int)i);
            }
        }
        enforcedRecFields[this.numPrimaryKeys] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)this.itemType);
        this.enforcedRecDesc = new RecordDescriptor(enforcedRecFields, enforcedTypeTraits);
        if (this.numFilterFields > 0) {
            ISerializerDeserializer serde;
            this.rtreeFields = new int[this.numNestedSecondaryKeyFields + this.numPrimaryKeys];
            for (i = 0; i < this.rtreeFields.length; ++i) {
                this.rtreeFields[i] = i;
            }
            Pair<IAType, Boolean> typePair = Index.getNonNullableKeyFieldType(this.filterFieldName, this.itemType);
            IAType type = (IAType)typePair.first;
            secondaryRecFields[this.numPrimaryKeys + this.numNestedSecondaryKeyFields] = serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)type);
        }
        this.secondaryRecDesc = new RecordDescriptor(secondaryRecFields);
        this.primaryKeyFields = new int[this.numPrimaryKeys];
        for (int i2 = 0; i2 < this.primaryKeyFields.length; ++i2) {
            this.primaryKeyFields[i2] = i2 + this.numNestedSecondaryKeyFields;
        }
        if (this.isPointMBR) {
            int i3;
            int numNestedSecondaryKeyFieldForPointMBR = this.numNestedSecondaryKeyFields / 2;
            ISerializerDeserializer[] recFieldsForPointMBR = new ISerializerDeserializer[this.numPrimaryKeys + numNestedSecondaryKeyFieldForPointMBR + this.numFilterFields];
            int idx = 0;
            for (i3 = 0; i3 < numNestedSecondaryKeyFieldForPointMBR; ++i3) {
                recFieldsForPointMBR[idx++] = secondaryRecFields[i3];
            }
            for (i3 = 0; i3 < this.numPrimaryKeys + this.numFilterFields; ++i3) {
                recFieldsForPointMBR[idx++] = secondaryRecFields[this.numNestedSecondaryKeyFields + i3];
            }
            this.secondaryRecDescForPointMBR = new RecordDescriptor(recFieldsForPointMBR);
        }
    }

    @Override
    public JobSpecification buildLoadingJobSpec() throws AsterixException, AlgebricksException {
        JobSpecification spec = RuntimeUtils.createJobSpecification((ICcApplicationContext)this.metadataProvider.getApplicationContext());
        int[] fieldPermutation = this.createFieldPermutationForBulkLoadOp(this.numNestedSecondaryKeyFields);
        int numNestedSecondaryKeFieldsConsideringPointMBR = this.isPointMBR ? this.numNestedSecondaryKeyFields / 2 : this.numNestedSecondaryKeyFields;
        RecordDescriptor secondaryRecDescConsideringPointMBR = this.isPointMBR ? this.secondaryRecDescForPointMBR : this.secondaryRecDesc;
        boolean isOverridingKeyFieldTypes = this.index.isOverridingKeyFieldTypes();
        IndexDataflowHelperFactory indexDataflowHelperFactory = new IndexDataflowHelperFactory(this.metadataProvider.getStorageComponentProvider().getStorageManager(), this.secondaryFileSplitProvider);
        if (this.dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            IOperatorDescriptor primaryScanOp;
            IOperatorDescriptor keyProviderOp = DatasetUtil.createDummyKeyProviderOp(spec, this.dataset, this.metadataProvider);
            JobId jobId = IndexUtil.bindJobEventListener(spec, this.metadataProvider);
            IOperatorDescriptor sourceOp = primaryScanOp = DatasetUtil.createPrimaryIndexScanOp(spec, this.metadataProvider, this.dataset, jobId);
            if (isOverridingKeyFieldTypes && !this.enforcedItemType.equals((Object)this.itemType)) {
                sourceOp = this.createCastOp(spec, this.dataset.getDatasetType(), this.index.isEnforced());
                spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), primaryScanOp, 0, sourceOp, 0);
            }
            AlgebricksMetaOperatorDescriptor asterixAssignOp = this.createAssignOp(spec, numNestedSecondaryKeFieldsConsideringPointMBR, secondaryRecDescConsideringPointMBR);
            AlgebricksMetaOperatorDescriptor selectOp = null;
            if (this.anySecondaryKeyIsNullable || isOverridingKeyFieldTypes) {
                selectOp = this.createFilterNullsSelectOp(spec, numNestedSecondaryKeFieldsConsideringPointMBR, secondaryRecDescConsideringPointMBR);
            }
            ExternalSortOperatorDescriptor sortOp = this.createSortOp(spec, new IBinaryComparatorFactory[]{MetadataProvider.proposeLinearizer(this.keyType, this.secondaryComparatorFactories.length)}, this.isPointMBR ? this.secondaryRecDescForPointMBR : this.secondaryRecDesc);
            TreeIndexBulkLoadOperatorDescriptor secondaryBulkLoadOp = this.createTreeIndexBulkLoadOp(spec, fieldPermutation, (IIndexDataflowHelperFactory)indexDataflowHelperFactory, 1.0f);
            AlgebricksMetaOperatorDescriptor metaOp = new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 0, new IPushRuntimeFactory[]{new SinkRuntimeFactory()}, new RecordDescriptor[0]);
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), keyProviderOp, 0, primaryScanOp, 0);
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, (IOperatorDescriptor)asterixAssignOp, 0);
            if (this.anySecondaryKeyIsNullable || isOverridingKeyFieldTypes) {
                spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)asterixAssignOp, 0, (IOperatorDescriptor)selectOp, 0);
                spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)selectOp, 0, (IOperatorDescriptor)sortOp, 0);
            } else {
                spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)asterixAssignOp, 0, (IOperatorDescriptor)sortOp, 0);
            }
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)sortOp, 0, (IOperatorDescriptor)secondaryBulkLoadOp, 0);
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)secondaryBulkLoadOp, 0, (IOperatorDescriptor)metaOp, 0);
            spec.addRoot((IOperatorDescriptor)metaOp);
            spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        } else {
            ExternalScanOperatorDescriptor primaryScanOp;
            ExternalScanOperatorDescriptor sourceOp = primaryScanOp = this.createExternalIndexingOp(spec);
            if (isOverridingKeyFieldTypes && !this.enforcedItemType.equals((Object)this.itemType)) {
                sourceOp = this.createCastOp(spec, this.dataset.getDatasetType(), this.index.isEnforced());
                spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)primaryScanOp, 0, (IOperatorDescriptor)sourceOp, 0);
            }
            AlgebricksMetaOperatorDescriptor asterixAssignOp = this.createExternalAssignOp(spec, numNestedSecondaryKeFieldsConsideringPointMBR, secondaryRecDescConsideringPointMBR);
            AlgebricksMetaOperatorDescriptor selectOp = null;
            if (this.anySecondaryKeyIsNullable || isOverridingKeyFieldTypes) {
                selectOp = this.createFilterNullsSelectOp(spec, numNestedSecondaryKeFieldsConsideringPointMBR, secondaryRecDescConsideringPointMBR);
            }
            ExternalSortOperatorDescriptor sortOp = this.createSortOp(spec, new IBinaryComparatorFactory[]{MetadataProvider.proposeLinearizer(this.keyType, this.secondaryComparatorFactories.length)}, this.isPointMBR ? this.secondaryRecDescForPointMBR : this.secondaryRecDesc);
            Object secondaryBulkLoadOp = this.externalFiles != null ? this.createExternalIndexBulkModifyOp(spec, fieldPermutation, (IIndexDataflowHelperFactory)indexDataflowHelperFactory, 1.0f) : this.createExternalIndexBulkLoadOp(spec, fieldPermutation, (IIndexDataflowHelperFactory)indexDataflowHelperFactory, 1.0f);
            AlgebricksMetaOperatorDescriptor metaOp = new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 0, new IPushRuntimeFactory[]{new SinkRuntimeFactory()}, new RecordDescriptor[]{this.secondaryRecDesc});
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)secondaryBulkLoadOp, 0, (IOperatorDescriptor)metaOp, 0);
            AlgebricksMetaOperatorDescriptor root = metaOp;
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)sourceOp, 0, (IOperatorDescriptor)asterixAssignOp, 0);
            if (this.anySecondaryKeyIsNullable || isOverridingKeyFieldTypes) {
                spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)asterixAssignOp, 0, (IOperatorDescriptor)selectOp, 0);
                spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)selectOp, 0, (IOperatorDescriptor)sortOp, 0);
            } else {
                spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)asterixAssignOp, 0, (IOperatorDescriptor)sortOp, 0);
            }
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)sortOp, 0, (IOperatorDescriptor)secondaryBulkLoadOp, 0);
            spec.addRoot((IOperatorDescriptor)root);
            spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        }
        return spec;
    }

    protected int[] createFieldPermutationForBulkLoadOp(int numSecondaryKeyFields) {
        int[] fieldPermutation = new int[numSecondaryKeyFields + this.numPrimaryKeys + this.numFilterFields];
        int numSecondaryKeyFieldsForPointMBR = numSecondaryKeyFields / 2;
        int end = this.isPointMBR ? numSecondaryKeyFieldsForPointMBR : fieldPermutation.length;
        for (int i = 0; i < end; ++i) {
            fieldPermutation[i] = i;
        }
        if (this.isPointMBR) {
            int idx = numSecondaryKeyFieldsForPointMBR;
            int i = 0;
            while (i < numSecondaryKeyFieldsForPointMBR) {
                fieldPermutation[idx++] = i++;
            }
            end = numSecondaryKeyFieldsForPointMBR + this.numPrimaryKeys + this.numFilterFields;
            i = numSecondaryKeyFieldsForPointMBR;
            while (i < end) {
                fieldPermutation[idx++] = i++;
            }
        }
        return fieldPermutation;
    }
}

