/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.Serializable;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.context.ITransactionSubsystemProvider;
import org.apache.asterix.common.context.TransactionSubsystemProvider;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.dataflow.data.nontagged.MissingWriterFactory;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.SecondaryCorrelatedBTreeOperationsHelper;
import org.apache.asterix.metadata.utils.SecondaryCorrelatedInvertedIndexOperationsHelper;
import org.apache.asterix.metadata.utils.SecondaryCorrelatedRTreeOperationsHelper;
import org.apache.asterix.metadata.utils.SecondaryIndexOperationsHelper;
import org.apache.asterix.metadata.utils.SecondaryTreeIndexOperationsHelper;
import org.apache.asterix.runtime.operators.LSMSecondaryIndexBulkLoadOperatorDescriptor;
import org.apache.asterix.runtime.operators.LSMSecondaryIndexCreationTupleProcessorOperatorDescriptor;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexInstantSearchOperationCallbackFactory;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraintHelper;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.evaluators.ColumnAccessEvalFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import org.apache.hyracks.algebricks.runtime.operators.std.AssignRuntimeFactory;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.data.std.primitive.BooleanPointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.marshalling.BooleanSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import org.apache.hyracks.dataflow.std.sort.ExternalSortOperatorDescriptor;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.btree.dataflow.LSMBTreeDiskComponentScanOperatorDescriptor;

public abstract class SecondaryCorrelatedTreeIndexOperationsHelper
extends SecondaryTreeIndexOperationsHelper {
    protected static final int COMPONENT_POS_OFFSET = 0;
    protected static final int ANTI_MATTER_OFFSET = 1;
    protected static final int NUM_TAG_FIELDS = 2;
    protected static final IBinaryComparatorFactory COMPONENT_POS_COMPARATOR_FACTORY = new IBinaryComparatorFactory(){
        private static final long serialVersionUID = 1L;

        public IBinaryComparator createBinaryComparator() {
            return new IBinaryComparator(){
                final IBinaryComparator comparator = BinaryComparatorFactoryProvider.INTEGER_POINTABLE_INSTANCE.createBinaryComparator();

                public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) throws HyracksDataException {
                    return -this.comparator.compare(b1, s1, l1, b2, s2, l2);
                }
            };
        }
    };

    protected SecondaryCorrelatedTreeIndexOperationsHelper(Dataset dataset, Index index, PhysicalOptimizationConfig physOptConf, MetadataProvider metadataProvider) throws AlgebricksException {
        super(dataset, index, physOptConf, metadataProvider);
    }

    protected RecordDescriptor getTaggedRecordDescriptor(RecordDescriptor recDescriptor) {
        ISerializerDeserializer[] fields = new ISerializerDeserializer[recDescriptor.getFields().length + 2];
        ITypeTraits[] traits = null;
        if (recDescriptor.getTypeTraits() != null) {
            traits = new ITypeTraits[recDescriptor.getTypeTraits().length + 2];
        }
        fields[0] = IntegerSerializerDeserializer.INSTANCE;
        if (traits != null) {
            traits[0] = IntegerPointable.TYPE_TRAITS;
        }
        fields[1] = BooleanSerializerDeserializer.INSTANCE;
        if (traits != null) {
            traits[1] = BooleanPointable.TYPE_TRAITS;
        }
        for (int i = 2; i < fields.length; ++i) {
            fields[i] = recDescriptor.getFields()[i - 2];
            if (traits == null || i >= traits.length) continue;
            traits[i] = recDescriptor.getTypeTraits()[i - 2];
        }
        return new RecordDescriptor(fields, traits);
    }

    protected IBinaryComparatorFactory[] getTaggedSecondaryComparatorFactories(IBinaryComparatorFactory[] secondaryComparatorFactories) {
        IBinaryComparatorFactory[] resultFactories = new IBinaryComparatorFactory[secondaryComparatorFactories.length + 1];
        resultFactories[0] = COMPONENT_POS_COMPARATOR_FACTORY;
        for (int i = 1; i < resultFactories.length; ++i) {
            resultFactories[i] = secondaryComparatorFactories[i - 1];
        }
        return resultFactories;
    }

    @Override
    protected AlgebricksMetaOperatorDescriptor createCastOp(JobSpecification spec, DatasetConfig.DatasetType dsType, boolean strictCast) throws AlgebricksException {
        int[] outColumns = new int[1];
        int[] projectionList = new int[2 + (this.dataset.hasMetaPart() ? 2 : 1) + this.numPrimaryKeys];
        int recordIdx = 2 + this.numPrimaryKeys;
        assert (dsType == DatasetConfig.DatasetType.INTERNAL);
        outColumns[0] = 2 + this.numPrimaryKeys;
        int projCount = 0;
        int i = 0;
        while (i < 2) {
            projectionList[projCount++] = i++;
        }
        for (i = 0; i <= this.numPrimaryKeys; ++i) {
            projectionList[projCount++] = 2 + i;
        }
        if (this.dataset.hasMetaPart()) {
            projectionList[2 + this.numPrimaryKeys + 1] = 2 + this.numPrimaryKeys + 1;
        }
        IScalarEvaluatorFactory[] castEvalFact = new IScalarEvaluatorFactory[]{new ColumnAccessEvalFactory(recordIdx)};
        IScalarEvaluatorFactory[] sefs = new IScalarEvaluatorFactory[]{this.createCastFunction(strictCast).createEvaluatorFactory(castEvalFact)};
        AssignRuntimeFactory castAssign = new AssignRuntimeFactory(outColumns, sefs, projectionList);
        return new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 1, new IPushRuntimeFactory[]{castAssign}, new RecordDescriptor[]{this.getTaggedRecordDescriptor(this.enforcedRecDesc)});
    }

    @Override
    protected AlgebricksMetaOperatorDescriptor createAssignOp(JobSpecification spec, int numSecondaryKeyFields, RecordDescriptor secondaryRecDesc) throws AlgebricksException {
        int[] outColumns = new int[numSecondaryKeyFields + this.numFilterFields];
        int[] projectionList = new int[2 + numSecondaryKeyFields + this.numPrimaryKeys + this.numFilterFields];
        for (int i = 0; i < numSecondaryKeyFields + this.numFilterFields; ++i) {
            outColumns[i] = 2 + this.numPrimaryKeys + i;
        }
        int projCount = 0;
        int i = 0;
        while (i < 2) {
            projectionList[projCount++] = i++;
        }
        for (i = 0; i < numSecondaryKeyFields; ++i) {
            projectionList[projCount++] = 2 + this.numPrimaryKeys + i;
        }
        for (i = 0; i < this.numPrimaryKeys; ++i) {
            projectionList[projCount++] = 2 + i;
        }
        if (this.numFilterFields > 0) {
            projectionList[projCount] = 2 + this.numPrimaryKeys + numSecondaryKeyFields;
        }
        IScalarEvaluatorFactory[] sefs = new IScalarEvaluatorFactory[this.secondaryFieldAccessEvalFactories.length];
        for (int i2 = 0; i2 < this.secondaryFieldAccessEvalFactories.length; ++i2) {
            sefs[i2] = this.secondaryFieldAccessEvalFactories[i2];
        }
        AssignRuntimeFactory assign = new AssignRuntimeFactory(outColumns, sefs, projectionList);
        AlgebricksMetaOperatorDescriptor asterixAssignOp = new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 1, new IPushRuntimeFactory[]{assign}, new RecordDescriptor[]{secondaryRecDesc});
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)asterixAssignOp, (AlgebricksPartitionConstraint)this.primaryPartitionConstraint);
        return asterixAssignOp;
    }

    protected IOperatorDescriptor createTupleProcessorOp(JobSpecification spec, RecordDescriptor taggedSecondaryRecDesc, int numSecondaryKeyFields, int numPrimaryKeyFields, boolean hasBuddyBTree) {
        LSMSecondaryIndexCreationTupleProcessorOperatorDescriptor op = new LSMSecondaryIndexCreationTupleProcessorOperatorDescriptor((IOperatorDescriptorRegistry)spec, taggedSecondaryRecDesc, (IMissingWriterFactory)MissingWriterFactory.INSTANCE, 2, numSecondaryKeyFields, numPrimaryKeyFields, hasBuddyBTree);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)op, (AlgebricksPartitionConstraint)this.primaryPartitionConstraint);
        return op;
    }

    @Override
    protected ExternalSortOperatorDescriptor createSortOp(JobSpecification spec, IBinaryComparatorFactory[] taggedSecondaryComparatorFactories, RecordDescriptor taggedSecondaryRecDesc) {
        int[] taggedSortFields = new int[taggedSecondaryComparatorFactories.length];
        taggedSortFields[0] = 0;
        for (int i = 1; i < taggedSortFields.length; ++i) {
            taggedSortFields[i] = i + 1;
        }
        ExternalSortOperatorDescriptor sortOp = new ExternalSortOperatorDescriptor((IOperatorDescriptorRegistry)spec, this.physOptConf.getMaxFramesExternalSort(), taggedSortFields, taggedSecondaryComparatorFactories, taggedSecondaryRecDesc);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)sortOp, (AlgebricksPartitionConstraint)this.primaryPartitionConstraint);
        return sortOp;
    }

    protected LSMSecondaryIndexBulkLoadOperatorDescriptor createTreeIndexBulkLoadOp(JobSpecification spec, MetadataProvider metadataProvider, RecordDescriptor taggedSecondaryRecDesc, int[] fieldPermutation, int numSecondaryKeys, int numPrimaryKeys, boolean hasBuddyBtree) throws AlgebricksException {
        IndexDataflowHelperFactory primaryIndexHelperFactory = new IndexDataflowHelperFactory(metadataProvider.getStorageComponentProvider().getStorageManager(), this.primaryFileSplitProvider);
        IndexDataflowHelperFactory secondaryIndexHelperFactory = new IndexDataflowHelperFactory(metadataProvider.getStorageComponentProvider().getStorageManager(), this.secondaryFileSplitProvider);
        LSMSecondaryIndexBulkLoadOperatorDescriptor treeIndexBulkLoadOp = new LSMSecondaryIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, taggedSecondaryRecDesc, (IIndexDataflowHelperFactory)primaryIndexHelperFactory, (IIndexDataflowHelperFactory)secondaryIndexHelperFactory, fieldPermutation, 2, numSecondaryKeys, numPrimaryKeys, hasBuddyBtree);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)treeIndexBulkLoadOp, (AlgebricksPartitionConstraint)this.secondaryPartitionConstraint);
        return treeIndexBulkLoadOp;
    }

    protected IOperatorDescriptor createPrimaryIndexScanDiskComponentsOp(JobSpecification spec, MetadataProvider metadataProvider, RecordDescriptor outRecDesc, JobId jobId) throws AlgebricksException {
        TransactionSubsystemProvider txnSubsystemProvider = TransactionSubsystemProvider.INSTANCE;
        boolean temp = this.dataset.getDatasetDetails().isTemp();
        NoOpOperationCallbackFactory searchCallbackFactory = temp ? NoOpOperationCallbackFactory.INSTANCE : new PrimaryIndexInstantSearchOperationCallbackFactory(jobId, this.dataset.getDatasetId(), this.dataset.getPrimaryBloomFilterFields(), (ITransactionSubsystemProvider)txnSubsystemProvider, 0);
        IndexDataflowHelperFactory indexHelperFactory = new IndexDataflowHelperFactory(metadataProvider.getStorageComponentProvider().getStorageManager(), this.primaryFileSplitProvider);
        LSMBTreeDiskComponentScanOperatorDescriptor primaryScanOp = new LSMBTreeDiskComponentScanOperatorDescriptor((IOperatorDescriptorRegistry)spec, outRecDesc, (IIndexDataflowHelperFactory)indexHelperFactory, (ISearchOperationCallbackFactory)searchCallbackFactory);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)primaryScanOp, (AlgebricksPartitionConstraint)this.primaryPartitionConstraint);
        return primaryScanOp;
    }

    public static SecondaryIndexOperationsHelper createIndexOperationsHelper(Dataset dataset, Index index, MetadataProvider metadataProvider, PhysicalOptimizationConfig physOptConf) throws AlgebricksException {
        SecondaryCorrelatedTreeIndexOperationsHelper indexOperationsHelper = null;
        switch (index.getIndexType()) {
            case BTREE: {
                indexOperationsHelper = new SecondaryCorrelatedBTreeOperationsHelper(dataset, index, physOptConf, metadataProvider);
                break;
            }
            case RTREE: {
                indexOperationsHelper = new SecondaryCorrelatedRTreeOperationsHelper(dataset, index, physOptConf, metadataProvider);
                break;
            }
            case SINGLE_PARTITION_WORD_INVIX: 
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: 
            case LENGTH_PARTITIONED_NGRAM_INVIX: {
                indexOperationsHelper = new SecondaryCorrelatedInvertedIndexOperationsHelper(dataset, index, physOptConf, metadataProvider);
                break;
            }
            default: {
                throw new CompilationException(1012, new Serializable[]{index.getIndexType()});
            }
        }
        indexOperationsHelper.init();
        return indexOperationsHelper;
    }

    protected int[] createFieldPermutationForBulkLoadOp() {
        int[] fieldPermutation = new int[2 + this.getNumSecondaryKeys() + this.numPrimaryKeys + this.numFilterFields];
        for (int i = 0; i < fieldPermutation.length; ++i) {
            fieldPermutation[i] = i;
        }
        return fieldPermutation;
    }
}

