/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.api.IAdapterFactory;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang.StringUtils;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobSpecification;

public class LoadableDataSource
extends DataSource {
    private final Dataset targetDataset;
    private final List<List<String>> partitioningKeys;
    private final String adapter;
    private final Map<String, String> adapterProperties;
    private final boolean isPKAutoGenerated;

    public LoadableDataSource(Dataset targetDataset, IAType itemType, IAType metaItemType, String adapter, Map<String, String> properties) throws AlgebricksException, IOException {
        super(new DataSourceId("loadable_dv", "loadable_ds"), itemType, metaItemType, (byte)3, null);
        this.targetDataset = targetDataset;
        this.adapter = adapter;
        this.adapterProperties = properties;
        this.partitioningKeys = targetDataset.getPrimaryKeys();
        ARecordType recType = (ARecordType)itemType;
        this.isPKAutoGenerated = ((InternalDatasetDetails)targetDataset.getDatasetDetails()).isAutogenerated();
        if (this.isPKAutoGenerated) {
            try {
                recType = this.getStrippedPKType(new LinkedList<String>((Collection)this.partitioningKeys.get(0)), recType);
            }
            catch (AsterixException e) {
                throw new AlgebricksException((Throwable)e);
            }
        }
        this.schemaTypes = new IAType[]{recType};
    }

    /*
     * Enabled aggressive block sorting
     */
    private ARecordType getStrippedPKType(List<String> partitioningKeys, ARecordType recType) throws AsterixException, HyracksDataException {
        LinkedList<String> fieldNames = new LinkedList<String>();
        LinkedList<IAType> fieldTypes = new LinkedList<IAType>();
        int j = 0;
        int i = 0;
        while (true) {
            block6: {
                IAType fieldType;
                block5: {
                    block3: {
                        block4: {
                            if (i >= recType.getFieldNames().length) {
                                return new ARecordType(recType.getTypeName(), fieldNames.toArray(new String[0]), fieldTypes.toArray(new IAType[0]), recType.isOpen());
                            }
                            if (!partitioningKeys.get(0).equals(recType.getFieldNames()[j])) break block3;
                            if (recType.getFieldTypes()[j].getTypeTag() != ATypeTag.OBJECT) break block4;
                            if (j != 0) {
                                throw new AsterixException("Autogenerated key " + StringUtils.join(partitioningKeys, (char)'.') + " should be a first field of the type " + recType.getTypeName());
                            }
                            partitioningKeys.remove(0);
                            fieldType = this.getStrippedPKType(partitioningKeys, (ARecordType)recType.getFieldTypes()[j]);
                            break block5;
                        }
                        ++j;
                        break block6;
                    }
                    fieldType = recType.getFieldTypes()[j];
                }
                fieldTypes.add(fieldType);
                fieldNames.add(recType.getFieldNames()[j]);
                ++j;
            }
            ++i;
        }
    }

    public List<List<String>> getPartitioningKeys() {
        return this.partitioningKeys;
    }

    public String getAdapter() {
        return this.adapter;
    }

    public Map<String, String> getAdapterProperties() {
        return this.adapterProperties;
    }

    public IAType getLoadedType() {
        return this.schemaTypes[this.schemaTypes.length - 1];
    }

    public Dataset getTargetDataset() {
        return this.targetDataset;
    }

    @Override
    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildDatasourceScanRuntime(MetadataProvider metadataProvider, IDataSource<DataSourceId> dataSource, List<LogicalVariable> scanVariables, List<LogicalVariable> projectVariables, boolean projectPushed, List<LogicalVariable> minFilterVars, List<LogicalVariable> maxFilterVars, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, JobSpecification jobSpec, Object implConfig) throws AlgebricksException {
        LoadableDataSource alds = (LoadableDataSource)dataSource;
        ARecordType itemType = (ARecordType)alds.getLoadedType();
        IAdapterFactory adapterFactory = metadataProvider.getConfiguredAdapterFactory(alds.getTargetDataset(), alds.getAdapter(), alds.getAdapterProperties(), itemType, null);
        RecordDescriptor rDesc = JobGenHelper.mkRecordDescriptor((IVariableTypeEnvironment)typeEnv, (IOperatorSchema)opSchema, (JobGenContext)context);
        return metadataProvider.buildLoadableDatasetScan(jobSpec, adapterFactory, rDesc);
    }

    public boolean isScanAccessPathALeaf() {
        return true;
    }
}

