/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.cluster;

import java.util.Collections;
import java.util.Set;
import org.apache.asterix.common.api.IClusterEventsSubscriber;
import org.apache.asterix.common.config.ClusterProperties;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.cluster.Node;
import org.apache.asterix.metadata.api.IClusterManager;
import org.apache.asterix.metadata.cluster.ClusterManager;

public class ClusterManagerProvider {
    private ClusterManagerProvider() {
    }

    public static IClusterManager getClusterManager() {
        return Holder.INSTANCE;
    }

    private static class NoopClusterManager
    implements IClusterManager {
        private NoopClusterManager() {
        }

        @Override
        public void addNode(ICcApplicationContext appCtx, Node node) throws AsterixException {
        }

        @Override
        public void removeNode(Node node) throws AsterixException {
        }

        @Override
        public void registerSubscriber(IClusterEventsSubscriber subscriber) {
        }

        @Override
        public boolean deregisterSubscriber(IClusterEventsSubscriber sunscriber) {
            return true;
        }

        @Override
        public Set<IClusterEventsSubscriber> getRegisteredClusterEventSubscribers() {
            return Collections.emptySet();
        }

        @Override
        public void notifyStartupCompleted() throws Exception {
        }
    }

    private static final class Holder {
        static final IClusterManager INSTANCE;

        private Holder() {
        }

        static {
            Cluster asterixCluster = ClusterProperties.INSTANCE.getCluster();
            String eventHome = asterixCluster == null ? null : (asterixCluster.getWorkingDir() == null ? null : asterixCluster.getWorkingDir().getDir());
            INSTANCE = eventHome != null ? new ClusterManager(eventHome) : new NoopClusterManager();
        }
    }
}

