/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.config.ClusterProperties;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.context.AsterixVirtualBufferCacheProvider;
import org.apache.asterix.common.context.CorrelatedPrefixMergePolicyFactory;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.common.ioopcallbacks.LSMBTreeIOOperationCallbackFactory;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.external.adapter.factory.GenericAdapterFactory;
import org.apache.asterix.external.api.IAdapterFactory;
import org.apache.asterix.external.api.IDataSourceAdapter;
import org.apache.asterix.external.dataset.adapter.AdapterIdentifier;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.api.IMetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataBuiltinEntities;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.entities.BuiltinTypeMap;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.entities.Node;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.metadata.feeds.BuiltinFeedPolicies;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexOperationTrackerFactory;
import org.apache.asterix.transaction.management.opcallbacks.SecondaryIndexOperationTrackerFactory;
import org.apache.asterix.transaction.management.resource.DatasetLocalResourceFactory;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.common.build.IndexBuilder;
import org.apache.hyracks.storage.am.common.dataflow.IndexDataflowHelper;
import org.apache.hyracks.storage.am.lsm.btree.dataflow.LSMBTreeLocalResourceFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTrackerFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCacheProvider;
import org.apache.hyracks.storage.am.lsm.common.impls.ConstantMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.NoMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.PrefixMergePolicyFactory;
import org.apache.hyracks.storage.common.ILocalResourceRepository;
import org.apache.hyracks.storage.common.IResourceFactory;
import org.apache.hyracks.storage.common.LocalResource;

public class MetadataBootstrap {
    public static final boolean IS_DEBUG_MODE = false;
    private static final Logger LOGGER = Logger.getLogger(MetadataBootstrap.class.getName());
    private static INcApplicationContext appContext;
    private static ILocalResourceRepository localResourceRepository;
    private static IIOManager ioManager;
    private static String metadataNodeName;
    private static List<String> nodeNames;
    private static boolean isNewUniverse;
    private static final IMetadataIndex[] PRIMARY_INDEXES;

    private MetadataBootstrap() {
    }

    public static void startUniverse(INCServiceContext ncServiceContext, boolean isNewUniverse) throws RemoteException, ACIDException, MetadataException {
        MetadataBootstrap.setNewUniverse(isNewUniverse);
        appContext = (INcApplicationContext)ncServiceContext.getApplicationContext();
        MetadataProperties metadataProperties = appContext.getMetadataProperties();
        metadataNodeName = metadataProperties.getMetadataNodeName();
        nodeNames = metadataProperties.getNodeNames();
        localResourceRepository = appContext.getLocalResourceRepository();
        ioManager = ncServiceContext.getIoManager();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        try {
            MetadataManager.INSTANCE.lock(mdTxnCtx, (byte)4);
            for (int i = 0; i < PRIMARY_INDEXES.length; ++i) {
                MetadataBootstrap.enlistMetadataDataset(ncServiceContext, PRIMARY_INDEXES[i]);
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Finished enlistment of metadata B-trees in " + (isNewUniverse ? "new" : "old") + " universe");
            }
            if (isNewUniverse) {
                MetadataBootstrap.insertInitialDataverses(mdTxnCtx);
                MetadataBootstrap.insertMetadataDatasets(mdTxnCtx, PRIMARY_INDEXES);
                MetadataBootstrap.insertMetadataDatatypes(mdTxnCtx);
                MetadataBootstrap.insertNodes(mdTxnCtx);
                MetadataBootstrap.insertInitialGroups(mdTxnCtx);
                MetadataBootstrap.insertInitialAdapters(mdTxnCtx);
                BuiltinFeedPolicies.insertInitialFeedPolicies(mdTxnCtx);
                MetadataBootstrap.insertInitialCompactionPolicies(mdTxnCtx);
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Finished creating metadata B-trees.");
                }
            }
            MetadataManager.INSTANCE.initializeDatasetIdFactory(mdTxnCtx);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            try {
                MetadataManager.INSTANCE.abortTransaction(mdTxnCtx);
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
                throw new MetadataException((Throwable)e);
            }
            throw new MetadataException((Throwable)e);
        }
    }

    private static void insertInitialDataverses(MetadataTransactionContext mdTxnCtx) throws MetadataException {
        String dataFormat = "org.apache.asterix.runtime.formats.NonTaggedDataFormat";
        MetadataManager.INSTANCE.addDataverse(mdTxnCtx, new Dataverse("Metadata", dataFormat, 0));
        MetadataManager.INSTANCE.addDataverse(mdTxnCtx, MetadataBuiltinEntities.DEFAULT_DATAVERSE);
    }

    public static void insertMetadataDatasets(MetadataTransactionContext mdTxnCtx, IMetadataIndex[] indexes) throws MetadataException {
        for (int i = 0; i < indexes.length; ++i) {
            InternalDatasetDetails id = new InternalDatasetDetails(InternalDatasetDetails.FileStructure.BTREE, InternalDatasetDetails.PartitioningStrategy.HASH, indexes[i].getPartitioningExpr(), indexes[i].getPartitioningExpr(), null, indexes[i].getPartitioningExprType(), false, null, false);
            MetadataManager.INSTANCE.addDataset(mdTxnCtx, new Dataset(indexes[i].getDataverseName(), indexes[i].getIndexedDatasetName(), indexes[i].getDataverseName(), indexes[i].getPayloadRecordType().getTypeName(), indexes[i].getNodeGroupName(), "prefix", GlobalConfig.DEFAULT_COMPACTION_POLICY_PROPERTIES, id, new HashMap<String, String>(), DatasetConfig.DatasetType.INTERNAL, indexes[i].getDatasetId().getId(), 0));
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Finished inserting initial datasets.");
        }
    }

    private static void getMetadataTypes(ArrayList<IAType> types) {
        for (int i = 0; i < PRIMARY_INDEXES.length; ++i) {
            types.add((IAType)PRIMARY_INDEXES[i].getPayloadRecordType());
        }
    }

    private static void insertMetadataDatatypes(MetadataTransactionContext mdTxnCtx) throws MetadataException {
        ArrayList<IAType> types = new ArrayList<IAType>();
        types.addAll(BuiltinTypeMap.getAllBuiltinTypes());
        MetadataBootstrap.getMetadataTypes(types);
        for (int i = 0; i < types.size(); ++i) {
            MetadataManager.INSTANCE.addDatatype(mdTxnCtx, new Datatype("Metadata", types.get(i).getTypeName(), types.get(i), false));
        }
        MetadataManager.INSTANCE.addDatatype(mdTxnCtx, MetadataBuiltinEntities.ANY_OBJECT_DATATYPE);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Finished inserting initial datatypes.");
        }
    }

    private static void insertNodes(MetadataTransactionContext mdTxnCtx) throws MetadataException {
        for (String nodesName : nodeNames) {
            MetadataManager.INSTANCE.addNode(mdTxnCtx, new Node(nodesName, 0L, 0L));
        }
    }

    private static void insertInitialGroups(MetadataTransactionContext mdTxnCtx) throws MetadataException {
        ArrayList<String> metadataGroupNodeNames = new ArrayList<String>();
        metadataGroupNodeNames.add(metadataNodeName);
        NodeGroup groupRecord = new NodeGroup("MetadataGroup", metadataGroupNodeNames);
        MetadataManager.INSTANCE.addNodegroup(mdTxnCtx, groupRecord);
    }

    private static void insertInitialAdapters(MetadataTransactionContext mdTxnCtx) throws MetadataException {
        String[] builtInAdapterClassNames;
        for (String adapterClassName : builtInAdapterClassNames = new String[]{GenericAdapterFactory.class.getName()}) {
            DatasourceAdapter adapter = MetadataBootstrap.getAdapter(adapterClassName);
            MetadataManager.INSTANCE.addAdapter(mdTxnCtx, adapter);
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Finished inserting built-in adapters.");
        }
    }

    private static void insertInitialCompactionPolicies(MetadataTransactionContext mdTxnCtx) throws MetadataException {
        String[] builtInCompactionPolicyClassNames;
        for (String policyClassName : builtInCompactionPolicyClassNames = new String[]{ConstantMergePolicyFactory.class.getName(), PrefixMergePolicyFactory.class.getName(), NoMergePolicyFactory.class.getName(), CorrelatedPrefixMergePolicyFactory.class.getName()}) {
            CompactionPolicy compactionPolicy = MetadataBootstrap.getCompactionPolicyEntity(policyClassName);
            MetadataManager.INSTANCE.addCompactionPolicy(mdTxnCtx, compactionPolicy);
        }
    }

    private static DatasourceAdapter getAdapter(String adapterFactoryClassName) throws MetadataException {
        try {
            String adapterName = ((IAdapterFactory)Class.forName(adapterFactoryClassName).newInstance()).getAlias();
            return new DatasourceAdapter(new AdapterIdentifier("Metadata", adapterName), adapterFactoryClassName, IDataSourceAdapter.AdapterType.INTERNAL);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MetadataException("Unable to instantiate builtin Adapter", (Throwable)e);
        }
    }

    private static CompactionPolicy getCompactionPolicyEntity(String compactionPolicyClassName) throws MetadataException {
        try {
            String policyName = ((ILSMMergePolicyFactory)Class.forName(compactionPolicyClassName).newInstance()).getName();
            return new CompactionPolicy("Metadata", policyName, compactionPolicyClassName);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MetadataException("Unable to instantiate builtin Merge Policy Factory", (Throwable)e);
        }
    }

    public static void enlistMetadataDataset(INCServiceContext ncServiceCtx, IMetadataIndex index) throws HyracksDataException {
        int datasetId = index.getDatasetId().getId();
        if (!appContext.getDatasetMemoryManager().reserve(index.getDatasetId().getId())) {
            throw new IllegalStateException("Failed to reserve memory for metadata dataset (" + datasetId + ")");
        }
        ClusterPartition metadataPartition = appContext.getMetadataProperties().getMetadataPartition();
        int metadataDeviceId = metadataPartition.getIODeviceNum();
        String metadataPartitionPath = StoragePathUtil.prepareStoragePartitionPath((String)ClusterProperties.INSTANCE.getStorageDirectoryName(), (int)metadataPartition.getPartitionId());
        String resourceName = metadataPartitionPath + File.separator + index.getFileNameRelativePath();
        FileReference file = ioManager.getFileReference(metadataDeviceId, resourceName);
        index.setFile(file);
        ITypeTraits[] typeTraits = index.getTypeTraits();
        IBinaryComparatorFactory[] cmpFactories = index.getKeyBinaryComparatorFactory();
        int[] bloomFilterKeyFields = index.getBloomFilterKeyFields();
        PrimaryIndexOperationTrackerFactory opTrackerFactory = index.isPrimaryIndex() ? new PrimaryIndexOperationTrackerFactory(datasetId) : new SecondaryIndexOperationTrackerFactory(datasetId);
        LSMBTreeIOOperationCallbackFactory ioOpCallbackFactory = LSMBTreeIOOperationCallbackFactory.INSTANCE;
        IStorageComponentProvider storageComponentProvider = appContext.getStorageComponentProvider();
        if (MetadataBootstrap.isNewUniverse()) {
            LSMBTreeLocalResourceFactory lsmBtreeFactory = new LSMBTreeLocalResourceFactory(storageComponentProvider.getStorageManager(), typeTraits, cmpFactories, null, null, null, (ILSMOperationTrackerFactory)opTrackerFactory, (ILSMIOOperationCallbackFactory)ioOpCallbackFactory, storageComponentProvider.getMetadataPageManagerFactory(), (IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(datasetId), storageComponentProvider.getIoOperationSchedulerProvider(), appContext.getMetadataMergePolicyFactory(), GlobalConfig.DEFAULT_COMPACTION_POLICY_PROPERTIES, true, bloomFilterKeyFields, appContext.getBloomFilterFalsePositiveRate(), true, null);
            DatasetLocalResourceFactory dsLocalResourceFactory = new DatasetLocalResourceFactory(datasetId, (IResourceFactory)lsmBtreeFactory);
            IndexBuilder indexBuilder = new IndexBuilder(ncServiceCtx, storageComponentProvider.getStorageManager(), index::getResourceId, file, (IResourceFactory)dsLocalResourceFactory, true);
            indexBuilder.build();
        } else {
            LocalResource resource = localResourceRepository.get(file.getRelativePath());
            if (resource == null) {
                throw new HyracksDataException("Could not find required metadata indexes. Please delete " + (String)appContext.getMetadataProperties().getTransactionLogDirs().get(appContext.getTransactionSubsystem().getId()) + " to intialize as a new instance. (WARNING: all data will be lost.)");
            }
            if (index.getResourceId() != resource.getId()) {
                throw new HyracksDataException("Resource Id doesn't match expected metadata index resource id");
            }
            IndexDataflowHelper indexHelper = new IndexDataflowHelper(ncServiceCtx, storageComponentProvider.getStorageManager(), file);
            indexHelper.open();
            indexHelper.close();
        }
    }

    public static void startDDLRecovery() throws MetadataException {
        MetadataTransactionContext mdTxnCtx = null;
        MetadataManager.INSTANCE.acquireWriteLatch();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Starting DDL recovery ...");
        }
        try {
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            List<Dataverse> dataverses = MetadataManager.INSTANCE.getDataverses(mdTxnCtx);
            for (Dataverse dataverse : dataverses) {
                MetadataBootstrap.recoverDataverse(mdTxnCtx, dataverse);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Completed DDL recovery.");
            }
        }
        catch (Exception e) {
            try {
                MetadataManager.INSTANCE.abortTransaction(mdTxnCtx);
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
            }
            throw new MetadataException((Throwable)e);
        }
        finally {
            MetadataManager.INSTANCE.releaseWriteLatch();
        }
    }

    private static void recoverDataverse(MetadataTransactionContext mdTxnCtx, Dataverse dataverse) throws MetadataException {
        if (dataverse.getPendingOp() != 0) {
            MetadataManager.INSTANCE.dropDataverse(mdTxnCtx, dataverse.getDataverseName());
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Dropped a pending dataverse: " + dataverse.getDataverseName());
            }
        } else {
            List<Dataset> datasets = MetadataManager.INSTANCE.getDataverseDatasets(mdTxnCtx, dataverse.getDataverseName());
            for (Dataset dataset : datasets) {
                MetadataBootstrap.recoverDataset(mdTxnCtx, dataset);
            }
        }
    }

    private static void recoverDataset(MetadataTransactionContext mdTxnCtx, Dataset dataset) throws MetadataException {
        List<Index> indexes;
        if (dataset.getPendingOp() != 0) {
            MetadataManager.INSTANCE.dropDataset(mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName());
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Dropped a pending dataset: " + dataset.getDataverseName() + "." + dataset.getDatasetName());
            }
        } else {
            indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName());
            for (Index index : indexes) {
                if (index.getPendingOp() == 0) continue;
                MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), index.getIndexName());
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("Dropped a pending index: " + dataset.getDataverseName() + "." + dataset.getDatasetName() + "." + index.getIndexName());
            }
        }
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL && (indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName())).isEmpty()) {
            List<ExternalFile> files = MetadataManager.INSTANCE.getDatasetExternalFiles(mdTxnCtx, dataset);
            for (ExternalFile file : files) {
                MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("Dropped an external file: " + dataset.getDataverseName() + "." + dataset.getDatasetName() + "." + file.getFileNumber());
            }
        }
    }

    public static boolean isNewUniverse() {
        return isNewUniverse;
    }

    public static void setNewUniverse(boolean isNewUniverse) {
        MetadataBootstrap.isNewUniverse = isNewUniverse;
    }

    static {
        PRIMARY_INDEXES = new IMetadataIndex[]{MetadataPrimaryIndexes.DATAVERSE_DATASET, MetadataPrimaryIndexes.DATASET_DATASET, MetadataPrimaryIndexes.DATATYPE_DATASET, MetadataPrimaryIndexes.INDEX_DATASET, MetadataPrimaryIndexes.NODE_DATASET, MetadataPrimaryIndexes.NODEGROUP_DATASET, MetadataPrimaryIndexes.FUNCTION_DATASET, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, MetadataPrimaryIndexes.FEED_DATASET, MetadataPrimaryIndexes.FEED_POLICY_DATASET, MetadataPrimaryIndexes.LIBRARY_DATASET, MetadataPrimaryIndexes.COMPACTION_POLICY_DATASET, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, MetadataPrimaryIndexes.FEED_CONNECTION_DATASET};
    }
}

