/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.util.ArrayList;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class FunctionTupleTranslator
extends AbstractTupleTranslator<Function> {
    public static final int FUNCTION_DATAVERSENAME_TUPLE_FIELD_INDEX = 0;
    public static final int FUNCTION_FUNCTIONNAME_TUPLE_FIELD_INDEX = 1;
    public static final int FUNCTION_FUNCTIONARITY_TUPLE_FIELD_INDEX = 2;
    public static final int FUNCTION_PAYLOAD_TUPLE_FIELD_INDEX = 3;
    private ISerializerDeserializer<ARecord> recordSerDes = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)MetadataRecordTypes.FUNCTION_RECORDTYPE);

    protected FunctionTupleTranslator(boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.FUNCTION_DATASET.getFieldCount());
    }

    @Override
    public Function getMetadataEntityFromTuple(ITupleReference frameTuple) throws HyracksDataException {
        byte[] serRecord = frameTuple.getFieldData(3);
        int recordStartOffset = frameTuple.getFieldStart(3);
        int recordLength = frameTuple.getFieldLength(3);
        ByteArrayInputStream stream = new ByteArrayInputStream(serRecord, recordStartOffset, recordLength);
        DataInputStream in = new DataInputStream(stream);
        ARecord functionRecord = (ARecord)this.recordSerDes.deserialize((DataInput)in);
        return this.createFunctionFromARecord(functionRecord);
    }

    private Function createFunctionFromARecord(ARecord functionRecord) {
        String dataverseName = ((AString)functionRecord.getValueByPos(0)).getStringValue();
        String functionName = ((AString)functionRecord.getValueByPos(1)).getStringValue();
        String arity = ((AString)functionRecord.getValueByPos(2)).getStringValue();
        IACursor cursor = ((AOrderedList)functionRecord.getValueByPos(3)).getCursor();
        ArrayList<String> params = new ArrayList<String>();
        while (cursor.next()) {
            params.add(((AString)cursor.get()).getStringValue());
        }
        String returnType = ((AString)functionRecord.getValueByPos(4)).getStringValue();
        String definition = ((AString)functionRecord.getValueByPos(5)).getStringValue();
        String language = ((AString)functionRecord.getValueByPos(6)).getStringValue();
        String functionKind = ((AString)functionRecord.getValueByPos(7)).getStringValue();
        return new Function(dataverseName, functionName, Integer.parseInt(arity), params, returnType, definition, language, functionKind);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Function function) throws HyracksDataException, MetadataException {
        this.tupleBuilder.reset();
        this.aString.setValue(function.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(function.getName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(function.getArity() + "");
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.FUNCTION_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(function.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.getName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.getArity() + "");
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        listBuilder.reset((AbstractCollectionType)((AOrderedListType)MetadataRecordTypes.FUNCTION_RECORDTYPE.getFieldTypes()[3]));
        for (String param : function.getParams()) {
            itemValue.reset();
            this.aString.setValue(param);
            this.stringSerde.serialize((Object)this.aString, itemValue.getDataOutput());
            listBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        listBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(3, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.getReturnType());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(4, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.getFunctionBody());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(5, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.getLanguage());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(6, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.getKind());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(7, (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

